/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: curs.c,v 1.32 2003/11/19 13:19:13 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
/*#include	"misc.h"*/
/*#include	"turn.h"*/
/*#include	"dun.h"*/
/*#include	"town.h"*/
/*#include	"item.h"*/
/*#include	"spell.h"*/
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"pet.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
#include	"draw.h"
#include	"curs.h"
/*#include	"menu.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
/*#include	"misc_prot.h"*/
/*#include	"turn_prot.h"*/
/*#include	"dun_prot.h"*/
/*#include	"town_prot.h"*/
/*#include	"item_prot.h"*/
/*#include	"spell_prot.h"*/
/*#include	"chr_prot.h"*/
/*#include	"party_prot.h"*/
/*#include	"mnstr_prot.h"*/
/*#include	"pet_prot.h"*/
/*#include	"fight_prot.h"*/
/*#include	"fx_prot.h"*/
/*#include	"trap_prot.h"*/
/*#include	"draw_prot.h"*/
#include	"curs_prot.h"
/*#include	"menu_prot.h"*/
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

#define	FLG_PRINT_REVERSE	0

/**/

static long	flg_curs, flg_curs_draw;
static bool_t	flg_color;
static curs_attr_t	g_current_attr;

/**/

static curs_attr_t	g_curs_attr[CURS_ATTR_MAX_N] = {
	{ 0, N_MSG_ATTR_NORMAL,
		COLOR_WHITE, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_REV,
		COLOR_WHITE, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_ERR,
		COLOR_RED, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_MENU_DIS,
		COLOR_YELLOW, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_MENU_SEL,
		COLOR_WHITE, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_MAP_ITEM,
		COLOR_GREEN, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_MAP_SQUARE,
		COLOR_CYAN, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_MAP_MNSTR,
		COLOR_RED, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_MAP_NPC,
		COLOR_CYAN, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_MAP_CRSR,
		COLOR_GREEN, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_FX_MBR_PLUS,
		COLOR_CYAN, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_FX_MBR_MINUS,
		COLOR_RED, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_FX_MBR_CRTCL,
		COLOR_RED, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_FX_MNSTR_PLUS,
		COLOR_RED, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_FX_MNSTR_MINUS,
		COLOR_CYAN, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_FX_MNSTR_CRTCL,
		COLOR_CYAN, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_VFX,
		COLOR_YELLOW, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_MBR_1,
		COLOR_RED, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_MBR_2,
		COLOR_GREEN, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_MBR_3,
		COLOR_BLUE, COLOR_BLACK, A_BOLD | A_REVERSE, },

	{ 0, N_MSG_ATTR_MBR_4,
		COLOR_CYAN, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_MBR_5,
		COLOR_MAGENTA, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_MBR_6,
		COLOR_YELLOW, COLOR_BLACK, A_REVERSE, },
};

/**/

void	init_curs( void )
{
	flg_curs = 0;
	flg_curs_draw = 0;
}

/**/

bool_t	init_curs_color( void )
{
#if	HAVE_LIBCURSES
	curs_attr_n_t	n;

	flg_color = TRUE;

	if( !has_colors() ){
		flg_color = FALSE;
		return FALSE;
	}
	if( start_color() != OK ){
		flg_color = FALSE;
		return FALSE;
	}

	for( n = 0; n < CURS_ATTR_MAX_N; n++ ){
		short	pair_n;

		pair_n = n + 1;
		init_curs_color_pair( &(g_curs_attr[n]), pair_n );
		g_curs_attr[n].color_pair_n = pair_n;
	}
#endif	/* HAVE_LIBCURSES */

	return TRUE;
}

/**/

bool_t	init_curs_color_pair( curs_attr_t *p, short pair_n )
{
#if	HAVE_LIBCURSES
	if( !flg_color )
		return FALSE;

	init_pair( pair_n, p->fg, p->bg );
	p->color_pair_n = pair_n;
#endif	/* HAVE_LIBCURSES */

	return TRUE;
}

/**/

bool_t	chk_curs_draw( void )
{
	return( flg_curs_draw > 0 );
}

/**/

void	ena_curs_draw( void )
{
	flg_curs_draw++;
}

/**/

void	dis_curs_draw( void )
{
	flg_curs_draw--;
}

/**/

bool_t	chk_curs( void )
{
	return( flg_curs > 0 );
}

/**/

void	ena_curs( void )
{
#if	HAVE_LIBCURSES
	if( chk_curs() ){
		noecho();
		cbreak();
		raw();
	}
#endif	/* HAVE_LIBCURSES */
}

/**/

void	dis_curs( void )
{
#if	HAVE_LIBCURSES
	if( chk_curs() ){
		noraw();
		nocbreak();
		echo();
	}
#endif	/* HAVE_LIBCURSES */
}

/**/

void	curs_clearok( WINDOW *win, bool_t bf )
{
	flg_curs++;

#if	HAVE_LIBCURSES
	if( flg_curs == 1 ){
		clearok( win, bf );
		ena_curs();
	}
#endif	/* HAVE_LIBCURSES */
}

/**/

void	curs_initscr( void )
{
	flg_curs++;

#if	HAVE_LIBCURSES
	if( flg_curs == 1 ){
		initscr();
		ena_curs();
		init_curs_color();
	}
#endif	/* HAVE_LIBCURSES */
}

/**/

void	curs_endwin( void )
{
#if	HAVE_LIBCURSES
	if( flg_curs == 1 ){
		dis_curs();
		endwin();
	}
#endif	/* HAVE_LIBCURSES */

	flg_curs--;
}

/**/

void	curs_keypad( WINDOW *win, bool_t bf )
{
#if	HAVE_LIBCURSES
	if( g_flg_use_keypad )
		keypad( win, bf );
#endif	/* HAVE_LIBCURSES */
}

/**/

void	curs_refresh( void )
{
	if( !chk_curs_draw() )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		refresh();
		return;
	}
#endif	/* HAVE_LIBCURSES */

	fflush( OUT_FP );
}

/**/

curs_attr_t	get_current_attr( void )
{
	return g_current_attr;
}

/**/

void	curs_attrset_dflt( void )
{
	curs_attrset_dir( &(g_curs_attr[CURS_ATTR_N_NORMAL]) );
}

/**/

void	curs_attrset_n( curs_attr_n_t n )
{
	curs_attrset_dir( &(g_curs_attr[n]) );
}

/**/

void	curs_attrset_dir( curs_attr_t *attr )
{
	int	tmp_attr;

	g_current_attr = *attr;

	if( !chk_curs_draw() )
		return;

	tmp_attr = 0;

#if	HAVE_LIBCURSES
	tmp_attr = COLOR_PAIR( attr->color_pair_n );
#endif	/* HAVE_LIBCURSES */

	tmp_attr |= attr->attr;

	curs_attrset( tmp_attr );
}

/**/

void	curs_attrset( int at )
{
	if( !chk_curs_draw() )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		attrset( at );
		return;
	}
#endif	/* HAVE_LIBCURSES */
#if	FLG_PRINT_REVERSE
	if( chk_flg( at, A_REVERSE ) )
		fprintf( OUT_FP, "\033[43m" );
	else
		fprintf( OUT_FP, "\033[m" );
#endif	/* FLG_PRINT_REVERSE */
}

/**/

void	curs_attron( int at )
{
	if( !chk_curs_draw() )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		attron( at );
		return;
	}
#endif	/* HAVE_LIBCURSES */
#if	FLG_PRINT_REVERSE
	if( chk_flg( at, A_REVERSE ) )
		fprintf( OUT_FP, "\033[43m" );
#endif	/* FLG_PRINT_REVERSE */
}

/**/

void	curs_attroff( int at )
{
	if( !chk_curs_draw() )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		attroff( at );
		return;
	}
#endif	/* HAVE_LIBCURSES */
#if	FLG_PRINT_REVERSE
	if( chk_flg( at, A_REVERSE ) )
		fprintf( OUT_FP, "\033[m" );
#endif	/* FLG_PRINT_REVERSE */
}

/**/

void	curs_echo( void )
{
#if	HAVE_LIBCURSES
	echo();
#endif	/* HAVE_LIBCURSES */
}

/**/

void	curs_noecho( void )
{
#if	HAVE_LIBCURSES
	noecho();
#endif	/* HAVE_LIBCURSES */
}

/**/

void	curs_move( int scrn_y, int scrn_x )
{
	if( !chk_curs_draw() )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		move( scrn_y, scrn_x );
		return;
	}
#endif	/* HAVE_LIBCURSES */

	fprintf( OUT_FP, "\033[%d;%dH", scrn_y + 1, scrn_x + 1 );
}

/**/

void	curs_printw( char *s, ... )
{
	va_list	argptr;

	if( !chk_curs_draw() )
		return;

	va_start( argptr, s );

#if	HAVE_LIBCURSES
	if( chk_curs() ){
		vwprintw( stdscr, s, argptr );
		va_end( argptr );
		return;
	}
#endif	/* HAVE_LIBCURSES */

	vfprintf( OUT_FP, s, argptr );

	va_end( argptr );
}

/**/

void	curs_clear( void )
{
	if( !chk_curs_draw() )
		return;

#if	HAVE_LIBCURSES

	if( chk_curs() ){
		clear();
		return;
	}

#endif	/* HAVE_LIBCURSES */

#ifdef	D_X68K

	fprintf( OUT_FP, "\032" );

#else	/* D_X68K */

	{
		long	i;
		const long	max_n = get_max_line();

		for( i = 0; i < max_n; i++ )
			fprintf( OUT_FP, "%*s", SCREEN_WIDTH, " " );
	}

#endif	/* D_X68K */
}

/**/

int	curs_getch( void )
{
#if	HAVE_LIBCURSES
	if( chk_curs() )
		return getch();
#endif	/* HAVE_LIBCURSES */

	return getchar();
}

/**/

void	curs_getnstr( char *s, int len )
{
	static char	buf[255 + 1];

	s[0] = '\0';

	if( !chk_curs_draw() )
		return;

#if	HAVE_LIBCURSES
	if( chk_curs() ){
# if	HAVE_GETNSTR
		getnstr( s, len );
		return;
# endif	/* HAVE_GETNSTR */
	}
#endif	/* HAVE_LIBCURSES */

	fgets( buf, sizeof( buf ) - 1, stdin );
	strncpy( s, buf, len );
}

/**/

curs_attr_t	*get_curs_attr( void )
{
	return g_curs_attr;
}

/**/

bool_t	chk_color( void )
{
	return flg_color;
}

long	get_max_line( void )
{
#if	HAVE_LIBCURSES
	return LINES;
#else	/* HAVE_LIBCURSES */
	return SCREEN_HEIGHT;
#endif	/* HAVE_LIBCURSES */
}

/**/
