/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: dun.h,v 1.12 2003/11/19 13:19:13 bowkenken Exp $
*****************************************************************/

#ifndef	DUN_H
#define	DUN_H

#include	"gmain.h"
#include	"curs.h"

#define	DUN_MAX_LEV_FLOOR	1000
#define	DUN_MAX_LEV_BASE	1000

#define	STAIRS_MAX_R	2

#define	AREA_MAX_X	20
#define	AREA_MAX_Y	20
#define	AREA_MAP_MAX_X	4
#define	AREA_MAP_MAX_Y	4
#define	MAP_MAX_X	(AREA_MAX_X * AREA_MAP_MAX_X)
#define	MAP_MAX_Y	(AREA_MAX_Y * AREA_MAP_MAX_Y)
#define	MAP_DEL_X	-1
#define	MAP_DEL_Y	-1

#define	SECT_NULL	'a'

typedef unsigned long	flg_map_t;

#define	FLG_MAP_OBJ_FIND	(1 << 0)
#define	FLG_MAP_OBJ_PASS	(1 << 1)
#define	FLG_MAP_OBJ_LOOK_FLOOR	(1 << 4)
#define	FLG_MAP_OBJ_LOOK_WALL	(1 << 5)

#define	FLG_MAP_CHR_FIND	(1 << 0)
#define	FLG_MAP_CHR_INVISIBLE	(1 << 1)
#define	FLG_MAP_CHR_NPC	(1 << 2)

#define	FLG_TOTAL_REV	(1 << 0)
#define	FLG_TOTAL_DRAW	(1 << 1)

#define	FLG_DOOR_OPEN	(1 << 0)
#define	FLG_DOOR_JAMMED	(1 << 1)
#define	FLG_DOOR_BROKEN	(1 << 2)
#define	FLG_DOOR_SECRET	(1 << 3)
#define	FLG_DOOR_SRCHED	(1 << 4)
#define	FLG_DOOR_GATE	(1 << 8)
#define	FLG_DOOR_SHOP	(1 << 9)

#define	FACE_MJR_WALL	'#'
#define	FACE_MNR_WALL	'#'
#define	FACE_MJR_FLOOR	'.'
#define	FACE_MNR_FLOOR	' '
#define	FACE_MJR_ITEM	'$'
#define	FACE_MJR_DOOR_CLOSE	'+'
#define	FACE_MJR_DOOR_OPEN	'\''
#define	FACE_MNR_DOOR_NORM	' '
#define	FACE_MNR_DOOR_JAMMED	'^'
#define	FACE_MNR_DOOR_BROKEN	'*'
#define	FACE_MNR_DOOR_SECRET	'#'
#define	FACE_MJR_STAIRS_UP	'<'
#define	FACE_MNR_STAIRS_UP	'<'
#define	FACE_MJR_STAIRS_DOWN	'>'
#define	FACE_MNR_STAIRS_DOWN	'>'
#define	FACE_MJR_TRAP	'^'
#define	FACE_MJR_MBR	'@'
#define	FACE_MJR_SQUARE	'%'

#define	DOOR_MAX_N	64

#define	CRSR_PTN_MAX_N	8
#define	CRSR_PTN_MAX_Y_LEN	16
#define	CRSR_PTN_MAX_X_LEN	16

typedef char	sect_t;

typedef struct {
	long	min_lev, max_lev, sgn_lev;
	rate_t	rate;
	char	ptn[AREA_MAX_Y][AREA_MAX_X];
	sect_t	sect[AREA_MAX_Y][AREA_MAX_X];
} room_ptn_t;

typedef unsigned long	flg_door_t;

typedef struct {
	long	n;
	long	x, y;
	long	dx, dy;
	char	mjr, mnr;
	flg_door_t	flg;
} door_t;

typedef struct {
	char	mjr[MAP_MAX_Y][MAP_MAX_X];	/* major face */
	char	mnr[MAP_MAX_Y][MAP_MAX_X];	/* minor face */
	flg_map_t	flg[MAP_MAX_Y][MAP_MAX_X];
} map_t;

typedef struct {
	map_t	obj;
	map_t	chr;
	map_t	total;
	sect_t	sect[MAP_MAX_Y][MAP_MAX_X];
	long	light_depth_obj[MAP_MAX_Y][MAP_MAX_X];
	long	light_depth_chr[MAP_MAX_Y][MAP_MAX_X];
	curs_attr_t	attr[MAP_MAX_Y][MAP_MAX_X];
} all_map_t;

typedef short	area_t;

typedef struct {
	all_map_t	map;
	area_t	area[AREA_MAP_MAX_Y][AREA_MAP_MAX_X];;
	door_t	door[DOOR_MAX_N];
	long	door_n;
	long	lev;
} dun_t;

typedef struct {
	long	x, y;
	long	x_len, y_len;
	long	mask_chr;
	char	face[CRSR_PTN_MAX_Y_LEN][CRSR_PTN_MAX_X_LEN * 2 + 1];
} crsr_ptn_t;

#endif	/* DUN_H */

