/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: fx.c,v 1.72 2003/11/23 04:29:50 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
/*#include	"misc.h"*/
#include	"turn.h"
/*#include	"dun.h"*/
/*#include	"town.h"*/
#include	"item.h"
#include	"spell.h"
/*#include	"chr.h"*/
#include	"party.h"
/*#include	"mnstr.h"*/
/*#include	"pet.h"*/
/*#include	"fight.h"*/
#include	"fx.h"
/*#include	"trap.h"*/
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
#include	"msg.h"
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"misc_prot.h"
#include	"turn_prot.h"
#include	"dun_prot.h"
/*#include	"town_prot.h"*/
#include	"item_prot.h"
#include	"spell_prot.h"
#include	"chr_prot.h"
#include	"party_prot.h"
#include	"mnstr_prot.h"
/*#include	"pet_prot.h"*/
#include	"fight_prot.h"
#include	"fx_prot.h"
#include	"trap_prot.h"
#include	"draw_prot.h"
#include	"curs_prot.h"
#include	"menu_prot.h"
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

#define	FX_MAX_N	(LS_MBR_MAX_N * 16)

#define	NATURAL_CURE_HP_TURN	32
#define	NATURAL_CURE_HP_RATE	5
#define	NATURAL_CURE_HP_RATE_NOT_WARE	8
#define	NATURAL_CURE_HP_MAX	16
#define	NATURAL_CURE_HP_MAX_NOT_WARE	20

#define	NATURAL_CURE_MP_TURN	64
#define	NATURAL_CURE_MP_RATE	5
#define	NATURAL_CURE_MP_RATE_NOT_WARE	8
#define	NATURAL_CURE_MP_MAX	16
#define	NATURAL_CURE_MP_MAX_NOT_WARE	20

#define	CURE_HP_LIGHT_N	10
#define	CURE_HP_MODERATE_N	50
#define	CURE_HP_SERIOUS_N	100

#define	CURE_HP_UNDEAD_RATE	10
#define	DISPEL_UNDEAD_RATE	((rate_t)200)

#define	POW_UP_RESI_RATE	_100_PERCENT

#define	POISON_DEC_N	1
#define	SOBER_AVE_TURN	12
#define	SOBER_SUB_RATE	1
#define	HUNGRY_FEEL_RATE	10
#define	STARVATION_FEEL_RATE	10
#define	FAINT_FEEL_RATE	20

#define	SMOKING_PER_A_DAY	20
#define	TOBACCO_ABSTAIN_AVE_TURN	\
		(TURN_DAYTIME / SMOKING_PER_A_DAY / 10)
#define	TOBACCO_ABSTAIN_SUB_RATE	2
#define	TOBACCO_POISONING_AVE_TURN	1
#define	TOBACCO_POISONING_ADD_RATE	1
#define	TOBACCO_CURE_POISONING_AVE_TURN	(1 * TURN_PER_HOUR)
#define	TOBACCO_CURE_POISONING_SUB_RATE	1
#define	TOBACCO_FEEL_AVE_TURN	10
#define	TOBACCO_FEEL_MAX_RATE	50
#define	ADD_NICOTINE_RATE_PER_TURN	\
		(_100_PERCENT / (5 * TURN_PER_MINUTE) + 1)

#define	RANDM_TELEPORT_RATE	1
#define	RANDM_TELEPORT_PARTY_RATE	1

#define	FX_DETECT_ITEM_R	(MAP_MAX_X / 3)
#define	FX_DETECT_DOOR_R	(MAP_MAX_X / 3)
#define	FX_DETECT_TRAP_R	(MAP_MAX_X / 3)

#define	FX_ABL_LEV_POW_UP_N	(+2)
#define	FX_ABL_LEV_POW_DOWN_N	(-1)
#define	FX_HP_LEV_POW_UP_N	(+2)

#define	DEATH_SPELL_RATE	30

#define	FX_REMOVE_CURSE_DIFFICULTY	4
#define	FX_BLESS_ADD_RATE	20

#define	MOVE_MIN_N	4
#define	MOVE_MAX_N	4

#define	FACE_MJR_ZAP	'*'
#define	ANIM_ZAP_LEN	(ANIM_FRAME_N / 4)

/**/

static short	liquor_proof[LIQUOR_KIND_MAX_N] = {
	20,	/* LIQUOR_KIND_RED_WINE, */
	20,	/* LIQUOR_KIND WHITE_WINE, */
	20,	/* LIQUOR_KIND_ROSE_WINE, */
	30,	/* LIQUOR_KIND_ALE, */
	30,	/* LIQUOR_KIND_BRANDY, */
	30,	/* LIQUOR_KIND_RUM, */
};

static n_msg_t	drink_n_msg_ls[] = {
	N_MSG_FX_DRINK_A00,
	N_MSG_FX_DRINK_A01,
	N_MSG_FX_DRINK_A02,
	N_MSG_FX_DRINK_A03,
	N_MSG_FX_DRINK_A04,
	N_MSG_FX_DRINK_A05,
	N_MSG_FX_DRINK_B00,
	N_MSG_NULL,
};

static n_msg_t	eat_food_n_msg_ls[] = {
	N_MSG_FX_EAT_FOOD_A00,
	N_MSG_FX_EAT_FOOD_A01,
	N_MSG_FX_EAT_FOOD_A02,
	N_MSG_FX_EAT_FOOD_A03,
	N_MSG_FX_EAT_FOOD_A04,
	N_MSG_FX_EAT_FOOD_A05,
	N_MSG_FX_EAT_FOOD_A06,
	N_MSG_FX_EAT_FOOD_A07,
	N_MSG_FX_EAT_FOOD_A08,
	N_MSG_FX_EAT_FOOD_B00,
	N_MSG_FX_EAT_FOOD_B01,
	N_MSG_FX_EAT_FOOD_B02,
	N_MSG_NULL,
};

static fx_t	fx_buf[FX_MAX_N];
static fx_t	fx_free;

static blast_t	blast = {
	0, 0, 0, 0,
	{
		"  *  ",
		" *** ",
		"*****",
		" *** ",
		"  *  ",
	},
};

/**/

void	init_fx( void )
{
	long	i;

	fx_free.next = &fx_buf[0];
	fx_buf[0].prev = &fx_free;
	fx_buf[0].next = &fx_buf[1];
	for( i = 1; i < FX_MAX_N - 1; i++ ){
		fx_buf[i].prev = &fx_buf[i - 1];
		fx_buf[i].next = &fx_buf[i + 1];
	}
	fx_buf[i].prev = &fx_buf[i - 1];
	fx_buf[i].next = &fx_free;
	fx_free.prev = &fx_buf[i];
}

/**/

void	inc_turn_all_fx( void )
{
	long	i;
	mnstr_t	*mns_head, *mns_p, *mns_pp;
	party_t	*pty;

	/* ƥСΥեȤμ¹ */

	pty = get_party();
	dec_turn_fx_all_mbr( 1 );
	for( i = 0; i < MBR_MAX_N; i++ ){
		mbr_t	*mbr;

		mbr = pty->mbr[i];

		if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST
				| FLG_STAT_DEAD ) ){
			continue;
		}

		/* HP μ */
		natural_cure_hp_mbr( mbr );

		/* MP μ */
		natural_cure_mp_mbr( mbr );

		/* äν */
		sober( mbr );

		/* ʪò */
		digest( mbr );

		/* Х */
		inc_turn_smoke( mbr );

		/* ХζǾɾ */
		abstain( mbr );

		/* ɤʤ */
		fraternize( mbr );

		/* Żǽϸ */
		dec_infra_vision( mbr );

		/* ƥݡ */
		randm_teleport( mbr );
		randm_teleport_party( mbr );

		exec_all_fx( mbr );
	}

	/* ƥ󥹥ΥեȤμ¹ */

	dec_turn_fx_all_mnstr( 1 );

	mns_head = get_mnstr_used();
	for( mns_p = mns_head->next->next; mns_p != NULL;
			mns_p = mns_p->next ){
		mns_pp = mns_p->prev;
		if( mns_pp == mns_head )
			break;

		/* äν */
		sober( mns_pp );

		/* ʪò */
		digest( mns_pp );

		/* ХζǾɾ */
		abstain( mns_pp );

		/* Żǽϸ */
		dec_infra_vision( mns_pp );

		/* ƥݡ */
		randm_teleport( mns_pp );

		exec_all_fx( mns_pp );
	}
}

/**/

void	natural_cure_hp_mbr( mbr_t *mbr )
{
	fx_t	*fx;
	bool_t	flg_wear;
	rate_t	rate;
	long	n, max;

	if( (get_turn() % NATURAL_CURE_HP_TURN) != 0 )
		return;
	if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	/* ǤˤƤϲʤ */
	fx = srch_fx( &(mbr->fx), FX_KIND_POISON );
	if( fx != NULL )
		return;

	flg_wear = chk_wear_armor( mbr );
	if( flg_wear )
		rate = NATURAL_CURE_HP_RATE;
	else
		rate = NATURAL_CURE_HP_RATE_NOT_WARE;

	max = calc_max_hp( mbr );
	n = (max * rate) / _100_PERCENT;
	if( n < 1 )
		n = 1;
	if( flg_wear ){
		if( n > NATURAL_CURE_HP_MAX )
			n = NATURAL_CURE_HP_MAX;
	} else {
		if( n > NATURAL_CURE_HP_MAX_NOT_WARE )
			n = NATURAL_CURE_HP_MAX_NOT_WARE;
	}

	add_hp( mbr, +n );
}

/**/

void	natural_cure_mp_mbr( mbr_t *mbr )
{
	bool_t	flg_wear;
	rate_t	rate;
	long	n, max;

	if( mbr == NULL )
		return;

	if( (get_turn() % NATURAL_CURE_MP_TURN) != 0 )
		return;
	if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	flg_wear = chk_wear_armor( mbr );
	if( flg_wear )
		rate = NATURAL_CURE_MP_RATE;
	else
		rate = NATURAL_CURE_MP_RATE_NOT_WARE;

	max = calc_max_mp( mbr );
	n = (max * rate) / _100_PERCENT;
	if( n < 1 )
		n = 1;
	if( flg_wear ){
		if( n > NATURAL_CURE_MP_MAX )
			n = NATURAL_CURE_MP_MAX;
	} else {
		if( n > NATURAL_CURE_MP_MAX_NOT_WARE )
			n = NATURAL_CURE_MP_MAX_NOT_WARE;
	}

	add_mp( mbr, n );
}

/**/

void	sober( chr_t *chr )
{
	if( !per_randm( SOBER_AVE_TURN ) )
		return;

	chr->fx_data.drunk_rate -= SOBER_SUB_RATE;
	if( chr->fx_data.drunk_rate < 0 )
		chr->fx_data.drunk_rate = 0;
}

/**/

void	dec_turn_fx_all_mbr( long turn )
{
	long	i;
	party_t	*pty;

	pty = get_party();

	for( i = 0; i < MBR_MAX_N; i++ ){
		mbr_t	*mbr;
		fx_t	*fx, *end;

		mbr = pty->mbr[i];

		if( chk_flg_or( mbr->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		end = &(mbr->fx);
		for( fx = end->next->next; fx->prev != end; fx = fx->next ){
			if( fx->prev->kind == FX_KIND_NULL )
				break;
			if( fx->prev->turn == FX_TURN_INFINITE_N )
				continue;
			if( fx->prev->turn > 0 )
				fx->prev->turn -= turn;
			if( fx->prev->turn > 0 )
				continue;

			clr_fx( fx->prev );
		}
	}
}

/**/

void	dec_turn_fx_all_mnstr( long turn )
{
	mnstr_t	*mns_head, *mns_p, *mns_pp;
	fx_t	*fx, *end;

	mns_head = get_mnstr_used();
	for( mns_p = mns_head->next->next; mns_p != NULL;
			mns_p = mns_p->next ){
		mns_pp = mns_p->prev;
		if( mns_pp == mns_head )
			break;

		end = &mns_pp->fx;
		for( fx = end->next->next; fx->prev != end; fx = fx->next ){
			if( fx->prev->turn == FX_TURN_INFINITE_N )
				continue;
			if( fx->prev->turn > 0 )
				fx->prev->turn -= turn;
			if( fx->prev->turn > 0 )
				continue;

			clr_fx( fx->prev );
		}
	}
}

/**/

abl_kind_t	get_fx_to_abl( fx_kind_t kind )
{
	switch( kind ){
	default:
		return ABL_KIND_MAX_N;
	case FX_KIND_SHARPNESS:
	case FX_KIND_DULLNESS:
		return ABL_KIND_DEX;
	case FX_KIND_STRENGTH:
	case FX_KIND_WEAKNESS:
		return ABL_KIND_STR;
	case FX_KIND_QUICKNESS:
	case FX_KIND_SLOWNESS:
		return ABL_KIND_AGI;
	case FX_KIND_WISE:
	case FX_KIND_FOOLISH:
		return ABL_KIND_WIS;
	case FX_KIND_BRAINY:
	case FX_KIND_BRAINLESS:
		return ABL_KIND_INT;
	case FX_KIND_ATTRACTIVE:
	case FX_KIND_UNATTRACTIVE:
		return ABL_KIND_CHA;
	}

	return ABL_KIND_MAX_N;
}

/**/

long	get_fx_to_abl_add( fx_kind_t kind )
{
	switch( kind ){
	default:
		return 0;
	case FX_KIND_SHARPNESS:
	case FX_KIND_STRENGTH:
	case FX_KIND_QUICKNESS:
	case FX_KIND_WISE:
	case FX_KIND_BRAINY:
	case FX_KIND_ATTRACTIVE:
		return FX_ABL_LEV_POW_UP_N;
	case FX_KIND_DULLNESS:
	case FX_KIND_WEAKNESS:
	case FX_KIND_SLOWNESS:
	case FX_KIND_FOOLISH:
	case FX_KIND_BRAINLESS:
	case FX_KIND_UNATTRACTIVE:
		return FX_ABL_LEV_POW_DOWN_N;
	}

	return 0;
}

/**/

void	exec_all_fx( mbr_t *mbr )
{
	fx_t	*fx, *end;

	if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	end = &mbr->fx;
	for( fx = end->next->next; fx->prev != end; fx = fx->next )
		exec_fx( fx->prev );
}

/**/

fx_t	*set_fx( chr_t *chr, fx_kind_t kind, long turn )
{
	fx_t	*fx;
	char	*s;
	flg_map_t	flg_map;
	bool_t	flg_lost_other, flg_lost_self;

	if( chr == NULL )
		return NULL;
	if( (kind == FX_KIND_NULL) || (kind == FX_KIND_MAX_N) )
		return NULL;

	flg_map = FLG_NULL;
	flg_lost_other = FALSE;
	flg_lost_self = FALSE;

	/* Ǥ˥եȤ뤫 */
	fx = srch_fx( &(chr->fx), kind );
	if( fx == NULL ){
		fx = asgn_fx( chr->fx.next );
		/* եȤäѤ */
		if( fx == NULL )
			return NULL;

		fx->kind = kind;
		fx->turn = 0;
		fx->n = 0;
		fx->chr = chr;
	}

	if( turn == FX_TURN_INFINITE_N )
		fx->turn = FX_TURN_INFINITE_N;
	else
		fx->turn = turn + roll_dice( turn );

	if( fx->chr == NULL )
		s = MSG_MNSTR_UNKNOWN;
	else
		s = fx->chr->name;

	/**/

	switch( fx->kind ){
	case FX_KIND_NULL:
	case FX_KIND_MAX_N:
		return fx;
	case FX_KIND_STONE:
		set_fx_stat( fx, FLG_STAT_STONE );
		print_msg_find( chr, FLG_NULL, MSG_FX_STONE, s );
		break;
	case FX_KIND_PARALYZE:
		set_fx_stat( fx, FLG_STAT_PARALYZE );
		print_msg_find( chr, FLG_NULL, MSG_FX_PARALYZE, s );
		break;
	case FX_KIND_POISON:
		set_fx_stat( fx, FLG_STAT_POISON );
		print_msg_find( chr, FLG_NULL, MSG_FX_POISON, s );
		break;
	case FX_KIND_CONFUSION:
		set_fx_stat( fx, FLG_STAT_CONFUSION );
		print_msg_find( chr, FLG_NULL, MSG_FX_CONFUSION, s );
		break;
	case FX_KIND_BLIND:
		set_fx_stat( fx, FLG_STAT_BLIND );
		if( fx->chr != NULL )
			clr_chr_trgt_act( fx->chr, FALSE );
		print_msg_find( chr, FLG_NULL, MSG_FX_BLIND, s );
		break;
	case FX_KIND_SLEEP:
		set_fx_stat( fx, FLG_STAT_SLEEP );
		print_msg_find( chr, FLG_NULL, MSG_FX_SLEEP, s );
		break;
	case FX_KIND_SILENCE:
		set_fx_stat( fx, FLG_STAT_SILENCE );
		print_msg_find( chr, FLG_NULL, MSG_FX_SILENCE, s );
		break;
	case FX_KIND_FEAR:
		set_fx_stat( fx, FLG_STAT_FEAR );
		print_msg_find( chr, FLG_NULL, MSG_FX_FEAR, s );
		break;
	case FX_KIND_HALLUCINATION:
		set_fx_stat( fx, FLG_STAT_HALLUCINATION );
		print_msg_find( chr, FLG_NULL, MSG_FX_HALLUCINATION, s );
		break;
	case FX_KIND_CHARM:
		set_fx_stat( fx, FLG_STAT_CHARM );
		print_msg_find( chr, FLG_NULL, MSG_FX_CHARM, s );
		break;
	case FX_KIND_FLY:
		set_fx_stat( fx, FLG_STAT_FLY );
		print_msg_find( chr, FLG_NULL, MSG_FX_FLY, s );
		break;
	case FX_KIND_FAINT:
		set_fx_stat( fx, FLG_STAT_FAINT );
		print_msg_find( chr, FLG_NULL, MSG_FX_FAINT, s );
		break;
	case FX_KIND_DRUNK:
		set_fx_stat( fx, FLG_STAT_DRUNK );
		print_msg_find( chr, FLG_NULL, MSG_FX_DRUNK, s );
		break;
	case FX_KIND_VANISH:
		set_fx_stat( fx, FLG_STAT_VANISH );
		if( fx->chr != NULL ){
			fx->chr->flg_map |= FLG_MAP_CHR_INVISIBLE;
			lost_trgt( fx->chr );
		}
		print_msg_find( chr, FLG_NULL, MSG_FX_VANISH, s );
		break;
	case FX_KIND_RESI_KNOC:
		set_fx_resi( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_RESI_PHYS, s );
		break;
	case FX_KIND_RESI_SLAS:
		set_fx_resi( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_RESI_PHYS, s );
		break;
	case FX_KIND_RESI_STIN:
		set_fx_resi( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_RESI_PHYS, s );
		break;
	case FX_KIND_RESI_HEAT:
		set_fx_resi( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_RESI_HEAT, s );
		break;
	case FX_KIND_RESI_COLD:
		set_fx_resi( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_RESI_COLD, s );
		break;
	case FX_KIND_RESI_ACID:
		set_fx_resi( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_RESI_ACID, s );
		break;
	case FX_KIND_RESI_MIND:
		set_fx_resi( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_RESI_MIND, s );
		break;
	case FX_KIND_RESI_ELEC:
		set_fx_resi( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_RESI_ELEC, s );
		break;
	case FX_KIND_RESI_POIS:
		set_fx_resi( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_RESI_POIS, s );
		break;
	case FX_KIND_SHARPNESS:
		set_fx_abl( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_SHARPNESS, s );
		break;
	case FX_KIND_DULLNESS:
		set_fx_abl( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_DULLNESS, s );
		break;
	case FX_KIND_STRENGTH:
		set_fx_abl( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_STRENGTH, s );
		break;
	case FX_KIND_WEAKNESS:
		set_fx_abl( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_WEAKNESS, s );
		break;
	case FX_KIND_QUICKNESS:
		set_fx_abl( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_QUICKNESS, s );
		break;
	case FX_KIND_SLOWNESS:
		set_fx_abl( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_SLOWNESS, s );
		break;
	case FX_KIND_WISE:
		set_fx_abl( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_WISE, s );
		break;
	case FX_KIND_FOOLISH:
		set_fx_abl( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_FOOLISH, s );
		break;
	case FX_KIND_BRAINY:
		set_fx_abl( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_BRAINY, s );
		break;
	case FX_KIND_BRAINLESS:
		set_fx_abl( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_BRAINLESS, s );
		break;
	case FX_KIND_ATTRACTIVE:
		set_fx_abl( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_ATTRACTIVE, s );
		break;
	case FX_KIND_UNATTRACTIVE:
		set_fx_abl( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_UNATTRACTIVE, s );
		break;
	case FX_KIND_SENSE_INVISIBLE:

		print_msg_find( chr, FLG_NULL, MSG_FX_SENSE_INVISIBLE, s );
		break;
	case FX_KIND_POW_UP_HP:
		set_fx_pow_up_hp( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_POW_UP_HP, s );
		break;
	case FX_KIND_MAGIC_SHIELD:
		if( set_fx_magic_armor( fx ) ){
			print_msg_find( chr, FLG_NULL,
					MSG_FX_MAGIC_SHIELD, s );
		}
		break;
	case FX_KIND_MAGE_ARMOR:
		if( set_fx_magic_armor( fx ) )
			print_msg_find( chr, FLG_NULL, MSG_FX_MAGE_ARMOR, s );
		break;
	case FX_KIND_SPEED_UP:
		set_fx_speed( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_SPEED_UP, s );
		break;
	case FX_KIND_SPEED_DOWN:
		set_fx_speed( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_SPEED_DOWN, s );
		break;
	case FX_KIND_BLESS:
		set_fx_bless( fx );
		print_msg_find( chr, FLG_NULL, MSG_FX_BLESS, s );
		break;
	}

	draw_mbr_stat( chr );

	return fx;
}

/**/

void	exec_fx( fx_t *p )
{
	if( p == NULL )
		return;

	switch( p->kind ){
	case FX_KIND_NULL:
	case FX_KIND_MAX_N:
		return;
	case FX_KIND_STONE:
	case FX_KIND_PARALYZE:
		break;
	case FX_KIND_POISON:
		exec_fx_poison( p );
		break;
	case FX_KIND_CONFUSION:
	case FX_KIND_BLIND:
	case FX_KIND_SLEEP:
	case FX_KIND_SILENCE:
	case FX_KIND_FEAR:
	case FX_KIND_HALLUCINATION:
	case FX_KIND_CHARM:
	case FX_KIND_FLY:
	case FX_KIND_FAINT:
	case FX_KIND_DRUNK:
	case FX_KIND_VANISH:
		break;
	case FX_KIND_RESI_KNOC:
	case FX_KIND_RESI_SLAS:
	case FX_KIND_RESI_STIN:
	case FX_KIND_RESI_HEAT:
	case FX_KIND_RESI_COLD:
	case FX_KIND_RESI_ACID:
	case FX_KIND_RESI_MIND:
	case FX_KIND_RESI_ELEC:
	case FX_KIND_RESI_POIS:
		break;
	case FX_KIND_SHARPNESS:
	case FX_KIND_DULLNESS:
	case FX_KIND_STRENGTH:
	case FX_KIND_WEAKNESS:
	case FX_KIND_QUICKNESS:
	case FX_KIND_SLOWNESS:
	case FX_KIND_WISE:
	case FX_KIND_FOOLISH:
	case FX_KIND_BRAINY:
	case FX_KIND_BRAINLESS:
	case FX_KIND_ATTRACTIVE:
	case FX_KIND_UNATTRACTIVE:
		break;
	case FX_KIND_SENSE_INVISIBLE:
	case FX_KIND_POW_UP_HP:
		break;
	case FX_KIND_MAGIC_SHIELD:
	case FX_KIND_MAGE_ARMOR:
		break;
	case FX_KIND_SPEED_UP:
	case FX_KIND_SPEED_DOWN:
		break;
	case FX_KIND_BLESS:
		break;
	}
}

/**/

void	clr_fx( fx_t *fx )
{
	char	*s;

	if( fx == NULL )
		return;

	if( fx->chr == NULL )
		s = MSG_MNSTR_UNKNOWN;
	else
		s = fx->chr->name;

	switch( fx->kind ){
	case FX_KIND_NULL:
	case FX_KIND_MAX_N:
		break;
	case FX_KIND_STONE:
		clr_fx_stat( fx, FLG_STAT_STONE );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_STONE, s );
		break;
	case FX_KIND_PARALYZE:
		clr_fx_stat( fx, FLG_STAT_PARALYZE );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_PARALYZE, s );
		break;
	case FX_KIND_POISON:
		clr_fx_stat( fx, FLG_STAT_POISON );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_POISON, s );
		break;
	case FX_KIND_CONFUSION:
		clr_fx_stat( fx, FLG_STAT_CONFUSION );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_CONFUSION, s );
		break;
	case FX_KIND_BLIND:
		clr_fx_stat( fx, FLG_STAT_BLIND );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_BLIND, s );
		break;
	case FX_KIND_SLEEP:
		clr_fx_stat( fx, FLG_STAT_SLEEP );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_SLEEP, s );
		break;
	case FX_KIND_SILENCE:
		clr_fx_stat( fx, FLG_STAT_SILENCE );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_SILENCE, s );
		break;
	case FX_KIND_FEAR:
		clr_fx_stat( fx, FLG_STAT_FEAR );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_FEAR, s );
		break;
	case FX_KIND_HALLUCINATION:
		clr_fx_stat( fx, FLG_STAT_HALLUCINATION );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_HALLUCINATION, s );
		break;
	case FX_KIND_CHARM:
		clr_fx_stat( fx, FLG_STAT_CHARM );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_CHARM, s );
		break;
	case FX_KIND_FLY:
		clr_fx_stat( fx, FLG_STAT_FLY );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_FLY, s );
		break;
	case FX_KIND_FAINT:
		clr_fx_stat( fx, FLG_STAT_FAINT );
		break;
	case FX_KIND_DRUNK:
		clr_fx_stat( fx, FLG_STAT_DRUNK );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_DRUNK, s );
		break;
	case FX_KIND_VANISH:
		clr_fx_stat( fx, FLG_STAT_VANISH );
		if( fx->chr != NULL )
			fx->chr->flg_map &= ~(FLG_MAP_CHR_INVISIBLE);
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_VANISH, s );
		break;
	case FX_KIND_RESI_KNOC:
		clr_fx_resi( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_RESI_KNOC, s );
		break;
	case FX_KIND_RESI_SLAS:
		clr_fx_resi( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_RESI_SLAS, s );
		break;
	case FX_KIND_RESI_STIN:
		clr_fx_resi( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_RESI_STIN, s );
		break;
	case FX_KIND_RESI_HEAT:
		clr_fx_resi( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_RESI_HEAT, s );
		break;
	case FX_KIND_RESI_COLD:
		clr_fx_resi( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_RESI_COLD, s );
		break;
	case FX_KIND_RESI_ACID:
		clr_fx_resi( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_RESI_ACID, s );
		break;
	case FX_KIND_RESI_MIND:
		clr_fx_resi( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_RESI_MIND, s );
		break;
	case FX_KIND_RESI_ELEC:
		clr_fx_resi( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_RESI_ELEC, s );
		break;
	case FX_KIND_RESI_POIS:
		clr_fx_resi( fx ); 
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_RESI_POIS, s );
		break;
	case FX_KIND_SHARPNESS:
		clr_fx_abl( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_SHARPNESS, s );
		break;
	case FX_KIND_DULLNESS:
		clr_fx_abl( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_DULLNESS, s );
		break;
	case FX_KIND_STRENGTH:
		clr_fx_abl( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_STRENGTH, s );
		break;
	case FX_KIND_WEAKNESS:
		clr_fx_abl( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_WEAKNESS, s );
		break;
	case FX_KIND_QUICKNESS:
		clr_fx_abl( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_QUICKNESS, s );
		break;
	case FX_KIND_SLOWNESS:
		clr_fx_abl( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_SLOWNESS, s );
		break;
	case FX_KIND_WISE:
		clr_fx_abl( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_WISE, s );
		break;
	case FX_KIND_FOOLISH:
		clr_fx_abl( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_FOOLISH, s );
		break;
	case FX_KIND_BRAINY:
		clr_fx_abl( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_BRAINY, s );
		break;
	case FX_KIND_BRAINLESS:
		clr_fx_abl( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_BRAINLESS, s );
		break;
	case FX_KIND_ATTRACTIVE:
		clr_fx_abl( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_ATTRACTIVE, s );
		break;
	case FX_KIND_UNATTRACTIVE:
		clr_fx_abl( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_UNATTRACTIVE, s );
		break;
	case FX_KIND_SENSE_INVISIBLE:
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_SENSE_INVISIBLE, s );
		break;
	case FX_KIND_POW_UP_HP:
		clr_fx_pow_up_hp( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_POW_UP_HP, s );
		break;
	case FX_KIND_MAGIC_SHIELD:
		clr_fx_magic_armor( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_MAGIC_SHIELD, s );
		break;
	case FX_KIND_MAGE_ARMOR:
		clr_fx_magic_armor( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_MAGE_ARMOR, s );
		break;
	case FX_KIND_SPEED_UP:
		clr_fx_speed( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_SPEED_UP, s );
		break;
	case FX_KIND_SPEED_DOWN:
		clr_fx_speed( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_SPEED_DOWN, s );
		break;
	case FX_KIND_BLESS:
		clr_fx_bless( fx );
		print_msg_find( fx->chr, FLG_NULL,
				MSG_CLR_FX_BLESS, s );
		break;
	}

	draw_mbr_stat( fx->chr );

	free_fx( fx );
}

/**/

void	set_fx_stat( fx_t *fx, flg_stat_t flg )
{
	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	fx->chr->stat |= flg;
}

/**/

void	clr_fx_stat( fx_t *fx, flg_stat_t flg )
{
	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	fx->chr->stat &= ~(flg);
}

/**/

void	set_fx_abl( fx_t *fx )
{
	abl_kind_t	abl;
	long	n;
	modifier_t	m;

	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	abl = get_fx_to_abl( fx->kind );
	if( abl == ABL_KIND_MAX_N )
		return;

	n = get_fx_to_abl_add( fx->kind );

	get_modifier_fx( fx->chr, &m );
	m.add_lev[abl] += n;
	set_modifier_fx( fx->chr, &m );
}

/**/

void	clr_fx_abl( fx_t *fx )
{
	abl_kind_t	abl;
	long	n;
	modifier_t	m;

	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	abl = get_fx_to_abl( fx->kind );
	if( abl == ABL_KIND_MAX_N )
		return;

	n = get_fx_to_abl_add( fx->kind );

	get_modifier_fx( fx->chr, &m );
	m.add_lev[abl] -= n;
	set_modifier_fx( fx->chr, &m );
}

/**/

void	set_fx_resi( fx_t *fx )
{
	resi_kind_t	resi;

	switch( fx->kind ){
	default:
		return;
	case FX_KIND_RESI_KNOC:
		resi = RESI_KIND_KNOC;
		break;
	case FX_KIND_RESI_SLAS:
		resi = RESI_KIND_SLAS;
		break;
	case FX_KIND_RESI_STIN:
		resi = RESI_KIND_STIN;
		break;
	case FX_KIND_RESI_HEAT:
		resi = RESI_KIND_HEAT;
		break;
	case FX_KIND_RESI_COLD:
		resi = RESI_KIND_COLD;
		break;
	case FX_KIND_RESI_ACID:
		resi = RESI_KIND_ACID;
		break;
	case FX_KIND_RESI_MIND:
		resi = RESI_KIND_MIND;
		break;
	case FX_KIND_RESI_ELEC:
		resi = RESI_KIND_ELEC;
		break;
	case FX_KIND_RESI_POIS:
		resi = RESI_KIND_POIS;
		break;
	}

	pow_up_resi( fx->chr, resi );
}

/**/

void	clr_fx_resi( fx_t *fx )
{
	resi_kind_t	resi;

	switch( fx->kind ){
	default:
		return;
	case FX_KIND_RESI_KNOC:
		resi = RESI_KIND_KNOC;
		break;
	case FX_KIND_RESI_SLAS:
		resi = RESI_KIND_SLAS;
		break;
	case FX_KIND_RESI_STIN:
		resi = RESI_KIND_STIN;
		break;
	case FX_KIND_RESI_HEAT:
		resi = RESI_KIND_HEAT;
		break;
	case FX_KIND_RESI_COLD:
		resi = RESI_KIND_COLD;
		break;
	case FX_KIND_RESI_ACID:
		resi = RESI_KIND_ACID;
		break;
	case FX_KIND_RESI_MIND:
		resi = RESI_KIND_MIND;
		break;
	case FX_KIND_RESI_ELEC:
		resi = RESI_KIND_ELEC;
		break;
	case FX_KIND_RESI_POIS:
		resi = RESI_KIND_POIS;
		break;
	}

	pow_down_resi( fx->chr, resi );
}

/**/

void	set_fx_pow_up_hp( fx_t *fx )
{
	pow_up_hp( fx, +FX_HP_LEV_POW_UP_N );
}

/**/

void	clr_fx_pow_up_hp( fx_t *fx )
{
	pow_up_hp( fx, -FX_HP_LEV_POW_UP_N );
}

/**/

bool_t	set_fx_magic_armor( fx_t *fx )
{
	return add_fx_magic_armor( fx, +1 );
}

/**/

bool_t	clr_fx_magic_armor( fx_t *fx )
{
	if( fx == NULL )
		return FALSE;

	return add_fx_magic_armor( fx, -fx->n );
}

/**/

bool_t	add_fx_magic_armor( fx_t *fx, long n )
{
	rate_t	armor_def, armor_crtcl, armor_ac;
	long	max_n;

	if( fx == NULL )
		return FALSE;
	if( fx->chr == NULL )
		return FALSE;

	armor_def = 0;
	armor_crtcl = 0;
	armor_ac = 0;
	max_n = 0;

	switch( fx->kind ){
	case FX_KIND_MAGIC_SHIELD:
		armor_def = n * MAGIC_SHIELD_ADD_DEF_RATE;
		max_n = MAGIC_SHIELD_MAX_N;
		break;
	case FX_KIND_MAGE_ARMOR:
		armor_ac = n * MAGE_ARMOR_ADD_AC_RATE;
		max_n = MAGE_ARMOR_MAX_N;
		break;
	default:
		return FALSE;
	}

	if( (fx->n + n) >= +max_n )
		return FALSE;
	if( (fx->n + n) <= -max_n )
		return FALSE;
	fx->n += n;

	return magic_armor( fx, armor_def, armor_crtcl, armor_ac );
}

/**/

void	set_fx_speed( fx_t *fx )
{
	modifier_t	m;

	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	get_modifier_fx( fx->chr, &m );
	if( fx->kind == FX_KIND_SPEED_UP ){
		if( fx->n >= MOVE_MAX_N )
			return;
		fx->n++;
		m.add_move_speed++;
	} else if( fx->kind == FX_KIND_SPEED_DOWN ){
		if( fx->n <= MOVE_MIN_N )
			return;
		fx->n--;
		m.add_move_speed--;
	}
	set_modifier_fx( fx->chr, &m );
}

/**/

void	clr_fx_speed( fx_t *fx )
{
	modifier_t	m;

	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	get_modifier_fx( fx->chr, &m );
	m.add_move_speed -= fx->n;
	set_modifier_fx( fx->chr, &m );
}

/**/

void	set_fx_bless( fx_t *fx )
{
	modifier_t	m;

	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	get_modifier_fx( fx->chr, &m );
	m.bless = FX_BLESS_ADD_RATE;
	set_modifier_fx( fx->chr, &m );
}

/**/

void	clr_fx_bless( fx_t *fx )
{
	modifier_t	m;

	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	get_modifier_fx( fx->chr, &m );
	m.bless = 0;
	set_modifier_fx( fx->chr, &m );
}

/**/

void	exec_fx_poison( fx_t *fx )
{
	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	if( fx->chr->kind == CHR_KIND_MNSTR )
		return;

	if( (get_turn() % FX_AVE_TURN_POISON_DEC) == 0 )
		add_hp( fx->chr, -fx->n );
}

/**/

void	quaff_potion( chr_t *chr, item_t *item, bool_t flg_dec )
{
	item_t	tmp;
	char	*s;
	long	i, n;
	char	*str_drink, *str_name;

	if( chr == NULL )
		return;
	if( item == NULL )
		return;
	if( item->kind != ITEM_KIND_POTION )
		return;

	print_msg_find( chr, FLG_NULL,
			MSG_FX_QUAFF_POTION, chr->name, item->name );

	identify_potion( item );

	copy_item( &tmp, item );
	if( flg_dec )
		inc_item( item, -1 );

	s = chr->name;

	n = 0;
	for( i = 0; i < 1024; i++ ){
		if( drink_n_msg_ls[i] == N_MSG_NULL )
			break;
		if( randm( i + 1 ) == 0 )
			n = i;
	}
	str_drink = MSG( drink_n_msg_ls[n] );

	if( tmp.tab.potion == NULL )
		return;
	str_name = tmp.tab.potion->name;

	switch( tmp.dat.potion.kind ){
	case POTION_KIND_NULL:
	case POTION_KIND_MAX_N:
		break;
	case POTION_KIND_WATER:
		print_msg_find( chr, FLG_NULL, MSG_FX_WATER, s );
		break;
	case POTION_KIND_RED_WINE:
		fx_drink_liquor( chr, &tmp, LIQUOR_KIND_RED_WINE );
		break;
	case POTION_KIND_WHITE_WINE:
		fx_drink_liquor( chr, &tmp, LIQUOR_KIND_WHITE_WINE );
		break;
	case POTION_KIND_ROSE_WINE:
		fx_drink_liquor( chr, &tmp, LIQUOR_KIND_ROSE_WINE );
		break;
	case POTION_KIND_ALE:
		fx_drink_liquor( chr, &tmp, LIQUOR_KIND_ALE );
		break;
	case POTION_KIND_BRANDY:
		fx_drink_liquor( chr, &tmp, LIQUOR_KIND_BRANDY );
		break;
	case POTION_KIND_RUM:
		fx_drink_liquor( chr, &tmp, LIQUOR_KIND_RUM );
		break;
	case POTION_KIND_MILK:
	case POTION_KIND_COFFE:
	case POTION_KIND_ICE_COFFE:
	case POTION_KIND_TEA:
	case POTION_KIND_MILK_TEA:
	case POTION_KIND_LEMON_TEA:
	case POTION_KIND_ICE_TEA:
	case POTION_KIND_ICE_MILK_TEA:
	case POTION_KIND_ICE_LEMON_TEA:
	case POTION_KIND_APPLE_JUICE:
	case POTION_KIND_GRAPE_JUICE:
	case POTION_KIND_ORANGE_JUICE:
	case POTION_KIND_BLACK_BERRY_JUICE:
	case POTION_KIND_CRAN_BERRY_JUICE:
	case POTION_KIND_RASP_BERRY_JUICE:
	case POTION_KIND_STRAW_BERRY_JUICE:
		print_msg_find( chr, FLG_NULL, str_drink, str_name );
		break;
	case POTION_KIND_OIL:
		print_msg_find( chr, FLG_NULL, MSG_S, MSG_FX_OIL );
		break;
	case POTION_KIND_STONE:
		quaff_potion_std( chr, FX_KIND_STONE );
		break;
	case POTION_KIND_PARALYZE:
		quaff_potion_std( chr, FX_KIND_PARALYZE );
		break;
	case POTION_KIND_POISON:
		quaff_potion_poison( chr );
		break;
	case POTION_KIND_CONFUSION:
		quaff_potion_std( chr, FX_KIND_CONFUSION );
		break;
	case POTION_KIND_BLIND:
		quaff_potion_std( chr, FX_KIND_BLIND );
		break;
	case POTION_KIND_SLEEP:
		quaff_potion_std( chr, FX_KIND_SLEEP );
		break;
	case POTION_KIND_SILENCE:
		quaff_potion_std( chr, FX_KIND_SILENCE );
		break;
	case POTION_KIND_FEAR:
		quaff_potion_std( chr, FX_KIND_FEAR );
		break;
	case POTION_KIND_HALLUCINATION:
		quaff_potion_std( chr, FX_KIND_HALLUCINATION );
		break;
	case POTION_KIND_CHARM:
		quaff_potion_std( chr, FX_KIND_CHARM );
		break;
	case POTION_KIND_FLY:
		quaff_potion_std( chr, FX_KIND_FLY );
		break;
	case POTION_KIND_VANISH:
		quaff_potion_std( chr, FX_KIND_VANISH );
		break;
	case POTION_KIND_RESI_PHYS:
		quaff_potion_resi( chr, FX_KIND_RESI_KNOC );
		quaff_potion_resi( chr, FX_KIND_RESI_SLAS );
		quaff_potion_resi( chr, FX_KIND_RESI_STIN );
		break;
	case POTION_KIND_RESI_HEAT:
		quaff_potion_resi( chr, FX_KIND_RESI_HEAT );
		break;
	case POTION_KIND_RESI_COLD:
		quaff_potion_resi( chr, FX_KIND_RESI_COLD );
		break;
	case POTION_KIND_RESI_ACID:
		quaff_potion_resi( chr, FX_KIND_RESI_ACID );
		break;
	case POTION_KIND_RESI_MIND:
		quaff_potion_resi( chr, FX_KIND_RESI_MIND );
		break;
	case POTION_KIND_RESI_ELEC:
		quaff_potion_resi( chr, FX_KIND_RESI_ELEC );
		break;
	case POTION_KIND_RESI_POIS:
		quaff_potion_resi( chr, FX_KIND_RESI_POIS );
		break;
	case POTION_KIND_SHARPNESS:
		quaff_potion_abl( chr, FX_KIND_SHARPNESS );
		break;
	case POTION_KIND_DULLNESS:
		quaff_potion_abl( chr, FX_KIND_DULLNESS );
		break;
	case POTION_KIND_STRENGTH:
		quaff_potion_abl( chr, FX_KIND_STRENGTH );
		break;
	case POTION_KIND_WEAKNESS:
		quaff_potion_abl( chr, FX_KIND_WEAKNESS );
		break;
	case POTION_KIND_QUICKNESS:
		quaff_potion_abl( chr, FX_KIND_QUICKNESS );
		break;
	case POTION_KIND_SLOWNESS:
		quaff_potion_abl( chr, FX_KIND_SLOWNESS );
		break;
	case POTION_KIND_WISE:
		quaff_potion_abl( chr, FX_KIND_WISE );
		break;
	case POTION_KIND_FOOLISH:
		quaff_potion_abl( chr, FX_KIND_FOOLISH );
		break;
	case POTION_KIND_BRAINY:
		quaff_potion_abl( chr, FX_KIND_BRAINY );
		break;
	case POTION_KIND_BRAINLESS:
		quaff_potion_abl( chr, FX_KIND_BRAINLESS );
		break;
	case POTION_KIND_ATTRACTIVE:
		quaff_potion_abl( chr, FX_KIND_ATTRACTIVE );
		break;
	case POTION_KIND_UNATTRACTIVE:
		quaff_potion_abl( chr, FX_KIND_UNATTRACTIVE );
		break;
	case POTION_KIND_SENSE_INVISIBLE:
		/*@@@*/
		print_msg_find( chr, FLG_NULL, MSG_FX_SENSE_INVISIBLE, s );
		break;
	case POTION_KIND_POW_UP_HP:
		quaff_potion_pow_up_hp( chr );
		break;
	case POTION_KIND_SPEED_UP:
		quaff_potion_speed( chr, +1 );
		break;
	case POTION_KIND_SPEED_DOWN:
		quaff_potion_speed( chr, -1 );
		break;
	case POTION_KIND_CURE_LEV:
		quaff_potion_cure_lev( chr );
		break;
	case POTION_KIND_CURE_HP_LIGHT:
		quaff_potion_cure_hp_light( chr );
		break;
	case POTION_KIND_CURE_HP_MODERATE:
		quaff_potion_cure_hp_moderate( chr );
		break;
	case POTION_KIND_CURE_HP_SERIOUS:
		quaff_potion_cure_hp_serious( chr );
		break;
	case POTION_KIND_CURE_HP_MAX:
		quaff_potion_cure_hp_max( chr );
		break;
	case POTION_KIND_CURE_POISON:
		quaff_potion_cure_poison( chr );
		break;
	case POTION_KIND_CURE_STATUS:
		quaff_potion_cure_status( chr );
		break;
	case POTION_KIND_DETECT_MNSTR:
		quaff_potion_detect_mnstr( chr );
		break;
	}

	draw_mbr_stat( chr );
}

/**/

void	quaff_potion_mnstr( mnstr_t *mnstr, item_t *item, bool_t flg_dec )
{
	item_t	tmp;

	if( mnstr == NULL )
		return;
	if( item == NULL )
		return;
	if( item->kind != ITEM_KIND_POTION )
		return;

	copy_item( &tmp, item );
	if( flg_dec )
		inc_item( item, -1 );

	switch( tmp.dat.potion.kind ){
	case POTION_KIND_NULL:
	case POTION_KIND_MAX_N:
		break;
	case POTION_KIND_WATER:
	case POTION_KIND_MILK:
		break;
	case POTION_KIND_RED_WINE:
		fx_drink_liquor( mnstr, &tmp, LIQUOR_KIND_RED_WINE );
		break;
	case POTION_KIND_WHITE_WINE:
		fx_drink_liquor( mnstr, &tmp, LIQUOR_KIND_WHITE_WINE );
		break;
	case POTION_KIND_ROSE_WINE:
		fx_drink_liquor( mnstr, &tmp, LIQUOR_KIND_ROSE_WINE );
		break;
	case POTION_KIND_ALE:
		fx_drink_liquor( mnstr, &tmp, LIQUOR_KIND_ALE );
		break;
	case POTION_KIND_BRANDY:
		fx_drink_liquor( mnstr, &tmp, LIQUOR_KIND_BRANDY );
		break;
	case POTION_KIND_RUM:
		fx_drink_liquor( mnstr, &tmp, LIQUOR_KIND_RUM );
		break;
	case POTION_KIND_COFFE:
	case POTION_KIND_ICE_COFFE:
	case POTION_KIND_TEA:
	case POTION_KIND_MILK_TEA:
	case POTION_KIND_LEMON_TEA:
	case POTION_KIND_ICE_TEA:
	case POTION_KIND_ICE_MILK_TEA:
	case POTION_KIND_ICE_LEMON_TEA:
	case POTION_KIND_APPLE_JUICE:
	case POTION_KIND_GRAPE_JUICE:
	case POTION_KIND_ORANGE_JUICE:
	case POTION_KIND_BLACK_BERRY_JUICE:
	case POTION_KIND_CRAN_BERRY_JUICE:
	case POTION_KIND_RASP_BERRY_JUICE:
	case POTION_KIND_STRAW_BERRY_JUICE:
	case POTION_KIND_OIL:
		break;
	case POTION_KIND_STONE:
		quaff_potion_std( mnstr, FX_KIND_STONE );
		break;
	case POTION_KIND_PARALYZE:
		quaff_potion_std( mnstr, FX_KIND_PARALYZE );
		break;
	case POTION_KIND_POISON:
		quaff_potion_poison( mnstr );
		break;
	case POTION_KIND_CONFUSION:
		quaff_potion_std( mnstr, FX_KIND_CONFUSION );
		break;
	case POTION_KIND_BLIND:
		quaff_potion_std( mnstr, FX_KIND_BLIND );
		break;
	case POTION_KIND_SLEEP:
		quaff_potion_std( mnstr, FX_KIND_SLEEP );
		break;
	case POTION_KIND_SILENCE:
		quaff_potion_std( mnstr, FX_KIND_SILENCE );
		break;
	case POTION_KIND_FEAR:
		quaff_potion_std( mnstr, FX_KIND_FEAR );
		break;
	case POTION_KIND_HALLUCINATION:
		quaff_potion_std( mnstr, FX_KIND_HALLUCINATION );
		break;
	case POTION_KIND_CHARM:
		quaff_potion_std( mnstr, FX_KIND_CHARM );
		break;
	case POTION_KIND_FLY:
		quaff_potion_std( mnstr, FX_KIND_FLY );
		break;
	case POTION_KIND_VANISH:
		quaff_potion_std( mnstr, FX_KIND_VANISH );
		break;
	case POTION_KIND_RESI_PHYS:
		quaff_potion_resi( mnstr, FX_KIND_RESI_KNOC );
		quaff_potion_resi( mnstr, FX_KIND_RESI_SLAS );
		quaff_potion_resi( mnstr, FX_KIND_RESI_STIN );
		break;
	case POTION_KIND_RESI_HEAT:
		quaff_potion_resi( mnstr, FX_KIND_RESI_HEAT );
		break;
	case POTION_KIND_RESI_COLD:
		quaff_potion_resi( mnstr, FX_KIND_RESI_COLD );
		break;
	case POTION_KIND_RESI_ACID:
		quaff_potion_resi( mnstr, FX_KIND_RESI_ACID );
		break;
	case POTION_KIND_RESI_MIND:
		quaff_potion_resi( mnstr, FX_KIND_RESI_MIND );
		break;
	case POTION_KIND_RESI_ELEC:
		quaff_potion_resi( mnstr, FX_KIND_RESI_ELEC );
		break;
	case POTION_KIND_RESI_POIS:
		quaff_potion_resi( mnstr, FX_KIND_RESI_POIS );
		break;
	case POTION_KIND_SHARPNESS:
		quaff_potion_abl( mnstr, FX_KIND_SHARPNESS );
		break;
	case POTION_KIND_DULLNESS:
		quaff_potion_abl( mnstr, FX_KIND_DULLNESS );
		break;
	case POTION_KIND_STRENGTH:
		quaff_potion_abl( mnstr, FX_KIND_STRENGTH );
		break;
	case POTION_KIND_WEAKNESS:
		quaff_potion_abl( mnstr, FX_KIND_WEAKNESS );
		break;
	case POTION_KIND_QUICKNESS:
		quaff_potion_abl( mnstr, FX_KIND_QUICKNESS );
		break;
	case POTION_KIND_SLOWNESS:
		quaff_potion_abl( mnstr, FX_KIND_SLOWNESS );
		break;
	case POTION_KIND_WISE:
		quaff_potion_abl( mnstr, FX_KIND_WISE );
		break;
	case POTION_KIND_FOOLISH:
		quaff_potion_abl( mnstr, FX_KIND_FOOLISH );
		break;
	case POTION_KIND_BRAINY:
		quaff_potion_abl( mnstr, FX_KIND_BRAINY );
		break;
	case POTION_KIND_BRAINLESS:
		quaff_potion_abl( mnstr, FX_KIND_BRAINLESS );
		break;
	case POTION_KIND_ATTRACTIVE:
		quaff_potion_abl( mnstr, FX_KIND_ATTRACTIVE );
		break;
	case POTION_KIND_UNATTRACTIVE:
		quaff_potion_abl( mnstr, FX_KIND_UNATTRACTIVE );
		break;
	case POTION_KIND_SENSE_INVISIBLE:
		/*@@@*/
		print_msg_find( mnstr, FLG_NULL,
				MSG_FX_SENSE_INVISIBLE, mnstr->name );
		break;
	case POTION_KIND_POW_UP_HP:
		quaff_potion_pow_up_hp( mnstr );
		break;
	case POTION_KIND_SPEED_UP:
		quaff_potion_speed( mnstr, +1 );
		break;
	case POTION_KIND_SPEED_DOWN:
		quaff_potion_speed( mnstr, -1 );
		break;
	case POTION_KIND_CURE_LEV:
		quaff_potion_cure_lev( mnstr );
		break;
	case POTION_KIND_CURE_HP_LIGHT:
		quaff_potion_cure_hp_light( mnstr );
		break;
	case POTION_KIND_CURE_HP_MODERATE:
		quaff_potion_cure_hp_moderate( mnstr );
		break;
	case POTION_KIND_CURE_HP_SERIOUS:
		quaff_potion_cure_hp_serious( mnstr );
		break;
	case POTION_KIND_CURE_HP_MAX:
		quaff_potion_cure_hp_max( mnstr );
		break;
	case POTION_KIND_CURE_POISON:
		quaff_potion_cure_poison( mnstr );
		break;
	case POTION_KIND_CURE_STATUS:
		quaff_potion_cure_status( mnstr );
		break;
	case POTION_KIND_DETECT_MNSTR:
		quaff_potion_detect_mnstr( mnstr );
		break;
	}
}

/**/

bool_t	quaff_potion_std( chr_t *chr, fx_kind_t fx_k )
{
	return set_fx_std( chr, fx_k );
}

/**/

bool_t	quaff_potion_abl( chr_t *chr, fx_kind_t fx_k )
{
	long	turn;

	switch( fx_k ){
	default:
		return FALSE;
	case FX_KIND_SHARPNESS:
	case FX_KIND_STRENGTH:
	case FX_KIND_QUICKNESS:
	case FX_KIND_WISE:
	case FX_KIND_BRAINY:
	case FX_KIND_ATTRACTIVE:
		turn = FX_AVE_TURN_POW_UP_ABL;
		break;
	case FX_KIND_DULLNESS:
	case FX_KIND_WEAKNESS:
	case FX_KIND_SLOWNESS:
	case FX_KIND_FOOLISH:
	case FX_KIND_BRAINLESS:
	case FX_KIND_UNATTRACTIVE:
		turn = FX_AVE_TURN_POW_DOWN_ABL;
		break;
	}

	return fx_abl( chr, fx_k, turn );
}

/**/

bool_t	quaff_potion_resi( chr_t *chr, fx_kind_t fx_k )
{
	return fx_resi( chr, fx_k, FX_AVE_TURN_POW_UP_RESI );
}

/**/

bool_t	quaff_potion_cure_lev( chr_t *chr )
{
	long	i;

	if( chr == NULL )
		return FALSE;

	for( i = 0; i < ABL_KIND_MAX_N; i++ )
		chr->abl.lev[i].n = chr->abl.lev[i].max;

	curs_attrset_n( CURS_ATTR_N_FX_MBR_PLUS );
	print_msg_find( chr, FLG_NULL, MSG_FX_CURE_LEV, chr->name );
	curs_attrset_dflt();

	return TRUE;
}

/**/

bool_t	quaff_potion_cure_hp_light( chr_t *chr )
{
	return fx_cure_hp_light( chr );
}

/**/

bool_t	quaff_potion_cure_hp_moderate( chr_t *chr )
{
	return fx_cure_hp_moderate( chr );
}

/**/

bool_t	quaff_potion_cure_hp_serious( chr_t *chr )
{
	return fx_cure_hp_serious( chr );
}

/**/

bool_t	quaff_potion_cure_hp_max( chr_t *chr )
{
	return fx_cure_hp_max( chr );
}

/**/

bool_t	quaff_potion_cure_poison( chr_t *chr )
{
	fx_t	*fx;

	if( chr == NULL )
		return FALSE;

	fx = &(chr->fx);

	fx = srch_fx( fx, FX_KIND_POISON );
	if( fx == NULL )
		return FALSE;

	clr_fx( fx );

	return TRUE;
}

/**/

bool_t	quaff_potion_cure_status( chr_t *chr )
{
	return fx_cure_all_status( chr );
}

/**/

bool_t	quaff_potion_detect_mnstr( chr_t *chr )
{
	return fx_detect_mnstr( chr );
}

/**/

bool_t	quaff_potion_poison( chr_t *chr )
{
	return fx_poison( chr );
}

/**/

bool_t	quaff_potion_pow_up_hp( chr_t *chr )
{
	return fx_pow_up_hp( chr, FX_AVE_TURN_POW_UP_HP );
}

/**/

bool_t	quaff_potion_speed( chr_t *chr, long sgn_n )
{
	long	turn;

	if( sgn_n >= +1 )
		turn = FX_AVE_TURN_SPEED_UP;
	else if( sgn_n <= -1 )
		turn = FX_AVE_TURN_SPEED_DOWN;
	else
		return FALSE;

	return fx_speed_up( chr, chr, sgn_n, turn );
}

/**/

void	fill_potion( mbr_t *mbr, item_t *potion )
{
	item_t	*lamp;
	light_tab_t	*tab;

	if( mbr == NULL )
		return;
	if( mbr->kind != CHR_KIND_MBR )
		return;
	if( potion == NULL )
		return;
	if( potion->kind != ITEM_KIND_POTION )
		return;

	lamp = get_mbr_item_asgn_equip( mbr );
	lamp = &(lamp[EQUIP_KIND_LIGHT_SOURCE]);
	tab = lamp->tab.light;
	if( (lamp->kind != ITEM_KIND_LIGHT)
			|| (!tab->flg_fill) ){
		print_msg_find( mbr, FLG_NULL, MSG_S, MSG_ERR_FILL_LAMP );
		return;
	}

	chr_light_up( mbr, mbr->x, mbr->y, FALSE );
	if( potion->dat.potion.kind == POTION_KIND_OIL ){
		lamp->dat.light.turn = tab->max_turn + ADJUST_TURN;
		identify_potion( potion );
	} else {
		print_msg_find( mbr, FLG_NULL,
				MSG_S, MSG_ERR_FILL_LAMP_NON_OIL );
		lamp->dat.light.turn = 0;
	}
	chr_light_up( mbr, mbr->x, mbr->y, TRUE );

	inc_item( potion, -1 );
}

/**/

void	fx_drink_liquor( chr_t *chr, item_t *item, liquor_kind_t kind )
{
	if( chr == NULL )
		return;
	if( item == NULL )
		return;
	if( item->tab.potion == NULL )
		return;

	if( chr->kind == CHR_KIND_MBR ){
		long	n, i;
		char	*str;

		/* ̣襤Υå */

		n = 0;
		for( i = 0; i < 1024; i++ ){
			if( drink_n_msg_ls[i] == N_MSG_NULL )
				break;
			if( randm( i + 1 ) == 0 )
				n = i;
		}
		str = MSG( drink_n_msg_ls[n] );

		print_msg_find( chr, FLG_NULL, str, item->tab.potion->name );
	}

	/*  */

	drink_liquor( chr, LIQUOR_KIND_RED_WINE );
}

/**/

bool_t	drink_liquor( chr_t *chr, liquor_kind_t kind )
{
	fx_t	*fx;
	long	add;

	if( chr == NULL )
		return FALSE;

	add = liquor_proof[kind];
	add = calc_resi( get_resi( chr, RESI_KIND_POIS ), add );
	chr->fx_data.drunk_rate += add;
	if( chr->fx_data.drunk_rate < _100_PERCENT )
		return FALSE;

	fx = set_fx( chr, FX_KIND_DRUNK, FX_TURN_DRUNK );

	if( fx == NULL )
		return FALSE;

	return TRUE;
}

/**/

void	read_scroll( chr_t *chr, item_t *item )
{
	bool_t	flg_dec = TRUE;

	if( chr == NULL )
		return;
	if( item == NULL )
		return;
	if( item->kind != ITEM_KIND_SCROLL )
		return;

	if( calc_light_depth( chr->x, chr->y ) <= 0 ){
		print_msg_find( chr, FLG_NULL,
				MSG_READ_SCROLL_FAILURE, chr->name );
		return;
	}

	print_msg_find( chr, FLG_NULL,
			MSG_FX_READ_SCROLL, chr->name, item->name );

	identify_scroll( item );

	switch( item->dat.scroll.kind ){
	case SCROLL_KIND_NULL:
	case SCROLL_KIND_MAX_N:
		flg_dec = FALSE;
		break;
	case SCROLL_KIND_SLEEP:
		read_scroll_sleep( chr );
		break;
	case SCROLL_KIND_IDENTIFY_ITEM:
		if( read_scroll_identify_item( chr ) ){
			flg_dec = FALSE;
			print_msg_find( chr, FLG_NULL, MSG_CANCEL );
		}
		redraw_all();
		break;
	case SCROLL_KIND_DETECT_ITEM:
		read_scroll_detect_item( chr );
		break;
	case SCROLL_KIND_TELEPORT:
		read_scroll_teleport( chr );
		break;
	case SCROLL_KIND_POW_UP_WPN_HIT:
		read_scroll_pow_up_wpn_hit( chr );
		break;
	case SCROLL_KIND_POW_UP_WPN_CRTCL:
		read_scroll_pow_up_wpn_crtcl( chr );
		break;
	case SCROLL_KIND_POW_UP_WPN_DAM:
		read_scroll_pow_up_wpn_dam( chr );
		break;
	case SCROLL_KIND_POW_UP_ARMOR_DEF:
		read_scroll_pow_up_armor_def( chr );
		break;
	case SCROLL_KIND_POW_UP_ARMOR_CRTCL:
		read_scroll_pow_up_armor_crtcl( chr );
		break;
	case SCROLL_KIND_POW_UP_ARMOR_AC:
		read_scroll_pow_up_armor_ac( chr );
		break;
	case SCROLL_KIND_PROTECT_ARMOR:
		read_scroll_protect_armor( chr );
		break;
	case SCROLL_KIND_REMOVE_CURSE:
		read_scroll_remove_curse( chr );
		break;
	case SCROLL_KIND_RECALL:
		flg_dec = read_scroll_recall();
		break;
	}

	if( flg_dec )
		inc_item( item, -1 );

	draw_mbr_stat( chr );
}

/**/

bool_t	read_scroll_sleep( chr_t *chr )
{
	long	dx, dy;
	long	turn;
	fx_kind_t	kind;
	mnstr_t	*mnstr;
	bool_t	ret;

	if( chr == NULL )
		return FALSE;

	ret = FALSE;

	for( dy = -1; dy <= +1; dy++ ){
		for( dx = -1; dx <= +1; dx++ ){
			mnstr = get_mnstr(
					chr->x + dx,
					chr->y + dy );
			if( mnstr == NULL )
				continue;

			kind = FX_KIND_SLEEP;
			turn = FX_AVE_TURN_SLEEP;
			if( set_fx( mnstr, kind, turn )
					!= NULL ){
				ret = TRUE;
			}
		}
	}

	if( ret ){
		print_msg_find( chr, FLG_NULL,
				MSG_FX_SLEEP_SUCCESS, chr->name );
	} else {
		print_msg_find( chr, FLG_NULL,
				MSG_FX_SLEEP_FAILURE, chr->name );
	}

	return ret;
}

/**/

bool_t	read_scroll_identify_item( chr_t *chr )
{
	return exec_menu_identify_item( chr );
}

/**/

bool_t	read_scroll_detect_item( chr_t *chr )
{
	return fx_detect_mnstr( chr );
}

/**/

bool_t	read_scroll_teleport( chr_t *chr )
{
	teleport_party();

	return TRUE;
}

/**/

bool_t	read_scroll_pow_up_wpn_hit( chr_t *chr )
{
	return fx_pow_up_wpn_hit( chr );
}

/**/

bool_t	read_scroll_pow_up_wpn_crtcl( chr_t *chr )
{
	return fx_pow_up_wpn_crtcl( chr );
}

/**/

bool_t	read_scroll_pow_up_wpn_dam( chr_t *chr )
{
	return fx_pow_up_wpn_dam( chr );
}

/**/

bool_t	read_scroll_pow_up_armor_def( chr_t *chr )
{
	return fx_pow_up_armor_def( chr );
}

/**/

bool_t	read_scroll_pow_up_armor_crtcl( chr_t *chr )
{
	return fx_pow_up_armor_crtcl( chr );
}

/**/

bool_t	read_scroll_pow_up_armor_ac( chr_t *chr )
{
	return fx_pow_up_armor_ac( chr );
}

/**/

bool_t	read_scroll_protect_armor( chr_t *chr )
{
	return fx_protect_armor( chr );
}

/**/

bool_t	read_scroll_remove_curse( chr_t *chr )
{
	return remove_curse( NULL, chr, 0 );
}

/**/

bool_t	read_scroll_recall( void )
{
	return recall();
}

/**/

bool_t	zap_stick( chr_t *chr, item_t *item )
{
	spell_tab_t	*spell;
	curs_attr_t	prev_attr;

	if( chr == NULL )
		return FALSE;
	if( chr->trgt.p == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_STICK )
		return FALSE;

	item->dat.stick.n--;
	if( item->dat.stick.n < 0 ){
		item->dat.stick.n = 0;
		print_msg_find( chr, FLG_NULL, MSG_S, MSG_STICK_FAILURE );
		return FALSE;
	}
	set_item_name( item );

	print_msg_find( chr, FLG_NULL,
			MSG_FX_ZAP_STICK, chr->name, item->name );

	spell = get_spell_tab( item->dat.stick.spell_kind );
	if( spell == NULL )
		return FALSE;

	get_vfx_attr( &prev_attr );
	set_vfx_attr_n( CURS_ATTR_N_VFX );

	switch( item->dat.stick.kind ){
	case STICK_KIND_NULL:
	case STICK_KIND_MAX_N:
		return FALSE;
	case STICK_KIND_WAND:
		chr_cast_spell_normal( chr, TRUE, spell, _100_PERCENT );
		break;
	case STICK_KIND_ROD:
		chr_cast_spell_spread( chr, TRUE, spell, _100_PERCENT );
		break;
	case STICK_KIND_STAFF:
		chr_cast_spell_mass( chr, TRUE, spell, _100_PERCENT );
		break;
	}

	set_vfx_attr( &prev_attr );

	return TRUE;
}

/**/

bool_t	fx_std( chr_t *chr, fx_kind_t fx_k )
{
	return set_fx_std( chr, fx_k );
}

/**/

bool_t	set_fx_std( chr_t *chr, fx_kind_t fx_k )
{
	long	turn;

	if( chr == NULL )
		return FALSE;

	turn = 0;

	switch( fx_k ){
	default:
		return FALSE;
	case FX_KIND_STONE:
		turn = FX_AVE_TURN_STONE;
		break;
	case FX_KIND_PARALYZE:
		turn = FX_AVE_TURN_PARALYZE;
		break;
	case FX_KIND_POISON:
		return fx_poison( chr );
	case FX_KIND_CONFUSION:
		turn = FX_AVE_TURN_CONFUSION;
		break;
	case FX_KIND_BLIND:
		turn = FX_AVE_TURN_BLIND;
		break;
	case FX_KIND_SLEEP:
		turn = FX_AVE_TURN_SLEEP;
		break;
	case FX_KIND_SILENCE:
		turn = FX_AVE_TURN_SILENCE;
		break;
	case FX_KIND_FEAR:
		turn = FX_AVE_TURN_FEAR;
		break;
	case FX_KIND_HALLUCINATION:
		turn = FX_AVE_TURN_HALLUCINATION;
		break;
	case FX_KIND_CHARM:
		turn = FX_AVE_TURN_CHARM;
		break;
	case FX_KIND_FLY:
		turn = FX_AVE_TURN_FLY;
		break;
	case FX_KIND_VANISH:
		turn = FX_AVE_TURN_VANISH;
		break;
	}

	if( set_fx( chr, fx_k, turn ) == NULL )
		return FALSE;

	return TRUE;
}

/**/

bool_t	fx_light( long x, long y )
{
	on_light_area( x, y, TRUE );
	set_flg_find_all_mnstr();
	redraw_map();

	return TRUE;
}

/**/

bool_t	fx_darkness( long x, long y )
{
	off_light_area( x, y, TRUE );
	set_flg_find_all_mnstr();
	redraw_map();

	return TRUE;
}

/**/

bool_t	fx_knock( door_t *p )
{
	if( p == NULL )
		return FALSE;

	return disarm_door( p->n );
}

/**/

bool_t	fx_lock( door_t *p )
{
	if( p == NULL )
		return FALSE;

	return jam_door( p->n );
}

/**/

bool_t	fx_disarm_trap( trap_t *p, chr_t *chr )
{
	if( p == NULL )
		return FALSE;
	if( chr == NULL )
		return FALSE;

	if( chr_roll( chr, ABL_KIND_MAG, ABL_KIND_INT, p->difficulty ) ){
		disarm_trap( p );
		print_msg_find( chr, FLG_NULL,
				MSG_TRAP_DISARM, chr->name, p->tab->name );
		return TRUE;
	}

	if( !rate_randm( TRAP_DISARM_FAILURE_RATE ) ){
		print_msg_find( chr, FLG_NULL, MSG_ERR_TRAP_DISARM_LEV );
		return FALSE;
	}

	caught_trap( p, chr );
	return TRUE;
}

/**/

bool_t	fx_teleport_party( void )
{
	return teleport_party();
}

/**/

bool_t	teleport_party( void )
{
	party_t	*pty;
	long	i;

	print_msg( FLG_NULL, MSG_FX_TELEPORT_PARTY );

	release_all_mbr();
	appear_party( TRUE );

	pty = get_party();
	for( i = 0; i < MBR_MAX_N; i++ )
		clr_chr_trgt_act( pty->mbr[i], FALSE );

	next_pos_square( 0 );

	set_flg_find_all_mnstr();
	redraw_all();

	return TRUE;
}

/**/

bool_t	fx_teleport( trgt_kind_t trgt_kind, void *p )
{
	switch( trgt_kind ){
	case TRGT_KIND_NULL:
		return FALSE;
	case TRGT_KIND_MBR:
	case TRGT_KIND_MNSTR:
		teleport_chr( (mbr_t *)p );
		return TRUE;
	case TRGT_KIND_MNSTR_NULL:
		return TRUE;
	case TRGT_KIND_ITEM:
		teleport_item( (item_t *)p );
		return TRUE;
	case TRGT_KIND_DOOR:
	case TRGT_KIND_TRAP:
	case TRGT_KIND_QUEUE:
	case TRGT_KIND_SQUARE:
	case TRGT_KIND_POS:
	case TRGT_KIND_AUTO:
	case TRGT_KIND_MAX_N:
		return FALSE;
	}

	return FALSE;
}

/**/

bool_t	teleport_chr( chr_t *chr )
{
	long	i;
	long	nx, ny;
	bool_t	ret = FALSE;

	if( chr == NULL )
		return FALSE;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return FALSE;

	print_msg_find( chr, FLG_NULL, MSG_FX_TELEPORT, chr->name );

	release_chr_all_ref( chr );

	clr_map_chr( chr );
	chr->pre_x = chr->x;
	chr->pre_y = chr->y;

	for( i = 1024; i > 0; i-- ){
		nx = 1 + randm( MAP_MAX_X - 2);
		ny = 1 + randm( MAP_MAX_Y - 2);

		if( can_move_chr( chr, nx, ny ) )
			break;	/* ֤˰ư褿 */
	}
	if( i > 0 ){
		chr->x = nx;
		chr->y = ny;
		ret = TRUE;
	}

	clr_chr_trgt_act( chr, FALSE );
	set_map_chr( chr );

	if( chr->kind == CHR_KIND_MBR )
		set_flg_find_all_mnstr();

	draw_chr( chr );

	return ret;
}

/**/

bool_t	fx_recall( void )
{
	return recall();
}

/**/

bool_t	recall( void )
{
	long	i;
	party_t	*pty;
	dun_t	*dun;
	long	n, max_floor, max_base;
	char	*ret;

	pty = get_party();
	dun = get_dun();
	max_floor = 0;
	max_base = 0;
	for( i = 0; i < MBR_MAX_N; i++ ){
		if( pty->mbr[i]->dun_max_lev_floor > max_floor )
			max_floor = pty->mbr[i]->dun_max_lev_floor;
		if( pty->mbr[i]->dun_max_lev_base > max_base )
			max_base = pty->mbr[i]->dun_max_lev_base;
	}

	if( dun->lev == 0 )
		n = -max_base;
	else
		n = 0;

	print_msg( FLG_NULL, MSG_FX_RECALL_ASK );
	ret = exec_menu_sel_num( -max_base, max_floor, &n );
	redraw_all();
	if( ret != NULL )
		return FALSE;

	pty->act.kind = ACT_KIND_RECALL;
	pty->act.n = n;
	pty->act.n2 = FX_AVE_TURN_RECALL;

	print_msg( FLG_MSG_NO_MORE_PREV, MSG_FX_RECALL );

	return TRUE;
}

/**/

bool_t	chk_recall( void )
{
	party_t	*pty;
	dun_t *dun;

	pty = get_party();

	if( pty->act.kind != ACT_KIND_RECALL )
		return FALSE;

	pty->act.n2--;

	if( pty->act.n2 > 0 )
		return FALSE;

	dun = get_dun();
	up_dun( pty->act.n - dun->lev );

	clr_party_act();

	return TRUE;
}

/**/

bool_t	fx_create_food( chr_t *chr )
{
	item_t	*food;

	if( chr == NULL )
		return FALSE;

	food = make_item_food( 10, FOOD_KIND_PRESERVED );
	if( food == NULL )
		return FALSE;

	if( chr->kind == CHR_KIND_MBR ){
		if( !give_mbr_item( chr, food, FALSE ) ){
			if( !put_item( chr->x, chr->y, PUT_ITEM_R,
					food, TRUE ) ){
				free_item( food );
				return FALSE;
			}
		}
	} else {
		if( !put_item( chr->x, chr->y, PUT_ITEM_R, food, TRUE ) ){
			free_item( food );
			return FALSE;
		}
	}

	if( food->tab.food != NULL ){
		print_msg_find( chr, FLG_NULL, MSG_FX_CREATE_FOOD,
				chr->name, food->tab.food->name );
	}

	return TRUE;
}

/**/

bool_t	fx_detect_item( chr_t *chr )
{
	long	x, y, r;

	x = chr->x;
	y = chr->y;
	r = FX_DETECT_ITEM_R;
	detect_item( x, y, r );

	return TRUE;
}

/**/

bool_t	fx_detect_door( chr_t *chr )
{
	long	x, y, r;

	x = chr->x;
	y = chr->y;
	r = FX_DETECT_DOOR_R;
	detect_door( x, y, r );

	return TRUE;
}

/**/

bool_t	fx_detect_trap( chr_t *chr )
{
	long	x, y, r;

	x = chr->x;
	y = chr->y;
	r = FX_DETECT_TRAP_R;
	detect_trap( x, y, r );

	return TRUE;
}

/**/

bool_t	fx_detect_mnstr( chr_t *chr )
{
	if( chr == NULL )
		return FALSE;

	if( chr->kind == CHR_KIND_MBR ){
		set_find_all_mnstr();
		redraw_all();
		wait_key();
		set_flg_find_all_mnstr();

		print_msg_find( chr, FLG_NULL,
				MSG_FX_DETECT_MNSTR, chr->name );
	}

	return TRUE;
}

/**/

bool_t	fx_darkvision( chr_t *chr )
{
	const long	turn = FX_AVE_TURN_DARKVISION;

	if( chr == NULL )
		return FALSE;

	clr_map_chr( chr );

	chr->fx_data.infra_vision += roll_dice( turn );

	set_map_chr( chr );

	return TRUE;
}

/**/

bool_t	fx_magic_missile(
	chr_t *o_p, trgt_kind_t trgt_kind, chr_t *d_p, rate_t rate
)
{
	resi_kind_t	resi;

	switch( randm( 3 ) ){
	case 0:
		resi = RESI_KIND_KNOC;
		break;
	case 1:
		resi = RESI_KIND_SLAS;
		break;
	case 2:
		resi = RESI_KIND_STIN;
		break;
	default:
		return FALSE;
	}

	return fx_spell_attack( o_p, trgt_kind, d_p,
			resi, ABL_KIND_SOR, rate );
}

/**/

bool_t	fx_spell_attack(
	chr_t *o_p, trgt_kind_t trgt_kind, void *d_p,
	resi_kind_t resi, abl_kind_t abl, rate_t rate
)
{
	switch( trgt_kind ){
	case TRGT_KIND_MBR:
	case TRGT_KIND_MNSTR:
		return spell_attack( o_p, (chr_t *)d_p,
				resi, FALSE, abl, rate );
	case TRGT_KIND_ITEM:
		break_item( (item_t *)d_p, TRUE );
		break;
	case TRGT_KIND_DOOR:
		if( break_door( ((door_t *)d_p)->n ) ){
			print_msg_find( o_p, FLG_NULL,
					MSG_DOOR_BREAK, o_p->name );
		}
		break;
	default:
		return FALSE;
	}

	return TRUE;
}

/**/

bool_t	fx_death_spell( chr_t *o_p, trgt_kind_t trgt_kind, void *d_p )
{
	long	o_lev, d_lev;
	static char	o_name[CHR_NAME_MAX_LEN + 1];
	static char	d_name[CHR_NAME_MAX_LEN + 1];
	curs_attr_n_t	attr_crtcl;

	if( o_p == NULL )
		return FALSE;
	if( d_p == NULL )
		return FALSE;
	if( trgt_kind != TRGT_KIND_MBR )
		if( trgt_kind != TRGT_KIND_MNSTR )
			return FALSE;

	o_lev = get_specialist_lev( o_p );
	d_lev = get_specialist_lev( (chr_t *)d_p );
	if( o_lev <= d_lev )
		return FALSE;

	if( !rate_randm( DEATH_SPELL_RATE ) )
		return FALSE;

	strncpy( o_name, o_p->name, CHR_NAME_MAX_LEN );
	strncpy( d_name, ((chr_t *)d_p)->name, CHR_NAME_MAX_LEN );
	if( ((chr_t *)d_p)->kind == CHR_KIND_MBR )
		attr_crtcl = CURS_ATTR_N_FX_MBR_CRTCL;
	else
		attr_crtcl = CURS_ATTR_N_FX_MNSTR_CRTCL;

	die_chr( (chr_t *)d_p, FALSE );

	curs_attrset_n( attr_crtcl );
	print_msg_find( o_p, FLG_NULL, MSG_FIGHT_KILL_STD, o_name, d_name );
	curs_attrset_dflt();

	return TRUE;
}

/**/

bool_t	fx_abl( chr_t *chr, fx_kind_t fx_k, long turn )
{
	fx_t	*fx;
	fx_kind_t	deny_kind;

	if( chr == NULL )
		return FALSE;

	switch( fx_k ){
	default:
		return FALSE;
	case FX_KIND_SHARPNESS:
		deny_kind = FX_KIND_DULLNESS;
		break;
	case FX_KIND_DULLNESS:
		deny_kind = FX_KIND_SHARPNESS;
		break;
	case FX_KIND_STRENGTH:
		deny_kind = FX_KIND_WEAKNESS;
		break;
	case FX_KIND_WEAKNESS:
		deny_kind = FX_KIND_STRENGTH;
		break;
	case FX_KIND_QUICKNESS:
		deny_kind = FX_KIND_SLOWNESS;
		break;
	case FX_KIND_SLOWNESS:
		deny_kind = FX_KIND_QUICKNESS;
		break;
	case FX_KIND_WISE:
		deny_kind = FX_KIND_FOOLISH;
		break;
	case FX_KIND_FOOLISH:
		deny_kind = FX_KIND_WISE;
		break;
	case FX_KIND_BRAINY:
		deny_kind = FX_KIND_BRAINLESS;
		break;
	case FX_KIND_BRAINLESS:
		deny_kind = FX_KIND_BRAINY;
		break;
	case FX_KIND_ATTRACTIVE:
		deny_kind = FX_KIND_UNATTRACTIVE;
		break;
	case FX_KIND_UNATTRACTIVE:
		deny_kind = FX_KIND_ATTRACTIVE;
		break;
	}

	fx = srch_fx( &(chr->fx), deny_kind );
	if( fx != NULL ){
		clr_fx( fx );
		return FALSE;
	}

	if( set_fx( chr, fx_k, turn ) == NULL )
		return FALSE;

	return TRUE;
}

/**/

bool_t	fx_acid( chr_t *chr )
{
	if( chr == NULL )
		return FALSE;

	if( chr->kind == CHR_KIND_MBR )
		return fx_acid_mbr( chr );
	if( chr->kind == CHR_KIND_MNSTR )
		return fx_acid_mnstr( chr );

	return FALSE;
}

/**/

bool_t	fx_acid_mbr( chr_t *chr )
{
	item_t	*eq;
	equip_kind_t	i, eq_kind;
	long	n;

	if( chr == NULL )
		return FALSE;
	if( chr->kind != CHR_KIND_MBR )
		return FALSE;

	eq = get_mbr_item_asgn_equip( chr );
	if( eq == NULL )
		return FALSE;

	eq_kind = EQUIP_KIND_MAX_N;
	n = 0;
	for( i = 0; i < EQUIP_KIND_MAX_N; i++ ){
		if( eq[i].kind == ITEM_KIND_ARMOR ){
			n++;
			if( randm( n ) == 0 ){
				eq_kind = i;
			}
		}
	}
	if( n <= 0 )
		return FALSE;

	if( chk_flg( eq[eq_kind].flg, FLG_ITEM_PROTECTED ) ){
		print_msg_find( chr, FLG_NULL,
				MSG_FX_PROTECTED_ARMOR, chr->name );
		return FALSE;
	}

	switch( randm( 3 ) ){
	case 0:
		eq[eq_kind].dat.armor.add_def--;
		break;
	case 1:
		eq[eq_kind].dat.armor.add_crtcl--;
		break;
	case 2:
		eq[eq_kind].dat.armor.add_ac--;
		break;
	}
	set_item_name( &(eq[eq_kind]) );

	print_msg_find( chr, FLG_NULL, MSG_FX_POW_DOWN_ARMOR, chr->name );
	print_msg_find( chr, FLG_NULL, MSG_S, eq[eq_kind].name );

	return TRUE;
}

/**/

bool_t	fx_acid_mnstr( chr_t *chr )
{
	if( chr == NULL )
		return FALSE;
	if( chr->kind != CHR_KIND_MNSTR )
		return FALSE;

	switch( randm( 3 ) ){
	case 0:
		chr->add_def--;
		break;
	case 1:
		chr->add_crtcl--;
		break;
	case 2:
		chr->add_ac--;
		break;
	}

	return TRUE;
}

/**/

bool_t	fx_poison( chr_t *chr )
{
	fx_kind_t	kind;
	long	turn;
	fx_t	*fx;

	if( chr == NULL )
		return FALSE;

	kind = FX_KIND_POISON;
	turn = FX_AVE_TURN_POISON;

	fx = set_fx( chr, kind, turn );
	if( fx == NULL )
		return FALSE;

	if( fx->n < POISON_DEC_N )
		fx->n = POISON_DEC_N;

	return TRUE;
}

/**/

bool_t	fx_pow_up_hp( chr_t *chr, long turn )
{
	fx_t	*fx;

	if( chr == NULL )
		return FALSE;

	fx = set_fx( chr, FX_KIND_POW_UP_HP, turn );
	if( fx == NULL )
		return FALSE;

	return TRUE;
}

/**/

void	pow_up_hp( fx_t *fx, long add_lev )
{
	modifier_t	m;

	if( fx == NULL )
		return;
	if( fx->chr == NULL )
		return;

	get_modifier_fx( fx->chr, &m );
	m.add_lev[ABL_KIND_HP] += add_lev;
	set_modifier_fx( fx->chr, &m );
}

/**/

bool_t	fx_magic_armor( chr_t *chr, fx_kind_t kind )
{
	long	turn;
	fx_t	*fx;

	if( chr == NULL )
		return FALSE;

	turn = 0;

	switch( kind ){
	case FX_KIND_MAGIC_SHIELD:
		turn = FX_AVE_TURN_MAGIC_SHIELD;
		break;
	case FX_KIND_MAGE_ARMOR:
		turn = FX_AVE_TURN_MAGE_ARMOR;
		break;
	default:
		return FALSE;
	}

	fx = set_fx( chr, kind, turn );
	if( fx == NULL )
		return FALSE;

	return TRUE;
}

/**/

bool_t	magic_armor(
	fx_t *fx,
	rate_t armor_def, rate_t armor_crtcl, rate_t armor_ac
)
{
	modifier_t	m;

	if( fx == NULL )
		return FALSE;
	if( fx->chr == NULL )
		return FALSE;

	get_modifier_fx( fx->chr, &m );
	m.armor_def += armor_def;
	m.armor_crtcl += armor_crtcl;
	m.armor_ac += armor_ac;
	set_modifier_fx( fx->chr, &m );

	return TRUE;
}

/**/

bool_t	fx_speed_up( chr_t *chr1, chr_t *chr2, long add, long turn )
{
	abl_kind_t	max_abl2;

	if( chr1->kind != chr2->kind ){
		max_abl2 = get_max_abl( chr2 );
		if( !roll( chr1, ABL_KIND_ENC, ABL_KIND_INT,
				chr2, max_abl2, max_abl2 ) ){
			return FALSE;
		}
	}

	if( add >= +1 )
		set_fx( chr2, FX_KIND_SPEED_UP, turn );
	else if( add <= -1 )
		set_fx( chr2, FX_KIND_SPEED_DOWN, turn );
	else
		return FALSE;

	return TRUE;
}

/**/

bool_t	fx_energy_drain( chr_t *chr )
{
	abl_kind_t	head, i, n;
	long	exp;

	if( chr == NULL )
		return FALSE;

	head = randm( ABL_KIND_MAX_N );
	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		n = (head + i) % ABL_KIND_MAX_N;
		if( chr->abl.lev[n].n > 0 )
			break;
	}
	if( i >= ABL_KIND_MAX_N )
		return FALSE;

	/* get_lev() ǤʤǤΥ٥ */
	exp = calc_need_exp( chr->abl.lev[n].n, n ) - 1;
	if( exp < 0 )
		exp = 0;

	chr->abl.exp[n].n = exp;
	chk_up_lev( chr, TRUE );

	return TRUE;
}

/**/

bool_t	fx_resi( chr_t *chr, fx_kind_t fx_k, long turn )
{
	fx_t	*fx;

	if( chr == NULL )
		return FALSE;

	fx = set_fx( chr, fx_k, turn );
	if( fx == NULL )
		return FALSE;

	return TRUE;
}

/**/

bool_t	pow_up_resi( chr_t *chr, resi_kind_t resi )
{
	return pow_up_down_resi( chr, resi, +POW_UP_RESI_RATE );
}

/**/

bool_t	pow_down_resi( chr_t *chr, resi_kind_t resi )
{
	return pow_up_down_resi( chr, resi, -POW_UP_RESI_RATE );
}

/**/

bool_t	pow_up_down_resi( chr_t *chr, resi_kind_t resi, rate_t rate )
{
	modifier_t	m;

	if( chr == NULL )
		return FALSE;

	get_modifier_fx( chr, &m );
	m.add_resi_n[resi] += rate;
	set_modifier_fx( chr, &m );

	return TRUE;
}

/**/

bool_t	fx_cure_hp_light( chr_t *chr )
{
	if( chr == NULL )
		return FALSE;

	if( !fx_cure_hp( chr, CURE_HP_LIGHT_N ) )
		return FALSE;

	return TRUE;
}

/**/

bool_t	fx_cure_hp_moderate( chr_t *chr )
{
	if( chr == NULL )
		return FALSE;

	if( !fx_cure_hp( chr, CURE_HP_MODERATE_N ) )
		return FALSE;

	return TRUE;
}

/**/

bool_t	fx_cure_hp_serious( chr_t *chr )
{
	if( chr == NULL )
		return FALSE;

	if( !fx_cure_hp( chr, CURE_HP_SERIOUS_N ) )
		return FALSE;

	return TRUE;
}

/**/

bool_t	fx_cure_hp_max( chr_t *chr )
{
	long	n;

	if( chr == NULL )
		return FALSE;

	n = chr->abl.hp.max - chr->abl.hp.n;
	if( n <= 0 )
		return FALSE;

	if( !fx_cure_hp( chr, n ) )
		return FALSE;

	return TRUE;
}

/**/

bool_t	fx_cure_hp( chr_t *chr, long cure_n )
{
	if( chr == NULL )
		return FALSE;
	if( cure_n == 0 )
		return FALSE;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return FALSE;

	if( chr->face.mjr == FACE_MJR_MNSTR_UNDEAD ){
		cure_n = cure_n * CURE_HP_UNDEAD_RATE / _100_PERCENT;
		cure_n = -cure_n;
	}

	print_msg_find( chr, FLG_NULL, MSG_FX_CURE_HP, chr->name, cure_n );
	add_hp( chr, +cure_n );

	return TRUE;
}

/**/

bool_t	resurrection( mbr_t *mbr )
{
	party_t	*pty = get_party();

	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;

	if( !chk_flg( mbr->stat, FLG_STAT_DEAD ) )
		return FALSE;

	mbr->stat &= ~(FLG_STAT_DEAD);
	mbr->abl.hp.n = mbr->abl.hp.max;

	if( mbr->mbr_n != MBR_N_NOT_JOIN ){
		mbr->x = pty->square.x + pty->square.chr_pos[mbr->mbr_n].x;
		mbr->y = pty->square.y + pty->square.chr_pos[mbr->mbr_n].y;
	}

	draw_mbr_stat( mbr );

	return TRUE;
}

/**/

bool_t	fx_heal( chr_t *chr )
{
	bool_t	flg;

	flg = FALSE;

	if( fx_cure_hp_max( chr ) )
		flg = TRUE;
	if( fx_cure_all_status( chr ) )
		flg = TRUE;

	return flg;
}

/**/

bool_t	fx_cure_all_status( chr_t *chr )
{
	bool_t	flg;

	flg = FALSE;

	if( fx_cure_status( chr, FX_KIND_STONE ) )
		flg = TRUE;
	if( fx_cure_status( chr, FX_KIND_PARALYZE ) )
		flg = TRUE;
	if( fx_cure_status( chr, FX_KIND_POISON ) )
		flg = TRUE;
	if( fx_cure_status( chr, FX_KIND_CONFUSION ) )
		flg = TRUE;
	if( fx_cure_status( chr, FX_KIND_BLIND ) )
		flg = TRUE;
	if( fx_cure_status( chr, FX_KIND_SLEEP ) )
		flg = TRUE;
	if( fx_cure_status( chr, FX_KIND_SILENCE ) )
		flg = TRUE;
	if( fx_cure_status( chr, FX_KIND_FEAR ) )
		flg = TRUE;
	if( fx_cure_status( chr, FX_KIND_HALLUCINATION ) )
		flg = TRUE;
	if( fx_cure_status( chr, FX_KIND_CHARM ) )
		flg = TRUE;

	if( flg )
		draw_mbr_stat( chr );

	return flg;
}

/**/

bool_t	fx_cure_status( chr_t *chr, fx_kind_t fx_kind )
{
	fx_t	*fx, *fx_head;

	if( chr == NULL )
		return FALSE;

	fx_head = &(chr->fx);

	fx = srch_fx( fx_head, fx_kind );
	if( fx == NULL )
		return FALSE;

	clr_fx( fx );
	return TRUE;
}

/**/

bool_t	fx_bless( chr_t *chr )
{
	fx_t	*fx;

	if( chr == NULL )
		return FALSE;

	fx = set_fx( chr, FX_KIND_BLESS, FX_AVE_TURN_BLESS );
	if( fx == NULL )
		return FALSE;

	return TRUE;
}

/**/

bool_t	fx_remove_curse( chr_t *chr1, chr_t *chr2 )
{
	rate_t	difficulty;

	if( chr2 == NULL )
		return FALSE;

	difficulty = FX_REMOVE_CURSE_DIFFICULTY;

	return remove_curse( chr1, chr2, difficulty );
}

/**/

bool_t	remove_curse( chr_t *chr1, mbr_t *mbr2, rate_t difficulty )
{
	abl_kind_t	abl_main, abl_sub;
	item_t	*head, *p;
	bool_t	flg;
	long	i;

	if( mbr2 == NULL )
		return FALSE;
	if( mbr2->kind != CHR_KIND_MBR )
		return TRUE;

	flg = FALSE;

	abl_main = ABL_KIND_PRI;
	abl_sub = ABL_KIND_WIS;

	head = get_mbr_item_asgn( mbr2 );
	for( p = head->next; p != head; p = p->next ){
		if( chk_flg( p->flg, FLG_ITEM_CURSED ) ){
			if( (chr1 != NULL) && (chr1->kind == CHR_KIND_MBR) ){
				if( !chr_roll( chr1, abl_main, abl_sub,
						difficulty ) ){
					continue;
				}
			}

			flg = TRUE;
			p->flg &= ~(FLG_ITEM_CURSED);
			set_item_name( p );
		}
	}

	p = get_mbr_item_asgn_equip( mbr2 );
	for( i = 0; i < EQUIP_KIND_MAX_N; i++ ){
		if( chk_flg( p[i].flg, FLG_ITEM_CURSED ) ){
			if( (chr1 != NULL) && (chr1->kind == CHR_KIND_MBR) ){
				if( !chr_roll( chr1, abl_main, abl_sub,
						difficulty ) ){
					continue;
				}
			}

			flg = TRUE;
			p[i].flg &= ~(FLG_ITEM_CURSED);
			set_item_name( &(p[i]) );
		}
	}

	if( flg ){
		curs_attrset_n( CURS_ATTR_N_FX_MBR_PLUS );
		print_msg_find( mbr2, FLG_NULL,
				MSG_FX_REMOVE_CURSE_SUCCESS, mbr2->name );
	} else {
		curs_attrset_n( CURS_ATTR_N_FX_MBR_MINUS );
		print_msg_find( mbr2, FLG_NULL,
				MSG_FX_REMOVE_CURSE_FAILURE, mbr2->name );
	}
	curs_attrset_dflt();

	return flg;
}

/**/

bool_t	fx_dispel_undead(
	chr_t *o_p,
	trgt_kind_t kind, void *d_p,
	rate_t rate
)
{
	if( o_p == NULL )
		return FALSE;
	if( d_p == NULL )
		return FALSE;

	if( kind != TRGT_KIND_MBR )
		if( kind != TRGT_KIND_MNSTR )
			return FALSE;

	if( ((chr_t *)d_p)->face.mjr != FACE_MJR_MNSTR_UNDEAD )
		return FALSE;

	rate = rate * DISPEL_UNDEAD_RATE / _100_PERCENT;
	return( fx_spell_attack( o_p, kind, d_p,
			RESI_KIND_ELEC, ABL_KIND_PRI, rate ) );
}

/**/

bool_t	fx_pow_up_wpn_hit( mbr_t *mbr )
{
	item_t	*eq;

	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL ){
		curs_attrset_n( CURS_ATTR_N_FX_MBR_PLUS );
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_WPN_HIT_FAILURE,
				mbr->name );
		curs_attrset_dflt();
		return FALSE;
	}

	if( pow_up_wpn_hit( randm_wpn( eq ) ) ){
		curs_attrset_n( CURS_ATTR_N_FX_MBR_PLUS );
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_WPN_HIT_SUCCESS,
				mbr->name );
		curs_attrset_dflt();

		return TRUE;
	} else {
		curs_attrset_n( CURS_ATTR_N_FX_MBR_MINUS );
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_WPN_HIT_FAILURE,
				mbr->name );
		curs_attrset_dflt();

		return FALSE;
	}
}

/**/

bool_t	fx_pow_up_wpn_crtcl( mbr_t *mbr )
{
	item_t	*eq;

	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL ){
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_WPN_CRTCL_FAILURE,
				mbr->name );
		return FALSE;
	}

	if( pow_up_wpn_crtcl( randm_wpn( eq ) ) ){
		curs_attrset_n( CURS_ATTR_N_FX_MBR_PLUS );
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_WPN_CRTCL_SUCCESS,
				mbr->name );
		curs_attrset_dflt();

		return TRUE;
	} else {
		curs_attrset_n( CURS_ATTR_N_FX_MBR_MINUS );
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_WPN_CRTCL_FAILURE,
				mbr->name );
		curs_attrset_dflt();

		return FALSE;
	}
}

/**/

bool_t	fx_pow_up_wpn_dam( mbr_t *mbr )
{
	item_t	*eq;

	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL ){
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_WPN_DAM_FAILURE,
				mbr->name );
		return FALSE;
	}

	if( pow_up_wpn_dam( randm_wpn( eq ) ) ){
		curs_attrset_n( CURS_ATTR_N_FX_MBR_PLUS );
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_WPN_DAM_SUCCESS,
				mbr->name );
		curs_attrset_dflt();

		return TRUE;
	} else {
		curs_attrset_n( CURS_ATTR_N_FX_MBR_MINUS );
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_WPN_DAM_FAILURE,
				mbr->name );
		curs_attrset_dflt();

		return FALSE;
	}
}

/**/

item_t	*randm_wpn( item_t *eq )
{
	const long	max_n = 3;
	equip_kind_t	kind;
	long	head, i;
	long	rn;

	if( eq == NULL )
		return( &(eq[EQUIP_KIND_WIELDING]) );

	kind = EQUIP_KIND_WIELDING;
	head = randm( max_n );
	rn = 0;

	for( i = 0; i < max_n; i++ ){
		long	n;
		equip_kind_t	k;

		n = (head + i) % max_n;
		if( n == 0 )
			k = EQUIP_KIND_WIELDING;
		else if( n == 1 )
			k = EQUIP_KIND_BOW;
		else
			k = EQUIP_KIND_ARW;

		if( eq[k].kind != ITEM_KIND_NULL ){
			rn++;
			if( per_randm( rn ) )
				kind = k;
		}
	}

	return( &(eq[kind]) );
}

/**/

bool_t	fx_pow_up_armor_def( mbr_t *mbr )
{
	item_t	*eq;

	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL ){
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_ARMOR_DEF_FAILURE,
				mbr->name );
		return FALSE;
	}

	if( pow_up_armor_def( randm_armor( eq ) ) ){
		curs_attrset_n( CURS_ATTR_N_FX_MBR_PLUS );
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_ARMOR_DEF_SUCCESS,
				mbr->name );
		curs_attrset_dflt();

		return TRUE;
	} else {
		curs_attrset_n( CURS_ATTR_N_FX_MBR_MINUS );
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_ARMOR_DEF_FAILURE,
				mbr->name );
		curs_attrset_dflt();

		return FALSE;
	}
}

/**/

bool_t	fx_pow_up_armor_crtcl( mbr_t *mbr )
{
	item_t	*eq;

	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL ){
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_ARMOR_CRTCL_FAILURE,
				mbr->name );
		return FALSE;
	}

	if( pow_up_armor_crtcl( randm_armor( eq ) ) ){
		curs_attrset_n( CURS_ATTR_N_FX_MBR_PLUS );
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_ARMOR_CRTCL_SUCCESS,
				mbr->name );
		curs_attrset_dflt();

		return TRUE;
	} else {
		curs_attrset_n( CURS_ATTR_N_FX_MBR_MINUS );
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_ARMOR_CRTCL_FAILURE,
				mbr->name );
		curs_attrset_dflt();

		return FALSE;
	}
}

/**/

bool_t	fx_pow_up_armor_ac( mbr_t *mbr )
{
	item_t	*eq;

	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL ){
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_ARMOR_AC_FAILURE,
				mbr->name );
		return FALSE;
	}

	if( pow_up_armor_ac( randm_armor( eq ) ) ){
		curs_attrset_n( CURS_ATTR_N_FX_MBR_PLUS );
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_ARMOR_AC_SUCCESS,
				mbr->name );
		curs_attrset_dflt();

		return TRUE;
	} else {
		curs_attrset_n( CURS_ATTR_N_FX_MBR_MINUS );
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_POW_UP_ARMOR_AC_FAILURE,
				mbr->name );
		curs_attrset_dflt();

		return FALSE;
	}
}

/**/

item_t	*randm_armor( item_t *eq )
{
	equip_kind_t	kind;
	equip_kind_t	head, i;
	long	rn;

	if( eq == NULL )
		return( &(eq[EQUIP_KIND_BODY]) );

	kind = EQUIP_KIND_WIELDING;
	head = randm( EQUIP_KIND_MAX_N );
	rn = 0;

	for( i = 0; i < EQUIP_KIND_MAX_N; i++ ){
		equip_kind_t	k;

		k = (head + i) % EQUIP_KIND_MAX_N;
		if( k == EQUIP_KIND_WIELDING )
			continue;
		if( k == EQUIP_KIND_BOW )
			continue;
		if( k == EQUIP_KIND_ARW )
			continue;

		if( eq[k].kind != ITEM_KIND_NULL ){
			rn++;
			if( per_randm( rn ) )
				kind = k;
		}
	}

	return( &(eq[kind]) );
}

/**/

bool_t	fx_protect_armor( mbr_t *mbr )
{
	item_t	*eq;
	bool_t	ret = FALSE;
	equip_kind_t	head, k, kk;

	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL ){
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_PROTECT_ARMOR_FAILURE,
				mbr->name );
		return FALSE;
	}

	head = randm( EQUIP_KIND_MAX_N );
	for( k = 0; k < EQUIP_KIND_MAX_N; k++ ){
		kk = (head + k) % EQUIP_KIND_MAX_N;

		if( protect_armor( &(eq[kk]) ) ){
			ret = TRUE;
			break;
		}
	}

	if( ret ){
		curs_attrset_n( CURS_ATTR_N_FX_MBR_PLUS );
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_PROTECT_ARMOR_SUCCESS,
				mbr->name );
	} else {
		curs_attrset_n( CURS_ATTR_N_FX_MBR_MINUS );
		print_msg_find( mbr, FLG_NULL,
				MSG_FX_PROTECT_ARMOR_FAILURE,
				mbr->name );
	}
	curs_attrset_dflt();

	return ret;
}

/**/

bool_t	pow_up_wpn_hit( item_t *wpn )
{
	long	per;

	if( wpn == NULL )
		return FALSE;
	if( wpn->kind != ITEM_KIND_WPN )
		return FALSE;

	per = wpn->dat.wpn.add_hit;
	per = per * per;
	if( per < 1 )
		per = 1;
	if( !per_randm( per ) )
		return FALSE;

	wpn->dat.wpn.add_hit++;
	set_item_name( wpn );

	return TRUE;
}

/**/

bool_t	pow_up_wpn_crtcl( item_t *wpn )
{
	long	per;

	if( wpn == NULL )
		return FALSE;
	if( wpn->kind != ITEM_KIND_WPN )
		return FALSE;

	per = wpn->dat.wpn.add_crtcl;
	per = per * per;
	if( per < 1 )
		per = 1;
	if( !per_randm( per ) )
		return FALSE;

	wpn->dat.wpn.add_crtcl++;
	set_item_name( wpn );

	return TRUE;
}

/**/

bool_t	pow_up_wpn_dam( item_t *wpn )
{
	long	per;

	if( wpn == NULL )
		return FALSE;
	if( wpn->kind != ITEM_KIND_WPN )
		return FALSE;

	per = wpn->dat.wpn.add_dam;
	per = per * per;
	if( per < 1 )
		per = 1;
	if( !per_randm( per ) )
		return FALSE;

	wpn->dat.wpn.add_dam++;
	set_item_name( wpn );

	return TRUE;
}

/**/

bool_t	protect_armor( item_t *armor )
{
	if( armor == NULL )
		return FALSE;
	if( armor->kind != ITEM_KIND_ARMOR )
		return FALSE;
	if( chk_flg( armor->flg, FLG_ITEM_PROTECTED ) )
		return FALSE;

	armor->flg |= FLG_ITEM_PROTECTED;
	set_item_name( armor );

	return TRUE;
}

/**/

bool_t	pow_up_armor_def( item_t *armor )
{
	long	per;

	if( armor == NULL )
		return FALSE;
	if( armor->kind != ITEM_KIND_ARMOR )
		return FALSE;

	per = armor->dat.armor.add_def;
	per = per * per * per;
	if( per < 1 )
		per = 1;
	if( !per_randm( per ) )
		return FALSE;

	armor->dat.armor.add_def++;
	set_item_name( armor );

	return TRUE;
}

/**/

bool_t	pow_up_armor_crtcl( item_t *armor )
{
	long	per;

	if( armor == NULL )
		return FALSE;
	if( armor->kind != ITEM_KIND_ARMOR )
		return FALSE;

	per = armor->dat.armor.add_crtcl;
	per = per * per * per;
	if( per < 1 )
		per = 1;
	if( !per_randm( per ) )
		return FALSE;

	armor->dat.armor.add_crtcl++;
	set_item_name( armor );

	return TRUE;
}

/**/

bool_t	pow_up_armor_ac( item_t *armor )
{
	long	per;

	if( armor == NULL )
		return FALSE;
	if( armor->kind != ITEM_KIND_ARMOR )
		return FALSE;

	per = armor->dat.armor.add_ac;
	per = per * per * per;
	if( per < 1 )
		per = 1;
	if( !per_randm( per ) )
		return FALSE;

	armor->dat.armor.add_ac++;
	set_item_name( armor );

	return TRUE;
}

/**/

void	eat_food( chr_t *chr, item_t *item )
{
	long	n, i;

	if( chr == NULL )
		return;
	if( item == NULL )
		return;

	print_msg_find( chr, FLG_NULL,
			MSG_EAT_FOOD, chr->name, item->name );

	n = 0;
	for( i = 0; i < 1024; i++ ){
		if( eat_food_n_msg_ls[i] == N_MSG_NULL )
			break;
		if( randm( i + 1 ) == 0 )
			n = i;
	}
	if( item->tab.food != NULL ){
		print_msg_find( chr, FLG_NULL,
				MSG( eat_food_n_msg_ls[n] ),
				item->tab.food->name );
	}

	take_meal_chr( chr, item->tab.food->fill_rate );

	inc_item( item, -1 );
}

/**/

bool_t	smoke_tobacco( mbr_t *mbr, item_t *item )
{
	item_t	*eq;
	bool_t	flg_use_pipe;

	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;
	if( item == NULL )
		return FALSE;
	if( item->kind != ITEM_KIND_TOBACCO )
		return TRUE;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL )
		return FALSE;
	eq = &(eq[EQUIP_KIND_HEAD]);

	flg_use_pipe = FALSE;
	if( chk_flg( item->tab.tobacco->flg, FLG_TOBACCO_USE_PIPE ) ){
		if( eq->kind != ITEM_KIND_PIPE ){
			print_msg_find( mbr, FLG_NULL,
					MSG_S, MSG_SMOKE_FAILURE );
			return FALSE;
		} else if( eq->tab.pipe->tobacco_kind
				!= item->tab.tobacco->kind ){
			print_msg_find( mbr, FLG_NULL,
					MSG_S, MSG_SMOKE_FAILURE );
			return FALSE;
		}
		flg_use_pipe = TRUE;
	}
	if( chk_flg( item->tab.tobacco->flg, FLG_TOBACCO_CAN_USE_PIPE )
			&& (eq->kind == ITEM_KIND_PIPE)
			&& (eq->dat.pipe.consume_turn > 0)
			&& (eq->tab.pipe->tobacco_kind
			== item->tab.tobacco->kind) ){
		flg_use_pipe = TRUE;
	}

	if( flg_use_pipe ){
		eq->dat.pipe.turn = item->dat.tobacco.turn;
		inc_item( item, -1 );
	}

	curs_attrset_n( CURS_ATTR_N_FX_MBR_MINUS );
	print_msg_find( mbr, FLG_NULL, MSG_S, MSG_FX_SMOKE_TOBACCO );
	curs_attrset_dflt();

	return !flg_use_pipe;	/* ѥפȤʤʤ */
}

/**/

void	inc_turn_smoke( mbr_t *mbr )
{
	item_t	*eq;
	nicotine_t	*nico;

	if( mbr == NULL )
		return;
	if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL )
		return;
	eq = &(eq[EQUIP_KIND_HEAD]);

	if( eq->kind == ITEM_KIND_PIPE ){
		if( eq->dat.pipe.consume_turn <= 0 )
			return;
		if( eq->dat.pipe.turn <= 0 )
			return;

		eq->dat.pipe.turn--;
		eq->dat.pipe.consume_turn--;
		set_item_name( eq );
		if( eq->dat.pipe.turn <= 0 ){
			print_msg_find( mbr, FLG_NULL,
					MSG_FX_SMOKE_END,
					mbr->name );
		}
		if( eq->dat.pipe.consume_turn <= 0 ){
			print_msg_find( mbr, FLG_NULL,
					MSG_FX_BREAK_PIPE,
					mbr->name, eq->name );
		}
	} else if( eq->kind == ITEM_KIND_TOBACCO ){
		if( eq->dat.tobacco.turn <= 0 )
			return;

		eq->dat.tobacco.turn--;
		set_item_name( eq );
		if( eq->dat.tobacco.turn <= 0 ){
			print_msg_find( mbr, FLG_NULL,
					MSG_FX_SMOKE_END,
					mbr->name );
		}
	} else {
		return;
	}

	nico = &(mbr->fx_data.nicotine);

	nico->rate += ADD_NICOTINE_RATE_PER_TURN;
	if( nico->rate > _100_PERCENT )
		nico->rate = _100_PERCENT;

	if( per_randm( TOBACCO_POISONING_AVE_TURN ) ){
		nico->poisoning_rate += TOBACCO_POISONING_ADD_RATE;
		if( nico->poisoning_rate > _100_PERCENT )
			nico->poisoning_rate = _100_PERCENT;
	}
}

/**/

void	dispose_tobacco( mbr_t *mbr, item_t *item )
{
	item_t	*head, *p;
	long	i;

	if( mbr == NULL )
		return;
	if( mbr->kind != CHR_KIND_MBR )
		return;
	if( item == NULL )
		return;
	if( item->kind != ITEM_KIND_DISPOSAL )
		return;

	head = get_mbr_item_asgn( mbr );
	p = head->next->next;
	for( i = 0; i < MBR_ITEM_MAX_N; i++, p = p->next ){
		if( p->prev == head )
			break;

		if( item->dat.disposal.n >= item->dat.disposal.max_n )
			break;

		dispose_tobacco_sub( item, p->prev );
	}

	p = get_mbr_item_asgn_equip( mbr );
	for( i = 0; i < EQUIP_KIND_MAX_N; i++ ){
		if( item->dat.disposal.n >= item->dat.disposal.max_n )
			break;

		dispose_tobacco_sub( item, &(p[i]) );
	}
}

/**/

void	dispose_tobacco_sub( item_t *disposal, item_t *tobacco )
{
	long	n;

	if( disposal == NULL )
		return;
	if( disposal->kind != ITEM_KIND_DISPOSAL )
		return;
	if( disposal->dat.disposal.n >= disposal->dat.disposal.max_n )
		return;

	if( tobacco == NULL )
		return;
	if( tobacco->kind != ITEM_KIND_TOBACCO )
		return;
	if( tobacco->dat.tobacco.turn > 0 )
		return;

	n = disposal->dat.disposal.max_n - disposal->dat.disposal.n;
	n = min( n, tobacco->n );

	inc_item( tobacco, -n );
	disposal->dat.disposal.n += n;

	set_item_name( disposal );
}

/**/

void	contribution( mbr_t *mbr, gold_t gold )
{
}

/**/

void	set_stomach( chr_t *chr )
{
	stomach_t	*st;

	if( chr == NULL )
		return;

	st = &(chr->fx_data.stomach);

	if( chk_flg( chr->stat, FLG_STAT_HUNGRY ) ){
		if( st->rate >= st->hungry_rate ){
			chr->stat &= ~FLG_STAT_HUNGRY;
			draw_mbr_stat( chr );
		}
	} else {
		if( st->rate < st->hungry_rate ){
			if( per_randm( HUNGRY_FEEL_RATE ) ){
				chr->stat |= FLG_STAT_HUNGRY;
				draw_mbr_stat( chr );
			}
		}
	}

	if( chk_flg( chr->stat, FLG_STAT_STARVATION ) ){
		if( st->rate >= st->starvation_rate ){
			chr->stat &= ~FLG_STAT_STARVATION;
			draw_mbr_stat( chr );
		}
	} else {
		if( st->rate < st->starvation_rate ){
			if( per_randm( STARVATION_FEEL_RATE ) ){
				chr->stat |= FLG_STAT_STARVATION;
				draw_mbr_stat( chr );
			}
		}
	}

	if( st->rate <= 0 ){
		st->rate = 0;
		if( per_randm( FAINT_FEEL_RATE ) ){
			faint( chr );
		}
	} else {
		fx_t	*fx;

		fx = srch_fx( &(chr->fx), FX_KIND_FAINT );
		if( fx != NULL ){
			clr_fx( fx );
			draw_mbr_stat( chr );
		}
	}
}

/**/

void	digest( chr_t *chr )
{
	rate_t	rate;
	long	n;

	if( chr == NULL )
		return;

	rate = modified_rate( _100_PERCENT, chr->fx_data.stomach.digest_n );
	n = chr->fx_data.stomach.digest_p_day * rate / _100_PERCENT;

	if( per_randm( TURN_A_DAY / n ) ){
		chr->fx_data.stomach.rate--;
		set_stomach( chr );
	}
}

/**/

void	take_meal_chr( chr_t *chr, short rate )
{
	rate *= _100_PERCENT;
	rate /= chr->fx_data.stomach.full_rate;

	chr->fx_data.stomach.rate += rate;
	if( chr->fx_data.stomach.rate >= _100_PERCENT ){
		chr->fx_data.stomach.rate = _100_PERCENT;
		print_msg_find( chr, FLG_NULL,
				MSG_STOMACH_FULL, chr->name );
	}

	set_stomach( chr );
}

/**/

void	take_meal_fill_chr( chr_t *chr )
{
	chr->fx_data.stomach.rate = _100_PERCENT;
	set_stomach( chr );
}

/**/

bool_t	faint( chr_t *chr )
{
	set_fx( chr, FX_KIND_FAINT, FX_AVE_TURN_FAINT );

	return TRUE;
}

/**/

void	abstain( chr_t *chr )
{
	nicotine_t	*nico;

	if( chr == NULL )
		return;

	nico = &(chr->fx_data.nicotine);

	if( per_randm( TOBACCO_ABSTAIN_AVE_TURN ) )
		nico->rate -= TOBACCO_ABSTAIN_SUB_RATE;
	if( nico->rate < 0 )
		nico->rate = 0;

	if( chk_flg( chr->stat, FLG_STAT_SLEEP ) )
		return;

	if( per_randm( TOBACCO_FEEL_AVE_TURN ) ){
		rate_t	rate;

		rate = _100_PERCENT - nico->rate;
		rate = rate * rate / _100_PERCENT;
		rate = rate * TOBACCO_FEEL_MAX_RATE / _100_PERCENT;
		rate = rate * nico->poisoning_rate / _100_PERCENT;
		if( rate_randm( rate ) ){
			if( chr->kind == CHR_KIND_MBR ){
				print_msg_find( chr, FLG_MSG_MORE,
						MSG_FX_TOBACCO_ABSTAIN,
						chr->name );
			}
		}
	}

	if( nico->rate <= 0 ){
		if( per_randm( TOBACCO_CURE_POISONING_AVE_TURN ) ){
			rate_t	rate;

			rate = TOBACCO_CURE_POISONING_SUB_RATE;
			nico->poisoning_rate -= rate;
		}
	}
}

/**/

void	fraternize( chr_t *chr )
{
	dun_t	*dun = get_dun();

	if( chr == NULL )
		return;
	if( dun->lev == 0 )
		return;

	chr->fx_data.friend_turn--;
	if( chr->fx_data.friend_turn < 0 )
		chr->fx_data.friend_turn = 0;
}

/**/

bool_t	dec_infra_vision( chr_t *chr )
{
	if( chr == NULL )
		return FALSE;

	clr_map_chr( chr );

	chr->fx_data.infra_vision--;
	if( chr->fx_data.infra_vision < 0 )
		chr->fx_data.infra_vision = 0;

	set_map_chr( chr );

	return( chr->fx_data.infra_vision > 0 );
}

/**/

void	randm_teleport( chr_t *chr )
{
	rate_t	rate;

	if( chr == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST ) )
		return;
	if( chr->work.teleport_n <= 0 )
		return;

	rate = modified_rate( RANDM_TELEPORT_RATE,
			chr->work.teleport_n );
	if( rate_randm( rate ) )
		teleport_chr( chr );
}

/**/

void	randm_teleport_party( chr_t *chr )
{
	rate_t	rate;

	if( chr == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST ) )
		return;
	if( chr->work.teleport_party_n <= 0 )
		return;

	rate = modified_rate( RANDM_TELEPORT_PARTY_RATE,
			chr->work.teleport_party_n );
	if( rate_randm( rate ) )
		teleport_party();
}

/**/

gold_t	fx_pick_gold( chr_t *o_p, chr_t *d_p, rate_t rate, long max_n )
{
	gold_t	n;

	if( o_p == NULL )
		return 0;
	if( d_p == NULL )
		return 0;

	n = get_chr_gold( d_p ) * rate / _100_PERCENT;
	if( n > max_n )
		n = max_n;

	print_msg_find( d_p, FLG_NULL,
			MSG_FX_PICK_GOLD, o_p->name, d_p->name );

	add_chr_gold( d_p, -n );
	add_chr_gold( o_p, +n );

	return n;
}

/**/

void	catch_chr( mnstr_t *mnstr, chr_t *chr )
{
	if( mnstr == NULL )
		return;
	if( chr == NULL )
		return;

	if( mnstr->work.catch_chr != NULL )
		release_chr( mnstr );

	if( mnstr->work.catch_chr != chr )
		mnstr->work.catch_chr = chr;

	inc_chr_caught( chr, +1 );
}

/**/

void	release_chr( mnstr_t *mnstr )
{
	if( mnstr == NULL )
		return;
	if( mnstr->work.catch_chr == NULL )
		return;

	inc_chr_caught( mnstr->work.catch_chr, -1 );

	mnstr->work.catch_chr = NULL;
}

/**/

void	release_all_mbr( void )
{
	party_t	*pty = get_party();
	long	i;

	for( i = 0; i < MBR_MAX_N; i++ )
		release_chr_all_ref( pty->mbr[i] );
}

/**/

void	release_chr_all_ref( chr_t *chr )
{
	mnstr_t	*mns_head, *mns_p, *mns_pp;

	mns_head = get_mnstr_used();
	for( mns_p = mns_head->next->next; mns_p != NULL;
			mns_p = mns_p->next ){
		mns_pp = mns_p->prev;
		if( mns_pp == mns_head )
			break;

		if( mns_pp->work.catch_chr == chr )
			mns_pp->work.catch_chr = NULL;
	}

	inc_chr_caught( chr, 0 );
}

/**/

void	inc_chr_caught( chr_t *chr, long n )
{
	if( chr == NULL )
		return;

	if( n == 0 )
		chr->work.caught = 0;
	else
		chr->work.caught += n;

	if( chr->work.caught > 0 )
		chr->stat |= FLG_STAT_CAUGHT;
	else
		chr->stat &= ~FLG_STAT_CAUGHT;

	draw_mbr_stat( chr );
}

/**/

long	get_abl_lev( chr_t *chr, abl_kind_t n )
{
	return( chr->abl.lev[n].n + chr->abl.lev[n].add );
}

/**/

abl_kind_t	get_max_abl( chr_t *chr )
{
	abl_kind_t	n, max_n;
	long	lev, max_lev;

	max_n = 0;
	max_lev = 0;
	for( n = 0; n < ABL_KIND_MAX_N; n++ ){
		lev = get_lev( chr, n );
		if( lev > max_lev ){
			max_n = n;
			max_lev = lev;
		}
	}

	return max_n;
}

/**/

fx_t	*asgn_fx( fx_t *p )
{
	fx_t	*fx;

	fx = fx_free.next;
	if( fx == &fx_free )
		return NULL;

	fx->kind = FX_KIND_NULL;

	ins_ls_fx( p->next, fx );

	return fx;
}

/**/

void	free_fx( fx_t *p )
{
	if( p != NULL )
		ins_ls_fx( &fx_free, p );
}

/**/

void	free_fx_all( fx_t *p )
{
	fx_t	*fx;

	if( p == NULL )
		return;

	for( fx = p->next->next; fx->prev != p; fx = fx->next )
		ins_ls_fx( &fx_free, fx->prev );
}

/**/

void	ins_ls_fx( fx_t *ls, fx_t *p )
{
	p->next->prev = p->prev;
	p->prev->next = p->next;

	p->prev = ls->prev;
	p->next = ls;

	ls->prev->next = p;
	ls->prev = p;
}

/**/

fx_t	*srch_fx( fx_t *ls, fx_kind_t kind )
{
	fx_t	*p;

	for( p = ls->next; p != ls; p = p->next ){
		if( p->kind == kind )
			return p;
	}

	return NULL;
}

/**/

blast_t	*get_blast( void )
{
	return &blast;
}

/**/

