/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: gmain.c,v 1.32 2003/11/21 17:51:58 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
#include	"misc.h"
#include	"turn.h"
#include	"town.h"
#include	"item.h"
#include	"spell.h"
#include	"chr.h"
#include	"party.h"
#include	"mnstr.h"
#include	"pet.h"
#include	"fight.h"
#include	"fx.h"
#include	"trap.h"
#include	"draw.h"
#include	"curs.h"
#include	"menu.h"
#include	"msg.h"
#include	"ver.h"
#include	"gmain_prot.h"
#include	"misc_prot.h"
#include	"turn_prot.h"
#include	"dun_prot.h"
#include	"town_prot.h"
#include	"item_prot.h"
#include	"spell_prot.h"
#include	"chr_prot.h"
#include	"party_prot.h"
#include	"mnstr_prot.h"
#include	"pet_prot.h"
#include	"fight_prot.h"
#include	"fx_prot.h"
#include	"trap_prot.h"
#include	"draw_prot.h"
#include	"curs_prot.h"
#include	"menu_prot.h"
#include	"tmenu_prot.h"
#include	"amenu_prot.h"
#include	"gfile_prot.h"
#include	"msg_prot.h"

#include	"main_unix_prot.h"

/**/

void	init_arg( void )
{
	g_flg_debug = FALSE;
#ifdef	DEBUG
	g_flg_debug = TRUE;
#endif	/* DEBUG */
#ifdef	NDEBUG
	g_flg_debug = FALSE;
#endif	/* NDEBUG */

	g_flg_clr_key_buf = TRUE;
	g_flg_use_keypad = TRUE;
	g_flg_measure_clk_tck = FALSE;
}

/**/

void	init_game( void )
{
	dun_t	*dun;

	init_scrn();

	srandm( time( NULL ) );
	set_game_day( 999, 4, 1 );
	set_turn( 10 * TURN_PER_HOUR );

	init_msg();
	init_draw();

	ena_scrn( TRUE );
	ena_curs_draw();
	wipe_all();

	init_game_file();

	init_dun();
	init_item();
	init_trap();
	init_fx();
	init_chr();
	init_spell();
	init_town();
	init_menu();
	init_tmenu();
	init_auto_menu();

	init_clock( g_flg_measure_clk_tck );

	dun = get_dun();
	dun->lev = 0;
	up_dun( 0 );
}

/**/

void	game_main( void )
{
	while( 1 ){
		chk_key( TRUE );
	}
}

/**/

void	exit_game( long code )
{
	FILE	*fp;

	curs_move( WIN_MSG_DRAW_MIN_Y, SCREEN_MIN_X );

	reset_scrn();

	if( code == 0 )
		fp = stdout;
	else
		fp = stderr;

	fprintf( fp, STR_FMT_COPYRIGHT, LS_STR_COPYRIGHT );
	fflush( fp );

	exit( code );
}

/**/

void	about_game( void )
{
	static char	tmp[1023 + 1];

	dis_scrn();

	fprintf( OUT_FP, MSG_FMT_COPYRIGHT, LS_STR_COPYRIGHT );
	fprintf( OUT_FP, "\n%s\n", MSG_HIT_ENTER_KEY );
	fflush( OUT_FP );
	fgets( tmp, sizeof( tmp ) - 1, stdin );

	fprintf( OUT_FP, MSG_S, MSG_ABOUT_GAME );
	fprintf( OUT_FP, "\n%s\n", MSG_HIT_ENTER_KEY );
	fflush( OUT_FP );
	fgets( tmp, sizeof( tmp ) - 1, stdin );

	ena_scrn( FALSE );
}

/**/

void	version( FILE *fp )
{
	fprintf( fp, STR_FMT_COPYRIGHT, LS_STR_COPYRIGHT );
	fflush( fp );
}

/**/

void	child_ps( void )
{
	child_ps_unix();
}

/**/

void	init_scrn( void )
{
	init_curs();
	init_term();
}

/**/

void	reset_scrn( void )
{
	while( chk_term() )
		dis_term();

	curs_refresh();
	while( chk_curs() ){
		curs_endwin();
	}
}

/**/

void	ena_scrn( bool_t flg_initscr )
{
	if( flg_initscr ){
		curs_initscr();
		curs_keypad( stdscr, TRUE );
	} else {
		curs_clearok( stdscr, TRUE );
		curs_refresh();
	}

	ena_term();
}

/**/

void	dis_scrn( void )
{
	dis_term();

	curs_refresh();
	curs_endwin();
}

/**/

void	init_term( void )
{
	init_term_unix();
}

/**/

bool_t	chk_term( void )
{
	return chk_term_unix();
}

/**/

void	ena_term( void )
{
	ena_term_unix();
}

/**/

void	dis_term( void )
{
	dis_term_unix();
}

/**/

