/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: misc.c,v 1.6 2003/11/19 13:19:13 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
/*#include	"misc.h"*/
/*#include	"turn.h"*/
/*#include	"dun.h"*/
/*#include	"town.h"*/
/*#include	"item.h"*/
/*#include	"spell.h"*/
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"pet.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
/*#include	"draw.h"*/
/*#include	"curs.h"*/
/*#include	"menu.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
/*#include	"gmain_prot.h"*/
/*#include	"misc_prot.h"*/
/*#include	"turn_prot.h"*/
/*#include	"dun_prot.h"*/
/*#include	"town_prot.h"*/
/*#include	"item_prot.h"*/
/*#include	"spell_prot.h"*/
/*#include	"chr_prot.h"*/
/*#include	"party_prot.h"*/
/*#include	"mnstr_prot.h"*/
/*#include	"pet_prot.h"*/
/*#include	"fight_prot.h"*/
/*#include	"fx_prot.h"*/
/*#include	"trap_prot.h"*/
/*#include	"draw_prot.h"*/
/*#include	"curs_prot.h"*/
/*#include	"menu_prot.h"*/
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

static long	rand_seed = 1;

/**/

void	srandm( long n )
{
	rand_seed = n;
}

/**/

long	randm( long n )
{
	long	a;

	rand_seed += 15349;
	rand_seed *= 37;
	rand_seed += 598393;
	a = (rand_seed & 0xffff0000) >> 16;
	rand_seed = ((rand_seed & 0x0000ffff) << 16) + a;
	rand_seed = abs( rand_seed );
	rand_seed += 379;

	if( n > 0 )
		return( rand_seed % n );
	else
		return 0;
}

/**/

bool_t	rate_randm( rate_t rate )
{
	return( randm( _100_PERCENT ) < rate );
}

/**/

bool_t	per_randm( long per )
{
	return( randm( per ) == 0 );
}

/**/

rate_t	modified_rate( rate_t rate, long n )
{
	if( n >= +1 ){
		rate *= _100_PERCENT + (50 * n);
		rate /= _100_PERCENT;
	}
	if( n <= -1 )
		rate /= abs( n ) + 1;

	if( rate < MODIFIED_MIN_RATE )
		rate = MODIFIED_MIN_RATE;

	return rate;
}

/**/

size_t	str_len_draw( const char *s )
{
	size_t	len;

	for( len = 0; *s; len++, s++ ){
		unsigned char	c;

		c = (unsigned char)*s;
		if( (0x80 <= c) && (c <= 0x9f) )
			len--;
	}

	return len;
}

/**/

size_t	str_len_std( const char *s )
{
	return strlen( s );
}

/**/

char	*str_max_n_cat( char *dst, char *src, int len )
{
	return strncat( dst, src, len - strlen( dst ) );
}

/**/

bool_t	chk_flg( unsigned long var, unsigned long flg )
{
	return( (var & flg) == flg );
}

/**/

bool_t	chk_flg_or( unsigned long var, unsigned long flg )
{
	return( (var & flg) != 0 );
}

/**/

