/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: mnstr.c,v 1.90 2003/11/21 18:35:21 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
/*#include	"misc.h"*/
/*#include	"turn.h"*/
/*#include	"dun.h"*/
/*#include	"town.h"*/
#include	"item.h"
#include	"spell.h"
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
#include	"pet.h"
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"misc_prot.h"
/*#include	"turn_prot.h"*/
#include	"dun_prot.h"
/*#include	"town_prot.h"*/
#include	"item_prot.h"
#include	"spell_prot.h"
#include	"chr_prot.h"
#include	"party_prot.h"
#include	"mnstr_prot.h"
#include	"pet_prot.h"
#include	"fight_prot.h"
#include	"fx_prot.h"
/*#include	"trap_prot.h"*/
#include	"draw_prot.h"
/*#include	"curs_prot.h"*/
/*#include	"menu_prot.h"*/
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

static mnstr_t	mnstr_buf[MNSTR_MAX_N];
static mnstr_t	mnstr_used, mnstr_free;

/**/

#include	"mnstr_tab.h"

/**/

#define	GARGOYLE_STATUE_N	3

#define	MNSTR_GOLD_MUL_N	1
#define	MNSTR_GOLD_ADD_N	10

/**/

void	init_mnstr( void )
{
	long	min_lev, max_lev;
	long	i, max_i;

	max_i = sizeof( mnstr_tab ) / sizeof( mnstr_tab[0] );
	for( i = 0; max_i; i++ ){
		if( mnstr_tab[i].mnstr_kind == MNSTR_KIND_NULL )
			break;

		mnstr_tab[i].name = MSG( mnstr_tab[i].name_n );
	}

	min_lev = 0;
	max_i = sizeof( mnstr_lev_tab ) / sizeof( mnstr_lev_tab[0] );
	for( i = 0; max_i; i++ ){
		mnstr_lev_tab_t	*tab;

		tab = &(mnstr_lev_tab[i]);

		if( tab->kind == MNSTR_KIND_NULL )
			break;

		min_lev += tab->add_lev;
		max_lev = min_lev + tab->range_lev - 1;

		tab->min_lev = min_lev;
		tab->max_lev = max_lev;
	}

	reset_mnstr();
}

/**/

void	reset_mnstr( void )
{
	long	i;

	mnstr_used.next = &mnstr_used;
	mnstr_used.prev = &mnstr_used;

	mnstr_free.next = &mnstr_buf[0];
	mnstr_buf[0].prev = &mnstr_free;
	mnstr_buf[0].next = &mnstr_buf[1];
	for( i = 1; i < MNSTR_MAX_N - 1; i++ ){
		mnstr_buf[i].prev = &(mnstr_buf[i - 1]);
		mnstr_buf[i].next = &(mnstr_buf[i + 1]);
	}
	mnstr_buf[i].prev = &mnstr_buf[i - 1];
	mnstr_buf[i].next = &mnstr_free;
	mnstr_free.prev = &mnstr_buf[i];
}

/**/

void	new_mnstr( mnstr_t *mnstr )
{
	long	lev;
	long	i;

	reset_modifier( &(mnstr->modifier_equip) );
	reset_modifier( &(mnstr->modifier_fx) );

#if	0
	mnstr->prev = NULL;
	mnstr->next = NULL;
#endif
	mnstr->kind = CHR_KIND_MNSTR;
	mnstr->name[0] = '0';
	mnstr->mbr_n = MBR_N_NOT_JOIN;
	mnstr->ls_mbr_n = 0;
	mnstr->face.mjr = FACE_MJR_NULL;
	mnstr->face.mnr = FACE_MNR_NULL;
	mnstr->face.mjr_org = FACE_MJR_NULL;
	mnstr->face.mnr_org = FACE_MNR_NULL;
	mnstr->race.main = MAIN_RACE_HUMAN;
	mnstr->race.sub = SUB_RACE_NULL;
	mnstr->race.name[0] = '0';
	mnstr->sex.cur = MALE;
	mnstr->sex.org = MALE;
	mnstr->x = MAP_DEL_X;
	mnstr->y = MAP_DEL_Y;
	mnstr->pre_x = MAP_DEL_X;
	mnstr->pre_y = MAP_DEL_Y;

	mnstr->move.speed.rate = _100_PERCENT;
	mnstr->move.speed.rate_org = _100_PERCENT;
	mnstr->move.speed.n = 0;
	mnstr->move.force_kind = MOVE_KIND_NULL;
	for( i = 0; i < MOVE_LS_KIND_MAX_N; i++ ){
		mnstr->move.ls[i][0].kind = MOVE_KIND_NULL;
		mnstr->move.ls[i][0].ratio = 0;
	}

	mnstr->gold = 0;
	mnstr->dun_max_lev_floor = 0;
	mnstr->dun_max_lev_base = 0;

	mnstr->trgt.dist = DIST_NEAR;
	mnstr->trgt.dflt_dist_mnstr = DIST_NEAR;
	mnstr->act.dflt_kind_mnstr
			= ACT_KIND_MNSTR_FIGHT;
	strncpy( mnstr->act.dflt_msg_mnstr,
			MSG_MENU_MARK_FIGHT, ACT_MSG_MAX_LEN );
	clr_chr_trgt_act( mnstr, TRUE );

	mnstr->flg_chr = FLG_NULL;
	mnstr->flg_map = FLG_NULL;
	mnstr->attitude = ATTITUDE_HOSTILE;
	mnstr->owner = NULL;
	mnstr->stat = FLG_NULL;

	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		lev = 1;

		mnstr->abl.lev[i].max = lev;
		mnstr->abl.exp[i].max = calc_lev_to_exp( lev, i );

		mnstr->abl.lev[i].n = mnstr->abl.lev[i].max;
		mnstr->abl.lev[i].add = 0;
		mnstr->abl.exp[i].n = mnstr->abl.exp[i].max;
	}
	mnstr->abl.hp.max = calc_max_hp( mnstr );
	mnstr->abl.mp.max = calc_max_mp( mnstr );
	mnstr->abl.hp.n = mnstr->abl.hp.max;
	mnstr->abl.mp.n = mnstr->abl.mp.max;

	mnstr->class_n = 0;

	for( i = 0; i < RESI_KIND_MAX_N; i++ ){
		mnstr->resi[i].n = _100_PERCENT;
		mnstr->resi[i].max = _100_PERCENT;
		mnstr->resi[i].add_n = 0;
	}
	mnstr->add_def = 0;
	mnstr->add_crtcl = 0;
	mnstr->add_ac = 0;

	mnstr->fx.next = &(mnstr->fx);
	mnstr->fx.prev = &(mnstr->fx);

	mnstr->fx_data.armor_def = 0;
	mnstr->fx_data.armor_crtcl = 0;
	mnstr->fx_data.armor_ac = 0;

	mnstr->fx_data.infra_vision = 0;

	mnstr->fx_data.stomach.rate = _100_PERCENT;
	mnstr->fx_data.stomach.full_rate = 100;
	mnstr->fx_data.stomach.digest_p_day = 20;
	mnstr->fx_data.stomach.hungry_rate = 70;
	mnstr->fx_data.stomach.starvation_rate = 30;

	mnstr->fx_data.drunk_rate = 0;

	mnstr->fx_data.nicotine.rate = 0;
	mnstr->fx_data.nicotine.poisoning_rate = 0;

	mnstr->fx_data.friend_turn = 0;

	mnstr->fx_data.bless = 0;

	mnstr->mnstr_kind = MNSTR_KIND_NULL;
	mnstr->mnstr_tab = NULL;

	mnstr->work.flg = FLG_NULL;
	mnstr->work.caught = 0;
	mnstr->work.catch_chr = NULL;
	mnstr->work.towner_dx = 0;
	mnstr->work.towner_dy = 0;
	mnstr->work.enter_door = NULL;
}

/**/

mnstr_t	*make_mnstr_rand( long x, long y, long dun_lev )
{
	mnstr_tab_t	*tab;
	mnstr_t	*p;
	short	group;
	long	i, j;

	if( !can_move_chr( NULL, x, y ) )
		return NULL;

	if( dun_lev == 0 )
		tab = get_towner_tab_rand();
	else
		tab = get_mnstr_tab_rand( dun_lev );
	if( tab == NULL )
		return NULL;

	p = make_mnstr( x, y, dun_lev, tab->mnstr_kind );

	group = roll_dice( tab->group );
	for( i = 0; i < tab->group - 1; i++ ){
		long	nx, ny;

		for( j = 128; j > 0; j-- ){
			nx = x + (randm( 10 + 1 + 10 ) - 10);
			ny = y + (randm( 10 + 1 + 10 ) - 10);
			if( can_move_chr( NULL, nx, ny ) )
				break;
		}
		if( j <= 0 )
			continue;

		make_mnstr( nx, ny, dun_lev, tab->mnstr_kind );
	}

	return p;
}

/**/

mnstr_t	*make_mnstr(
	long x, long y, long dun_lev, mnstr_kind_t mnstr_kind
)
{
	mnstr_t	*p;

	p = mnstr_free.next;
	if( p == &mnstr_free )
		return NULL;
	ins_ls_mnstr( &mnstr_used, p );

	new_mnstr( p );

	if( make_mnstr_alloc( p, x, y, dun_lev, mnstr_kind ) == NULL ){
		die_chr( p, FALSE );
		return NULL;
	}

	return p;
}

/**/

mnstr_t	*make_mnstr_alloc(
	mnstr_t *p, long x, long y, long dun_lev, mnstr_kind_t mnstr_kind
)
{
	long	i;
	dun_t	*dun;
	mnstr_tab_t	*tab;
	mnstr_lev_tab_t	*lev_tab;

	dun = get_dun();

	if( p == NULL )
		return NULL;
	if( mnstr_kind == MNSTR_KIND_NULL )
		return NULL;
	if( clip_pos( x, y ) ){
		if( dun->map.chr.mjr[y][x] != FACE_MJR_NULL )
			return NULL;
		if( !chk_flg( dun->map.obj.flg[y][x], FLG_MAP_OBJ_PASS ) )
			return NULL;
	}

	tab = get_mnstr_tab( mnstr_kind, dun_lev );
	if( tab == NULL )
		return NULL;

	lev_tab = get_mnstr_lev_tab( mnstr_kind, dun_lev );
	if( lev_tab == NULL )
		return NULL;

	new_mnstr( p );

	strncpy( p->name, tab->name, MNSTR_NAME_MAX_LEN );
	p->x = x;
	p->y = y;
	p->pre_x = p->x;
	p->pre_y = p->y;
	p->face.mjr = tab->face_mjr;
	p->face.mnr = tab->face_mnr;
	p->face.mjr_org = tab->face_mjr;
	p->face.mnr_org = tab->face_mnr;
	p->move = tab->move;
	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		long	lev;

		lev = calc_mnstr_abl_lev( lev_tab->min_lev,
				tab->abl_lev_rate[i] );

		p->abl.lev[i].n = lev;
		p->abl.lev[i].max = lev;
		p->abl.lev[i].add = 0;

		p->abl.exp[i].n = calc_need_exp( lev, i );
		p->abl.exp[i].max = p->abl.exp[i].n;
	}
	p->abl.hp.max = calc_max_hp( p );
	p->abl.mp.max = calc_max_mp( p );
	p->abl.hp.n = p->abl.hp.max;
	p->abl.mp.n = p->abl.mp.max;

	for( i = 0; i < RESI_KIND_MAX_N; i++ ){
		p->resi[i].n = tab->resi[i];
		p->resi[i].max = tab->resi[i];
		p->resi[i].add_n = 0;
	}
	p->add_def = 0;
	p->add_crtcl = 0;
	p->add_ac = 0;
	p->gold = calc_mnstr_gold( lev_tab->min_lev, tab->gold_rate );
	p->flg_chr = tab->flg_chr;
	p->flg_map = tab->flg_map;
	p->attitude = tab->attitude;
	p->stat = FLG_NULL;
	p->trgt.kind = TRGT_KIND_NULL;
	p->trgt.p = NULL;
	p->trgt.n = 0;
	p->trgt.x = 0;
	p->trgt.y = 0;
	p->trgt.true_x = 0;
	p->trgt.true_y = 0;
	p->fx.next = &(p->fx);
	p->fx.prev = &(p->fx);
	p->mnstr_kind = mnstr_kind;
	p->mnstr_tab = tab;

	p->work.flg = FLG_NULL;
	p->work.flg &= ~(FLG_WORK_FIND_MBR);
	p->work.caught = 0;
	p->work.catch_chr = NULL;
	p->work.towner_dx = randm( 3 ) - 1;
	p->work.towner_dy = randm( 3 ) - 1;
	p->work.enter_door = NULL;

	/**/

	if( chk_flg( p->flg_map, FLG_MAP_CHR_INVISIBLE ) )
		p->stat |= FLG_STAT_VANISH;

	if( p->attitude == ATTITUDE_HOSTILE )
		p->flg_map &= ~FLG_MAP_CHR_NPC;
	else
		p->flg_map |= FLG_MAP_CHR_NPC;

	set_map_chr( p );

	if( !make_mnstr_special( dun_lev, p ) )
		return NULL;

	return p;
}

/**/

bool_t	make_mnstr_special( long dun_lev, mnstr_t *p )
{
	long	i;
	long	n;
	item_t	*chest;

	if( p == NULL )
		return FALSE;

	switch( p->mnstr_kind ){
	default:
		break;
	case MNSTR_KIND_GARGOYLE:
		n = 0;
		if( !set_statue( p->x, p->y, dun_lev, TRUE ) )
			return FALSE;
		n++;

		for( i = 0; i < 1024; i++ ){
			long	x, y;

			if( n >= GARGOYLE_STATUE_N )
				break;

			x = p->x / MAP_MAX_X * MAP_MAX_X;
			x += randm( AREA_MAX_X - 2) + 1;
			y = p->y / MAP_MAX_Y * MAP_MAX_Y;
			x += randm( AREA_MAX_Y - 2) + 1;
			if( set_statue( x, y, dun_lev, FALSE ) )
				n++;
		}
		break;
	case MNSTR_KIND_MIMIC:
		if( get_item( p->x, p->y ) != NULL )
			return FALSE;

		chest = make_item_chest( dun_lev, get_chest_n( dun_lev ) );

		if( chest == NULL )
			return FALSE;
		if( !put_item( p->x, p->y, 1, chest, FALSE ) ){
			del_item( chest );
			return FALSE;
		}

		break;
	}

	return TRUE;
}

/**/

void	act_all_mnstr( void )
{
	mnstr_t	*head, *p, *pp;

	head = &mnstr_used;
	for( p = head->next->next; p != NULL; p = p->next ){
		pp = p->prev;
		if( pp == head )
			break;

		set_act_mnstr( pp );
		act_chr( pp );
		set_modifier( pp );
	}
}

/**/

bool_t	chk_can_act_mnstr( mnstr_t *p )
{
	long	i;
	party_t	*party;
	dun_t	*dun;

	party = get_party();
	dun = get_dun();

	if( p == NULL )
		return FALSE;
	if( p->kind != CHR_KIND_MNSTR )
		return FALSE;

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( party->mbr[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}
		if( (abs( p->x - party->mbr[i]->x )
				<= MNSTR_MOVE_MAX_X)
				&& (abs( p->y - party->mbr[i]->y )
				<= MNSTR_MOVE_MAX_Y) ){
			break;
		}
	}
	if( i >= MBR_MAX_N ){	/* СΥƤ */
		p->flg_map &= ~FLG_MAP_CHR_FIND;
		dun->map.chr.flg[p->y][p->x] = p->flg_map;
		draw_mnstr( p );

		return FALSE;
	}

	if( chk_flg_or( p->stat,
			FLG_STAT_NOT_EXIST
			| FLG_STAT_DEAD
			| FLG_STAT_PARALYZE
			| FLG_STAT_SLEEP
			| FLG_STAT_FAINT ) ){
		return FALSE;
	}

	return TRUE;
}

/**/

void	set_act_mnstr( mnstr_t *p )
{
	if( p == NULL )
		return;
	if( p->mnstr_tab == NULL )
		return;

	if( p->mnstr_tab->func == NULL )
		set_act_mnstr_std( p );
	else
		p->mnstr_tab->func( p );
}

/**/

mbr_t	*mnstr_mark_mbr_std( mnstr_t *p )
{
	return mnstr_mark_mbr_common( p, SEX_NULL );
}

/**/

mbr_t	*mnstr_mark_mbr_cubus( mnstr_t *p, sex_t sex )
{
	return mnstr_mark_mbr_common( p, sex );
}

/**/

mbr_t	*mnstr_mark_mbr_common( mnstr_t *p, sex_t sex )
{
	party_t	*pty = get_party();
	pet_t	**pty_pet = get_party_pet();
	trgt_kind_t	trgt_kind;
	chr_t	*mark_p;
	long	i;
	long	r;

	if( p == NULL )
		return NULL;

	clr_chr_trgt( p );

	if( p->attitude != ATTITUDE_HOSTILE )
		return NULL;

	trgt_kind = TRGT_KIND_NULL;
	mark_p = NULL;
	r = MAP_MAX_X + MAP_MAX_Y;
	for( i = 0; i < MBR_MAX_N; i++ ){
		long	tmp_r;

		if( chk_flg_or( pty->mbr[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		if( chk_flg( pty->mbr[i]->stat, FLG_STAT_VANISH ) )
			continue;

		if( !chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) ){
			if( !chk_find_chr( p, pty->mbr[i] ) )
				continue;
		}

		if( sex != SEX_NULL )
			if( sex != pty->mbr[i]->sex.cur )
				continue;

		tmp_r = abs( pty->mbr[i]->x - p->x )
				+ abs( pty->mbr[i]->y - p->y );
		if( tmp_r < r ){
			trgt_kind = TRGT_KIND_MBR;
			mark_p = pty->mbr[i];
			r = tmp_r;
		}
	}
	for( i = 0; i < PET_MAX_N; i++ ){
		long	tmp_r;

		if( pty_pet[i] == NULL )
			continue;

		if( chk_flg_or( pty_pet[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		if( chk_flg( pty_pet[i]->stat, FLG_STAT_VANISH ) )
			continue;

		if( !chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) ){
			if( !chk_find_chr( p, pty_pet[i] ) )
				continue;
		}

		if( sex != SEX_NULL )
			continue;

		tmp_r = abs( pty_pet[i]->x - p->x )
				+ abs( pty_pet[i]->y - p->y );
		if( tmp_r < r ){
			trgt_kind = TRGT_KIND_MNSTR;
			mark_p = pty_pet[i];
			r = tmp_r;
		}
	}
	if( mark_p == NULL ){
		if( sex == SEX_NULL )
			return NULL;
		else
			return mnstr_mark_mbr_common( p, SEX_NULL );
	}

	/* Ĥ */

	p->work.flg |= FLG_WORK_FIND_MBR;

	p->trgt.kind = trgt_kind;
	p->trgt.p = mark_p;
	p->trgt.n = mark_p->mbr_n;
	p->trgt.x = mark_p->x;
	p->trgt.y = mark_p->y;
	p->trgt.true_x = p->trgt.x;
	p->trgt.true_y = p->trgt.y;

	return p->trgt.p;
}

/**/

mbr_t	*mnstr_mark_mbr_adjoin( mnstr_t *p )
{
	party_t	*pty = get_party();
	pet_t	**pty_pet = get_party_pet();
	trgt_kind_t	trgt_kind;
	chr_t	*mark_p;
	long	i;

	if( p == NULL )
		return NULL;

	if( p->attitude != ATTITUDE_HOSTILE )
		return NULL;

	trgt_kind = TRGT_KIND_NULL;
	mark_p = NULL;
	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( pty->mbr[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}
		if( abs( p->x - pty->mbr[i]->x ) > 1 )
			continue;
		if( abs( p->y - pty->mbr[i]->y ) > 1 )
			continue;

		trgt_kind = TRGT_KIND_MBR;
		mark_p = pty->mbr[i];
		break;
	}
	for( i = 0; i < PET_MAX_N; i++ ){
		if( mark_p != NULL )
			break;

		if( pty_pet[i] == NULL )
			break;
		if( chk_flg_or( pty_pet[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}
		if( abs( p->x - pty_pet[i]->x ) > 1 )
			continue;
		if( abs( p->y - pty_pet[i]->y ) > 1 )
			continue;

		trgt_kind = TRGT_KIND_MNSTR;
		mark_p = pty_pet[i];
		break;
	}

	if( mark_p == NULL )
		return NULL;

	/* Ĥ */

	p->flg_map |= FLG_MAP_CHR_FIND;
	p->work.flg |= FLG_WORK_FIND_MBR;

	if( chk_flg( p->flg_map, FLG_MAP_CHR_INVISIBLE )
			|| chk_flg( p->stat, FLG_STAT_VANISH ) ){
		item_t	*item;

		p->flg_map &= ~FLG_MAP_CHR_INVISIBLE;
		p->stat &= ~FLG_STAT_VANISH;
		draw_mnstr( p );
		print_msg( FLG_NULL, MSG_MBR_FIND_INVISIBLE,
				p->name );

		item = get_item( p->x, p->y );
		if( item != NULL )
			lost_trgt( item );
	}

	p->trgt.kind = trgt_kind;
	p->trgt.p = mark_p;
	p->trgt.n = mark_p->mbr_n;
	p->trgt.x = mark_p->x;
	p->trgt.y = mark_p->y;
	p->trgt.true_x = p->trgt.x;
	p->trgt.true_y = p->trgt.y;

	return p->trgt.p;
}

/**/

bool_t	mnstr_move_or_atack_std( mnstr_t *p )
{
	attack_t	*ls;
	ratio_t	sum_bash, sum_throw, sum_spell, n;

	if( p == NULL )
		return FALSE;
	if( p->mnstr_tab == NULL )
		return FALSE;

	ls = p->mnstr_tab->attack;

	sum_bash = calc_attack_sum( ls, TRUE, TRUE, FALSE, FALSE );
	sum_throw = calc_attack_sum( ls, FALSE, FALSE, TRUE, FALSE );
	sum_spell = calc_attack_sum( ls, FALSE, FALSE, FALSE, TRUE );

	n = randm( sum_bash + sum_throw + sum_spell );

	if( n < sum_bash ){
		set_chr_act( p, ACT_KIND_MBR_FIGHT,
				(chr_t *)(p->trgt.p), NULL, 0, 0 );
	} else if( n < sum_bash + sum_throw ){
		set_chr_act( p, ACT_KIND_MBR_THROW,
				(chr_t *)(p->trgt.p), NULL, 0, 0 );
	} else {
		attack_t	*atk;

		atk = get_attack( FALSE, ls,
				FALSE, FALSE, FALSE, TRUE );
		if( atk == NULL )
			return FALSE;
		set_chr_act( p, ACT_KIND_SPELL,
				get_spell_tab( atk->spell ),
				MSG( atk->spell_fmt ),
				atk->extent, 0 );
	}

	return TRUE;
}

/**/

void	set_attitude_mnstr_group( char face_mjr, attitude_t att )
{
	mnstr_t	*head, *p, *pp;

	head = &mnstr_used;
	for( p = head->next->next; p != NULL; p = p->next ){
		pp = p->prev;
		if( pp == head )
			break;

		if( pp->face.mjr == face_mjr )
			pp->attitude = att;
	}
}

/**/

void	inc_turn_all_mnstr( void )
{
	mnstr_t	*head, *p, *pp;

	head = &mnstr_used;
	for( p = head->next->next; p != NULL; p = p->next ){
		pp = p->prev;
		if( pp == head )
			break;

		pp->fx_data.infra_vision--;
		if( pp->fx_data.infra_vision < 0 )
			pp->fx_data.infra_vision = 0;
	}
}

/**/

bool_t	increase_mnstr( mnstr_t *p )
{
	long	nx, ny;

	if( p == NULL )
		return FALSE;

	nx = p->x + (randm( 3 ) - 1);
	ny = p->y + (randm( 3 ) - 1);
	if( can_move_chr( NULL, nx, ny ) ){
		dun_t	*dun;
		mnstr_t	*new_mnstr;

		dun = get_dun();

		new_mnstr = make_mnstr( nx, ny, dun->lev, p->mnstr_kind );
		if( new_mnstr == NULL )
			return FALSE;

		new_mnstr->attitude = p->attitude;

		return TRUE;
	}

	return FALSE;
}

/**/

bool_t	chk_auto_door_mnstr( mnstr_t *p, long x1, long y1, long x2, long y2 )
{
	if( p == NULL )
		return FALSE;
	if( p->kind != CHR_KIND_MNSTR )
		return FALSE;

	if( chk_flg( p->flg_chr, FLG_CHR_CAN_OPEN_DOOR ) ){
		if( chk_auto_door_mnstr_open( p, x1, y1 ) )
			return TRUE;
		if( chk_auto_door_mnstr_open( p, x2, y2 ) )
			return TRUE;
	} else if( chk_flg( p->flg_chr, FLG_CHR_CAN_BREAK_DOOR ) ){
		if( chk_auto_door_mnstr_break( p, x1, y1 ) )
			return TRUE;
		if( chk_auto_door_mnstr_break( p, x2, y2 ) )
			return TRUE;
	}

	return FALSE;
}

/**/

bool_t	chk_auto_door_mnstr_open( mnstr_t *p, long x, long y )
{
	dun_t	*dun = get_dun();

	if( p == NULL )
		return FALSE;
	if( !clip_pos( x, y ) )
		return FALSE;

	if( dun->map.obj.mjr[y][x] == FACE_MJR_DOOR_CLOSE ){
		door_t	*dr;

		dr = get_door( x, y );
		if( dr != NULL )
			return chr_open_door( p, dr->n );
	}

	return FALSE;
}

/**/

bool_t	chk_auto_door_mnstr_break( mnstr_t *p, long x, long y )
{
	dun_t	*dun = get_dun();
	char	c;

	if( p == NULL )
		return FALSE;
	if( !clip_pos( x, y ) )
		return FALSE;

	c = dun->map.obj.mjr[y][x];
	if( (c == FACE_MJR_DOOR_CLOSE) || (c == FACE_MJR_DOOR_OPEN) ){
		door_t	*dr;

		dr = get_door( x, y );
		if( dr != NULL )
			return chr_break_door( p, dr->n );
	}

	return FALSE;
}

/**/

void	set_flg_find_all_mnstr( void )
{
	mnstr_t	*head, *p, *pp;

	head = &mnstr_used;
	for( p = head->next->next; p != NULL; p = p->next ){
		pp = p->prev;
		if( pp == head )
			break;

		set_flg_find_mnstr( pp );
	}
}

/**/

bool_t	set_flg_find_mnstr( mnstr_t *p )
{
	long	i;
	dun_t	*dun;
	party_t	*pty;

	dun = get_dun();
	pty = get_party();

	if( p == NULL )
		return FALSE;
	if( chk_flg_or( p->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return FALSE;

	p->flg_map &= ~FLG_MAP_CHR_FIND;
	dun->map.chr.flg[p->y][p->x] = p->flg_map;

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_find_chr( pty->mbr[i], p ) ){
			p->flg_map |= FLG_MAP_CHR_FIND;
			dun->map.chr.flg[p->y][p->x] = p->flg_map;
			return TRUE;
		}
	}

	return FALSE;
}

/**/

long	add_hp_mnstr( mnstr_t *mnstr, long n )
{
	long	pre_hp, add;

	if( mnstr == NULL )
		return 0;

	pre_hp = mnstr->abl.hp.n;

	mnstr->abl.hp.n += n;
	if( mnstr->abl.hp.n > mnstr->abl.hp.max )
		mnstr->abl.hp.n = mnstr->abl.hp.max;
	if( mnstr->abl.hp.n < 0 )
		mnstr->abl.hp.n = 0;

	add = mnstr->abl.hp.n - pre_hp;
	if( add != 0 )
		vfx_num( mnstr, add );

	if( mnstr->abl.hp.n <= 0 )
		die_chr( mnstr, TRUE );

	return mnstr->abl.hp.n;
}

/**/

void	die_mnstr( mnstr_t *p )
{
	if( p == NULL )
		return;

	do {
		long	n;
		item_t	*coin;

		if( p->gold <= 0 )
			break;

		n = get_coin_tab_n( get_coin_tab( COIN_KIND_GOLD ) );
		if( n < 0 )
			break;

		coin = make_item_coin( 1, n );
		if( coin == NULL )
			break;
		coin->n = p->gold;
		set_item_name( coin );

		if( !put_item( p->x, p->y, PUT_ITEM_R, coin, FALSE ) )
			del_item( coin );
	} while( 0 );

	release_chr( p );

	ins_ls_mnstr( &mnstr_free, p );
}

/**/

void	set_find_all_mnstr( void )
{
	mnstr_t	*head, *p, *pp;
	dun_t	*dun;

	dun = get_dun();

	head = &mnstr_used;
	for( p = head->next->next; p != NULL; p = p->next ){
		pp = p->prev;
		if( pp == head )
			break;

		pp->flg_map |= FLG_MAP_CHR_FIND;
		pp->flg_map &= ~FLG_MAP_CHR_INVISIBLE;
		dun->map.chr.flg[pp->y][pp->x] = pp->flg_map;
	}
}

/**/

void	print_ls_mnstr( void )
{
	party_t	*pty = get_party();
	long	max_dun_lev_base, min_lev, max_lev;
	long	i, max_i;

	max_dun_lev_base = 0;
	for( i = 0; i < MBR_MAX_N; i++ ){
		long	lev;

		lev = abs( pty->mbr[i]->dun_max_lev_base );
		if( max_dun_lev_base < lev )
			max_dun_lev_base = lev;
	}

	min_lev = 0;
	max_i = sizeof( mnstr_lev_tab ) / sizeof( mnstr_lev_tab[0] );
	for( i = 0; max_i; i++ ){
		mnstr_tab_t	*tab;

		if( mnstr_lev_tab[i].kind == MNSTR_KIND_NULL )
			break;

		min_lev += mnstr_lev_tab[i].add_lev;
		max_lev = min_lev + mnstr_lev_tab[i].range_lev - 1;

		tab = get_mnstr_tab( mnstr_lev_tab[i].kind, min_lev );
		if( tab == NULL )
			continue;

		if( max_dun_lev_base < min_lev )
			continue;

		print_msg( FLG_NULL, MSG_LS_MNSTR,
				min_lev, max_lev, tab->name );
	}
}

/**/

char	*get_mnstr_name( mnstr_kind_t mnstr_kind )
{
	mnstr_tab_t	*tab;

	tab = get_mnstr_tab( mnstr_kind, 0 );
	if( tab == NULL )
		return MSG_MNSTR_UNKNOWN;

	return tab->name;
}

/**/

mnstr_tab_t	*get_mnstr_tab( mnstr_kind_t mnstr_kind, long dun_lev )
{
	mnstr_tab_t	*tab;
	long	n;

	tab = NULL;
	for( n = 0; mnstr_tab[n].mnstr_kind != MNSTR_KIND_NULL; n++ ){
		mnstr_lev_tab_t	*lev_tab;

		if( mnstr_tab[n].mnstr_kind != mnstr_kind )
			continue;

		tab = &(mnstr_tab[n]);

		lev_tab = get_mnstr_lev_tab( mnstr_kind, dun_lev );
		if( lev_tab != NULL ){
			if( lev_tab->min_lev <= abs( dun_lev ) ){
				if( abs( dun_lev ) <= lev_tab->max_lev ){
					break;
				}
			}
		}
	}

	return tab;
}

/**/

mnstr_tab_t	*get_mnstr_tab_rand( long dun_lev )
{
	mnstr_kind_t	kind;
	long	i, max_i, n;

	kind = MNSTR_KIND_NULL;
	n = 0;
	max_i = sizeof( mnstr_lev_tab ) / sizeof( mnstr_lev_tab[0] );
	for( i = 0; max_i; i++ ){
		mnstr_lev_tab_t	*lev_p;

		lev_p = &(mnstr_lev_tab[i]);

		if( lev_p->kind == MNSTR_KIND_NULL )
			break;

		if( lev_p->min_lev <= abs( dun_lev ) ){
			if( abs( dun_lev ) <= lev_p->max_lev ){
				n++;
				if( per_randm( n ) ){
					kind = lev_p->kind;
				}
			}
		}
	}

	return get_mnstr_tab( kind, dun_lev );
}

/**/

mnstr_tab_t	*get_towner_tab_rand( void )
{
	long	n, sum;
	long	i, max_i;

	max_i = sizeof( towner_tab ) / sizeof( towner_tab[0] );

	sum = 0;
	for( i = 0; max_i; i++ ){
		if( towner_tab[i].kind == MNSTR_KIND_NULL )
			break;

		sum += towner_tab[i].ratio;
	}

	n = randm( sum );

	sum = 0;
	for( i = 0; max_i; i++ ){
		if( towner_tab[i].kind == MNSTR_KIND_NULL )
			break;

		sum += towner_tab[i].ratio;

		if( n < sum )
			break;
	}
	if( i >= max_i )
		return NULL;

	return get_mnstr_tab( towner_tab[i].kind, 0 );
}

/**/

mnstr_lev_tab_t	*get_mnstr_lev_tab( mnstr_kind_t mnstr_kind, long dun_lev )
{
	mnstr_lev_tab_t	*tab;
	long	i, max_i;

	tab = NULL;
	max_i = sizeof( mnstr_lev_tab ) / sizeof( mnstr_lev_tab[0] );
	for( i = 0; max_i; i++ ){
		mnstr_lev_tab_t	*p;

		p = &(mnstr_lev_tab[i]);

		if( p->kind == MNSTR_KIND_NULL )
			break;

		if( p->min_lev <= abs( dun_lev ) ){
			if( abs( dun_lev ) <= p->max_lev ){
				tab = p;
				break;
			}
		}
	}

	return tab;
}

/**/

void	ins_ls_mnstr( mnstr_t *ls, mnstr_t *p )
{
	if( ls == NULL )
		return;
	if( ls->prev == NULL )
		return;
	if( ls->next == NULL )
		return;
	if( p == NULL )
		return;
	if( p->prev == NULL )
		return;
	if( p->next == NULL )
		return;

	p->next->prev = p->prev;
	p->prev->next = p->next;

	p->prev = ls->prev;
	p->next = ls;

	ls->prev->next = p;
	ls->prev = p;
}

/**/

void	exp_chr_mnstr( chr_t *chr, long exp, bool_t flg_print_lev )
{
	long	left_exp;
	rate_t	abl_sum;
	abl_kind_t	k, left_k;
	long	left_n;

	if( chr == NULL )
		return;
	if( chr->mnstr_tab == NULL )
		return;

	left_exp = exp;
	left_n = 0;
	left_k = 0;

	abl_sum = 0;
	for( k = 0; k < ABL_KIND_MAX_N; k++ )
		abl_sum += chr->mnstr_tab->abl_lev_rate[k];
	if( abl_sum <= 0 )
		return;

	for( k = 0; k < ABL_KIND_MAX_N; k++ ){
		rate_t	abl_rate;
		long	e;

		abl_rate = chr->mnstr_tab->abl_lev_rate[k];
		if( abl_rate == 0 )
			continue;

		e = exp * abl_rate / abl_sum;
		chr->abl.exp[k].n += e;

		left_exp -= e;
		left_n++;
		if( per_randm( left_n ) )
			left_k = k;
	}

	chr->abl.exp[left_k].n += left_exp;

	chk_up_lev( chr, flg_print_lev );
}

/**/

long	calc_mnstr_exp( mnstr_t *p, long dun_lev )
{
	long	lev;
	long	exp;

	if( p == NULL )
		return 1;
	if( p->mnstr_tab == NULL )
		return 1;

	lev = abs( dun_lev ) * RATE_LEV_PER_DUN_LEV / _100_PERCENT;

	exp = calc_need_exp( lev, ABL_KIND_HP );
	exp -= calc_need_exp( lev - 1, ABL_KIND_HP );

	exp /= EXP_NEED_KILL_MNSTR_N;

	if( exp < 1 )
		exp = 1;
	exp *= MBR_MAX_N;
	exp = exp * _100_PERCENT / ABL_RATE_MAX_N;

	return exp;
}

/**/

long	calc_mnstr_abl_lev( long dun_lev, rate_t rate )
{
	long	lev;

	lev = abs( dun_lev ) * RATE_LEV_PER_DUN_LEV / _100_PERCENT;
	lev = lev * rate / _100_PERCENT;

	if( lev < 0 )
		lev = 0;
	if( lev < 1 )
		if( rate > 0 )
			lev = 1;

	return lev;
}

/**/

gold_t	calc_mnstr_gold( long dun_lev, rate_t rate )
{
	gold_t	gold;

	gold = abs( dun_lev * dun_lev );
	gold *= MNSTR_GOLD_MUL_N;
	gold += MNSTR_GOLD_ADD_N;
	gold = gold * rate / _100_PERCENT;

	return gold;
}

/**/

mnstr_t	*get_mnstr( long x, long y )
{
	mnstr_t	*head, *p, *pp;
	pet_t	*pet;

	head = &mnstr_used;
	for( p = head->next->next; p != NULL; p = p->next ){
		pp = p->prev;
		if( pp == head )
			break;

		if( chk_flg_or( pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}
		if( (pp->x == x) && (pp->y == y) )
			return pp;
	}

	pet = get_pet( x, y );
	if( pet != NULL )
		return pet;

	return NULL;
}

/**/

mnstr_t	*get_mnstr_nearest( long x, long y )
{
	mnstr_t	*head, *p, *pp, *ret_p;
	long	min_r, tmp_r;
	long	n;

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_p = NULL;
	n = 0;

	head = &mnstr_used;
	for( p = head->next->next; p != NULL; p = p->next ){
		pp = p->prev;
		if( pp == head )
			break;

		if( !chk_flg( pp->flg_map, FLG_MAP_CHR_FIND ) )
			continue;
		if( chk_flg_or( pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}
		if( pp->attitude != ATTITUDE_HOSTILE )
			continue;

		tmp_r = abs( pp->x - x ) + abs( pp->y - y );
		if( tmp_r < min_r ){
			n = 0;
			min_r = tmp_r;
		} else if( tmp_r == min_r ){
			n++;
			if( randm( n ) != 0 )
				continue;
		} else {
			continue;
		}

		ret_p = pp;
	}

	return ret_p;
}

/**/

mnstr_t	*get_mnstr_near( long x, long y )
{
	mnstr_t	*head, *p, *pp, *ret_p;
	long	min_r, tmp_r;
	long	n;

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_p = NULL;
	n = 0;
	head = &mnstr_used;
	for( p = head->next->next; p != NULL; p = p->next ){
		pp = p->prev;
		if( pp == head )
			break;

		if( !chk_flg( pp->flg_map, FLG_MAP_CHR_FIND ) )
			continue;
		if( chk_flg_or( pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}
		if( pp->attitude != ATTITUDE_HOSTILE )
			continue;

		tmp_r = abs( pp->x - x ) + abs( pp->y - y );
		if( tmp_r < min_r ){
			n = 0;
			min_r = tmp_r;
		} else if( (tmp_r - min_r) <= MNSTR_NEAR_R ){
			n++;
			if( randm( n ) != 0 )
				continue;
		} else {
			continue;
		}

		ret_p = pp;
	}

	return ret_p;
}

/**/

mnstr_t	*get_mnstr_disperse( mbr_t *mbr )
{
	mnstr_t	*head, *p, *pp, *ret_p;
	long	min_r, tmp_r;
	long	n;
	long	x, y;

	x = mbr->x;
	y = mbr->y;

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_p = NULL;
	n = 0;
	head = &mnstr_used;
	for( p = head->next->next; p != NULL; p = p->next ){
		pp = p->prev;
		if( pp == head )
			break;

		if( !chk_flg( pp->flg_map, FLG_MAP_CHR_FIND ) )
			continue;
		if( chk_flg_or( pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}
		if( pp->attitude != ATTITUDE_HOSTILE )
			continue;

		tmp_r = abs( pp->x - x ) + abs( pp->y - y );
		if( tmp_r < min_r ){
			if( already_mark_mnstr( pp, mbr ) )
				continue;
			n = 0;
			min_r = tmp_r;
		} else if( tmp_r == min_r ){
			if( already_mark_mnstr( pp, mbr ) )
				continue;
			n++;
			if( randm( n ) != 0 )
				continue;
		} else {
			continue;
		}

		ret_p = pp;
	}

	return ret_p;
}

/**/

mnstr_t	*get_mnstr_randm( long x, long y )
{
	mnstr_t	*head, *p, *pp, *ret_p;
	long	n;

	ret_p = NULL;
	n = 0;
	head = &mnstr_used;
	for( p = head->next->next; p != NULL; p = p->next ){
		pp = p->prev;
		if( pp == head )
			break;

		if( !chk_flg( pp->flg_map, FLG_MAP_CHR_FIND ) )
			continue;
		if( chk_flg_or( pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}
		if( pp->attitude != ATTITUDE_HOSTILE )
			continue;

		n++;
		if( randm( n ) == 0 )
			ret_p = pp;
	}

	return ret_p;
}

/**/

bool_t	already_mark_mnstr( mnstr_t *mnstr, mbr_t *mbr )
{
	party_t	*pty;
	long	i;

	pty = get_party();

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( pty->mbr[i] == mbr )
			continue;

		if( pty->mbr[i]->trgt.p == ((void *)mnstr) )
			return TRUE;
	}

	return FALSE;
}

/**/

mnstr_t	*get_mnstr_rand( long x, long y )
{
	mnstr_t	*head, *p, *pp;
	long	n, max_n, max_n2;

	max_n = 0;
	max_n2 = 0;
	head = &mnstr_used;
	for( p = head->next->next; p != NULL; p = p->next ){
		pp = p->prev;
		if( pp == head )
			break;

		if( !chk_flg( pp->flg_map, FLG_MAP_CHR_FIND ) )
			continue;
		if( chk_flg_or( pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		max_n++;

		if( (abs( pp->x - x ) < 1) && (abs( pp->y - y ) < 1) )
			max_n2++;
	}
	if( max_n <= 0 )
		return NULL;

	if( max_n2 == 0 ){
		n = randm( max_n ) + 1;
		head = &mnstr_used;
		for( p = head->next->next; p != NULL; p = p->next ){
			pp = p->prev;
			if( pp == head )
				break;

			if( !chk_flg( pp->flg_map, FLG_MAP_CHR_FIND ) )
				continue;
			if( chk_flg_or( pp->stat,
					FLG_STAT_NOT_EXIST
					| FLG_STAT_DEAD ) ){
				continue;
			}

			n--;
			if( n == 0 )
				return pp;
		}
	} else {
		n = randm( max_n2 ) + 1;
		head = &mnstr_used;
		for( p = head->next->next; p != NULL; p = p->next ){
			pp = p->prev;
			if( pp == head )
				break;

			if( !chk_flg( pp->flg_map, FLG_MAP_CHR_FIND ) )
				continue;
			if( chk_flg_or( pp->stat,
					FLG_STAT_NOT_EXIST
					| FLG_STAT_DEAD ) ){
				continue;
			}

			if( (abs( pp->x - x ) < 1)
					&& (abs( pp->y - y ) < 1) ){
				n--;
				if( n == 0 )
					return pp;
			}
		}
	}

	return NULL;
}

/**/

mnstr_t	*get_mnstr_used( void )
{
	return &mnstr_used;
}

/**/

