/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: mnstr_act.c,v 1.11 2003/11/23 04:29:50 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
#include	"misc.h"
#include	"turn.h"
#include	"dun.h"
#include	"town.h"
#include	"item.h"
/*#include	"spell.h"*/
#include	"chr.h"
#include	"party.h"
#include	"mnstr.h"
#include	"pet.h"
/*#include	"fight.h"*/
#include	"fx.h"
/*#include	"trap.h"*/
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
/*#include	"gmain_prot.h"*/
#include	"misc_prot.h"
#include	"turn_prot.h"
#include	"dun_prot.h"
#include	"town_prot.h"
#include	"item_prot.h"
/*#include	"spell_prot.h"*/
#include	"chr_prot.h"
/*#include	"party_prot.h"*/
#include	"mnstr_prot.h"
#include	"mnstr_act_prot.h"
#include	"pet_prot.h"
/*#include	"fight_prot.h"*/
#include	"fx_prot.h"
/*#include	"trap_prot.h"*/
#include	"draw_prot.h"
/*#include	"curs_prot.h"*/
/*#include	"menu_prot.h"*/
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

#define	PICK_GOLD_RATE	((rate_t)10)
#define	PICK_GOLD_MAX_N	((gold_t)500)

#define	INCREASE_RATE_GIANT_RAT	20

#define	TOWNER_ENTER_DOOR_RATE	10
#define	TOWNER_ENTER_DOOR_R	3
#define	TOWNER_EXIT_DOOR_RATE	10
#define	TOWNER_CANCEL_DOOR_RATE	10

/*  */

void	set_act_mnstr_std( mnstr_t *p )
{
	if( p == NULL )
		return;

	if( p->attitude == ATTITUDE_MATE ){
		set_act_pet_std( p );
		return;
	}

	mnstr_mark_mbr_std( p );

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) )
		mnstr_move_or_atack_std( p );
}

/**/

void	set_act_mnstr_cubus( mnstr_t *p, sex_t sex )
{
	if( p == NULL )
		return;

	if( p->attitude == ATTITUDE_MATE ){
		set_act_pet_std( p );
		return;
	}

	mnstr_mark_mbr_cubus( p, sex );

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) )
		mnstr_move_or_atack_std( p );
}

/**/

void	set_act_mnstr_towner( mnstr_t *p )
{
	if( p == NULL )
		return;

	if( p->attitude == ATTITUDE_MATE ){
		set_act_pet_std( p );
		return;
	}

	chk_discount_mark( p );
	if( p->trgt.kind == TRGT_KIND_QUEUE )
		return;

	if( p->act.kind == ACT_KIND_DOOR_OPEN ){
		if( rate_randm( TOWNER_CANCEL_DOOR_RATE ) )
			clr_chr_trgt_act( p, FALSE );
	} else {
		set_act_mnstr_std( p );
		set_act_towner_enter_door( p );
	}

	set_act_towner_exit_door( p );
}

/**/

void	set_act_towner_enter_door( mnstr_t *p )
{
	dun_t	*dun = get_dun();
	door_t	*dr;

	if( p == NULL )
		return;
	if( dun->lev != 0 )
		return;
	if( p->act.kind == ACT_KIND_DOOR_OPEN )
		return;
	if( !rate_randm( TOWNER_ENTER_DOOR_RATE ) )
		return;

	dr = get_door_towner( p->x, p->y, TOWNER_ENTER_DOOR_R );
	if( dr == NULL )
		return;
	if( chk_discount_door( dr ) )
		return;

	set_chr_act( p, ACT_KIND_DOOR_OPEN, NULL, NULL, 0, 0 );
	mark_door( p, dr, DIST_NEAR );
}

/**/

void	set_act_towner_exit_door( mnstr_t *p )
{
	door_t	*dr;

	if( p == NULL )
		return;
	if( p->work.enter_door == NULL )
		return;
	if( !rate_randm( TOWNER_EXIT_DOOR_RATE ) )
		return;
	if( chk_night() )
		return;

	dr = p->work.enter_door;
	if( dr == NULL )
		return;

	set_chr_pos( p, dr->x, dr->y );
	p->work.enter_door = NULL;
}

/******************************************************************/

/*  */
/* ɥ饴 */
/*  */

/*  */

void	set_act_mnstr_leprechaun( mnstr_t *p )
{
	chr_t	*mbr;

	if( p == NULL )
		return;

	mbr = mnstr_mark_mbr_adjoin( p );

	if( mbr != NULL ){
		fx_pick_gold( p, mbr, PICK_GOLD_RATE, PICK_GOLD_MAX_N );
		print_msg( FLG_NULL, MSG_MNSTR_DISAPPEAR, p->name );
		teleport_chr( p );
	}

	set_act_mnstr_std( p );
}

/*  */

/* ʪ */

void	set_act_mnstr_venus_fly_trap( mnstr_t *p )
{
	if( p == NULL )
		return;

	if( mnstr_mark_mbr_adjoin( p ) != NULL )
		catch_chr( p, p->trgt.p );

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) )
		mnstr_move_or_atack_std( p );
}

/**/

void	set_act_mnstr_slime( mnstr_t *p )
{
	if( p == NULL )
		return;

	if( mnstr_mark_mbr_adjoin( p ) == NULL )
		mnstr_mark_mbr_std( p );

	set_act_mnstr_std( p );
}

/**/

void	set_act_mnstr_spore( mnstr_t *p )
{
	if( p == NULL )
		return;

	if( mnstr_mark_mbr_adjoin( p ) != NULL )
		mnstr_move_or_atack_std( p );
}

/* ưʪ */

void	set_act_mnstr_giant_rat( mnstr_t *p )
{
	static long	increase_turn = -1;

	if( p == NULL )
		return;

	set_act_mnstr_std( p );

	if( increase_turn < get_turn() ){
		if( rate_randm( INCREASE_RATE_GIANT_RAT ) ){
			increase_mnstr( p );
			increase_turn = get_turn();
		}
	}
}

/*  */

void	set_act_mnstr_giant_spider( mnstr_t *p )
{
	mbr_t	*mbr;
	bool_t	flg_rel;

	if( p == NULL )
		return;

	mbr = mnstr_mark_mbr_adjoin( p );
	if( mbr == NULL )
		mnstr_mark_mbr_std( p );
	else
		catch_chr( p, mbr );

	if( mbr == NULL )
		flg_rel = TRUE;
	else if( rate_randm( 30 ) )
		flg_rel = TRUE;
	else
		flg_rel = FALSE;

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) ){
		if( flg_rel )
			release_chr( p );

		mnstr_move_or_atack_std( p );
	}
}

/* ʹ */
/* Ⱦ */
/*  */
/* ʪ */
/* ʪ */
/* ˡʪ */

void	set_act_mnstr_gargoyle( mnstr_t *p )
{
	dun_t	*dun = get_dun();

	if( p == NULL )
		return;

	/* begin */

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) ){
		mnstr_mark_mbr_std( p );
	} else {
		flg_map_t	flg_map;
		chr_t	*mark;

		flg_map = dun->map.obj.flg[p->y][p->x];
		dun->map.obj.flg[p->y][p->x] |= FLG_MAP_OBJ_PASS;

		mark = mnstr_mark_mbr_adjoin( p );

		dun->map.obj.flg[p->y][p->x] = flg_map;

		if( mark != NULL ){
			/* Ĥ */
			dun->map.obj.mjr[p->y][p->x] = FACE_MJR_FLOOR;
			dun->map.obj.mnr[p->y][p->x] = FACE_MNR_FLOOR;
			dun->map.obj.flg[p->y][p->x] = FLG_MAP_OBJ_PASS;
		}
	}

	/* end */

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) )
		mnstr_move_or_atack_std( p );
}

/**/

void	set_act_mnstr_mimic( mnstr_t *p )
{
	if( p == NULL )
		return;

	if( mnstr_mark_mbr_adjoin( p ) != NULL )
		catch_chr( p, p->trgt.p );

	if( chk_flg( p->work.flg, FLG_WORK_FIND_MBR ) )
		mnstr_move_or_atack_std( p );
}

/*  */

/* ǥå */

void	set_act_mnstr_vampire( mnstr_t *p )
{
	mnstr_tab_t	*tab;

	if( p == NULL )
		return;

	tab = get_mnstr_tab( MNSTR_KIND_GIANT_BAT, 0 );
	if( tab == NULL )
		return;

	if( p->face.mjr == FACE_MJR_MNSTR_UNDEAD ){
		set_act_mnstr_std( p );

		if( rate_randm( 10 ) ){
			p->move = tab->move;
			p->modifier_fx.face_mjr = FACE_MJR_MNSTR_ANIMAL;
			p->modifier_fx.face_mnr = FACE_MNR_MNSTR_BAT;
		}
	} else {
		tab->func( p );

		if( rate_randm( 10 ) ){
			tab = p->mnstr_tab;
			if( tab != NULL )
				p->move = tab->move;
			p->modifier_fx.face_mjr = FACE_MJR_MNSTR_UNDEAD;
			p->modifier_fx.face_mnr = FACE_MNR_MNSTR_VAMPIRE;
		}
	}
}

/*  */

void	set_act_mnstr_incubus( mnstr_t *p )
{
	set_act_mnstr_cubus( p, FEMALE );
}

/**/


void	set_act_mnstr_succubus( mnstr_t *p )
{
	set_act_mnstr_cubus( p, MALE );
}

/*  */
/*  */

