/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: mnstr_tab.h,v 1.80 2003/11/22 08:31:02 bowkenken Exp $
*****************************************************************/

#ifndef	MNSTR_TAB_H
#define	MNSTR_TAB_H

#include	"party.h"
#include	"fight.h"
#include	"mnstr_act_prot.h"

/**/

#if	0
typedef struct {
	/* 󥹥μ */
	mnstr_kind_t	kind;

	/* ȯ볬κǾκʬ */
	long	add_lev, range_lev;

	/* ȯ볬κǾ */
	long	min_lev, max_lev;
} mnstr_lev_tab_t;
#endif

mnstr_lev_tab_t	mnstr_lev_tab[] = {
	{ MNSTR_KIND_FIGHTER,
		+0, +1, },
	{ MNSTR_KIND_MONK,
		+0, +1, },
	{ MNSTR_KIND_HUNTER,
		+0, +1, },
	{ MNSTR_KIND_THIEF,
		+0, +1, },
	{ MNSTR_KIND_WIZARD,
		+0, +1, },
	{ MNSTR_KIND_SUMMONER,
		+0, +1, },
	{ MNSTR_KIND_PRIEST,
		+0, +1, },
	{ MNSTR_KIND_FARMER,
		+0, +1, },
	{ MNSTR_KIND_CRAFTSMAN,
		+0, +1, },
	{ MNSTR_KIND_MERCHANT,
		+0, +1, },
/**/
	{ MNSTR_KIND_GIANT_BAT,
		+1, +1, },
	{ MNSTR_KIND_GIANT_SNAKE,
		+0, +1, },
	{ MNSTR_KIND_GIANT_RAT,
		+1, +1, },
	{ MNSTR_KIND_GIANT_CENTIPEDE,
		+0, +1, },
	{ MNSTR_KIND_KOBOLD,
		+1, +3, },
	{ MNSTR_KIND_VIPER_SNAKE,
		+0, +1, },
	{ MNSTR_KIND_GOBLIN,
		+1, +3, },
	{ MNSTR_KIND_GIANT_BEE,
		+1, +3, },
	{ MNSTR_KIND_HOBGOBLIN,
		+1, +3, },
	{ MNSTR_KIND_CAT,
		+0, +1, },
	{ MNSTR_KIND_DOG,
		+0, +1, },
	{ MNSTR_KIND_WOLF,
		+0, +1, },
	{ MNSTR_KIND_PYON_PYON,
		+0, +1, },
	{ MNSTR_KIND_SKELETON,
		+1, +3, },
	{ MNSTR_KIND_ORK,
		+1, +3, },
	{ MNSTR_KIND_VENUS_FLY_TRAP,
		+1, +3, },
	{ MNSTR_KIND_GIANT_SCORPION,
		+1, +3, },
	{ MNSTR_KIND_ZOMBIE,
		+1, +3, },
	{ MNSTR_KIND_YETI,
		+1, +3, },
	{ MNSTR_KIND_GIANT_ANT,
		+1, +3, },
	{ MNSTR_KIND_GNOLL,
		+1, +3, },
	{ MNSTR_KIND_GIANT_SPIDER,
		+1, +3, },
	{ MNSTR_KIND_OGRE,
		+1, +3, },
	{ MNSTR_KIND_LEPRECHAUN,
		+1, +3, },
	{ MNSTR_KIND_GHOUL,
		+1, +3, },
	{ MNSTR_KIND_SLIME,
		+1, +3, },
	{ MNSTR_KIND_IMP,
		+1, +3, },
	{ MNSTR_KIND_TROLL,
		+1, +3, },
	{ MNSTR_KIND_INVISIBLE_STALKER,
		+1, +3, },
	{ MNSTR_KIND_ACID_FLY,
		+1, +3, },
	{ MNSTR_KIND_FIRE_ELEMENTAL,
		+1, +3, },
	{ MNSTR_KIND_HIPPOGRIFF,
		+1, +3, },
	{ MNSTR_KIND_WATER_ELEMENTAL,
		+1, +3, },
	{ MNSTR_KIND_GIANT_BEETLE,
		+1, +3, },
	{ MNSTR_KIND_GHOST,
		+1, +3, },
	{ MNSTR_KIND_WOOD_GOLEM,
		+1, +3, },
	{ MNSTR_KIND_GRIFFON,
		+1, +3, },
	{ MNSTR_KIND_BONE_GOLEM,
		+1, +3, },
	{ MNSTR_KIND_INCUBUS,
		+1, +3, },
	{ MNSTR_KIND_SPORE,
		+1, +3, },
	{ MNSTR_KIND_EARTH_ELEMENTAL,
		+1, +3, },
	{ MNSTR_KIND_AIR_ELEMENTAL,
		+1, +3, },
	{ MNSTR_KIND_WIGHT,
		+1, +3, },
	{ MNSTR_KIND_FLESH_GOLEM,
		+1, +3, },
	{ MNSTR_KIND_SUCCUBUS,
		+1, +3, },
	{ MNSTR_KIND_MANTICORE,
		+1, +3, },
	{ MNSTR_KIND_WILL_O_WISP,
		+1, +3, },
	{ MNSTR_KIND_GAS_CLOUD,
		+1, +3, },
	{ MNSTR_KIND_SHADE,
		+1, +3, },
	{ MNSTR_KIND_CHIMERA,
		+1, +3, },
	{ MNSTR_KIND_FIRE_GIANT,
		+1, +3, },
	{ MNSTR_KIND_MUMMY,
		+1, +3, },
	{ MNSTR_KIND_FROST_GIANT,
		+1, +3, },
	{ MNSTR_KIND_GARGOYLE,
		+1, +3, },
	{ MNSTR_KIND_STONE_GOLEM,
		+1, +3, },
	{ MNSTR_KIND_DURAHAN,
		+1, +3, },
	{ MNSTR_KIND_IRON_GOLEM,
		+1, +3, },
	{ MNSTR_KIND_SALAMANDER,
		+1, +3, },
	{ MNSTR_KIND_CYCLOPS,
		+1, +3, },
	{ MNSTR_KIND_UNDINE,
		+1, +3, },
	{ MNSTR_KIND_BANSHEE,
		+1, +3, },
	{ MNSTR_KIND_GNOME,
		+1, +3, },
	{ MNSTR_KIND_SYLPH,
		+1, +3, },
	{ MNSTR_KIND_WRAITH,
		+1, +3, },
	{ MNSTR_KIND_MIMIC,
		+1, +3, },
	{ MNSTR_KIND_VAMPIRE,
		+1, +3, },
	{ MNSTR_KIND_NULL,
		+0, +0, },
};

/******************************************************************/

#if	0
typedef struct {
	/* 󥹥μ */
	mnstr_kind_t	mnstr_kind;

	/* 󥹥̾ */
	char	*name;
	n_msg_t	name_n;

	/* ʿѤο */
	long	group;

	/* ̤ɽ */
	char	face_mjr, face_mnr;

	/* ưŪ˷׻иͤν */
	rate_t	exp;

	/* ݤȤɤγ */
	rate_t	gold_rate;

	/* ׹ͥ롼 */
	void	(*func)( struct chr_t *p );

	/* ١ȿ */
	attitude_t	attitude;

	/* ǽ */
	rate_t	abl_lev_rate[ABL_KIND_MAX_N];

	/*  */
	rate_t	resi[RESI_KIND_MAX_N];

	/* ˡ */
	attack_t	attack[CHR_ATACK_MAX_N + 1];

	/* ɸξꤵƥޡ饹 */
	rate_t	def, armor_crtcl, ac;

	/* ư */
	move_t	move;

	/* ¾üưΥե饰 */
	flg_chr_t	flg_chr;

	/* ޥå(dun->map.chr.flg[y][x])˽񤯥ե饰 */
	flg_map_t	flg_map;
} mnstr_tab_t;

typedef struct {
	attack_kind_t	kind;
	ratio_t	ratio;
	bool_t	flg_throw, flg_monk;
	rate_t	hit, crtcl, dam;
	resi_kind_t	resi_kind;
	fx_kind_t	fx_kind;
	long	fx_turn;
	spell_kind_t	spell;
	extent_kind_t	extent;
	n_msg_t	spell_fmt;
} attack_t;
#endif

/* HP  MP  */
/* DEX STR AGI */
/* WIS INT CHA */
/* FIG MON HUN THI */
/* MAG SOR ENC SUM */
/* PRI SHA BAR NIN */

/* KNOC SLAS STIN */
/* HEAT COLD ACID WIND */
/* ELEC POIS */

mnstr_tab_t	mnstr_tab[] = {
/*  */
/* ɥ饴 */
/*  */
/*  */
	{ MNSTR_KIND_LEPRECHAUN, NULL,
		N_MSG_MNSTR_LEPRECHAUN,
		1,
		FACE_MJR_MNSTR_FAIRY,
		FACE_MNR_MNSTR_LEPRECHAUN,
		(rate_t)+0, (rate_t)200,
		set_act_mnstr_leprechaun,
		ATTITUDE_HOSTILE,
		{
			 50, 100,
			100, 100, 100,
			100, 100, 100,
			100, 100, 100, 100,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_SLASH, 4, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)50,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)50, (rate_t)50, (rate_t)50,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT
			| FLG_CHR_CAN_OPEN_DOOR
			| FLG_CHR_AVOID_TRAP),
		FLG_NULL,
	},
/*  */
	{ MNSTR_KIND_FIRE_ELEMENTAL, NULL,
		N_MSG_MNSTR_FIRE_ELEMENTAL,
		1,
		FACE_MJR_MNSTR_ELEMENTAL,
		FACE_MNR_MNSTR_FIRE_ELEMENTAL,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			100, 100, 100,
			  0, 100,   0,   0,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			999,  50, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_TACKLE, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_HEAT,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_SALAMANDER, NULL,
		N_MSG_MNSTR_SALAMANDER,
		1,
		FACE_MJR_MNSTR_ELEMENTAL,
		FACE_MNR_MNSTR_SALAMANDER,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 300,
			100, 100, 100,
			100, 100, 100,
			  0, 100,   0,   0,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			999,  50, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_HEAT,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_KICK, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_HEAT,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_HEAT,
				FX_KIND_NULL, 0,
				SPELL_KIND_FIRE_BALL,
				EXTENT_KIND_SPREAD,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_HEAT,
				FX_KIND_NULL, 0,
				SPELL_KIND_FIRE_BALL,
				EXTENT_KIND_MASS,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)80, (rate_t)80, (rate_t)80,
		{
			{ (rate_t)0, (rate_t)100, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_CAN_BREAK_DOOR
			| FLG_CHR_MAGIC_PROTECT
			| FLG_CHR_AVOID_TRAP),
		FLG_NULL,
	},

	{ MNSTR_KIND_WATER_ELEMENTAL, NULL,
		N_MSG_MNSTR_WATER_ELEMENTAL,
		1,
		FACE_MJR_MNSTR_ELEMENTAL,
		FACE_MNR_MNSTR_WATER_ELEMENTAL,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			100, 100, 100,
			  0, 100,   0,   0,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50, 999, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_TACKLE, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_COLD,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_UNDINE, NULL,
		N_MSG_MNSTR_UNDINE,
		1,
		FACE_MJR_MNSTR_ELEMENTAL,
		FACE_MNR_MNSTR_UNDINE,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 300,
			100, 100, 100,
			100, 100, 100,
			  0, 100,   0,   0,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50, 999, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_COLD,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_KICK, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_COLD,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_COLD,
				FX_KIND_NULL, 0,
				SPELL_KIND_ICE_BLIZZARD,
				EXTENT_KIND_SPREAD,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_COLD,
				FX_KIND_NULL, 0,
				SPELL_KIND_ICE_BLIZZARD,
				EXTENT_KIND_MASS,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)80, (rate_t)80, (rate_t)80,
		{
			{ (rate_t)0, (rate_t)100, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_CAN_BREAK_DOOR
			| FLG_CHR_MAGIC_PROTECT
			| FLG_CHR_AVOID_TRAP),
		FLG_NULL,
	},

	{ MNSTR_KIND_EARTH_ELEMENTAL, NULL,
		N_MSG_MNSTR_EARTH_ELEMENTAL,
		1,
		FACE_MJR_MNSTR_ELEMENTAL,
		FACE_MNR_MNSTR_EARTH_ELEMENTAL,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			100, 100, 100,
			  0, 100,   0,   0,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 999,  50,
			100, 100,
		},
		{
			{ ATTACK_KIND_TACKLE, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_ACID,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_GNOME, NULL,
		N_MSG_MNSTR_GNOME,
		1,
		FACE_MJR_MNSTR_ELEMENTAL,
		FACE_MNR_MNSTR_GNOME,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 300,
			100, 100, 100,
			100, 100, 100,
			  0, 100,   0,   0,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 999,  50,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_ACID,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_KICK, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_ACID,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_ACID,
				FX_KIND_NULL, 0,
				SPELL_KIND_ACID_RAIN,
				EXTENT_KIND_SPREAD,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_ACID,
				FX_KIND_NULL, 0,
				SPELL_KIND_ACID_RAIN,
				EXTENT_KIND_MASS,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)80, (rate_t)80, (rate_t)80,
		{
			{ (rate_t)0, (rate_t)100, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_CAN_BREAK_DOOR
			| FLG_CHR_MAGIC_PROTECT
			| FLG_CHR_AVOID_TRAP),
		FLG_NULL,
	},

	{ MNSTR_KIND_AIR_ELEMENTAL, NULL,
		N_MSG_MNSTR_AIR_ELEMENTAL,
		1,
		FACE_MJR_MNSTR_ELEMENTAL,
		FACE_MNR_MNSTR_AIR_ELEMENTAL,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			100, 100, 100,
			  0, 100,   0,   0,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100,  50, 999,
			100, 100,
		},
		{
			{ ATTACK_KIND_TACKLE, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_SYLPH, NULL,
		N_MSG_MNSTR_SYLPH,
		1,
		FACE_MJR_MNSTR_ELEMENTAL,
		FACE_MNR_MNSTR_SYLPH,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 300,
			100, 100, 100,
			100, 100, 100,
			  0, 100,   0,   0,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100,  50, 999,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_KICK, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_MIND_STORM,
				EXTENT_KIND_SPREAD,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_MIND_STORM,
				EXTENT_KIND_MASS,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)80, (rate_t)80, (rate_t)80,
		{
			{ (rate_t)0, (rate_t)100, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_CAN_BREAK_DOOR
			| FLG_CHR_MAGIC_PROTECT
			| FLG_CHR_AVOID_TRAP),
		FLG_NULL,
	},

	{ MNSTR_KIND_WILL_O_WISP, NULL,
		N_MSG_MNSTR_WILL_O_WISP,
		1,
		FACE_MJR_MNSTR_ELEMENTAL,
		FACE_MNR_MNSTR_WILL_O_WISP,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			100, 100, 100,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			999,  50,
		},
		{
			{ ATTACK_KIND_TACKLE, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_ELEC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 0 },
					{ MOVE_KIND_STAGGER, 1 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT | FLG_CHR_MAGIC_PROTECT),
		FLG_NULL,
	},

	{ MNSTR_KIND_SHADE, NULL,
		N_MSG_MNSTR_SHADE,
		1,
		FACE_MJR_MNSTR_ELEMENTAL,
		FACE_MNR_MNSTR_SHADE,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			100, 100, 100,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			 50, 999,
		},
		{
			{ ATTACK_KIND_TACKLE, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_POIS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 0 },
					{ MOVE_KIND_STAGGER, 1 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_DARK | FLG_CHR_MAGIC_PROTECT),
		FLG_NULL,
	},
/* ʪ */
	{ MNSTR_KIND_VENUS_FLY_TRAP, NULL,
		N_MSG_MNSTR_VENUS_FLY_TRAP,
		1,
		FACE_MJR_MNSTR_PLANT,
		FACE_MNR_MNSTR_VENUS_FLY_TRAP,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_venus_fly_trap,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			 80,  80,  80,
			 10,  10,  10,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 30, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_STRANGLE, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)30, (rate_t)50,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)0, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 0 },
					{ MOVE_KIND_STOP, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STOP, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_SLIME, NULL,
		N_MSG_MNSTR_SLIME,
		2,
		FACE_MJR_MNSTR_PLANT,
		FACE_MNR_MNSTR_SLIME,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_slime,
		ATTITUDE_HOSTILE,
		{
			 50,  50,
			 50, 100,  50,
			 10,  10,  10,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			999, 999, 999,
			 30, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_TOUCH, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)100,
				RESI_KIND_ACID,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)30, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 7 },
					{ MOVE_KIND_STAGGER, 3 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_MAP_CHR_INVISIBLE,
	},

	{ MNSTR_KIND_SPORE, NULL,
		N_MSG_MNSTR_SPORE,
		1,
		FACE_MJR_MNSTR_PLANT,
		FACE_MNR_MNSTR_SPORE,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_spore,
		ATTITUDE_HOSTILE,
		{
			 50, 100,
			 50,  50,  50,
			 10,  10,  10,
			  0,   0,   0,   0,
			  0, 200,   0,   0,
			  0,   0,   0,   0,
		},
		{
			999, 999, 999,
			 30, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_MAGIC_MISSILE,
				EXTENT_KIND_SPREAD,
				N_MSG_FMT_SPELL_SPORE, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)0, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 0 },
					{ MOVE_KIND_STOP, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STOP, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},
/* ưʪ */
	{ MNSTR_KIND_GIANT_BAT, NULL,
		N_MSG_MNSTR_GIANT_BAT,
		4,
		FACE_MJR_MNSTR_ANIMAL,
		FACE_MNR_MNSTR_BAT,
		(rate_t)-20, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			 30,  30, 100,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 2 },
					{ MOVE_KIND_STAGGER, 8 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_GIANT_RAT, NULL,
		N_MSG_MNSTR_GIANT_RAT,
		4,
		FACE_MJR_MNSTR_ANIMAL,
		FACE_MNR_MNSTR_RAT,
		(rate_t)-50, (rate_t)0,
		set_act_mnstr_giant_rat,
		ATTITUDE_NEUTRAL,
		{
			 50, 100,
			100, 100, 100,
			 30,  30, 100,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 4 },
					{ MOVE_KIND_STAGGER, 6 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_GIANT_SNAKE, NULL,
		N_MSG_MNSTR_GIANT_SNAKE,
		1,
		FACE_MJR_MNSTR_ANIMAL,
		FACE_MNR_MNSTR_SNAKE,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			200, 100,
			100, 200, 100,
			 30,  30, 100,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50,  80, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 8 },
					{ MOVE_KIND_STAGGER, 2 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_VIPER_SNAKE, NULL,
		N_MSG_MNSTR_VIPER_SNAKE,
		1,
		FACE_MJR_MNSTR_ANIMAL,
		FACE_MNR_MNSTR_SNAKE,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			 30,  30, 100,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50,  80, 100, 100,
			100, 200,
		},
		{
			{ ATTACK_KIND_BITE, 2, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)30,
				RESI_KIND_POIS,
				FX_KIND_POISON, FX_TURN_INFINITE_N,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 8 },
					{ MOVE_KIND_STAGGER, 2 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_CAT, NULL,
		N_MSG_MNSTR_CAT,
		1,
		FACE_MJR_MNSTR_ANIMAL,
		FACE_MNR_MNSTR_CAT,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_FRIENDLY,
		{
			 50,  50,
			100, 100, 120,
			 50,  50, 100,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)70, (rate_t)50, (rate_t)50,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_CLAW, 1, FALSE, FALSE,
				(rate_t)70, (rate_t)50, (rate_t)50,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)100, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 9 },
					{ MOVE_KIND_STAGGER, 1 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_DOG, NULL,
		N_MSG_MNSTR_DOG,
		1,
		FACE_MJR_MNSTR_ANIMAL,
		FACE_MNR_MNSTR_DOG,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_FRIENDLY,
		{
			 50,  50,
			100, 120, 100,
			 50,  50,  80,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)60,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_CLAW, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)60,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)100, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 9 },
					{ MOVE_KIND_STAGGER, 1 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_WOLF, NULL,
		N_MSG_MNSTR_WOLF,
		1,
		FACE_MJR_MNSTR_ANIMAL,
		FACE_MNR_MNSTR_WOLF,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_NEUTRAL,
		{
			 50,  50,
			120, 120, 100,
			 50,  50,  80,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)70, (rate_t)50, (rate_t)60,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_CLAW, 1, FALSE, FALSE,
				(rate_t)70, (rate_t)50, (rate_t)60,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)100, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 9 },
					{ MOVE_KIND_STAGGER, 1 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_PYON_PYON, NULL,
		N_MSG_MNSTR_PYON_PYON,
		1,
		FACE_MJR_MNSTR_ANIMAL,
		FACE_MNR_MNSTR_PYON_PYON,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_FRIENDLY,
		{
			 50, 200,
			 80,  80, 150,
			 50,  50, 100,
			  0,  80,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_BITE, 5, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)50,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)50,
				RESI_KIND_ELEC,
				FX_KIND_NULL, 0,
				SPELL_KIND_LIGHTNING_BOLT,
				EXTENT_KIND_NORMAL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)100, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 9 },
					{ MOVE_KIND_STAGGER, 1 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},
/*  */
	{ MNSTR_KIND_GIANT_CENTIPEDE, NULL,
		N_MSG_MNSTR_GIANT_CENTIPEDE,
		4,
		FACE_MJR_MNSTR_INSECT,
		FACE_MNR_MNSTR_CENTIPEDE,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			 30,  30,  30,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50,  50, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 5 },
					{ MOVE_KIND_STAGGER, 5 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_GIANT_BEE, NULL,
		N_MSG_MNSTR_GIANT_BEE,
		2,
		FACE_MJR_MNSTR_INSECT,
		FACE_MNR_MNSTR_BEE,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 150,
			 30,  30,  30,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50,  50, 100, 100,
			100, 200,
		},
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_POIS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 7 },
					{ MOVE_KIND_STAGGER, 3 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_GIANT_SCORPION, NULL,
		N_MSG_MNSTR_GIANT_SCORPION,
		1,
		FACE_MJR_MNSTR_INSECT,
		FACE_MNR_MNSTR_SCORPION,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 150,
			 30,  30,  30,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50,  50, 100, 100,
			100, 200,
		},
		{
			{ ATTACK_KIND_NIP, 2, FALSE, FALSE,
				(rate_t)50, (rate_t)30, (rate_t)50,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)30, (rate_t)50,
				RESI_KIND_POIS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 7 },
					{ MOVE_KIND_STAGGER, 3 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_GIANT_ANT, NULL,
		N_MSG_MNSTR_GIANT_ANT,
		4,
		FACE_MJR_MNSTR_INSECT,
		FACE_MNR_MNSTR_ANT,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 150,
			 30,  30,  30,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50,  50, 200, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_ACID,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 5 },
					{ MOVE_KIND_STAGGER, 5 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_GIANT_SPIDER, NULL,
		N_MSG_MNSTR_GIANT_SPIDER,
		1,
		FACE_MJR_MNSTR_INSECT,
		FACE_MNR_MNSTR_SPIDER,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_giant_spider,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 150,
			 30,  30,  30,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50,  50, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)30, (rate_t)50,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 7 },
					{ MOVE_KIND_STAGGER, 3 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_ACID_FLY, NULL,
		N_MSG_MNSTR_ACID_FLY,
		1,
		FACE_MJR_MNSTR_INSECT,
		FACE_MNR_MNSTR_FLY,
		(rate_t)-80, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_NEUTRAL,
		{
			100, 500,
			100, 100, 150,
			 30,  30,  30,
			  0, 100,   0,   0,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50,  50, 200, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_ACID,
				FX_KIND_NULL, 0,
				SPELL_KIND_ACID_RAIN,
				EXTENT_KIND_NORMAL,
				N_MSG_FMT_SPELL_ACID, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 2 },
					{ MOVE_KIND_STAGGER, 8 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_GIANT_BEETLE, NULL,
		N_MSG_MNSTR_GIANT_BEETLE,
		1,
		FACE_MJR_MNSTR_INSECT,
		FACE_MNR_MNSTR_BEETLE,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			200, 100,
			100, 200, 150,
			 30,  30,  30,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50,  50, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)30, (rate_t)50,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_TACKLE, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)30, (rate_t)50,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 8 },
					{ MOVE_KIND_STAGGER, 2 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},
/* ʹ */
	{ MNSTR_KIND_FIGHTER, NULL,
		N_MSG_MNSTR_FIGHTER,
		1,
		FACE_MJR_MNSTR_HUMAN,
		FACE_MNR_MNSTR_FIGHTER,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_towner,
		ATTITUDE_NEUTRAL,
		{
			100,   0,
			100, 100, 100,
			  0,   0,   0,
			100,   0,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_SLASH, 4, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)80, (rate_t)80, (rate_t)80,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_TOWNER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT | FLG_CHR_CAN_OPEN_DOOR),
		FLG_NULL,
	},

	{ MNSTR_KIND_MONK, NULL,
		N_MSG_MNSTR_MONK,
		1,
		FACE_MJR_MNSTR_HUMAN,
		FACE_MNR_MNSTR_MONK,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_towner,
		ATTITUDE_NEUTRAL,
		{
			100,   0,
			100, 100, 100,
			  0,   0,   0,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 4, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_KICK, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)80, (rate_t)80, (rate_t)80,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_TOWNER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT | FLG_CHR_CAN_OPEN_DOOR),
		FLG_NULL,
	},

	{ MNSTR_KIND_HUNTER, NULL,
		N_MSG_MNSTR_HUNTER,
		1,
		FACE_MJR_MNSTR_HUMAN,
		FACE_MNR_MNSTR_HUNTER,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_towner,
		ATTITUDE_NEUTRAL,
		{
			 75,   0,
			100, 100,  75,
			  0,   0,   0,
			 50,   0, 100,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_THROW, 4, TRUE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)60, (rate_t)60, (rate_t)60,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_TOWNER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT | FLG_CHR_CAN_OPEN_DOOR),
		FLG_NULL,
	},

	{ MNSTR_KIND_THIEF, NULL,
		N_MSG_MNSTR_THIEF,
		1,
		FACE_MJR_MNSTR_HUMAN,
		FACE_MNR_MNSTR_THIEF,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_towner,
		ATTITUDE_NEUTRAL,
		{
			 75,   0,
			100,  50, 100,
			  0,   0,   0,
			 75,   0,   0, 100,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_SLASH, 4, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)50,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)50,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)50, (rate_t)50, (rate_t)50,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_TOWNER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT | FLG_CHR_CAN_OPEN_DOOR),
		FLG_NULL,
	},

	{ MNSTR_KIND_WIZARD, NULL,
		N_MSG_MNSTR_WIZARD,
		1,
		FACE_MJR_MNSTR_HUMAN,
		FACE_MNR_MNSTR_WIZARD,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_towner,
		ATTITUDE_NEUTRAL,
		{
			 50, 100,
			  0,   0,   0,
			  0, 100,   0,
			  0,   0,   0,   0,
			100,  75,  75,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_HEAT,
				FX_KIND_NULL, 0,
				SPELL_KIND_FIRE_BALL,
				EXTENT_KIND_MASS,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_COLD,
				FX_KIND_NULL, 0,
				SPELL_KIND_ICE_BLIZZARD,
				EXTENT_KIND_MASS,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_TOWNER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT | FLG_CHR_CAN_OPEN_DOOR),
		FLG_NULL,
	},

	{ MNSTR_KIND_SUMMONER, NULL,
		N_MSG_MNSTR_SUMMONER,
		1,
		FACE_MJR_MNSTR_HUMAN,
		FACE_MNR_MNSTR_SUMMONER,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_towner,
		ATTITUDE_NEUTRAL,
		{
			 75, 100,
			  0,   0,  25,
			  0, 100,   0,
			100,   0,   0,   0,
			  0,   0,   0, 100,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_HEAT,
				FX_KIND_NULL, 0,
				SPELL_KIND_FIRE_BALL,	/*@@@*/
				EXTENT_KIND_MASS,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_COLD,
				FX_KIND_NULL, 0,
				SPELL_KIND_ICE_BLIZZARD,	/*@@@*/
				EXTENT_KIND_MASS,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)80, (rate_t)80, (rate_t)80,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_TOWNER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT | FLG_CHR_CAN_OPEN_DOOR),
		FLG_NULL,
	},

	{ MNSTR_KIND_PRIEST, NULL,
		N_MSG_MNSTR_PRIEST,
		1,
		FACE_MJR_MNSTR_HUMAN,
		FACE_MNR_MNSTR_PRIEST,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_towner,
		ATTITUDE_NEUTRAL,
		{
			100, 100,
			  0,   0,   0,
			100,   0,   0,
			100,   0,   0,   0,
			  0,   0,   0,   0,
			100,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_KNOCK, 4, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)50,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_ELEC,
				FX_KIND_NULL, 0,
				SPELL_KIND_CURE_HP_MODERATE,	/*@@@*/
				EXTENT_KIND_NORMAL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)60, (rate_t)60, (rate_t)60,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_TOWNER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT | FLG_CHR_CAN_OPEN_DOOR),
		FLG_NULL,
	},

	{ MNSTR_KIND_FARMER, NULL,
		N_MSG_MNSTR_FARMER,
		1,
		FACE_MJR_MNSTR_HUMAN,
		FACE_MNR_MNSTR_FARMER,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_towner,
		ATTITUDE_NEUTRAL,
		{
			 50,   0,
			  0,   0,   0,
			 50,   0,  50,
			 10,  10,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 4, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_KICK, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_TOWNER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT | FLG_CHR_CAN_OPEN_DOOR),
		FLG_NULL,
	},

	{ MNSTR_KIND_CRAFTSMAN, NULL,
		N_MSG_MNSTR_CRAFTSMAN,
		1,
		FACE_MJR_MNSTR_HUMAN,
		FACE_MNR_MNSTR_CRAFTSMAN,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_towner,
		ATTITUDE_NEUTRAL,
		{
			 50,   0,
			  0,   0,   0,
			 50,   0,  50,
			 10,  10,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 4, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_KICK, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_TOWNER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT | FLG_CHR_CAN_OPEN_DOOR),
		FLG_NULL,
	},

	{ MNSTR_KIND_MERCHANT, NULL,
		N_MSG_MNSTR_MERCHANT,
		1,
		FACE_MJR_MNSTR_HUMAN,
		FACE_MNR_MNSTR_MERCHANT,
		(rate_t)+0, (rate_t)500,
		set_act_mnstr_towner,
		ATTITUDE_NEUTRAL,
		{
			 50,   0,
			  0,   0,   0,
			 50,   0,  50,
			 10,  10,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 4, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_KICK, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_TOWNER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT | FLG_CHR_CAN_OPEN_DOOR),
		FLG_NULL,
	},
/* Ⱦ */
/*  */
	{ MNSTR_KIND_YETI, NULL,
		N_MSG_MNSTR_YETI,
		1,
		FACE_MJR_MNSTR_GIANT,
		FACE_MNR_MNSTR_YETI,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			200, 100,
			100, 150, 100,
			 50,  50,  50,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 30, 500, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_KICK, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_CHR_CAN_OPEN_DOOR,
		FLG_NULL,
	},

	{ MNSTR_KIND_OGRE, NULL,
		N_MSG_MNSTR_OGRE,
		3,
		FACE_MJR_MNSTR_GIANT,
		FACE_MNR_MNSTR_OGRE,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			200, 100,
			100, 150, 100,
			 50,  50,  50,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_SLASH, 4, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)50,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_CHR_CAN_OPEN_DOOR,
		FLG_NULL,
	},

	{ MNSTR_KIND_TROLL, NULL,
		N_MSG_MNSTR_TROLL,
		1,
		FACE_MJR_MNSTR_GIANT,
		FACE_MNR_MNSTR_TROLL,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			200, 100,
			100, 200, 100,
			 50,  50,  50,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 200, 200,
			 50, 100,  50, 100,
			 50, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)30, (rate_t)100,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_KICK, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)30, (rate_t)150,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_CHR_CAN_BREAK_DOOR,
		FLG_NULL,
	},

	{ MNSTR_KIND_FIRE_GIANT, NULL,
		N_MSG_MNSTR_FIRE_GIANT,
		1,
		FACE_MJR_MNSTR_GIANT,
		FACE_MNR_MNSTR_FIRE_GIANT,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			200, 100,
			100, 200, 100,
			 50,  50,  50,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			999,  50, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)30, (rate_t)100,
				RESI_KIND_HEAT,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_KICK, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)30, (rate_t)150,
				RESI_KIND_HEAT,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_CHR_CAN_BREAK_DOOR,
		FLG_NULL,
	},

	{ MNSTR_KIND_FROST_GIANT, NULL,
		N_MSG_MNSTR_FROST_GIANT,
		1,
		FACE_MJR_MNSTR_GIANT,
		FACE_MNR_MNSTR_FROST_GIANT,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			200, 100,
			100, 200, 100,
			 50,  50,  50,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50, 999, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)30, (rate_t)100,
				RESI_KIND_COLD,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_KICK, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)30, (rate_t)150,
				RESI_KIND_COLD,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_CHR_CAN_BREAK_DOOR,
		FLG_NULL,
	},

	{ MNSTR_KIND_CYCLOPS, NULL,
		N_MSG_MNSTR_CYCLOPS,
		1,
		FACE_MJR_MNSTR_GIANT,
		FACE_MNR_MNSTR_CYCLOPS,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			300, 100,
			100, 200, 100,
			 50,  50,  50,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_KICK, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_CHR_CAN_BREAK_DOOR,
		FLG_NULL,
	},
/* ʪ */
/* ʪ */
/* ˡʪ */
	{ MNSTR_KIND_INVISIBLE_STALKER, NULL,
		N_MSG_MNSTR_INVISIBLE_STALKER,
		1,
		FACE_MJR_MNSTR_MAGICAL,
		FACE_MNR_MNSTR_INVISIBLE_STALKER,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			100, 100, 100,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_CLAW, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_CHR_CAN_OPEN_DOOR,
		FLG_MAP_CHR_INVISIBLE,
	},

	{ MNSTR_KIND_GARGOYLE, NULL,
		N_MSG_MNSTR_GARGOYLE,
		1,
		FACE_MJR_MNSTR_MAGICAL,
		FACE_MNR_MNSTR_GARGOYLE,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_gargoyle,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			100, 100,  30,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 200, 200,
			100, 100, 100, 300,
			100, 100,
		},
		{
			{ ATTACK_KIND_CLAW, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)100,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_CAN_OPEN_DOOR | FLG_CHR_AVOID_TRAP),
		FLG_MAP_CHR_INVISIBLE,
	},

	{ MNSTR_KIND_MIMIC, NULL,
		N_MSG_MNSTR_MIMIC,
		1,
		FACE_MJR_MNSTR_MAGICAL,
		FACE_MNR_MNSTR_MIMIC,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_mimic,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			100, 100,  30,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)0, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STOP, 1 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_MAP_CHR_INVISIBLE,
	},

	{ MNSTR_KIND_WOOD_GOLEM, NULL,
		N_MSG_MNSTR_WOOD_GOLEM,
		1,
		FACE_MJR_MNSTR_MAGICAL,
		FACE_MNR_MNSTR_WOOD_GOLEM,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			200, 100,
			100, 150,  50,
			 30,  30,  30,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50, 100, 100, 300,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)50, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_CHR_CAN_BREAK_DOOR,
		FLG_NULL,
	},

	{ MNSTR_KIND_BONE_GOLEM, NULL,
		N_MSG_MNSTR_BONE_GOLEM,
		1,
		FACE_MJR_MNSTR_MAGICAL,
		FACE_MNR_MNSTR_BONE_GOLEM,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			200, 100,
			100, 150,  50,
			 30,  30,  30,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			 50, 150, 150,
			100, 100, 100, 300,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)50, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_CHR_CAN_BREAK_DOOR,
		FLG_NULL,
	},

	{ MNSTR_KIND_FLESH_GOLEM, NULL,
		N_MSG_MNSTR_FLESH_GOLEM,
		1,
		FACE_MJR_MNSTR_MAGICAL,
		FACE_MNR_MNSTR_FLESH_GOLEM,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			200, 100,
			100, 150,  50,
			 30,  30,  30,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 300,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)50, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_CHR_CAN_BREAK_DOOR,
		FLG_NULL,
	},

	{ MNSTR_KIND_STONE_GOLEM, NULL,
		N_MSG_MNSTR_STONE_GOLEM,
		1,
		FACE_MJR_MNSTR_MAGICAL,
		FACE_MNR_MNSTR_STONE_GOLEM,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			200, 100,
			100, 150,  50,
			 30,  30,  30,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 150, 150,
			100, 100, 100, 300,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)150,
		{
			{ (rate_t)0, (rate_t)50, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_CHR_CAN_BREAK_DOOR,
		FLG_NULL,
	},

	{ MNSTR_KIND_IRON_GOLEM, NULL,
		N_MSG_MNSTR_IRON_GOLEM,
		1,
		FACE_MJR_MNSTR_MAGICAL,
		FACE_MNR_MNSTR_IRON_GOLEM,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			200, 100,
			100, 150,  50,
			 30,  30,  30,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			150, 150, 150,
			100, 100, 100, 300,
			100, 100,
		},
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)200,
		{
			{ (rate_t)0, (rate_t)50, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_CHR_CAN_BREAK_DOOR,
		FLG_NULL,
	},

	{ MNSTR_KIND_GAS_CLOUD, NULL,
		N_MSG_MNSTR_GAS_CLOUD,
		1,
		FACE_MJR_MNSTR_MAGICAL,
		FACE_MNR_MNSTR_GAS_CLOUD,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			 30,  30,  30,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			200, 200, 200,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_TOUCH, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_ACID,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)50, (rate_t)50, (rate_t)50,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_CHR_MAGIC_PROTECT,
		FLG_NULL,
	},
/*  */
	{ MNSTR_KIND_HIPPOGRIFF, NULL,
		N_MSG_MNSTR_HIPPOGRIFF,
		1,
		FACE_MJR_MNSTR_COMPOUND,
		FACE_MNR_MNSTR_HIPPOGRIFF,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			 80, 100,
			 80,  80, 100,
			 50,  50, 100,
			  0,  80,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_CLAW, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)150, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_GRIFFON, NULL,
		N_MSG_MNSTR_GRIFFON,
		1,
		FACE_MJR_MNSTR_COMPOUND,
		FACE_MNR_MNSTR_GRIFFON,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			 50,  50, 100,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 50, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_CLAW, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)150, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_MANTICORE, NULL,
		N_MSG_MNSTR_MANTICORE,
		1,
		FACE_MJR_MNSTR_COMPOUND,
		FACE_MNR_MNSTR_MANTICORE,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			120, 100,
			120, 120, 120,
			 30,  30,  30,
			  0, 120,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_CLAW, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_POIS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_CHIMERA, NULL,
		N_MSG_MNSTR_CHIMERA,
		1,
		FACE_MJR_MNSTR_COMPOUND,
		FACE_MNR_MNSTR_CHIMERA,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			120, 100,
			120, 120, 120,
			 30,  30,  30,
			  0, 120,   0,   0,
			  0, 100,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_CLAW, 2, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_POIS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_HEAT,
				FX_KIND_NULL, 0,
				SPELL_KIND_FIRE_BALL,
				EXTENT_KIND_NORMAL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},
/* ǥå */
	{ MNSTR_KIND_SKELETON, NULL,
		N_MSG_MNSTR_SKELETON,
		4,
		FACE_MJR_MNSTR_UNDEAD,
		FACE_MNR_MNSTR_SKELETON,
		(rate_t)-10, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			 80, 100,
			 80,  80,  80,
			 30,  30,  10,
			 80,  80,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 999,
			 30, 100,
		},
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)50,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 9 },
					{ MOVE_KIND_STAGGER, 1 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_ZOMBIE, NULL,
		N_MSG_MNSTR_ZOMBIE,
		4,
		FACE_MJR_MNSTR_UNDEAD,
		FACE_MNR_MNSTR_ZOMBIE,
		(rate_t)-10, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			 80, 100,
			 80,  80,  50,
			 30,  30,  10,
			  0,  80,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 999,
			 30, 100,
		},
		{
			{ ATTACK_KIND_CLAW, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_BITE, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)50, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 7 },
					{ MOVE_KIND_STAGGER, 3 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_GHOUL, NULL,
		N_MSG_MNSTR_GHOUL,
		4,
		FACE_MJR_MNSTR_UNDEAD,
		FACE_MNR_MNSTR_GHOUL,
		(rate_t)-10, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			 90, 100,
			 90,  90,  50,
			 40,  40,  10,
			  0,  80,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 999,
			 30, 100,
		},
		{
			{ ATTACK_KIND_CLAW, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_SLAS,
				FX_KIND_PARALYZE, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_BITE, 2, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)50, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 7 },
					{ MOVE_KIND_STAGGER, 3 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_GHOST, NULL,
		N_MSG_MNSTR_GHOST,
		1,
		FACE_MJR_MNSTR_UNDEAD,
		FACE_MNR_MNSTR_GHOST,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			 80,  80,  10,
			  0,  80,   0,   0,
			  0,   0, 100,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 999,
			 30, 100,
		},
		{
			{ ATTACK_KIND_TOUCH, 9, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_ENERGY_DRAIN,
				EXTENT_KIND_NORMAL,
				N_MSG_FMT_SPELL_ENERGY_DRAIN, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 7 },
					{ MOVE_KIND_STAGGER, 3 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_PASSWALL | FLG_CHR_MAGIC_PROTECT ),
		FLG_NULL,
	},

	{ MNSTR_KIND_WIGHT, NULL,
		N_MSG_MNSTR_WIGHT,
		1,
		FACE_MJR_MNSTR_UNDEAD,
		FACE_MNR_MNSTR_WIGHT,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			 80,  80,  10,
			  0,  80,   0,   0,
			  0,   0, 100,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 999,
			 30, 100,
		},
		{
			{ ATTACK_KIND_CLAW, 6, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_BITE, 2, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_ENERGY_DRAIN,
				EXTENT_KIND_NORMAL,
				N_MSG_FMT_SPELL_ENERGY_DRAIN, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)60, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 7 },
					{ MOVE_KIND_STAGGER, 3 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_CHR_MAGIC_PROTECT,
		FLG_NULL,
	},

	{ MNSTR_KIND_MUMMY, NULL,
		N_MSG_MNSTR_MUMMY,
		1,
		FACE_MJR_MNSTR_UNDEAD,
		FACE_MNR_MNSTR_MUMMY,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			100, 100,  10,
			  0, 100,   0,   0,
			  0,   0, 100,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			 30, 100, 100, 999,
			 30, 100,
		},
		{
			{ ATTACK_KIND_CLAW, 7, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_ENERGY_DRAIN,
				EXTENT_KIND_NORMAL,
				N_MSG_FMT_SPELL_ENERGY_DRAIN, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)60, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 8 },
					{ MOVE_KIND_STAGGER, 2 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_DURAHAN, NULL,
		N_MSG_MNSTR_DURAHAN,
		1,
		FACE_MJR_MNSTR_UNDEAD,
		FACE_MNR_MNSTR_DURAHAN,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			150, 100,
			150, 150, 150,
			100, 100,  10,
			150,   0,   0,   0,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 999,
			 30, 100,
		},
		{
			{ ATTACK_KIND_SLASH, 3, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_INDICATE, 1, FALSE, FALSE,
				(rate_t)80, (rate_t)80, (rate_t)80,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_CHR_MAGIC_PROTECT,
		FLG_NULL,
	},

	{ MNSTR_KIND_BANSHEE, NULL,
		N_MSG_MNSTR_BANSHEE,
		1,
		FACE_MJR_MNSTR_UNDEAD,
		FACE_MNR_MNSTR_BANSHEE,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			100, 100,  50,
			  0,  50,   0,   0,
			  0,   0, 100,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 999,
			 30, 100,
		},
		{
			{ ATTACK_KIND_TOUCH, 6, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_CONFUSION,
				EXTENT_KIND_MASS,
				N_MSG_FMT_SPELL_CRY, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_ENERGY_DRAIN,
				EXTENT_KIND_NORMAL,
				N_MSG_FMT_SPELL_ENERGY_DRAIN, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)60, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 5 },
					{ MOVE_KIND_STAGGER, 5 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_PASSWALL | FLG_CHR_MAGIC_PROTECT),
		FLG_NULL,
	},

	{ MNSTR_KIND_WRAITH, NULL,
		N_MSG_MNSTR_WRAITH,
		1,
		FACE_MJR_MNSTR_UNDEAD,
		FACE_MNR_MNSTR_WRAITH,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			100, 100,  10,
			  0, 100,   0,   0,
			  0,   0, 100,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 999,
			 30, 100,
		},
		{
			{ ATTACK_KIND_TOUCH, 6, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_ENERGY_DRAIN,
				EXTENT_KIND_SPREAD,
				N_MSG_FMT_SPELL_ENERGY_DRAIN, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)60, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 8 },
					{ MOVE_KIND_STAGGER, 2 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_PASSWALL | FLG_CHR_MAGIC_PROTECT),
		FLG_NULL,
	},

	{ MNSTR_KIND_VAMPIRE, NULL,
		N_MSG_MNSTR_VAMPIRE,
		1,
		FACE_MJR_MNSTR_UNDEAD,
		FACE_MNR_MNSTR_VAMPIRE,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_vampire,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			100, 100, 100,
			  0, 100,   0,   0,
			  0,   0, 100,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 999,
			 50, 100,
		},
		{
			{ ATTACK_KIND_CLAW, 3, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_BITE, 2, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_ENERGY_DRAIN,
				EXTENT_KIND_SPREAD,
				N_MSG_FMT_SPELL_ENERGY_DRAIN, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_PASSWALL | FLG_CHR_MAGIC_PROTECT),
		FLG_NULL,
	},
/*  */
	{ MNSTR_KIND_KOBOLD, NULL,
		N_MSG_MNSTR_KOBOLD,
		3,
		FACE_MJR_MNSTR_EVIL,
		FACE_MNR_MNSTR_KOBOLD,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			 80,  50,  50,
			100, 100, 100, 100,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_STING, 4, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)50,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)50,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)50, (rate_t)50, (rate_t)50,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT
			| FLG_CHR_CAN_OPEN_DOOR
			| FLG_CHR_AVOID_TRAP),
		FLG_NULL,
	},

	{ MNSTR_KIND_GOBLIN, NULL,
		N_MSG_MNSTR_GOBLIN,
		4,
		FACE_MJR_MNSTR_EVIL,
		FACE_MNR_MNSTR_GOBLIN,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			 80,  50,  50,
			100, 100, 100, 100,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_KNOCK, 4, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)50,
				RESI_KIND_KNOC,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_STING, 4, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)50,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)50, (rate_t)50, (rate_t)50,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT
			| FLG_CHR_CAN_OPEN_DOOR
			| FLG_CHR_AVOID_TRAP),
		FLG_NULL,
	},

	{ MNSTR_KIND_HOBGOBLIN, NULL,
		N_MSG_MNSTR_HOBGOBLIN,
		4,
		FACE_MJR_MNSTR_EVIL,
		FACE_MNR_MNSTR_HOBGOBLIN,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			 80,  50,  50,
			100, 100, 100, 100,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_SLASH, 4, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)50,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)50, (rate_t)50, (rate_t)50,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT
			| FLG_CHR_CAN_OPEN_DOOR
			| FLG_CHR_AVOID_TRAP),
		FLG_NULL,
	},

	{ MNSTR_KIND_ORK, NULL,
		N_MSG_MNSTR_ORK,
		3,
		FACE_MJR_MNSTR_EVIL,
		FACE_MNR_MNSTR_ORK,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 150, 100,
			 80,  50,  50,
			100, 100, 100, 100,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_SLASH, 4, FALSE, FALSE,
				(rate_t)80, (rate_t)100, (rate_t)80,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)50, (rate_t)50, (rate_t)50,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT
			| FLG_CHR_CAN_OPEN_DOOR
			| FLG_CHR_AVOID_TRAP),
		FLG_NULL,
	},

	{ MNSTR_KIND_GNOLL, NULL,
		N_MSG_MNSTR_GNOLL,
		3,
		FACE_MJR_MNSTR_EVIL,
		FACE_MNR_MNSTR_GNOLL,
		(rate_t)+0, (rate_t)100,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			 80,  50,  50,
			100, 100, 100, 100,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_SLASH, 4, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)50,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)50, (rate_t)50, (rate_t)50,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_LIGHT
			| FLG_CHR_CAN_OPEN_DOOR
			| FLG_CHR_AVOID_TRAP),
		FLG_NULL,
	},

	{ MNSTR_KIND_INCUBUS, NULL,
		N_MSG_MNSTR_INCUBUS,
		1,
		FACE_MJR_MNSTR_EVIL,
		FACE_MNR_MNSTR_INCUBUS,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_incubus,
		ATTITUDE_HOSTILE,
		{
			 80, 100,
			 80,  80,  80,
			 50, 100, 200,
			  0,  80,   0,   0,
			  0,   0, 100,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_KISS, 3, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)0,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_CARESS_BUST, 3, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)0,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_CARESS_HIP, 3, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)0,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_ENERGY_DRAIN,
				EXTENT_KIND_NORMAL,
				N_MSG_FMT_SPELL_ENERGY_DRAIN, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},

	{ MNSTR_KIND_SUCCUBUS, NULL,
		N_MSG_MNSTR_SUCCUBUS,
		1,
		FACE_MJR_MNSTR_EVIL,
		FACE_MNR_MNSTR_SUCCUBUS,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_succubus,
		ATTITUDE_HOSTILE,
		{
			 80, 100,
			 80,  80,  80,
			 50, 100, 200,
			  0,  80,   0,   0,
			  0,   0, 100,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_KISS, 3, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)0,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SEDUCE, 3, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)0,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_CARESS_CROTCH, 3, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)0,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_SPELL, 1, FALSE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_MIND,
				FX_KIND_NULL, 0,
				SPELL_KIND_ENERGY_DRAIN,
				EXTENT_KIND_NORMAL,
				N_MSG_FMT_SPELL_ENERGY_DRAIN, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)30, (rate_t)30, (rate_t)30,
		{
			{ (rate_t)0, (rate_t)80, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},
/*  */
/*  */
	{ MNSTR_KIND_IMP, NULL,
		N_MSG_MNSTR_IMP,
		4,
		FACE_MJR_MNSTR_DEVIL,
		FACE_MNR_MNSTR_IMP,
		(rate_t)+0, (rate_t)0,
		set_act_mnstr_std,
		ATTITUDE_HOSTILE,
		{
			100, 100,
			100, 100, 100,
			 80,  50,  50,
			100, 100, 100, 100,
			  0,   0,   0,   0,
			  0,   0,   0,   0,
		},
		{
			100, 100, 100,
			100, 100, 100, 100,
			100, 100,
		},
		{
			{ ATTACK_KIND_SLASH, 4, FALSE, FALSE,
				(rate_t)50, (rate_t)50, (rate_t)50,
				RESI_KIND_SLAS,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				(rate_t)30, (rate_t)30, (rate_t)30,
				RESI_KIND_STIN,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)50, (rate_t)50, (rate_t)50,
		{
			{ (rate_t)0, (rate_t)90, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_STD, 10 },
					{ MOVE_KIND_STAGGER, 0 },
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		(FLG_CHR_CAN_OPEN_DOOR | FLG_CHR_AVOID_TRAP),
		FLG_NULL,
	},
/**/
	{ MNSTR_KIND_NULL, NULL,
		N_MSG_MAX_N,
		0,
		FACE_MJR_NULL,
		FACE_MNR_NULL,
		(rate_t)+0, (rate_t)0,
		NULL,
		ATTITUDE_NEUTRAL,
		{
			0, 0,
			0, 0, 0,
			0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
			0, 0, 0, 0,
		},
		{
			0, 0, 0,
			0, 0, 0, 0,
			0, 0,
		},
		{
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				(rate_t)0, (rate_t)0, (rate_t)0,
				RESI_KIND_MAX_N,
				FX_KIND_NULL, 0,
				SPELL_KIND_NULL,
				EXTENT_KIND_NULL,
				N_MSG_NULL, },
		},
		(rate_t)0, (rate_t)0, (rate_t)0,
		{
			{ (rate_t)0, (rate_t)0, 0, },
			MOVE_KIND_NULL,
			{
				{
					{ MOVE_KIND_NULL, 0 },
				},
				{
					{ MOVE_KIND_STAGGER, 10 },
					{ MOVE_KIND_NULL, 0 },
				},
			},
		},
		FLG_NULL,
		FLG_NULL,
	},
};

/**/

typedef struct {
	mnstr_kind_t	kind;
	ratio_t	ratio;
} towner_tab_t;

towner_tab_t	towner_tab[] = {
	{ MNSTR_KIND_FIGHTER,
		1, },
	{ MNSTR_KIND_MONK,
		1, },
	{ MNSTR_KIND_HUNTER,
		1, },
	{ MNSTR_KIND_THIEF,
		1, },
	{ MNSTR_KIND_WIZARD,
		1, },
	{ MNSTR_KIND_SUMMONER,
		1, },
	{ MNSTR_KIND_PRIEST,
		1, },
	{ MNSTR_KIND_FARMER,
		5, },
	{ MNSTR_KIND_CRAFTSMAN,
		5, },
	{ MNSTR_KIND_MERCHANT,
		5, },
	{ MNSTR_KIND_NULL,
		0, },
};

#endif	/* MNSTR_TAB_H */
