/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: pet.c,v 1.10 2003/11/23 04:29:50 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
#include	"misc.h"
/*#include	"turn.h"*/
/*#include	"dun.h"*/
/*#include	"town.h"*/
#include	"item.h"
/*#include	"spell.h"*/
#include	"chr.h"
#include	"party.h"
#include	"mnstr.h"
#include	"pet.h"
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"misc_prot.h"
/*#include	"turn_prot.h"*/
/*#include	"dun_prot.h"*/
/*#include	"town_prot.h"*/
/*#include	"item_prot.h"*/
/*#include	"spell_prot.h"*/
#include	"chr_prot.h"
#include	"party_prot.h"
#include	"mnstr_prot.h"
#include	"pet_prot.h"
#include	"pet_prot.h"
/*#include	"fight_prot.h"*/
/*#include	"fx_prot.h"*/
/*#include	"trap_prot.h"*/
#include	"draw_prot.h"
/*#include	"curs_prot.h"*/
/*#include	"menu_prot.h"*/
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

static pet_t	*party_pet[PET_MAX_N];

static pet_t	*ls_pet[LS_PET_MAX_N + 1];
static pet_t	ls_pet_buf[LS_PET_MAX_N + 1];

/**/

void	init_pet( void )
{
	party_t	*pty = get_party();
	pet_t	*p;
	long	i;

	for( i = 0; i < LS_PET_MAX_N + 1; i++ )
		ls_pet[i] = &(ls_pet_buf[i]);

	for( i = 0; i < LS_PET_MAX_N + 1; i++ ){
		new_pet( ls_pet[i] );
		ls_pet[i]->stat = FLG_STAT_NOT_EXIST;
	}

	for( i = 0; i < PET_MAX_N; i++ )
		party_pet[i] = NULL;

	i = 0;
	p = make_pet( 10, MNSTR_KIND_PYON_PYON );
	if( p != NULL ){
		p->owner = pty->mbr[i];
		party_pet[i] = p;
	}
}

/**/

pet_t	*make_pet( long dun_lev, pet_kind_t pet_kind )
{
	long	i;
	pet_t	*p;

	p = NULL;
	for( i = 0; i < LS_PET_MAX_N; i++ ){
		if( chk_flg( ls_pet[i]->stat, FLG_STAT_NOT_EXIST ) ){
			p = ls_pet[i];
			break;
		}
	}
	if( p == NULL )
		return NULL;

	if( make_pet_alloc( p, dun_lev, pet_kind ) == NULL ){
		p->stat = FLG_STAT_NOT_EXIST;
		return NULL;
	}

	return p;
}

/**/

pet_t	*make_pet_alloc( pet_t *p, long dun_lev, pet_kind_t pet_kind )
{
	mnstr_t	*m;

	if( p == NULL )
		return NULL;

	new_pet( p );

	m = make_mnstr_alloc( p, MAP_DEL_X, MAP_DEL_Y, dun_lev, pet_kind );
	if( m == NULL )
		return NULL;

	p->flg_map |= FLG_MAP_CHR_NPC;
	p->attitude = ATTITUDE_MATE;
	p->owner = NULL;

	return p;
}

/**/

void	new_pet( pet_t *pet )
{
	new_mnstr( pet );
}

/**/

void	clr_map_all_pet( void )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ )
		clr_map_chr( party_pet[i] );
}

/**/

void	set_map_all_pet( void )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ )
		set_map_chr( party_pet[i] );
}

/**/

void	appear_all_pet( bool_t flg_clr_map )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ ){
		if( party_pet[i] == NULL )
			continue;
		if( chk_flg_or( party_pet[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		appear_pet( party_pet[i], flg_clr_map );
	}
}

/**/

void	appear_pet( pet_t *pet, bool_t flg_clr_map )
{
	long	r;
	long	i;
	bool_t	flg_break;

	if( pet == NULL )
		return;

	clr_chr_trgt_act( pet, FALSE );
	if( flg_clr_map )
		clr_map_chr( pet );

	pet->flg_map |= FLG_MAP_CHR_FIND;
	pet->x = randm( MAP_MAX_X );
	pet->y = randm( MAP_MAX_Y );

	if( pet->owner == NULL ){
		set_map_chr( pet );
		return;
	}

	flg_break = FALSE;
	for( r = 1; r < 128; i++ ){
		for( i = 0; i < 1024; i++ ){
			long	dx, dy;
			long	x, y;

			dx = randm( r * 2 + 1 ) - r;
			dy = randm( r * 2 + 1 ) - r;

			x = pet->owner->x + dx;
			y = pet->owner->y + dy;

			if( can_move_chr( pet, x, y ) ){
				pet->x = x;
				pet->y = y;
				flg_break = TRUE;
				break;
			}
		}
		if( flg_break )
			break;
	}

	set_map_chr( pet );
}

/**/

void	act_all_pet( void )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ ){
		pet_t	*pp;

		pp = party_pet[i];
		if( pp == NULL )
			continue;

		set_act_mnstr( pp );
		act_chr( pp );
		set_modifier( pp );
	}
}

/**/

void	set_act_pet_std( pet_t *p )
{
	if( p == NULL )
		return;

	pet_mark_std( p );

	if( (p->trgt.kind == TRGT_KIND_MNSTR)
			|| (p->trgt.kind == TRGT_KIND_MNSTR_NULL) ){
		mnstr_move_or_atack_std( p );
	}
}

/**/

mnstr_t	*pet_mark_std( pet_t *p )
{
	void	*trgt_p;
	mnstr_t	*mnstr_p;
	bool_t	flg_cp_mark;

	if( p == NULL )
		return NULL;

	clr_chr_trgt_act( p, TRUE );

	if( p->owner == NULL )
		return NULL;

	trgt_p = NULL;
	flg_cp_mark = FALSE;

	switch( p->owner->trgt.kind ){
	case TRGT_KIND_NULL:
		break;
	case TRGT_KIND_MBR:
		break;
	case TRGT_KIND_MNSTR:
	case TRGT_KIND_MNSTR_NULL:
		mnstr_p = (mnstr_t *)(p->owner->trgt.p);
		if( mnstr_p == NULL )
			break;
		if( mnstr_p->attitude != ATTITUDE_HOSTILE )
			break;
		flg_cp_mark = TRUE;
		break;
	case TRGT_KIND_ITEM:
		if( p->owner->trgt.dist != DIST_NEAR ){
			flg_cp_mark = TRUE;
			set_chr_act( p, ACT_KIND_ITEM_PICK_UP,
					NULL, NULL, 0, 0 );
		}
		break;
	case TRGT_KIND_DOOR:
	case TRGT_KIND_TRAP:
	case TRGT_KIND_QUEUE:
	case TRGT_KIND_SQUARE:
	case TRGT_KIND_POS:
	case TRGT_KIND_AUTO:
		break;
	case TRGT_KIND_MAX_N:
		break;
	}

	if( flg_cp_mark ){
		p->trgt = p->owner->trgt;
		p->trgt.dist = DIST_NEAR;
		trgt_p = p->trgt.p;
	}

	return trgt_p;
}

/**/

pet_t	**get_party_pet( void )
{
	return party_pet;
}

/**/

pet_t	**get_ls_pet( void )
{
	return ls_pet;
}

/**/

pet_t	*get_pet( long x, long y )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ ){
		pet_t	*pp;

		pp = party_pet[i];
		if( pp == NULL )
			continue;
		if( chk_flg_or( pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		if( (pp->x == x) && (pp->y == y) )
			return pp;
	}

	return NULL;
}

/**/

void	clr_pet_owner( pet_t *p )
{
	party_t	*pty = get_party();
	long	i;

	for( i = 0; i < MBR_MAX_N; i++ ){
		pet_t	*pp;

		pp = pty->mbr[i];
		if( chk_flg_or( pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		p->owner = pp;
		break;
	}
}

/**/

bool_t	chk_can_join_pet( pet_t *pet )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ ){
		if( party_pet[i] == pet )
			return FALSE;
	}

	return TRUE;
}

/**/

bool_t	chk_can_not_join_pet( pet_t *pet )
{
	long	i;

	for( i = 0; i < PET_MAX_N; i++ ){
		if( party_pet[i] == pet )
			return TRUE;
	}

	return FALSE;
}

/**/

bool_t	join_pet( pet_t *pet )
{
	long	i;

	if( !chk_can_join_pet( pet ) )
		return FALSE;

	for( i = 0; i < PET_MAX_N; i++ ){
		if( party_pet[i] != NULL )
			continue;

		party_pet[i] = pet;
		return TRUE;
	}

	return FALSE;
}

/**/

bool_t	not_join_pet( pet_t *pet )
{
	long	i;

	if( !chk_can_not_join_pet( pet ) )
		return FALSE;

	for( i = 0; i < PET_MAX_N; i++ ){
		if( party_pet[i] != pet )
			continue;

		party_pet[i] = NULL;
		return TRUE;
	}

	return FALSE;
}

/**/

