/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: tmenu_tab.h,v 1.11 2003/11/19 13:19:14 bowkenken Exp $
*****************************************************************/

#ifndef	TMENU_TAB_H
#define	TMENU_TAB_H

#include	"town.h"
#include	"menu.h"
#include	"tmenu_prot.h"

/**/

menu_t	ls_menu_shop[LS_MENU_SHOP_MAX_N + 1];

menu_t	ls_menu_temple[] = {
	{
		"/Temple",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_temple_init, NULL,
		FLG_NULL,
	},
	{
		"/Temple/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Temple/Remove curse",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_TEMPLE_REMOVE_CURSE, "",
		cb_menu_temple_remove_curse, NULL,
		FLG_NULL,
	},
	{
		"/Temple/Cure status",
		"<Item>",
		'S',
		"",
		N_MSG_MENU_TEMPLE_CURE_STATUS, "",
		cb_menu_temple_cure_status, NULL,
		FLG_NULL,
	},
	{
		"/Temple/Resurrection",
		"<Item>",
		'R',
		"",
		N_MSG_MENU_TEMPLE_RESURRECTION, "",
		cb_menu_temple_resurrection, NULL,
		FLG_NULL,
	},
	{
		"/Temple/Contribution",
		"<Item>",
		'O',
		"",
		N_MSG_MENU_TEMPLE_CONTRIBUTION, "",
		cb_menu_temple_contribution, NULL,
		FLG_NULL,
	},
	{
		"/Temple/Data",
		"<Item>",
		'D',
		"",
		N_MSG_MENU_SHOP_DATA, "",
		cb_menu_shop_data, NULL,
		FLG_NULL,
	},
	{
		"/Temple/Collect gold",
		"<Item>",
		'L',
		"",
		N_MSG_MENU_SHOP_COLLECT_GOLD, "",
		cb_menu_shop_collect_gold, NULL,
		FLG_NULL,
	},
	{
		"/Temple/Divide gold",
		"<Item>",
		'V',
		"",
		N_MSG_MENU_SHOP_DIVIDE_GOLD, "",
		cb_menu_shop_divide_gold, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_magic_guild[] = {
	{
		"/Magic Guild",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_magic_guild_init, NULL,
		FLG_NULL,
	},
/* ȥ */
	{
		"/Magic Guild/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [ˡ] */
	{
		"/Magic Guild/MAG",
		"<Branch>",
		'M',
		"",
		N_MSG_MAG, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [ˡ] ¾ */
	{
		"/Magic Guild/MAG/Title Misc",
		"<Title>",
		'\0',
		"",
		N_MSG_MAG_MISC, "",
		NULL, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/LIGHT",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_LIGHT, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_LIGHT,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/DARKNESS",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_DARKNESS, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_DARKNESS,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/TELEPORT_PARTY",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_TELEPORT_PARTY, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_TELEPORT_PARTY,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/TELEPORT",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_TELEPORT, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_TELEPORT,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/RECALL",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_RECALL, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_RECALL,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/KNOCK",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_KNOCK, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_KNOCK,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/LOCK",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_LOCK, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_LOCK,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/DISARM_TRAP",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_DISARM_TRAP, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_DISARM_TRAP,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/DISPEL_MAGIC",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_DISPEL_MAGIC, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_DISPEL_MAGIC,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/MIRROR_IMAGE",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_MIRROR_IMAGE, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_MIRROR_IMAGE,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/ANIMATE_OBJECTS",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_ANIMATE_OBJECTS, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_ANIMATE_OBJECTS,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/SHELTER",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_SHELTER, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_SHELTER,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/CREATE_FOOD",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_CREATE_FOOD, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_CREATE_FOOD,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/CREATE_UNDEAD",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_CREATE_UNDEAD, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_CREATE_UNDEAD,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/NO_LEARN Misc",
		"<Item>",
		'Z',
		"",
		N_MSG_SPELL_NO_LEARN, "",
		cb_menu_magic_guild_no_learn, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/--",
		"<PageSeparator>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [ˡ] õ */
	{
		"/Magic Guild/MAG/Title Detect",
		"<Title>",
		'\0',
		"",
		N_MSG_MAG_DETECT, "",
		NULL, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/IDENTIFY_ITEM",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_IDENTIFY_ITEM, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_IDENTIFY_ITEM,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/SEARCHING",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_SEARCHING, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_SEARCHING,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/ANALYZE_DWEOMER",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_ANALYZE_DWEOMER, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_ANALYZE_DWEOMER,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/DETECT_MAGIC",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_DETECT_MAGIC, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_DETECT_MAGIC,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/DETECT_ITEM",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_DETECT_ITEM, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_DETECT_ITEM,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/DETECT_DOORS",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_DETECT_DOORS, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_DETECT_DOORS,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/DETECT_TRAPS",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_DETECT_TRAPS, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_DETECT_TRAPS,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/DETECT_MONSTER",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_DETECT_MONSTER, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_DETECT_MONSTER,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/SENSE_INVISIBLE",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_SENSE_INVISIBLE, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_SENSE_INVISIBLE,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/NO_LEARN Detect",
		"<Item>",
		'Z',
		"",
		N_MSG_SPELL_NO_LEARN, "",
		cb_menu_magic_guild_no_learn, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/--",
		"<PageSeparator>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [ˡ] ƥѲ */
	{
		"/Magic Guild/MAG/Title Change status",
		"<Title>",
		'\0',
		"",
		N_MSG_MAG_CHANGE_STAT, "",
		NULL, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/FLY",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_FLY, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_FLY,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/FEATHER_FALL",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_FEATHER_FALL, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_FEATHER_FALL,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/VANISH",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_VANISH, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_VANISH,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/DARKVISION",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_DARKVISION, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_DARKVISION,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/PASSWALL",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_PASSWALL, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_PASSWALL,
		FLG_NULL,
	},
/* [ˡ] üե饰Ѳ */
	{
		"/Magic Guild/MAG/POLYMORPH_OTHER",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_POLYMORPH_OTHER, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_POLYMORPH_OTHER,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/POLYMORPH_SELF",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_POLYMORPH_SELF, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_POLYMORPH_SELF,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/STEALTH",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_STEALTH, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_STEALTH,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/NO_LEARN Change status",
		"<Item>",
		'Z',
		"",
		N_MSG_SPELL_NO_LEARN, "",
		cb_menu_magic_guild_no_learn, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/MAG/--",
		"<PageSeparator>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [Ʈˡ] */
	{
		"/Magic Guild/SOR",
		"<Branch>",
		'O',
		"",
		N_MSG_SOR, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [Ʈˡ]  */
	{
		"/Magic Guild/SOR/Title Attack",
		"<Title>",
		'\0',
		"",
		N_MSG_SOR_ATTACK, "",
		NULL, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/MAGIC_MISSILE",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_MAGIC_MISSILE, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_MAGIC_MISSILE,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/FIRE_BALL",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_FIRE_BALL, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_FIRE_BALL,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/ICE_BLIZZARD",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_ICE_BLIZZARD, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_ICE_BLIZZARD,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/ACID_RAIN",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_ACID_RAIN, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_ACID_RAIN,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/WIND_STORM",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_MIND_STORM, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_MIND_STORM,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/LIGHTNING_BOLT",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_LIGHTNING_BOLT, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_LIGHTNING_BOLT,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/POISON_CLOUD",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_POISON_CLOUD, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_POISON_CLOUD,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/DEATH_SPELL",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_DEATH_SPELL, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_DEATH_SPELL,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/NO_LEARN Attack",
		"<Item>",
		'Z',
		"",
		N_MSG_SPELL_NO_LEARN, "",
		cb_menu_magic_guild_no_learn, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/--",
		"<PageSeparator>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [Ʈˡ] ɸ */
	{
		"/Magic Guild/SOR/Title Defense",
		"<Title>",
		'\0',
		"",
		N_MSG_SOR_DEFENSE, "",
		NULL, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/MAGIC_SHIELD",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_MAGIC_SHIELD, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_MAGIC_SHIELD,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/MAGE_ARMOR",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_MAGE_ARMOR, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_MAGE_ARMOR,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/STONESKIN",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_STONESKIN, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_STONESKIN,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/IRON_BODY",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_IRON_BODY, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_IRON_BODY,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/SPELL_RESISTANCE",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_SPELL_RESISTANCE, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_SPELL_RESISTANCE,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/COUNTER_MAGIC",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_COUNTER_MAGIC, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_COUNTER_MAGIC,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/NO_LEARN Defense",
		"<Item>",
		'Z',
		"",
		N_MSG_SPELL_NO_LEARN, "",
		cb_menu_magic_guild_no_learn, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/--",
		"<PageSeparator>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [Ʈˡ] ơ۾ */
	{
		"/Magic Guild/SOR/Title Weaken status",
		"<Title>",
		'\0',
		"",
		N_MSG_SOR_WEAKEN_STAT, "",
		NULL, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/STONE",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_STONE, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_STONE,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/PARALYZE",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_PARALYZE, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_PARALYZE,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/POISON",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_POISON, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_POISON,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/CONFUSION",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_CONFUSION, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_CONFUSION,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/BLINDNESS",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_BLINDNESS, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_BLINDNESS,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/SLEEP",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_SLEEP, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_SLEEP,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/SILENCE",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_SILENCE, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_SILENCE,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/FEAR",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_FEAR, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_FEAR,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/HALLUCINATION",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_HALLUCINATION, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_HALLUCINATION,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/CHARM",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_CHARM, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_CHARM,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/NO_LEARN Weaken status",
		"<Item>",
		'Z',
		"",
		N_MSG_SPELL_NO_LEARN, "",
		cb_menu_magic_guild_no_learn, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/SOR/--",
		"<PageSeparator>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [ˡ] */
	{
		"/Magic Guild/ENC",
		"<Branch>",
		'E',
		"",
		N_MSG_ENC, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [ˡ] ӥƥ */
	{
		"/Magic Guild/ENC/Title Strengthen ability",
		"<Title>",
		'\0',
		"",
		N_MSG_ENC_STRENGTHEN_ABILITY, "",
		NULL, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/SHARPNESS",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_SHARPNESS, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_SHARPNESS,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/STRENGTH",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_STRENGTH, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_STRENGTH,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/QUICKNESS",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_QUICKNESS, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_QUICKNESS,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/WISE",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_WISE, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_WISE,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/BRAINY",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_BRAINY, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_BRAINY,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/ATTRACTIVE",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_ATTRACTIVE, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_ATTRACTIVE,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/NO_LEARN Strengthen ability",
		"<Item>",
		'Z',
		"",
		N_MSG_SPELL_NO_LEARN, "",
		cb_menu_magic_guild_no_learn, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/--",
		"<PageSeparator>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [ˡ]  */
	{
		"/Magic Guild/ENC/Title Strengthen misc",
		"<Title>",
		'\0',
		"",
		N_MSG_ENC_STRENGTHEN_MISC, "",
		NULL, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/POWER_UP_HP",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_POWER_UP_HP, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_POWER_UP_HP,
		FLG_NULL,
	},
/* [ˡ]  */
	{
		"/Magic Guild/ENC/HASTE",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_HASTE, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_HASTE,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/NO_LEARN Strengthen misc",
		"<Item>",
		'Z',
		"",
		N_MSG_SPELL_NO_LEARN, "",
		cb_menu_magic_guild_no_learn, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/--",
		"<PageSeparator>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [ˡ] ӥƥ */
	{
		"/Magic Guild/ENC/Title Weaken ability",
		"<Title>",
		'\0',
		"",
		N_MSG_ENC_WEAKEN_ABILITY, "",
		NULL, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/DULLNESS",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_DULLNESS, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_DULLNESS,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/WEAKNESS",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_WEAKNESS, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_WEAKNESS,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/SLOWNESS",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_SLOWNESS, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_SLOWNESS,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/FOOLISH",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_FOOLISH, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_FOOLISH,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/BRAINLESS",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_BRAINLESS, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_BRAINLESS,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/UNATTRACTIVE",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_UNATTRACTIVE, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_UNATTRACTIVE,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/NO_LEARN Weaken ability",
		"<Item>",
		'Z',
		"",
		N_MSG_SPELL_NO_LEARN, "",
		cb_menu_magic_guild_no_learn, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/--",
		"<PageSeparator>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [ˡ]  */
	{
		"/Magic Guild/ENC/Title Weaken misc",
		"<Title>",
		'\0',
		"",
		N_MSG_ENC_WEAKEN_MISC, "",
		NULL, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/ENERGY_DRAIN",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_ENERGY_DRAIN, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_ENERGY_DRAIN,
		FLG_NULL,
	},
/* [ˡ]  */
	{
		"/Magic Guild/ENC/SLOW",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_SLOW, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_SLOW,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/HUNGER",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_HUNGER, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_HUNGER,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/CANCELLATION",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_CANCELLATION, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_CANCELLATION,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/NO_LEARN Weaken misc",
		"<Item>",
		'Z',
		"",
		N_MSG_SPELL_NO_LEARN, "",
		cb_menu_magic_guild_no_learn, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/ENC/--",
		"<PageSeparator>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [ˡ] */
	{
		"/Magic Guild/SUM",
		"<Branch>",
		'U',
		"",
		N_MSG_SUM, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [ˡ]  */
	{
		"/Magic Guild/SUM/Title Summon",
		"<Title>",
		'\0',
		"",
		N_MSG_SUM_SUMMON, "",
		NULL, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/SUM/SUMMON_MONSTER",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_SUMMON_MONSTER, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_SUMMON_MONSTER,
		FLG_NULL,
	},

	{
		"/Magic Guild/SUM/DISMISSAL",
		"<Branch>",
		'\0',
		"",
		N_MSG_SPELL_DISMISSAL, "",
		cb_menu_magic_guild, (void *)SPELL_KIND_DISMISSAL,
		FLG_NULL,
	},

	{
		"/Magic Guild/SUM/NO_LEARN Summon",
		"<Item>",
		'Z',
		"",
		N_MSG_SPELL_NO_LEARN, "",
		cb_menu_magic_guild_no_learn, NULL,
		FLG_NULL,
	},

	{
		"/Magic Guild/SUM/--",
		"<PageSeparator>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
/* [ηʸ] */
/* [ˡ]  */
/* []  */
/* [Ǧ] */
/*  */
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_order_sel_mbr[1 + 1 + MBR_MAX_N + 1 + 1];

menu_t	ls_menu_bar[] = {
	{
		"/Bar",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Bar/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NAME_BAR, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Bar/Order",
		"<Branch>",
		'O',
		"",
		N_MSG_MENU_BAR_ORDER, "",
		cb_menu_bar_order, NULL,
		FLG_NULL,
	},
	{
		"/Bar/Form",
		"<Branch>",
		'V',
		"",
		N_MSG_MENU_BAR_FORM, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Bar/Form/Form",
		"<Branch>",
		'V',
		"",
		N_MSG_MENU_BAR_FORM, "",
		cb_menu_bar_form, NULL,
		FLG_NULL,
	},
	{
		"/Bar/Form/Edit member",
		"<Branch>",
		'P',
		"",
		N_MSG_MENU_BAR_EDIT_MBR, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Bar/Form/Edit member/Edit member",
		"<Branch>",
		'E',
		"",
		N_MSG_MENU_BAR_EDIT_MBR, "",
		cb_menu_bar_edit_mbr, NULL,
		FLG_NULL,
	},
	{
		"/Bar/Form/Edit member/New member",
		"<OpenWinItem>",
		'N',
		"",
		N_MSG_MENU_BAR_NEW_MBR, "",
		cb_menu_bar_new_mbr, NULL,
		FLG_NULL,
	},
	{
		"/Bar/Form/Edit member/Remove member",
		"<Branch>",
		'R',
		"",
		N_MSG_MENU_BAR_REMOVE_MBR, "",
		cb_menu_bar_remove_mbr, NULL,
		FLG_NULL,
	},
	{
		"/Bar/Form/Edit class",
		"<Branch>",
		'C',
		"",
		N_MSG_MENU_BAR_EDIT_CLASS, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Bar/Form/Edit class/Edit class",
		"<Branch>",
		'E',
		"",
		N_MSG_MENU_BAR_EDIT_CLASS, "",
		cb_menu_bar_edit_class, NULL,
		FLG_NULL,
	},
	{
		"/Bar/Form/Edit class/New class",
		"<OpenWinItem>",
		'N',
		"",
		N_MSG_MENU_BAR_NEW_CLASS, "",
		cb_menu_bar_new_class, NULL,
		FLG_NULL,
	},
	{
		"/Bar/Form/Edit class/Remove class",
		"<Branch>",
		'R',
		"",
		N_MSG_MENU_BAR_REMOVE_CLASS, "",
		cb_menu_bar_remove_class, NULL,
		FLG_NULL,
	},
	{
		"/Bar/Form/Save",
		"<OpenWinItem>",
		'S',
		"",
		N_MSG_MENU_BAR_SAVE, "",
		cb_menu_bar_save, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_bar_form[
		1 + (1 + LS_MBR_PAGE_MAX_N + 1)
		* LS_MBR_MAX_N_PER_PAGE + 1];

menu_t	ls_menu_bar_form_sub[] = {
	{
		"/Form",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_bar_form_sub_init, NULL,
		FLG_NULL,
	},
	{
		"/Form/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Form/Join",
		"<Branch>",
		'J',
		"",
		N_MSG_MENU_BAR_JOIN, "",
		cb_menu_bar_join, NULL,
		FLG_NULL,
	},
	{
		"/Form/Not join",
		"<Item>",
		'N',
		"",
		N_MSG_MENU_BAR_NOT_JOIN, "",
		cb_menu_bar_not_join, NULL,
		FLG_NULL,
	},
	{
		"/Form/Data",
		"<OpenWinItem>",
		'P',
		"",
		N_MSG_MENU_DATA, "",
		cb_menu_bar_data_form, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_bar_join[1 + MBR_MAX_N + 1];

menu_t	ls_menu_bar_sel_mbr[
		1 + (1 + LS_MBR_PAGE_MAX_N + 1)
		* LS_MBR_MAX_N_PER_PAGE + 1];

menu_t	ls_menu_bar_edit_mbr_sub[] = {
	{
		"/Edit member",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Edit member/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_TTL_MENU_BAR_EDIT_MBR, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Edit member/Data",
		"<OpenWinItem>",
		'P',
		"",
		N_MSG_MENU_DATA, "",
		cb_menu_bar_data_edit, NULL,
		FLG_NULL,
	},
	{
		"/Edit member/Arrange",
		"<Item>",
		'A',
		"",
		N_MSG_MENU_BAR_ARRANGE, "",
		cb_menu_bar_arrange, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_bar_sel_edit_class[] = {
	{
		"/Select edit class",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Select edit class/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_TTL_MENU_SEL_EDIT_CLASS, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Select edit class/Edit",
		"<OpenWinItem>",
		'E',
		"",
		N_MSG_MENU_BAR_EDIT_CLASS, "",
		cb_menu_bar_edit_class_sub, NULL,
		FLG_NULL,
	},
	{
		"/Select edit class/Arrange",
		"<Item>",
		'A',
		"",
		N_MSG_MENU_BAR_ARRANGE_CLASS, "",
		cb_menu_bar_arrange_class, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_inn[] = {
	{
		"/Inn",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Inn/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NAME_INN, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Inn/Stay",
		"<Item>",
		'C',
		"",
		N_MSG_MENU_INN_STAY, "",
		cb_menu_inn_stay, NULL,
		FLG_NULL,
	},
	{
		"/Inn/Divide gold",
		"<Item>",
		'V',
		"",
		N_MSG_MENU_SHOP_DIVIDE_GOLD, "",
		cb_menu_shop_divide_gold, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

menu_t	ls_menu_pet_shop[] = {
	{
		"/Pet Shop",
		"<Branch>",
		'\0',
		"",
		N_MSG_NULL, "",
		cb_menu_pet_shop_init, NULL,
		FLG_NULL,
	},
	{
		"/Pet Shop/Title",
		"<Title>",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
	{
		"/Pet Shop/Take",
		"<Branch>",
		'T',
		"",
		N_MSG_MENU_PET_SHOP_TAKE, "",
		cb_menu_pet_shop_take, NULL,
		FLG_NULL,
	},
	{
		"/Pet Shop/Leave",
		"<Branch>",
		'L',
		"",
		N_MSG_MENU_PET_SHOP_LEAVE, "",
		cb_menu_pet_shop_leave, NULL,
		FLG_NULL,
	},
	{
		"/Pet Shop/Buy",
		"<Branch>",
		'B',
		"",
		N_MSG_MENU_PET_SHOP_BUY, "",
		cb_menu_pet_shop_buy, NULL,
		FLG_NULL,
	},
	{
		"",
		"",
		'\0',
		"",
		N_MSG_NULL, "",
		NULL, NULL,
		FLG_NULL,
	},
};

#define	PET_SHOP_PAGE_MAX_N	4
#define	PET_SHOP_PET_N_PER_PAGE	16
#define	PET_SHOP_PET_MAX_N	\
	(PET_SHOP_PAGE_MAX_N * PET_SHOP_PET_N_PER_PAGE)

menu_t	ls_menu_pet_shop_take[1 + 1 + (LS_PET_MAX_N * 2) + 1];
menu_t	ls_menu_pet_shop_leave[1 + 1 + (PET_MAX_N * 2) + 1];
menu_t	ls_menu_pet_shop_buy[
	1 + 1 + PET_SHOP_PET_MAX_N + PET_SHOP_PAGE_MAX_N + 1];

#endif	/* TMENU_TAB_H */
