/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: town.h,v 1.10 2003/11/23 04:29:50 bowkenken Exp $
*****************************************************************/

#ifndef	TOWN_H
#define	TOWN_H

#include	"dun.h"
#include	"mnstr.h"

typedef enum {
	SHOP_N_NULL,
	SHOP_N_BAR,
	SHOP_N_INN,
	SHOP_N_TEMPLE,
	SHOP_N_WPN,
	SHOP_N_ARMOR,
	SHOP_N_MAGIC,
	SHOP_N_ALCHEMY,
	SHOP_N_GROCERY,
	SHOP_N_RESTAURANT,
	SHOP_N_TEAROOM,
	SHOP_N_TOBACCO,
	SHOP_N_PET_SHOP,
	SHOP_N_MAX_N,
} shop_n_t;

typedef struct {
	mnstr_kind_t	kind;
	gold_t	price;
} art_ls_pet_shop_t;

#define	FACE_MNR_GATE	'+'
#define	FACE_MNR_SHOP_INN	'I'
#define	FACE_MNR_SHOP_BAR	'B'
#define	FACE_MNR_SHOP_TEMPLE	'T'
#define	FACE_MNR_SHOP_WPN	'W'
#define	FACE_MNR_SHOP_ARMOR	'A'
#define	FACE_MNR_SHOP_MAGIC	'M'
#define	FACE_MNR_SHOP_ALCHEMY	'L'
#define	FACE_MNR_SHOP_GROCERY	'G'
#define	FACE_MNR_SHOP_RESTAURANT	'R'
#define	FACE_MNR_SHOP_TEAROOM	'C'
#define	FACE_MNR_SHOP_TOBACCO	'S'
#define	FACE_MNR_SHOP_PET_SHOP	'P'

#define	FACE_MNR_STREETLAMP	'*'

#define	TOWN_PTN_COL_MAX_N	128

#define	STREETLAMP_R	2

typedef struct {
	long	col_str_len;
	long	col_n;
	unsigned char	col_mjr[TOWN_PTN_COL_MAX_N];
	unsigned char	col_mnr[TOWN_PTN_COL_MAX_N];
	char	map_mjr[MAP_MAX_Y][MAP_MAX_X];
	char	map_mnr[MAP_MAX_Y][MAP_MAX_X];
} town_ptn_t;

typedef struct {
	long	col_code;
	char	mjr, mnr;
} town_ptn_col_tab_t;

#endif	/* TOWN_H */
