/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: turn.c,v 1.7 2003/11/23 04:29:50 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
/*#include	"misc.h"*/
#include	"turn.h"
/*#include	"dun.h"*/
#include	"town.h"
#include	"item.h"
/*#include	"spell.h"*/
/*#include	"chr.h"*/
#include	"party.h"
#include	"mnstr.h"
/*#include	"pet.h"*/
/*#include	"fight.h"*/
#include	"fx.h"
/*#include	"trap.h"*/
/*#include	"draw.h"*/
/*#include	"curs.h"*/
#include	"menu.h"
#include	"msg.h"
/*#include	"ver.h"*/
/*#include	"gmain_prot.h"*/
/*#include	"misc_prot.h"*/
#include	"turn_prot.h"
/*#include	"dun_prot.h"*/
#include	"town_prot.h"
#include	"item_prot.h"
/*#include	"spell_prot.h"*/
/*#include	"chr_prot.h"*/
/*#include	"party_prot.h"*/
#include	"mnstr_prot.h"
/*#include	"pet_prot.h"*/
/*#include	"fight_prot.h"*/
#include	"fx_prot.h"
/*#include	"trap_prot.h"*/
/*#include	"draw_prot.h"*/
/*#include	"curs_prot.h"*/
/*#include	"menu_prot.h"*/
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

static long	g_day, g_turn;

/**/

long	get_turn( void )
{
	return g_turn;
}

/**/

long	set_turn( long n )
{
	g_turn = n;
	if( g_turn >= TURN_A_DAY ){
		g_day += g_turn / TURN_A_DAY;
		g_turn %= TURN_A_DAY;
	}

	return g_turn;
}

/**/

long	inc_turn( void )
{
	g_turn++;
	if( g_turn >= TURN_A_DAY ){
		g_day += g_turn / TURN_A_DAY;
		g_turn %= TURN_A_DAY;
	}
	chk_morning_glow( g_turn );
	chk_evening_glow( g_turn );
	chk_discount_day( g_day );

	inc_turn_all_item();
	inc_turn_all_fx();
	inc_turn_all_mnstr();

	return g_turn;
}

/**/

bool_t	chk_morning( void )
{
	long	turn;

	turn = get_turn() % TURN_A_DAY;

	if( turn < (MORNING_HOUR * TURN_PER_HOUR) )
		return FALSE;
	if( turn >= ((MORNING_HOUR + 1) * TURN_PER_HOUR) )
		return FALSE;

	return TRUE;
}

/**/

bool_t	chk_evening( void )
{
	long	turn;

	turn = get_turn() % TURN_A_DAY;

	if( turn < (EVENING_HOUR * TURN_PER_HOUR) )
		return FALSE;
	if( turn >= ((EVENING_HOUR + 1) * TURN_PER_HOUR) )
		return FALSE;

	return TRUE;
}

/**/

bool_t	chk_night( void )
{
	long	turn;
	long	morning;
	long	evening;

	turn = get_turn() % TURN_A_DAY;
	morning = MORNING_HOUR * TURN_PER_HOUR;
	evening = EVENING_HOUR * TURN_PER_HOUR;

	if( turn < morning )
		return TRUE;
	if( turn >= evening )
		return TRUE;
	return FALSE;
}

/**/

char	*get_calendar_str( void )
{
	long	game_day, turn;
	long	year, month, day, hour, minute;
	char	*week;
	static char	s[127 + 1];

	game_day = get_game_day();
	turn = get_turn();
	year = (game_day / 360);
	month = (game_day / 30) % 12 + 1;
	day = game_day % 30 + 1;
	hour = (turn / TURN_PER_HOUR) % 24;
	minute = (turn / TURN_PER_MINUTE) % 60;
	week = get_day_of_week_name();

	sprintf( s, MSG_CALENDAR, year, month, day, week, hour, minute );

	return s;
}

/**/

long	get_game_day( void )
{
	return g_day;
}

/**/

long	set_game_day( long year, long month, long day )
{
	g_day = 0;
	g_day += year * 360;
	g_day += (month - 1) * 30;
	g_day += day - 1;

	return g_day;
}

/**/

char	*get_day_of_week_name( void )
{
	switch( get_day_of_week() ){
	case DAY_OF_WEEK_ELEC:
		return MSG_DAY_OF_WEEK_ELEC;
	case DAY_OF_WEEK_PHYS:
		return MSG_DAY_OF_WEEK_PHYS;
	case DAY_OF_WEEK_HEAT:
		return MSG_DAY_OF_WEEK_HEAT;
	case DAY_OF_WEEK_COLD:
		return MSG_DAY_OF_WEEK_COLD;
	case DAY_OF_WEEK_ACID:
		return MSG_DAY_OF_WEEK_ACID;
	case DAY_OF_WEEK_WIND:
		return MSG_DAY_OF_WEEK_MIND;
	case DAY_OF_WEEK_POIS:
		return MSG_DAY_OF_WEEK_POIS;
	case DAY_OF_WEEK_MAX_N:
		break;
	}

	return MSG_NULL;
}

/**/

day_of_week_t	get_day_of_week( void )
{
	return( get_game_day() % DAY_OF_WEEK_MAX_N );
}

/**/

