#include <stdio.h>
#include <stdlib.h>

#define ARG_ERR_MSG "Wrong argument. Aborting…\n"

#include <JavascriptCore/JavascriptCore.h>//-framework JavaScriptCoreオプションを使用の事

extern void functionLoader(JSGlobalContextRef ctx, JSObjectRef jobjGlobal);
void classWrapper(JSGlobalContextRef ctx, JSObjectRef jobjGlobal, char* name, JSObjectRef* classObject);
void functionWrapper(JSGlobalContextRef ctx, JSObjectRef parentObj, char* name, JSObjectCallAsFunctionCallback jsGlobalFunction);

int interpreter(char* code)
{
#ifdef DEBUG
    printf("JavaScript interpreter has been started.\n");
#endif
	
#ifdef DEBUG
    printf("Creating Global context..");
#endif
	
    JSGlobalContextRef ctx = JSGlobalContextCreate(NULL);
	
#ifdef DEBUG
    printf("Done!\n");
#endif
	
    // グローバル実行コンテキストが持つグローバルオブジェクトを取得する
    // ブラウザでいうところの window オブジェクトのようなもの
    JSObjectRef jobjGlobal = JSContextGetGlobalObject(ctx);
	
    functionLoader(ctx, jobjGlobal);
	
    // JavaScript のソースを JS の文字列にする
    JSStringRef jstrSource = JSStringCreateWithUTF8CString(code);
	
#ifdef DEBUG
    printf("JavaScript source is now ready to execute. Starting ..\n\n");
#endif
	
    // 実行、 this を NULL とするとグローバルオブジェクトが this になるらしい
    JSEvaluateScript(ctx, jstrSource, NULL, NULL, 1, NULL); 
    // 文字列のリファレンスカウンタをデクリメント
    JSStringRelease(jstrSource);
	
#ifdef DEBUG
    printf("Script execution has came to the end. Terminating JavaScript instance ..\n");
#endif
	
    // 解放許可？
    JSGlobalContextRelease(ctx);
    // 解放実行？EXC_BAD_ACCESSが来る。
    //JSGarbageCollect(ctx);
    return 0;
	
}

void classWrapper(JSGlobalContextRef ctx, JSObjectRef jobjGlobal, char* name, JSObjectRef* classObject)
{
	//クラスの定義を保持する変数を作成
	JSClassDefinition classDefinition	= kJSClassDefinitionEmpty;
	//クラス型の変数を作成
	JSClassRef classSubstance;
	//クラスの名前を決定
	classDefinition.className = name;
	//　プロトタイプ　は　手動　で作成という事にする
	classDefinition.attributes = kJSClassAttributeNoAutomaticPrototype; 
	//クラス型を作成
	classSubstance = JSClassCreate(&classDefinition);
	//クラスをオブジェクト化
	*classObject = JSObjectMakeConstructor(ctx, classSubstance, NULL);
	//プロトタイプ継承
	JSObjectSetPrototype(ctx, *classObject, JSObjectGetPrototype(ctx, jobjGlobal));
	//クラスを持ったオブジェクトの名前を作る
	JSStringRef jstr = JSStringCreateWithUTF8CString(name);
	//クラスのオブジェクトをCTXに公開
	JSObjectSetProperty(ctx, jobjGlobal, jstr, *classObject, kJSPropertyAttributeNone, NULL);
	// 文字列のリファレンスカウンタをデクリメント
    JSStringRelease(jstr);
}

void functionWrapper(JSGlobalContextRef ctx, JSObjectRef parentObj, char* name, JSObjectCallAsFunctionCallback jsGlobalFunction)
{
    // JavaScript で扱える文字列を作る
    JSStringRef jstr = JSStringCreateWithUTF8CString(name);
    // C の関数を JS の関数オブジェクトにする
    JSObjectRef jfunc = JSObjectMakeFunctionWithCallback(ctx, jstr, jsGlobalFunction);
	//プロトタイプ継承
	JSObjectSetPrototype(ctx, jfunc, JSObjectGetPrototype(ctx, parentObj));
    // オブジェクトのPrototypeのプロパティとして追加
    JSObjectSetProperty(ctx, JSObjectGetPrototype(ctx, parentObj), jstr, jfunc, kJSPropertyAttributeNone, NULL);
    // 文字列のリファレンスカウンタをデクリメント
    JSStringRelease(jstr);
}