#include <stdio.h>
#include <stdlib.h>
#include "xaw.h"

//***  Strong suggetion for mac users to overwrite Intrinsic.h  ***
//***  Define Boolean as unsigned char  ***

void functionLoader_Gui(JSGlobalContextRef ctx, JSObjectRef jobjGlobal);
XtAppContext app_con;
WidgetClass xawWidetTypes[] = {};
XtOrientation xawOrientationDirection[]={XtorientHorizontal, XtorientVertical};


Widget *myWidgets;
xawWidet *myCtrls;
int objIDc = 0;

char* winName;

/* コールバック関数 */
void xawJsCallbackFunction( Widget w, XtPointer client, XtPointer called )
{
	int* myID;
	winName = (char*)malloc(sizeof(char)*16);
	winName = XtName(w);
	
	sscanf(winName,"%d",myID);
	printf("%d",*myID);
	JSObjectCallAsFunction(*(myCtrls[*myID].Context), *(myCtrls[*myID].CallbackFunction), NULL, 0,NULL,NULL);
}

Widget createForm(Widget* form, xawWindow window)
{
	Widget top;

	/* ツールキットの初期化 */
	top = XtVaAppInitialize( window.Context, window.Name, NULL, 0, &window.argc, window.argv, NULL, NULL );
	/*  クラス名       引数のリソース指定を解釈*/
	/* 台紙ウィジットの作成 */            /* ウィジットクラス */
	*form = XtVaCreateManagedWidget( "form", formWidgetClass, top, 
                                   /* ウィジット名 */      /* 親ウィンドウ */
								   /* リソースの指定 */                XtNorientation, window.Direction,
								   /* いくつでもOKなので最後はNULL */  NULL );
	return top;
}

Widget createControl(xawWidet widget)
{
	myWidgets = (Widget *)realloc( myWidgets, sizeof(Widget)*(objIDc+2) );
	if( myWidgets == NULL )//ポインタが空っぽだったら実行停止。
	{
		printf( "Memory re-allocation failed!\n" );
		exit( 1 );
	}
	
	
	myWidgets[objIDc+2] = XtVaCreateManagedWidget( widget.Name, widget.Type, widget.Parent,
								   XtNlabel, widget.Text,
								   XtNwidth, widget.Width, XtNheight, widget.Height,
									/* 縁取り */             XtNborderWidth, widget.Border,
								   /* 配置方法 */           XtNfromHoriz, NULL,
								   /* ウィンドウの左端から */  XtNhorizDistance, widget.Left,
								   /* ウィンドウの上端から */  XtNfromVert, NULL,
														   XtNvertDistance, widget.Top,
								   NULL );
	XtAddCallback( myWidgets[objIDc+2], XtNcallback, xawJsCallbackFunction, NULL );
	objIDc++;
	return myWidgets[objIDc+2];
}

static JSValueRef jsControlCreate(
								 JSContextRef        ctx,
								 JSObjectRef         jobj,
								 JSObjectRef         jobjThis,
								 size_t              argLen,
								 const JSObjectRef   args[],
								 JSValueRef*         jobjExp)
{
	JSValueRef r = JSValueMakeNumber(ctx,  -1);
	
	//name
	//JSStringRef     jstrName = JSValueToStringCopy(ctx, JSObjectGetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("Name"), jobjExp), jobjExp);
	//size_t          len     = JSStringGetMaximumUTF8CStringSize(jstrName);
	//char*           name   =  (char*)malloc(len);
	//JSStringGetUTF8CString(jstrName, name, len);
	//**********
	
	
	//type
	int typenum	= (int)JSValueToNumber(ctx, JSObjectGetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("Type"), jobjExp),NULL);	
	WidgetClass type;
	switch(typenum)
	{
			case 0:
				type = labelWidgetClass;
				break;
			case 1:
				type = commandWidgetClass;
				break;
	}
	//*********
	
	//parent
	int parentID	= (int)JSValueToNumber(ctx, 
										   JSObjectGetProperty(ctx,
															   JSObjectGetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("Parent"), jobjExp),
															JSStringCreateWithUTF8CString("ID"),
															jobjExp),NULL);	
	//-------
	parentID++;
	
	//text
	JSStringRef     jstrText = JSValueToStringCopy(ctx, JSObjectGetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("Text"), jobjExp), jobjExp);
	size_t len     = JSStringGetMaximumUTF8CStringSize(jstrText);
	char*           text   =  (char*)malloc(len);
	JSStringGetUTF8CString(jstrText, text, len);
	//**********
	
	int W	= (int)JSValueToNumber(ctx, JSObjectGetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("Width"), jobjExp),NULL);	
	int H	= (int)JSValueToNumber(ctx, JSObjectGetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("Height"), jobjExp),NULL);	
	int L	= (int)JSValueToNumber(ctx, JSObjectGetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("Left"), jobjExp),NULL);	
	int T	= (int)JSValueToNumber(ctx, JSObjectGetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("Top"), jobjExp),NULL);
	int B	= (int)JSValueToNumber(ctx, JSObjectGetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("Border"), jobjExp),NULL);
	

	JSStringRef     jstrCallback = JSValueToStringCopy(ctx, JSObjectGetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("Callback"), jobjExp), jobjExp);
	len     = JSStringGetMaximumUTF8CStringSize(jstrCallback);
	char*           func   =  (char*)malloc(len);
	JSStringGetUTF8CString(jstrCallback, func, len);

	myCtrls = (xawWidet *)realloc( myCtrls, sizeof(xawWidet)*(objIDc+2) );
	if( myCtrls == NULL )//ポインタが空っぽだったら実行停止。
	{
		printf( "Memory re-allocation failed!\n" );
		exit( 1 );
	}
	
	char*           name   =  (char*)malloc(sizeof(char)*16);
	sprintf(name, "%d", objIDc+2);
	myCtrls[objIDc+2].Name = name;
	//myCtrl.Name = name;
	myCtrls[objIDc+2].Type = type;
	myCtrls[objIDc+2].Parent = myWidgets[parentID];
	myCtrls[objIDc+2].Text = text;
	myCtrls[objIDc+2].Width = W;//x
	myCtrls[objIDc+2].Height = H;//y
	myCtrls[objIDc+2].Left = L;//x
	myCtrls[objIDc+2].Top = T;//y
	myCtrls[objIDc+2].Border = B;
	myCtrls[objIDc+2].Context = ctx;
	
	
	if(!JSValueIsUndefined(ctx, JSObjectGetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("Callback"), NULL)))
	{
		myCtrls[objIDc+2].CallbackFunction = JSObjectGetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("Callback"), NULL);
	}
	
	
	
	createControl(myCtrls[objIDc+2]);
	r = JSValueMakeNumber(ctx,  objIDc);
	JSObjectSetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("ID"), r, kJSPropertyAttributeNone, NULL);
	return r;
}

static JSValueRef jsWindowCreate(
				 JSContextRef        ctx,
				 JSObjectRef         jobj,
				 JSObjectRef         jobjThis,
				 size_t              argLen,
				 const JSObjectRef   args[],
				 JSValueRef*         jobjExp)
{
	myWidgets = (Widget *)malloc( sizeof(Widget)*2 );
	if( myWidgets == NULL )//ポインタが空っぽだったら実行停止。
	{
		printf( "Memory alloc failed!\n" );
		exit( 1 );
	}
	xawWindow myWindow;
	
	JSValueRef r = JSValueMakeNumber(ctx,  -1);
	//if(JSObjectIsConstructor(ctx, jobj))
	
        JSStringRef     jstrName = JSValueToStringCopy(ctx, JSObjectGetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("Name"), jobjExp), jobjExp);
        size_t          len     = JSStringGetMaximumUTF8CStringSize(jstrName);
        char*           name   =  (char*)malloc(len);
        JSStringGetUTF8CString(jstrName, name, len);
		
		myWindow.Context = &app_con;
		myWindow.argc = g_argc;
		myWindow.argv = g_argv;
		myWindow.Name = name;
		myWindow.Direction = (JSValueToBoolean(ctx, JSObjectGetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("Name"), jobjExp)))?XtorientVertical:XtorientHorizontal;
		
		myWidgets[objIDc] = createForm(&myWidgets[objIDc + 1], myWindow);
		
		
		r = JSValueMakeNumber(ctx,  objIDc);
		JSObjectSetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("ID"), r, kJSPropertyAttributeNone, NULL);
	
	objIDc ++;
	
	return r;
}

static JSValueRef jsWindowShow(
						  JSContextRef        ctx,
						  JSObjectRef         jobj,
						  JSObjectRef         jobjThis,
						  size_t              argLen,
						  const JSObjectRef   args[],
						  JSValueRef*         jobjExp)
{
	//jobjThis.ID
	JSValueRef objID = JSObjectGetProperty(ctx, jobjThis, JSStringCreateWithUTF8CString("ID"), jobjExp);
	
	int windowID = (int)JSValueToNumber(ctx,objID,jobjExp);
	XtRealizeWidget( myWidgets[windowID] );
	XtAppMainLoop( app_con ); 
}


void functionLoader_Gui(JSGlobalContextRef ctx, JSObjectRef jobjGlobal)
{
	JSObjectRef Window, Widget;
	printf("GUI has been enabled with this version.\nEnjoy!\n");
	classWrapper(ctx, jobjGlobal, "xawWindow", &Window);
	
	JSObjectRef Window_Name, Window_Direction;
	Window_Name = JSValueMakeString(ctx, JSStringCreateWithUTF8CString("undefined"));
	JSObjectSetProperty(ctx, Window, JSStringCreateWithUTF8CString("Name"), Window_Name, kJSPropertyAttributeNone, NULL);	
	JSObjectSetProperty(ctx, Window, JSStringCreateWithUTF8CString("Direction"), Window_Direction, kJSPropertyAttributeNone, NULL);
	
	functionWrapper(ctx, Window, "SetProperty", (JSObjectCallAsFunctionCallback)jsWindowCreate);
	functionWrapper(ctx, Window, "Show", (JSObjectCallAsFunctionCallback)jsWindowShow);	
	
	classWrapper(ctx, jobjGlobal, "xawControl", &Widget);
	functionWrapper(ctx, Widget, "Create", (JSObjectCallAsFunctionCallback)jsControlCreate);
	JSObjectRef Control_Name, Control_Type, Control_Parent, Control_Text, Control_Width, Control_Height, Control_Left, Control_Top, Control_Border, Control_Callback;
	Control_Name = JSValueMakeString(ctx, JSStringCreateWithUTF8CString("undefined"));
	JSObjectSetProperty(ctx, Widget, JSStringCreateWithUTF8CString("Name"), Control_Name, kJSPropertyAttributeNone, NULL);	
	JSObjectSetProperty(ctx, Widget, JSStringCreateWithUTF8CString("Type"), Control_Type, kJSPropertyAttributeNone, NULL);
	JSObjectSetProperty(ctx, Widget, JSStringCreateWithUTF8CString("Parent"), Control_Parent, kJSPropertyAttributeNone, NULL);
	JSObjectSetProperty(ctx, Widget, JSStringCreateWithUTF8CString("Text"), Control_Text, kJSPropertyAttributeNone, NULL);
	JSObjectSetProperty(ctx, Widget, JSStringCreateWithUTF8CString("Width"), Control_Width, kJSPropertyAttributeNone, NULL);
	JSObjectSetProperty(ctx, Widget, JSStringCreateWithUTF8CString("Height"), Control_Height, kJSPropertyAttributeNone, NULL);
	JSObjectSetProperty(ctx, Widget, JSStringCreateWithUTF8CString("Left"), Control_Left, kJSPropertyAttributeNone, NULL);
	JSObjectSetProperty(ctx, Widget, JSStringCreateWithUTF8CString("Top"), Control_Top, kJSPropertyAttributeNone, NULL);
	JSObjectSetProperty(ctx, Widget, JSStringCreateWithUTF8CString("Border"), Control_Border, kJSPropertyAttributeNone, NULL);
	JSObjectSetProperty(ctx, Widget, JSStringCreateWithUTF8CString("Callback"), Control_Callback, kJSPropertyAttributeNone, NULL);
//	dialogtest(g_argc,g_argv);
}
