﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace NetMonitor.AmfFormat
{
	static class Amf0Reader
	{
		public static Amf0Archive ReadAmf0(byte[] buf)
		{
			using (MemoryStream st = new MemoryStream(buf))
			{
				return ReadAmf0(st);
			}
		}
		public static Amf0Archive ReadAmf0(Stream st)
		{
			BigendianReader reader = new BigendianReader(st);
			UInt16 version = reader.ReadUInt16();
			if (version != 0)
				return null;
			UInt16 headerCount = reader.ReadUInt16();
			AmfHeaderData[] headerArray = new AmfHeaderData[headerCount];
			for (int i = 0; i < headerCount; i++)
			{
				AmfHeaderData header = new AmfHeaderData();
				headerArray[i] = header;
				header.HeaderName = reader.ReadString();
				header.Flag = reader.ReadByte() != 0;
				UInt32 headerDataLength = reader.ReadUInt32();
				if (headerDataLength > 0)
				{
					header.HeaderData = ReadData(reader);
					//byte[] buf = new byte[headerDataLength];
					//reader.BaseStream.Read(buf, 0, (int)headerDataLength);
					//using (memst = new MemoryStream(buf))
					//{
					//}
				}
			}
			UInt16 mesCount = reader.ReadUInt16();
			AmfMessageData[] mesArray = new AmfMessageData[mesCount];
			for (int i = 0; i < mesCount; i++)
			{
				AmfMessageData mes = new AmfMessageData();
				mesArray[i] = mes;
				mes.TargetURI = reader.ReadString();
				mes.ResponseURI = reader.ReadString();
				UInt32 mesDataLength = reader.ReadUInt32();
				if (mesDataLength > 0)
				{
					mes.Data = ReadData(reader);
				}
			}
			return new Amf0Archive(headerArray, mesArray);
		}

		private static AmfData ReadData(BigendianReader reader)
		{
			switch (reader.ReadByte())
			{
				case 0://number-type
					return new AmfNumberData(reader.ReadDouble());
				case 1:
					return new AmfBooleanData(reader.ReadByte() != 0);
				case 2:
					return new AmfStringData(reader.ReadString());
				case 5:
					return new AmfNullData();
				case 6:
					return new AmfUndefinedData();
				case 3:
					return ReadObjectData(reader, false);
				//いまいち0x08の仕様がわからん 
				//array-countまかせ法 - 失敗
				//case 8:
				//    {
				//        int length = (int)reader.ReadUInt32();
				//        AmfObjectArrayData array = new AmfObjectArrayData(length);
				//        for (int i = 0; i < length; i++)
				//            array.Array[i] = ReadObjectData(reader);

				//        return array;
				//    } 
				//array-countにまかせ＆最後はobject-end-marker法 - 失敗
				//case 8:
				//    {
				//        int length = (int)reader.ReadUInt32();
				//        AmfObjectArrayData2 array = new AmfObjectArrayData2(length);
				//        for (int i = 0; i < length; i++)
				//            array.Array[i] = ReadObjectMenberData(reader);
				//        string key = reader.ReadString();
				//        if (key.Length > 0 || reader.ReadByte() != 0x09)
				//            throw new Exception("データ異常");
				//        return array;
				//    }

				//array-countは読み捨て、0x03と同様にobject-end-markerでmember数を決める。
				//array-countよりmember数が多かったりするんだがとりあえずうまくいったのでこれでやる。
				case 8:
					{
						return ReadObjectData(reader, true);
					}
				case 0xA:
					{
						int length = (int)reader.ReadUInt32();
						AmfArrayData array = new AmfArrayData(length);
						for (int i = 0; i < length; i++)
							array.Array[i] = ReadData(reader);
						return array;
					}
				default:
					throw new Exception("データ異常");
			}
		}

		private static AmfObjectMember ReadObjectMenberData(BigendianReader reader)
		{
			if (reader.BaseStream.Position >= reader.BaseStream.Length)
				return new AmfObjectMember("", new AmfStringData(""));
			string key = reader.ReadString();
			if (key.Length == 0)
			{
				throw new Exception("データ異常");
			}
			return new AmfObjectMember(key, ReadData(reader));
		}

		private static AmfObjectData ReadObjectData(BigendianReader reader,bool hasLength)
		{
			AmfObjectData obj = null;

			if (hasLength)
				obj = new AmfObjectData(reader.ReadUInt32());
			else
				obj = new AmfObjectData();
			while (true)
			{
				if (reader.BaseStream.Position >= reader.BaseStream.Length)
					break;
				string key = reader.ReadString();
				if (key.Length == 0)
				{
					if (reader.ReadByte() == 0x09)
						break;
					throw new Exception("データ異常");
				}
				obj.Members.Add(new AmfObjectMember(key, ReadData(reader)));
			}
			return obj;
		}
	}
}
