﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace NetMonitor.AmfFormat
{
	class BigendianReader :IDisposable
	{
		public BigendianReader(Stream st)
		{
			BaseStream = st;
		}
		public readonly Stream BaseStream;

		byte[] numBuf = new byte[8];
		public int ReadByte()
		{
			return BaseStream.ReadByte();
		}

		public UInt16 ReadUInt16()
		{
			if (BaseStream.Position >= BaseStream.Length)
				return 0;
			numBuf[1] = (byte)BaseStream.ReadByte();
			numBuf[0] = (byte)BaseStream.ReadByte();
			return BitConverter.ToUInt16(numBuf, 0);
		}

		public UInt32 ReadUInt32()
		{
			if (BaseStream.Position >= BaseStream.Length)
				return 0;
			numBuf[3] = (byte)BaseStream.ReadByte();
			numBuf[2] = (byte)BaseStream.ReadByte();
			numBuf[1] = (byte)BaseStream.ReadByte();
			numBuf[0] = (byte)BaseStream.ReadByte();
			return BitConverter.ToUInt32(numBuf, 0);
		}

		public double ReadDouble()
		{
			if (BaseStream.Position >= BaseStream.Length)
				return 0.0;
			byte[] buf = new byte[8];
			BaseStream.Read(buf, 0, 8);
			for (int i = 0; i < 8; i++)
				numBuf[i] = buf[7 - i];
			return BitConverter.ToDouble(numBuf, 0);
		}

		public string ReadString()
		{
			if (BaseStream.Position >= BaseStream.Length)
				return "";
			UInt16 length = ReadUInt16();
			if (length == 0)
				return "";
			byte[] buf = new byte[length];
			BaseStream.Read(buf, 0, length);
			return Encoding.UTF8.GetString(buf);
		}

		public void Dispose()
		{
			if(BaseStream != null)
				BaseStream.Dispose();
		}
	}
}
