﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NetMonitor.LoW.StaticData;

namespace NetMonitor.LoW.BattleData
{
	struct ExpectedDamage
	{
		public int Min;
		public int Max;
		public int Expected;
		public static ExpectedDamage operator+(ExpectedDamage x, ExpectedDamage y)
		{
			ExpectedDamage d = new ExpectedDamage();
			d.Min = x.Min + y.Min;
			d.Max = x.Max + y.Max;
			d.Expected = x.Expected + y.Expected;
			return d;
		}
		public const string Title = "  最小 - 期待値-  最大 ";
		public override string ToString()
		{
			return string.Format("{0,7}-{1,7}-{2,7}",Min,Expected,Max);
		}
	}

	abstract class AbstractIdealBattle
	{
		public const int MAX_NAME_COUNT = 24;

		//public readonly ExpectedDamage[,] damage = new ExpectedDamage[2, 5];
		public bool expected = false;
		public bool calced = false;

		public bool Doubt = false;
		public abstract string GetConsoleText();
		public abstract string GetTextBoxText();
		protected int[] m_DamageSimulate(int SimulateCount, Chara chara, BParameter defParam)
		{
			var rand = new MinorShift._Library.MTRandom();
			double atk, def, bal, per, cri, dmg;
			int[] cardOrder = new int[] { 0, 1, 2, 0, 1, 2 };
			double factor = 1;
			int[] sim = new int[SimulateCount];
			for (int trial = 0; trial < SimulateCount; trial++)
			{
				int MP = chara.Param.sp;
				sim[trial] = 0;
				//MP関係ないcharaだけ先に３回殴る
				if ((chara.Param.type == 1 && defParam.ability == BattleAbility.ImmuneToPhysical)
				|| (chara.Param.type != 1 && defParam.ability == BattleAbility.ImmuneToMagic))
				{
				}
				else
				{//無効でない場合のみ
					factor = chara.Param.element.GetElementFactor(defParam.element.type);
					bal = chara.Param.balance * 0.01;
					cri = chara.Param.critical * 0.01;
					if (chara.Param.type == 1)
					{
						atk = chara.Param.atk * factor;
						def = defParam.def;
					}
					else
					{
						atk = chara.Param.mag * factor;
						def = defParam.rst;
					}
					for (int atkNum = 0; atkNum < 3; atkNum++)
					{
						//クリティカル発動
						if (cri > rand.NextDouble())
						{
							dmg = atk * (1.0 - bal + bal * rand.NextDouble() * 2);
						}
						else
						{
							dmg = atk * (1.0 - bal + bal * rand.NextDouble() * 2) - def;
							if (dmg < 0.0)
								continue;
						}
						sim[trial] += (int)(dmg + 0.5);
					}
				}
				//カード攻撃順序(MP消費順)並び替え
				int n = cardOrder.Length;
				while (n > 1)
				{
					n--;
					int k = rand.Next(n + 1);
					int tmp = cardOrder[k];
					cardOrder[k] = cardOrder[n];
					cardOrder[n] = tmp;
				}
				for (int cardNum = 0; cardNum < cardOrder.Length; cardNum++)
				{
					Card card = chara.setcard[cardOrder[cardNum]];
					if (card == null)
						continue;
					if ((card.CardParam.type == 1 && defParam.ability == BattleAbility.ImmuneToPhysical)
					|| (card.CardParam.type != 1 && defParam.ability == BattleAbility.ImmuneToMagic))//無効
						continue;
					factor = card.CardParam.element.GetElementFactor(defParam.element.type);
					atk = card.CardParam.atk * factor;
					bal = card.CardParam.balance * 0.01;
					cri = card.CardParam.critical * 0.01;
					per = card.CardParam.s_per * 0.001;
					if (card.CardParam.type == 1)
					{
						def = defParam.def;
					}
					else
					{
						def = defParam.rst;
					}
					//スキル発動
					if (per > rand.NextDouble() && MP >= card.CardParam.sp)
					{
						MP -= card.CardParam.sp;
						atk = card.CardParam.satk * factor;
					}
					//クリティカル発動
					if (cri > rand.NextDouble())
					{
						dmg = atk * (1 - bal + bal * rand.NextDouble() * 2);
					}
					else
					{
						dmg = atk * (1 - bal + bal * rand.NextDouble() * 2) - def;
						if (dmg < 0)
							continue;
					}
					sim[trial] += (int)(dmg + 0.5);
				}

			}
			return sim;
		}
		protected ExpectedDamage[] m_ExpectedValue(Chara attacker, BParameter defParam)
		{
			ExpectedDamage[] damage = new ExpectedDamage[5];
			damage[0] = attacker.CalcExpected(defParam);
			for (int c = 0; c < 3; c++)
			{
				int j = c + 1;
				Card atkCard = attacker.setcard[c];
				if (atkCard == null)
				{
					damage[j] = new ExpectedDamage();
					continue;
				}
				damage[j] = atkCard.CalcExpected(defParam);
			}
			for (int j = 0; j < 4; j++)
			{
				damage[4] += damage[j];
				damage[4] += damage[j];
				if (j == 0)
					damage[4] += damage[j];
			}
			return damage;
		}
	}
}