﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NetMonitor.AmfFormat;

namespace NetMonitor.LoW
{
	class LBossList
	{
		public Dictionary<int, LBoss> List = new Dictionary<int, LBoss>();
		public LBoss LastLBoss = null;
		public string GetConsoleText()
		{
			StringBuilder sb = new StringBuilder();
			StringBuilder my_sb = new StringBuilder();
			foreach (KeyValuePair<int, LBoss> pair in List)
			{
				LBoss lboss = pair.Value;
				if (lboss.myself)
					sb.Append("[自引き]");
				else if (lboss.Info == LBossInfo.None || lboss.Info == LBossInfo.Unknown)
					sb.Append("[情報無]");
				else if (!lboss.readRecentDamage)
					sb.Append("[ 未読 ]");
				else if (lboss.req_damage <= lboss.my_damage)
					sb.Append("[達成済]");
				else if (lboss.req_damage - lboss.my_damage > lboss.hp - 1)
					sb.Append("[不可能]");
				else
					sb.Append("[未達成]");
				sb.Append(" ");
				sb.Append(lboss.NameWithAbl);
				if(lboss.max_hp > 0 && lboss.hp > 1)
					sb.Append(string.Format(" ({0,3}%)", lboss.hp*100 / lboss.max_hp));
				else if (lboss.hp == 1)
					sb.Append("(HP 1)");
				//if (!lboss.myself && lboss.owner != null)
				//{
				//    sb.Append(" from ");
				//    sb.Append(lboss.owner.chara_name);
				//}
				sb.Append(System.Environment.NewLine);
			}
			
			return sb.ToString();
		}
		public string GetTextBoxText()
		{
			StringBuilder sb = new StringBuilder();
			sb.Append("[大ボスリスト]");
			if (List.Count == 0)
			{
				sb.Append(" なし");
				return sb.ToString();
			}
			sb.Append("全"); sb.Append(List.Count); sb.Append("件 ");
			int i = 0;
			int j = 0;
			foreach (KeyValuePair<int, LBoss> pair in List)
			{
				LBoss lboss = pair.Value;
				if (lboss.myself) { }
				else if (lboss.Info == LBossInfo.None || lboss.Info == LBossInfo.Unknown) { }
				else if (!lboss.readRecentDamage) { j++; }
				else if (lboss.req_damage <= lboss.my_damage) { }
				else if (lboss.req_damage - lboss.my_damage > lboss.hp - 1)
				{ }
				else
				{ i++; }
			}
			if (j > 0)
			{
				sb.Append("未読"); sb.Append(j); sb.Append("件 ");
			}
			if (i > 0)
			{
				sb.Append("未報酬"); sb.Append(i); sb.Append("件 ");
			}
			return sb.ToString();
		}

		public void UpdateData(AmfData[] lbossObjArray, DateTime time)
		{
			Dictionary<int, LBoss> newLBossList = new Dictionary<int, LBoss>();
			foreach (AmfData amf in lbossObjArray)
			{
				LBoss lboss = null;
				AmfObjectData lboss_data = amf as AmfObjectData;
				if (lboss_data == null)
					continue;
				int ld_id = lboss_data.GetMember("ld_id").GetIntValue();
				if (List.ContainsKey(ld_id))
				{
					lboss = List[ld_id];
					lboss.UpdateDate(lboss_data, time);
				}
				else
				{
					lboss = LBoss.FromAmfObject(lboss_data, time);
				}
				newLBossList.Add(lboss.ld_id, lboss);
			}
			List.Clear();
			List = newLBossList;
		}

		public void Remove(LBoss lboss)
		{
			if (List.ContainsKey(lboss.ld_id))
				List.Remove(lboss.ld_id);
			if (LastLBoss != null && LastLBoss.ld_id == lboss.ld_id)
				LastLBoss = null;
		}

		public LBoss GetLBoss(AmfObjectData lboss_data, DateTime time)
		{
			LBoss lboss = null;
			int ld_id = lboss_data.GetMember("ld_id").GetIntValue();
			if (List.ContainsKey(ld_id))
			{
				lboss = List[ld_id];
				lboss.UpdateDate(lboss_data, time);
				return lboss;
			}
			lboss = LBoss.FromAmfObject(lboss_data, time);
			List.Add(lboss.ld_id, lboss);
			return lboss;
		}
	}
}
