﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using NetMonitor.View;
using NetMonitor.AmfFormat;

namespace NetMonitor.LoW.StaticData
{
	enum Element
	{
		None = 0,
		Earth = 1,
		Water = 2,
		Fire = 3,
		Wind = 4,
	}
	struct ElementStr
	{
		public Element type;
		public int num;

		public Element GetWeekElement()
		{
			switch (type)
			{
				case Element.None: return Element.None;
				case Element.Earth: return Element.Wind;
				case Element.Water: return Element.Earth;
				case Element.Fire: return Element.Water;
				case Element.Wind: return Element.Fire;
			}
			return Element.None;
		}
		public double GetAffinity(ElementStr rother)
		{
			if (type == Element.None || rother.type == Element.None)
				return 0.0;
			if (((int)rother.type) - ((int)type) == 1 || (type == Element.Wind && rother.type == Element.Earth))
				return (100 + num) / 100.0;
			if (((int)type) - ((int)rother.type) == 1 || (rother.type == Element.Wind && type == Element.Earth))
				return -((100 + rother.num) / 100.0);
			return 0.0;
		}
		public double GetElementFactor(Element def)
		{
			if (type == Element.None || def == Element.None || num == 0)
				return 1.0;
			if (((int)def) - ((int)type) == 1 || (type == Element.Wind && def == Element.Earth))
				return (100 + num) / 100.0;
			return 1.0;
		}
		public override string ToString()
		{
			StringBuilder sb = new StringBuilder();

			switch (type)
			{
				case Element.None: return "無   ";
				case Element.Earth: sb.Append("地");break;
				case Element.Water: sb.Append("水"); break;
				case Element.Fire: sb.Append("火");break;
				case Element.Wind:sb.Append("風") ;break;
			}
			sb.Append(string.Format("{0,3}", num));
			return sb.ToString();
		}



		public static ElementStr FromAmfObject(AmfObjectData obj)
		{
			ElementStr result = new ElementStr();
			foreach (AmfObjectMember mem in obj.Members)
			{
				switch (mem.Key)
				{
					case "type":
						{
							string name = ((AmfStringData)mem.Value).s;
							switch (name)
							{
								case "water": result.type = Element.Water; break;
								case "wind": result.type = Element.Wind; break;
								case "earth": result.type = Element.Earth; break;
								case "fire": result.type = Element.Fire; break;
							}
							break;
						}
					case "num": result.num = mem.Value.GetIntValue(); break;
				}
			}
			if (result.num == 0)
				result.type = Element.None;
			return result;
		}
	}

}
