﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NetMonitor.LoW.StaticData
{
	enum EquipmentArea
	{
		None = -1,
		r_hand = 0,
		l_hand = 1,
		body = 2,
	}

	class EquipmentStatic : AbstractLoWDataStatic
	{
		/// <summary>
		/// レアリティ
		/// マスクデータ
		/// </summary>
		public int item_rarity { get; set; }

		public EquipmentArea area { get; set; }

		public GrowthRate GRate;
		///// <summary>
		///// 物理 = 1,魔法 = 2
		///// 装備品に関してはこの項目は大した意味はない
		///// </summary>
		//public int item_type { get; set; }
		///// <summary>
		///// MP上昇量
		///// </summary>
		//public int sp { get; set; }
		///// <summary>
		///// 
		///// </summary>
		public int Lv制限 { get; set; }
		/// <summary>
		/// 最大強化値
		/// </summary>
		public int plus_max { get; set; }
		///// <summary>
		///// クリティカル
		///// </summary>
		//public int critical { get; set; }
		///// <summary>
		///// バランス
		///// </summary>
		//public int balance { get; set; }
		///// <summary>
		///// 攻撃力
		///// </summary>
		//public int atk { get; set; }
		///// <summary>
		///// 魔法攻撃力
		///// </summary>
		//public int mag { get; set; }
		///// <summary>
		///// 防御力
		///// </summary>
		//public int def { get; set; }
		///// <summary>
		///// 魔法防御力
		///// </summary>
		//public int rst { get; set; }


		//public double growthrate_atk { get; set; }
		//public double growthrate_mag { get; set; }
		//public double growthrate_def { get; set; }
		//public double growthrate_rst { get; set; }
		/// <summary>
		/// 売価
		/// </summary>
		public int sell_cost { get; set; }
		public override void ReadCsvLine(string[] tokens)
		{
			base.ReadCsvLine(tokens);
			int i = 6;


			switch (tokens[i++])
			{
				case "右手": area = EquipmentArea.r_hand; break;
				case "左手": area = EquipmentArea.l_hand; break;
				case "体": area = EquipmentArea.body; break;
				default:
					Doubt = true;
					area = EquipmentArea.None;
					break;
			}
			switch (tokens[i++])
			{
				case "剣":
				case "盾":
				case "鎧":
					Param.type = 1; break;

				case "杖":
				case "腕輪":
				case "服":
				Param.type = 2; break;
				default:
					Doubt = true;
					Param.type = -1;
					break;
			}
			Param.sp = int.Parse(tokens[i++]);
			Lv制限 = int.Parse(tokens[i++]);
			Param.critical = int.Parse(tokens[i++]);
			Param.balance = int.Parse(tokens[i++]);
			Param.atk = int.Parse(tokens[i++]);
			Param.mag = int.Parse(tokens[i++]);
			Param.def = int.Parse(tokens[i++]);
			Param.rst = int.Parse(tokens[i++]);
			if (tokens.Length > i && tokens[i].Length > 0)
			{
				GRate.atk = double.Parse(tokens[i++]);
				GRate.mag = double.Parse(tokens[i++]);
				GRate.def = double.Parse(tokens[i++]);
				GRate.rst = double.Parse(tokens[i++]);
				sell_cost = int.Parse(tokens[i++]);
			}
			else
			{
				m_SetGrowthRate();
			}
		}

		public void m_SetGrowthRate()
		{
			switch(area)
			{
				case EquipmentArea.r_hand:
					if (Param.type == 1)
					{
						GRate.atk = 0.05;
					}
					else
					{
						GRate.mag = 0.05;
					}
					break;
				case EquipmentArea.l_hand:
					if (Param.type == 1)
					{
						GRate.def = 0.02;
						GRate.rst = 0.03;
					}
					else
					{
						GRate.def = 0.03;
						GRate.rst = 0.02;
					}
					break;
				case EquipmentArea.body:
					if (Param.type == 1)
					{
						GRate.def = 0.05;
						GRate.rst = 0.02;
					}
					else
					{
						GRate.def = 0.02;
						GRate.rst = 0.05;
					}
					break;
			}
		}

		public override string GetDictionaryKey()
		{
			return name;
		}
	}
}
