﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Net.Sockets;
using System.IO;
using PacketDotNet;
using SharpPcap;



namespace NetMonitor.Network
{
	class PacketCapture : IDisposable
	{
		/// <summary>
		/// DllNotFoundException
		/// 
		/// </summary>
		public void Open()
		{
			foreach (ICaptureDevice d in CaptureDeviceList.Instance)
			{
				IList<SharpPcap.LibPcap.PcapAddress> addr = null;
				if (d is SharpPcap.AirPcap.AirPcapDevice)
				{
					addr = ((SharpPcap.AirPcap.AirPcapDevice)d).Addresses;
				}
				else if (d is SharpPcap.WinPcap.WinPcapDevice)
				{
					addr = ((SharpPcap.WinPcap.WinPcapDevice)d).Addresses;
				}
				else if (d is SharpPcap.LibPcap.LibPcapLiveDevice)
				{
					addr = ((SharpPcap.LibPcap.LibPcapLiveDevice)d).Addresses;
				}
				if (addr != null && addr.Count > 0)
				{

					for (int i = 0; i < addr.Count; i++)
					{
						if (addr[i] == null || addr[i].Addr == null || addr[i].Addr.ipAddress == null)
							continue;
						if (localIP != null)
						{
							if(addr[i].Addr.ipAddress.ToString() == localIP.ToString())
							{
								localIP = addr[i].Addr.ipAddress;
								device = d;
								goto devicefound;
							}
						}
						else if (addr[i].Addr.ipAddress.AddressFamily == AddressFamily.InterNetwork)
						{
							if (addr[i].Addr.ipAddress.ToString() == "0.0.0.0")
								continue;
							localIP = addr[i].Addr.ipAddress;
							device = d;
							goto devicefound;
						}
					}
				}
			}
devicefound:
			if (device == null || localIP == null)
			{
				throw new Exception("適切なデバイスが見つかりません");
			}
			// ハンドラ設定
			device.OnPacketArrival += OnPacketArrival;

			// デバイスオープン
			int readTimeoutMilliseconds = 1000;
			if (device is SharpPcap.AirPcap.AirPcapDevice)
			{
				// NOTE: AirPcap devices cannot disable local capture
				var airPcap = device as SharpPcap.AirPcap.AirPcapDevice;
				airPcap.Open(SharpPcap.WinPcap.OpenFlags.DataTransferUdp, readTimeoutMilliseconds);
			}
			else if (device is SharpPcap.WinPcap.WinPcapDevice)
			{
				var winPcap = device as SharpPcap.WinPcap.WinPcapDevice;
				winPcap.Open(SharpPcap.WinPcap.OpenFlags.DataTransferUdp | SharpPcap.WinPcap.OpenFlags.NoCaptureLocal, readTimeoutMilliseconds);
			}
			else if (device is SharpPcap.LibPcap.LibPcapLiveDevice)
			{
				var livePcapDevice = device as SharpPcap.LibPcap.LibPcapLiveDevice;
				livePcapDevice.Open(DeviceMode.Promiscuous, readTimeoutMilliseconds);
			}
			else
			{
				throw new System.InvalidOperationException("unknown device type of " + device.GetType().ToString());
			}
			//フィルター設定 IP/TCPのみ
			device.Filter = "ip and tcp";
			deviceOpened = true;
		}
		public volatile bool captureRunning = false;
		private volatile bool deviceOpened = false;
		ICaptureDevice device;
		public void Start()
		{
			// キャプチャ開始
			device.StartCapture();
			captureRunning = true;
		}

		public void Stop()
		{
			// キャプチャ停止
			device.StopCapture();
			captureRunning = false;
		}
		public DatagramList list = new DatagramList();
		public IPAddress localIP;

		public IPAddress targetServer;
		public void SetIP(string target, string local)
		{
			if(local == null)
				localIP = null;
			else
				localIP =  IPAddress.Parse(local);
			if(target == null)
				targetServer = null;
			else
				targetServer =  IPAddress.Parse(target);
		}
		
		// イベントハンドラ
		private void OnPacketArrival(object sender, CaptureEventArgs e)
		{
			DateTime time = TimeZoneInfo.ConvertTimeFromUtc(e.Packet.Timeval.Date, TimeZoneInfo.Local);
			//			int len = e.Packet.Data.Length;
			Packet packet = PacketDotNet.Packet.ParsePacket(e.Packet.LinkLayerType, e.Packet.Data);
			IpPacket ipPacket = (IpPacket)packet.PayloadPacket as IpPacket;
			TcpPacket tcpPacket = ipPacket.PayloadPacket as TcpPacket;
			if (tcpPacket == null)
				return;
			if (tcpPacket.Syn)
				return;
			if (ipPacket.DestinationAddress.ToString() != localIP.ToString())
				return;
			if (ipPacket.SourceAddress.ToString() != targetServer.ToString())
				return;
			list.AddSegment(new TCPSegment(tcpPacket, time));
			list.SeekComplete();

			//TcpPacket tcpPacket = PacketDotNet.TcpPacket.GetEncapsulated(packet);

		}



		public void Dispose()
		{
			if (captureRunning)
				device.StopCapture();
			captureRunning = false;
			if(deviceOpened)
				device.Close();
			deviceOpened = false;

		}
	}
}