﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PacketDotNet;
using System.IO;

namespace NetMonitor.Network
{
	class TCPSegment : IComparable<TCPSegment>
	{
		public TCPSegment(TcpPacket tcpPacket, DateTime time)
		{
			RecievedTime = time;
			SequenceNumber = tcpPacket.SequenceNumber;
			if (tcpPacket.Ack)
				AcknowledgmentNumber = tcpPacket.AcknowledgmentNumber;
			else
				AcknowledgmentNumber = 0;
			FlagFIN = tcpPacket.Fin;
			HasHttpHeader = false;
			IpPacket ipPacket = (IpPacket)tcpPacket.ParentPacket;
			//            seg.hasHttpHeader = false;
			//HTTP Responseのみ取り扱う
			//byte[] buf = tcpPacket.PayloadData;

			int length = ipPacket.TotalLength;// +14;
			int offset = 0;
			//offset += 14;
			offset += ipPacket.HeaderLength * 4 + tcpPacket.DataOffset * 4;
			if (offset >= length)
			{
				Payload = null;
				return;
			}
			byte[] buf = tcpPacket.ParentPacket.Bytes;
			
			if (buf != null && buf.Length > 4 && buf[offset] == 0x48 && buf[offset + 1] == 0x54 && buf[offset + 2] == 0x54 && buf[offset + 3] == 0x50)
			{
				int httpLength = 0;
				HttpHeader = new HttpHeader();
				MemoryStream st = new MemoryStream(buf);
				st.Seek(offset, SeekOrigin.Begin);
				StreamReader reader = null;
				using (reader = new StreamReader(st, Encoding.GetEncoding("SHIFT-JIS")))
				{
					string line = null;
					while (true)
					{
						line = reader.ReadLine();
						if (line == null || line.Length == 0)
							break;
						httpLength += 1 + line.Length;
						if (line.StartsWith("Content-Type:", StringComparison.OrdinalIgnoreCase))
						{
							line = line.Substring("Content-Type:".Length);
							HttpHeader.ContentType = line.Trim();
						}
						else if (line.StartsWith("Content-Length:", StringComparison.OrdinalIgnoreCase))
						{
							line = line.Substring("Content-Length:".Length);
							HttpHeader.ContentLength = int.Parse(line.Trim());
						}
						else if (line.StartsWith("Content-Encoding:", StringComparison.OrdinalIgnoreCase))
						{
							line = line.Substring("Content-Encoding:".Length);
							HttpHeader.ContentEncoding = line.Trim();
						}
						int index = line.IndexOf(':');
					}
				}
				HasHttpHeader = true;
				offset += httpLength;
				bool returnCode = false;
				while (true)
				{
					if(offset+1 >= length)
					{
						offset = length;
						break;
					}
					if (buf[offset] == 0x0D && buf[offset + 1] == 0x0A)
					{
						offset += 2;
						if (returnCode)
							break;
						returnCode = true;
					}
					else if (buf[offset] == 0x0D || buf[offset] == 0x0A)
					{
						offset++;
						if (returnCode)
							break;
						returnCode = true;
					}
					else
					{
						offset++;
						returnCode = false;
					}
				}
			}
			if (buf != null)
			{
				if (offset == 0)
					Payload = buf;
				else if (length > offset)
				{
					Payload = new byte[length - offset];
					Array.Copy(buf, offset, Payload, 0, Payload.Length);
				}
			}
		}
		public DateTime RecievedTime;
		public bool HasHttpHeader;
		public HttpHeader HttpHeader;
		public byte[] Payload;
		public UInt32 SequenceNumber;
		public UInt32 AcknowledgmentNumber;
		public bool FlagFIN;

		public Int32 CompareTo(TCPSegment rother)
		{
			return this.SequenceNumber.CompareTo(rother.SequenceNumber);
		}

		public override string ToString()
		{
			StringBuilder sb = new StringBuilder();
			if (FlagFIN)
				sb.Append("<FIN> ");
			if (HasHttpHeader)
				sb.Append("<Http>");
			sb.Append("S.Num = ");
			sb.Append(SequenceNumber.ToString());
			sb.Append(": PLLength = ");
			if(Payload != null)
				sb.Append(Payload.Length.ToString());
			else
				sb.Append("null");
			return sb.ToString();
		}

	}
}
