﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NetMonitor.LoW.StaticData;
using NetMonitor.AmfFormat;

namespace NetMonitor.LoW
{
	struct ActionParam
	{
		public int now;
		public int max;
		public int next_up;
		public DateTime update;
		public int Current
		{
			get
			{
				int result = now;
				TimeSpan time = DateTime.Now - update;
				int i = (int)time.TotalMinutes;
				if (time.Seconds > next_up)
					i++;
				if (i > 0)
				{
					result += i;
					if (result > max)
						return max;
				}
				return result;
			}
		}
	
		public static ActionParam FromAmfObject(AmfObjectData obj, DateTime updateTime)
		{
			ActionParam result = new ActionParam();
			result.update = updateTime;
			foreach (AmfObjectMember mem in obj.Members)
			{
				switch (mem.Key)
				{
					case "now": result.now = mem.Value.GetIntValue(); break;
					case "max": result.max = mem.Value.GetIntValue(); break;
					case "next_up": result.next_up = mem.Value.GetIntValue(); break;
				}
			}
			return result;
		}
	}
}
