﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NetMonitor.LoW.StaticData;
using NetMonitor.AmfFormat;

namespace NetMonitor.LoW.BattleData
{
	class Attack
	{
		public int action;
		public ElementStr element;
		public int atk;
		public bool skill = false;
		public string skill_name = null;
		//検証用
		public double bal;
		public int isCri;
		public string name = "";
		public double EF;
		public bool mgc;
		public bool Doubt;
		public bool immune;
		public static readonly string Title = "Ok/Ty/" +new string(' ',IdealTowerBattle.MAX_NAME_COUNT)  + "damage/ EF/Sk/cri/  bal";
		public string ToDebugString()
		{
			StringBuilder sb = new StringBuilder();
			if (Doubt)
				sb.Append("×/");
			else
				sb.Append("○/");
			if (mgc)
				sb.Append("魔/");
			else
				sb.Append("物/");
			sb.Append(name);
			int wordCount = MinorShift._Library.LangManager.GetStrlenLang(name);
			if (wordCount < IdealTowerBattle.MAX_NAME_COUNT)
				sb.Append(new string(' ', IdealTowerBattle.MAX_NAME_COUNT - wordCount));

			sb.Append(string.Format("{0,6}/",atk));
			if(immune)
			{
				sb.Append("[無効]");
				return sb.ToString();
			}
			sb.Append(string.Format("{0,3:0.0}/",EF));
			if (skill)
				sb.Append("Sk/");
			else
				sb.Append("No/");
			if (isCri == 0)
				sb.Append(" No/");
			else if (isCri == 1)
				sb.Append(" ？/");
			else if (isCri == 2)
				sb.Append("Yes/");
			sb.Append(string.Format("{0,5:##0.0}",bal * 100));
			return sb.ToString();
		}
		
		
		
		
		public static Attack FromAmfbject(AmfObjectData obj)
		{
			Attack result = new Attack();
			AmfObjectData element = null;
			foreach (AmfObjectMember mem in obj.Members)
			{
				switch (mem.Key)
				{
					case "action": result.action = mem.Value.GetIntValue(); break;
					case "element": element = (AmfObjectData)mem.Value; break;
					case "skill": result.skill = mem.Value.GetBooleanValue(); break;
					case "skill_name": result.skill_name = ((AmfStringData)mem.Value).s; break;
					case "atk": result.atk =mem.Value.GetIntValue();break;
				}
			}
			if (element != null)
			{
				foreach (AmfObjectMember mem in element.Members)
				{
					switch (mem.Key)
					{
						case "type":
							{
								string name = ((AmfStringData)mem.Value).s;
								switch (name)
								{
									case "water": result.element.type = Element.Water; break;
									case "wind": result.element.type = Element.Wind; break;
									case "earth": result.element.type = Element.Earth; break;
									case "fire": result.element.type = Element.Fire; break;
								}
								break;
							}
						case "num": result.element.num = mem.Value.GetIntValue(); break;
					}
				}
				if (result.element.num == 0)
					result.element.type = Element.None;
			}
			
			return result;
		}
		public override string ToString()
		{
			StringBuilder sb = new StringBuilder();
			sb.Append("[");
			sb.Append(action.ToString());
			sb.Append("]");
			sb.Append(string.Format("{0,5}:",atk));
			sb.Append(element.type.ToString());
			sb.Append(element.num.ToString());
			if (skill)
			{
				sb.Append("<");
				sb.Append(skill_name);
				sb.Append(">");
			}

			return sb.ToString();
		}
	}
}
