﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NetMonitor.AmfFormat;

namespace NetMonitor.LoW.BattleData
{
	enum BattleType
	{
		None,
		Tower,
		LBoss,
	}
	class BattleResult
	{
		public bool win;
		public bool finish;
		//public ??? get_award;
		public int hp_diff;//???
		public int award_no;//???
		public Attack[] attack;
		public Attack[] e_attack;
		public Card[] setcard;
		public Card[] e_setcard;
		public BattleType type;
		public string TextBoxText = "";
		public string Confirm(IdealLBossBattle ideal)
		{
			if (ideal == null)
				return null;
			if (string.IsNullOrEmpty(ideal.chara.chara_name))
				return null;
			if (type != BattleType.LBoss)
				return null;
			if (attack == null || e_attack != null || e_setcard != null)
				return null;

			StringBuilder sb = new StringBuilder();
#if DEBUG

			for (int i = 0; i < 3; i++)
			{
				Card idealCard = ideal.chara.setcard[i];
				Card realCard = setcard[i];
				if (idealCard == null || realCard == null)
					continue;
				sb.Append(idealCard.NameWithClass); sb.Append(System.Environment.NewLine);
				sb.Append(string.Format("lv   = {0,5}/{1,5}", idealCard.card_lv, realCard.card_lv)); sb.Append(System.Environment.NewLine);
				sb.Append(string.Format("addatk={0,5}/{1,5}", idealCard.AddParam.atk, realCard.AddParam.atk)); sb.Append(System.Environment.NewLine);
				sb.Append(string.Format("atk  = {0,5}/{1,5}", idealCard.CardParam.atk, realCard.CardParam.atk)); sb.Append(System.Environment.NewLine);
				sb.Append(string.Format("satk = {0,5}/{1,5}", idealCard.CardParam.satk, realCard.CardParam.satk)); sb.Append(System.Environment.NewLine);
			}
			sb.Append(System.Environment.NewLine);
#endif
			sb.Append(Attack.Title);sb.Append(System.Environment.NewLine);
			sb.Append(" -You-      ");
			int damage = Confirm_sub(sb, attack, setcard, ideal.chara, ideal.lboss.Param);
			sb.Append(string.Format("your atk = {0}", damage));
			switch (ideal.goal)
			{
				case LBossGoal.Reward:
					{
						int v = ideal.lboss.req_damage - (ideal.lboss.my_damage + damage);
						if (v < 0)
							TextBoxText = "[大ボスログ] 報酬ライン達成";
						else
							TextBoxText = "[大ボスログ] 報酬ラインまであと " + v.ToString();
					}
					break;
				case LBossGoal.HP1:
					{
						int v = ideal.lboss.hp - damage - 1;
						if (v <= 0)
							TextBoxText = "[大ボスログ] HP1";
						else
							TextBoxText = "[大ボスログ] HP1まであと " + v.ToString();
					}
					break;
				case LBossGoal.Kill:
					{
						if (win)
							TextBoxText = "[大ボスログ] 撃破";
						else
							TextBoxText = "[大ボスログ] 撃破まであと " + (ideal.lboss.hp - damage).ToString();
					}
					break;
				default:
					{
						TextBoxText = "[大ボスログ] ダメージ " + damage.ToString();
					}
					break;
			}
			ideal.lboss.AddDamageLog(damage);
			if (win)
			{
				ideal.lboss.hp = 0;
				MainData.LBossList.Remove(ideal.lboss);
			}
			else if (ideal.lboss.hp <= 0)
				ideal.lboss.hp = 1;
			ideal.calcReward();
			return sb.ToString();
		}

		public string Confirm(IdealTowerBattle ideal)
		{
			if (ideal == null)
				return null;
			if (string.IsNullOrEmpty(ideal.chara[0].chara_name))
				return null;
			if (type != BattleType.Tower)
				return null;
			if (attack == null || e_attack == null)
				return null;

			StringBuilder sb = new StringBuilder();
#if DEBUG
			for (int atkID = 0; atkID < 2; atkID++)
			{
				Card[] cards = atkID == 0 ? setcard : e_setcard;
				Chara attacker = ideal.chara[atkID];

				for (int i = 0; i < 3; i++)
				{
					Card idealCard = attacker.setcard[i];
					Card realCard = cards[i];
					if (idealCard == null || realCard == null)
						continue;
					sb.Append(idealCard.NameWithClass); sb.Append(System.Environment.NewLine);
					sb.Append(string.Format("lv   = {0,5}/{1,5}", idealCard.card_lv, realCard.card_lv)); sb.Append(System.Environment.NewLine);
					sb.Append(string.Format("addatk={0,5}/{1,5}", idealCard.AddParam.atk, realCard.AddParam.atk)); sb.Append(System.Environment.NewLine);
					sb.Append(string.Format("atk  = {0,5}/{1,5}", idealCard.CardParam.atk, realCard.CardParam.atk)); sb.Append(System.Environment.NewLine);
					sb.Append(string.Format("satk = {0,5}/{1,5}", idealCard.CardParam.satk, realCard.CardParam.satk)); sb.Append(System.Environment.NewLine);
				}
			}
			sb.Append(System.Environment.NewLine);
#endif
			sb.Append(Attack.Title); sb.Append(System.Environment.NewLine);
			int[] damage = new int[2];
			sb.Append(" -You-      ");
			damage[0] = Confirm_sub(sb, attack, setcard, ideal.chara[0], ideal.chara[1].Param);
			sb.Append(" -Opponent- ");
			damage[1] = Confirm_sub(sb, e_attack, e_setcard, ideal.chara[1], ideal.chara[0].Param);
			sb.Append(string.Format("your atk = {0}, damage = {1}", damage[0], damage[1]));
			if (win)
				TextBoxText = "[対戦ログ] you win.";
			else
				TextBoxText = "[対戦ログ] you lose.";
			return sb.ToString();
		}
		
		private int Confirm_sub(StringBuilder sb, Attack[] mess, Card[] cards, Chara attacker, BParameter defParam)
		{
			int damage = 0;
			int mp = attacker.Param.sp;
			if (attacker.Param.type == 1)
				sb.Append(string.Format(" ATK{0,5}/", attacker.Param.atk));
			else
				sb.Append(string.Format(" MAG{0,5}/", attacker.Param.mag));
			sb.Append(string.Format("DEF{0,5}/RST{1,5}", attacker.Param.def, attacker.Param.rst));
			sb.Append(System.Environment.NewLine);
			foreach(Attack atkdata in mess)
			{
				BParameter Param;
				double atk, def, bal, cri;
				if (atkdata.action == 0)
				{
					Param = attacker.Param;
					atkdata.name = attacker.chara_name;
				}
				else
				{
					Card card = cards[atkdata.action - 1];
					if (card == null)
					{
						atkdata.Doubt = true;
						atkdata.name = "null";
						goto atkend;
					}
					Param = card.CardParam;
					atkdata.name = card.NameWithClass;
				}
				if (atkdata.skill)
				{
					atk = Param.satk;
					mp -= Param.sp;
				}
				else
					atk = Param.atk;
				if (Param.type == 1)
				{
					atkdata.mgc = false;
					def = defParam.def;
					if (defParam.ability == BattleAbility.ImmuneToPhysical)
					{
						atkdata.immune = true;
						if (atkdata.atk != 0)
							atkdata.Doubt = true;
						goto atkend;
					}
				}
				else
				{
					if (atkdata.action == 0)
					{
						atk = Param.mag;
					}
					atkdata.mgc = true;
					def = defParam.rst;
					if (defParam.ability == BattleAbility.ImmuneToMagic)
					{
						atkdata.immune = true;
						if (atkdata.atk != 0)
							atkdata.Doubt = true;
						goto atkend;
					}
				}
				atkdata.EF = Param.element.GetElementFactor(defParam.element.type);
				atk *= atkdata.EF;
				bal = Param.balance * 0.01;
				cri = Param.critical * 0.01;
				//if(atkdata.atk < atk * (1.0 - bal) - def)
				//{
				//    atkdata.Doubt = true;
				//    goto atkend;
				//}
				if (atkdata.atk == 0)
				{
					atkdata.isCri = 0;
					atkdata.bal = (((double)def) / atk - 1.0);
					if (atkdata.bal > bal)
						atkdata.bal = bal;
					if (atkdata.bal < -bal)
						atkdata.Doubt = true;
					goto atkend;
				}
				if(atkdata.atk > atk * (1.0 + bal) - def)
					atkdata.isCri = 2;
				else if(atkdata.atk > atk * (1.0 - bal))
					atkdata.isCri = 1;
				if (atkdata.isCri == 2)
				{
					atkdata.bal = (((double)atkdata.atk) / atk - 1.0);
				}
				else
				{
					atkdata.bal = (((double)atkdata.atk+def) / atk - 1.0);
				}
				if (atkdata.bal < -bal || atkdata.bal > bal)
					atkdata.Doubt = true;

			atkend:
				damage += atkdata.atk;
				sb.Append(atkdata.ToDebugString()); sb.Append(System.Environment.NewLine);
			}
			if(mp < 0)
			{
				sb.Append("×MP上限を超えるスキルが発動しました  "+ mp.ToString() + "/"+ attacker.Param.sp.ToString());sb.Append(System.Environment.NewLine);
			}
			return damage;
		}
		
		public int TotalDamage
		{
			get
			{
				if (attack == null)
					return 0;
				int total = 0;
				foreach (Attack atk in attack)
					total += atk.atk;
				return total;
			}
		}
		public int E_TotalDamage
		{
			get
			{
				if (e_attack == null)
					return 0;
				int total = 0;
				foreach (Attack atk in e_attack)
					total += atk.atk;
				return total;
			}
		}
		public static BattleResult FromAmfObject(AmfObjectData obj)
		{
			BattleResult result = new BattleResult();
			foreach (AmfObjectMember mem in obj.Members)
			{
				switch (mem.Key)
				{
					case "win": result.win = mem.Value.GetBooleanValue(); break;
					case "finish": result.finish = mem.Value.GetBooleanValue(); break;
					case "hp_diff": result.hp_diff = mem.Value.GetIntValue(); break;
					case "award_no": result.award_no = mem.Value.GetIntValue(); break;
					case "battle":
					{
						AmfArrayData attackArray = ((AmfObjectData)mem.Value).GetMember("attack") as AmfArrayData;
						Attack[] attack = new Attack[attackArray.Array.Length];
						for (int i = 0; i < attack.Length; i++)
							attack[i] = Attack.FromAmfbject((AmfObjectData)attackArray.Array[i]);
						result.attack = attack;
						result.type = BattleType.LBoss;
						attackArray = ((AmfObjectData)mem.Value).GetMember("e_attack") as AmfArrayData;
						if (attackArray != null)
						{
							attack = new Attack[attackArray.Array.Length];
							for (int i = 0; i < attack.Length; i++)
								attack[i] = Attack.FromAmfbject((AmfObjectData)attackArray.Array[i]);
							result.e_attack = attack;
							result.type = BattleType.Tower;
						}
					}
					break;
					case "setcards":
					{
						AmfArrayData setcardArray = ((AmfObjectData)mem.Value).GetMember("setcard") as AmfArrayData;
						Card[] cards = new Card[3];
						for (int i = 0; i < cards.Length && i < setcardArray.Array.Length; i++)
							cards[i] = Card.FromAmfObject((AmfObjectData)setcardArray.Array[i]);
						result.setcard = cards;
						setcardArray = ((AmfObjectData)mem.Value).GetMember("e_setcard") as AmfArrayData;
						if (setcardArray != null)
						{
							cards = new Card[3];
							for (int i = 0; i < cards.Length && i < setcardArray.Array.Length; i++)
								cards[i] = Card.FromAmfObject((AmfObjectData)setcardArray.Array[i]);
							result.e_setcard = cards;
						}
					}
					break;
				}
			}
			return result;
		}
	}
}
