﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NetMonitor.LoW.BattleData
{
	enum LBossGoal
	{
		None,
		Kill,
		HP1,
		Reward,
	}
	
	class IdealLBossBattle : AbstractIdealBattle
	{
		public readonly Chara chara;
		public readonly LBoss lboss;
		public LBossGoal goal;
		public IdealLBossBattle(Chara me, LBoss target)
		{
			chara = me;
			lboss = target;
			calcReward();
			
		}
		public void calcReward()
		{
			if (lboss.myself)//とどめを刺す
			{
				goal = LBossGoal.Kill;
				rewardLeft = lboss.hp;
			}
			else if (lboss.req_damage > lboss.my_damage && (lboss.req_damage - lboss.my_damage) < lboss.hp-1)//報酬ラインまで
			{
				goal = LBossGoal.Reward;
				rewardLeft = lboss.req_damage - lboss.my_damage;
			}
			else //HP1まで削る
			{
				goal = LBossGoal.HP1;
				rewardLeft = lboss.hp - 1;
			}
			if (rewardLeft <= 0)
			{
				goal = LBossGoal.None;
			}
			
		}
		public double[] req_AtkNum = new double[10];
		public double ave_AtkNum;
		public double mid_AtkNum;
		public ExpectedDamage[] damage = new ExpectedDamage[5];
		public int rewardLeft = -1;
		//ExpectedDamage[] DamAve = new ExpectedDamage[2];
		public override string GetConsoleText()
		{
			StringBuilder sb = new StringBuilder();
			if (string.IsNullOrEmpty(chara.chara_name))
			{
				sb.Append("情報不足により計算不能"); sb.Append(System.Environment.NewLine);
				sb.Append("自分の情報がありません"); sb.Append(System.Environment.NewLine);
				sb.Append("装備、街に戻る等をクリックして情報を更新して下さい");
				return sb.ToString();
			}
			if (!chara.cardInfoComplete)
			{
				sb.Append("◆自己カードの育成情報がありません(最良育成を仮定)"); sb.Append(System.Environment.NewLine);
			}
			if (lboss.StaticData == null)
			{
				sb.Append("◆大ボスのcsvデータがありません"); sb.Append(System.Environment.NewLine);
			}
			else if (lboss.Doubt)
			{
				sb.Append("◆大ボスのcsvデータが不完全または矛盾しています"); sb.Append(System.Environment.NewLine);

			}
			sb.Append("※期待値の計算にはMPを考慮しません"); sb.Append(System.Environment.NewLine);
			if(lboss.owner != null)
			{
				sb.Append(lboss.owner.chara_name);
				sb.Append(" からの応援依頼"); sb.Append(System.Environment.NewLine);
			}
			sb.Append(chara.chara_name);
			sb.Append(" (");
			sb.Append(chara.Param.element.ToString());
			sb.Append(") vs ");
			sb.Append(lboss.lboss_name);
			sb.Append(" (");
			sb.Append(lboss.Param.element.ToString());
			sb.Append(") :");
			sb.Append(System.Environment.NewLine);

			Chara attacker = chara;
			string name = "";

			for (int i = -1; i < 5; i++)
			{
				int wordCount = 0;

				if (i == -1)
				{
					name = " -You- ";
				}
				else if (i == 0)
					name = attacker.chara_name;
				else if (i == 4)
					name = "合計";
				else
				{
					Card card = attacker.setcard[i - 1];
					if (card == null)
					{
						sb.Append("(カードなし)");
						sb.Append(System.Environment.NewLine);
						continue;
					}
					name = card.NameWithClass;
					if (card.Info == CardInfo.Unknown)
					{
						sb.Append(name);
						sb.Append("(csvデータなし)");
						sb.Append(System.Environment.NewLine);
						continue;
					}
				}
				sb.Append(name);
				wordCount = MinorShift._Library.LangManager.GetStrlenLang(name);
				if (wordCount < MAX_NAME_COUNT)
					sb.Append(new string(' ', MAX_NAME_COUNT - wordCount));
				if (i == -1)
					sb.Append(ExpectedDamage.Title);
				else
				{
					sb.Append(damage[i].ToString());
					if (i == 0)
						sb.Append(" * 3");
					else if (i != 4)
						sb.Append(" * 2");
				}

				sb.Append(System.Environment.NewLine);
			}
			sb.Append(" -Boss- ");sb.Append(System.Environment.NewLine);


			sb.Append(lboss.NameWithAbl);sb.Append(System.Environment.NewLine);
			int persent = 100;
			if(lboss.max_hp > 0)
			{
				persent = lboss.hp*100 / lboss.max_hp;
				if (persent == 0)
					persent = 1;
			}
			sb.Append(string.Format("HP/MHP     = {0,9}/{1,9} ({2,3}%)", lboss.hp, lboss.max_hp, persent)); sb.Append(System.Environment.NewLine);
			sb.Append(string.Format("your atk   = {0,9}", lboss.my_damage));
			if (!lboss.myself && lboss.Info == LBossInfo.Calculated && lboss.req_damage <= lboss.my_damage)
				sb.Append(" *報酬ライン達成済*");
			sb.Append(System.Environment.NewLine);
			if (goal == LBossGoal.None)
				return sb.ToString();
			else if (goal == LBossGoal.Reward)
				sb.Append("報酬ラインまであと ");
			else if (goal == LBossGoal.Kill)
				sb.Append("撃破まであと ");
			else if (goal == LBossGoal.HP1)
				sb.Append("HP1 まであと ");
			sb.Append(rewardLeft); sb.Append(System.Environment.NewLine);
			if (double.IsPositiveInfinity(ave_AtkNum))
				sb.Append("不可能");
			else if (double.IsNegativeInfinity(ave_AtkNum))
				sb.Append("一確");
			else
			{
				sb.Append(rewardLeft); sb.Append(System.Environment.NewLine);
				for (int i = 0; i < req_AtkNum.Length; i++)
				{
					if (req_AtkNum[i] == 0.0)
						continue;
					if (i == req_AtkNum.Length - 1)
						sb.Append(string.Format("{0,2}撃以上 {1,4:0.0}%", i + 1, req_AtkNum[i] * 100));
					else
						sb.Append(string.Format("{0,2}撃     {1,4:0.0}%", i + 1, req_AtkNum[i] * 100));
					if (i == mid_AtkNum)
						sb.Append(" *中央値*");
					sb.Append(System.Environment.NewLine);
				}
			}
			sb.Append(System.Environment.NewLine);
			//sb.Append("your atk    = "); sb.Append(new string(' ', MAX_NAME_COUNT - "your atk    = ".Length)); sb.Append(DamAve[0].ToString()); sb.Append(System.Environment.NewLine);
			//sb.Append("your damage = "); sb.Append(new string(' ', MAX_NAME_COUNT - "your damage = ".Length)); sb.Append(DamAve[1].ToString()); sb.Append(System.Environment.NewLine);
			sb.Append(GetTextBoxText()); sb.Append(System.Environment.NewLine);
			return sb.ToString();
		}
		
		public override string GetTextBoxText()
		{
			StringBuilder sb = new StringBuilder();
			sb.Append("[大ボス]");
			if (!calced && goal != LBossGoal.None)
			{
				sb.Append(" (情報不足)");
				return sb.ToString();
			}
			if (lboss.myself)
				sb.Append("[自引き]");
			else if (lboss.req_damage <= lboss.my_damage)
				sb.Append("[済]");
			else if ((lboss.req_damage - lboss.my_damage) > lboss.hp -1)
				sb.Append("[不可]");
			else
				sb.Append("[未]");
			if (goal == LBossGoal.None)
			{
				sb.Append(" 目標なし");
				return sb.ToString();
			}
			else if (goal == LBossGoal.Kill)
				sb.Append(" 撃破まで ");
			else if (goal == LBossGoal.Reward)
				sb.Append(" 報酬ラインまで ");
			else
				sb.Append(" HP1まで ");

			if (double.IsPositiveInfinity(ave_AtkNum))
				sb.Append("不可能");
			else if (double.IsNegativeInfinity(ave_AtkNum))
				sb.Append("一確");
			else if (ave_AtkNum > 100)
				sb.Append("100撃以上");
			else
				sb.Append(string.Format("平均 {0,5:#0.00}撃", ave_AtkNum));
				
			if (Doubt)
			{
				sb.Append(" (csvデータ不足)");
			}
			return sb.ToString();
		}
		
		public void CalcOdds(int SimulateCount)
		{
			if (string.IsNullOrEmpty(chara.chara_name) || lboss == null)
				return;
			if(!expected)
				CalcExpectedValue();
			if(goal == LBossGoal.None)
				return;
			Doubt = false;
			if (lboss.Doubt)
				Doubt = true;
			if(chara.ParamIsDoubt)
				Doubt = true;
			foreach (Card sc in chara.setcard)
				if (sc != null && sc.Doubt)
					Doubt = true;
			if (rewardLeft < damage[4].Min)//一確
			{
				ave_AtkNum = Double.NegativeInfinity;
				calced = true;
				return;
			}
			if (damage[4].Max == 0 || damage[4].Expected == 0)//不可能
			{
				ave_AtkNum = Double.PositiveInfinity;
				calced = true;
				return;
			}
			int[] sim = base.m_DamageSimulate(SimulateCount, chara, lboss.Param);
			var rand = new MinorShift._Library.MTRandom();
			int[] req_AtkNumSim = new int[req_AtkNum.Length];
			long AtkNumSum = 0;
			
			for(int i = 0;i<SimulateCount;i++)
			{
				int dmg = 0;
				int atknum = 0;
				for(;atknum<req_AtkNum.Length - 1;atknum++)
				{
					dmg += sim[rand.Next(SimulateCount)];
					if(dmg >= rewardLeft)
						break;
				}
				req_AtkNumSim[atknum]++;
				if(dmg >= rewardLeft)
					AtkNumSum += 1 + atknum;
				else
					AtkNumSum += 1 + atknum + ((rewardLeft - dmg) / damage[4].Expected + 1);
			}
			ave_AtkNum = ((double)AtkNumSum) / SimulateCount;
			mid_AtkNum = -1;
			int midCounter = 0;
			for(int i = 0;i<req_AtkNum.Length;i++)
			{
				req_AtkNum[i] = ((double)req_AtkNumSim[i]) / SimulateCount;
				midCounter += req_AtkNumSim[i];
				if (mid_AtkNum < 0 && midCounter > (SimulateCount / 2))
					mid_AtkNum = i;
			}
			calced = true;
		}
		
		public void CalcExpectedValue()
		{
			if (string.IsNullOrEmpty(chara.chara_name))
				return;
			calcReward();
			damage = base.m_ExpectedValue(chara, lboss.Param);
			expected = true;
		}
	}
}
