﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NetMonitor.LoW.StaticData;
using NetMonitor.AmfFormat;

namespace NetMonitor.LoW
{
	enum CardInfo
	{
		None = 0,
		/// <summary>
		/// サーバーからのデータが不完全でcsvデータもなく推測もできない
		/// </summary>
		Unknown,
		/// <summary>
		/// name, classから予想したデータ 育成経路は仮定 lvはあったりなかったり
		/// </summary>
		Virtual,
		/// <summary>
		/// サーバーから送られてきたデータのうちname, class, lvとadd_atk、add_satkから算出したデータ
		/// </summary>
		Calculated,
		/// <summary>
		/// サーバーから送られてきた完全データ
		/// </summary>
		Complete,
	}

	class Card
	{
		public CardStatic StaticData;
		public CardInfo Info;
		/// <summary>
		/// データが疑わしいフラグ
		/// </summary>
		public bool Doubt { get; set; }
		public Card(string str, int card_class)
		{
			card_name = str;
			this.card_class = card_class;
			this.Doubt = true;
		}
		public Card(CardStatic data)
		{
			StaticData = data;
			card_lv = 1;
			StParam = data.Param;
			CardParam = data.Param;
			card_name = data.GetDictionaryKey();
			lvup_max = data.lvup_max;
			card_class = data.card_class;
			card_rarity = data.card_rarity;
			setcost = data.setcost;
			max_lv = false;
			this.Doubt = data.Doubt;
			Info = CardInfo.Virtual;
		}


		
		public static bool Consistent(Card[] x, Card[] y)
		{
			if (x == y)
				return true;
			if (x == null || y == null)
				return false;
			if (x.Length != y.Length)
				return false;
			for (int i = 0; i < x.Length; i++)
				if (!Consistent(x[i], y[i]))
					return false;
			return true;
		}

		public static bool Consistent(Card x, Card y)
		{
			if (x == y)
				return true;
			if (x == null || y == null)
				return false;
			if (x.card_name != y.card_name)
				return false;
			if (x.card_class != y.card_class)
				return false;
			//仮想値については詮索しない
			if (x.Info == CardInfo.Virtual || y.Info == CardInfo.Virtual)
				return true;
			if (x.card_lv != y.card_lv)
				return false;
			if (x.card_exp != y.card_exp)
				return false;
			if (x.AddParam != y.AddParam)
				return false;
			if (x.Info == y.Info)
				return true;
			return (x.CardParam == y.CardParam);
		}

		public static Card[] SetcardFromAmfArray(AmfArrayData array)
		{
			Card[] result = new Card[3];
			for (int i = 0; i < result.Length && i < array.Array.Length; i++)
			{
				result[i] = FromAmfObject((AmfObjectData)array.Array[i]);
			}
			return result;
		}
		public static Card FromAmfObject(AmfObjectData obj)
		{
			AmfStringData nameData = obj.GetMember("card_name") as AmfStringData;
			AmfStringData classData = obj.GetMember("class") as AmfStringData;
			//card_idしかないデータ 使用できない
			if (nameData == null || classData == null)
				return null;

			int card_class = int.Parse(classData.s);

			CardStatic cardSt = LoWDataStatic.GetCardData(nameData.s, card_class);
			Card result, template, maxCard,minCard = null;
			bool hasAdd_atk = false;
			bool hasLv = false;
			result = new Card(nameData.s, card_class);

			int card_atk = -1;
			int card_satk = -1;
			foreach (AmfObjectMember mem in obj.Members)
			{
				switch (mem.Key)
				{
					case "card_id": result.card_id = ((AmfStringData)mem.Value).s; break;
					case "card_lv": result.card_lv = mem.Value.GetIntValue(); hasLv = true; break;
					case "add_atk": result.AddParam.atk = mem.Value.GetIntValue(); hasAdd_atk = true; break;
					case "add_satk": result.AddParam.satk = mem.Value.GetIntValue(); hasAdd_atk = true; break;
					case "set_flg": result.set_flg = mem.Value.GetIntValue(); break;
					case "trade_flg": result.trade_flg = mem.Value.GetBooleanValue(); break;
					case "lock_flg": result.lock_flg = mem.Value.GetBooleanValue(); break;
					case "max_lv": result.max_lv = mem.Value.GetBooleanValue(); break;
					case "class": result.card_class = mem.Value.GetIntValue(); break;
					case "card_exp": result.card_exp = mem.Value.GetIntValue(); break;
					//case "card_img": result.card_img = ; break;
					//case "cd_id": result.cd_id = ; break;
					//case "cg_id": result.cg_id = ; break;
					//case "card_lv_per": result.card_lv_per = mem.Value.GetIntValue(); break;
					//case "card_note": result.card_note = ((AmfStringData)mem.Value).s; break;
					//case "req_lv": result.req_lv = mem.Value.GetIntValue(); break;
					//case "skill_name": result.skill_name = ((AmfStringData)mem.Value).s; break;
					//case "stock_flg": result.stock_flg = mem.Value.GetIntValue(); break;
					//case "battle_flg": result.battle_flg = mem.Value.GetIntValue(); break;
					//case "sell_cost": result.sell_cost = mem.Value.GetIntValue(); break;
					case "card_rarity": result.card_rarity = mem.Value.GetIntValue(); break;
					case "card_type": result.StParam.type = mem.Value.GetIntValue(); break;
					case "card_per": result.StParam.s_per = mem.Value.GetIntValue(); break;
					case "setcost": result.setcost = mem.Value.GetIntValue(); break;
					case "lvup_max": result.lvup_max = mem.Value.GetIntValue(); break;
					case "sp": result.StParam.sp = mem.Value.GetIntValue(); break;
					case "atk": result.StParam.atk = mem.Value.GetIntValue(); break;
					case "satk": result.StParam.satk = mem.Value.GetIntValue(); break;
					case "card_atk": card_atk = mem.Value.GetIntValue(); break;
					case "card_satk": card_satk = mem.Value.GetIntValue(); break;
					case "balance": result.StParam.balance = mem.Value.GetIntValue(); break;
					case "critical": result.StParam.critical = mem.Value.GetIntValue(); break;
					case "water": result.StParam.element.type = Element.Water; result.StParam.element.num = mem.Value.GetIntValue(); break;
					case "wind": result.StParam.element.type = Element.Wind; result.StParam.element.num = mem.Value.GetIntValue(); break;
					case "earth": result.StParam.element.type = Element.Earth; result.StParam.element.num = mem.Value.GetIntValue(); break;
					case "fire": result.StParam.element.type = Element.Fire; result.StParam.element.num = mem.Value.GetIntValue(); break;
				}
			}
			result.CardParam = result.StParam;
			//完全情報あり CardInfo.Complete;
			if (result.setcost != 0 && card_atk >= 0 && card_satk >= 0)
			{
				result.CardParam.atk = card_atk;
				result.CardParam.satk = card_satk;
				result.Doubt = false;
				result.Info = CardInfo.Complete;
				if (cardSt != null && !cardSt.Doubt)
				{
					template = new Card(cardSt);
					maxCard = cardSt.CreateBestCard(result.card_lv);
					minCard = cardSt.CreateWorstCard(result.card_lv);
					//TODO:StaticDataの正誤調査
				}
				return result;
			}
			//サーバーからの情報は不完全だがcsvと合わせて完全データを再現可能 CardInfo.Calculated;
			if (hasAdd_atk && hasLv)
			{
				if (cardSt != null)
				{
					template = new Card(cardSt);
					template.card_lv = result.card_lv;
					template.AddParam = result.AddParam;
					result = template;
					result.CardParam = (result.StParam + result.AddParam).Growth(cardSt.GRate, result.card_lv - 1);
					result.Info = CardInfo.Calculated;
					return result;
				}
				result.Info = CardInfo.Unknown;
				return result;
			}

			if (cardSt == null)
			{
				result.Info = CardInfo.Unknown;
				return result;
			}
			if (hasLv)
				return cardSt.CreateBestCard(result.card_lv);

			return cardSt.CreateBestCard(-1);
		}

		/// <summary>
		/// ID。ユニークではない。カード名とclassが同じならIDも同じようだ。カードimgと対応。
		/// </summary>
		public string card_id;
		/// <summary>
		/// 現在Lv
		/// </summary>
		public int card_lv;
		/// <summary>
		/// 現在経験値。
		/// </summary>
		public int card_exp;
		///// <summary>
		///// Lv1時点での図鑑値からの乖離
		///// </summary>
		//public int add_atk{get;set;}
		///// <summary>
		///// Lv1時点での図鑑値からの乖離
		///// </summary>
		//public int add_satk{get;set;}
		/// <summary>
		/// セット位置 0～3
		/// </summary>
		public int set_flg;
		/// <summary>
		/// 謎フラグ トレードシステム実装予定なのかNPC売りのことなのか
		/// </summary>
		public bool trade_flg;
		/// <summary>
		/// lock_flg ロックされているかどうか
		/// </summary>
		public bool lock_flg;
		/// <summary>
		/// 名前 装備と異なり + などは付かない
		/// </summary>
		public string card_name;
		//画像情報。使用しない
		//public string card_img{get;set;}
		//public string event_img{get;set;}
		//public int cg_id{get;set;}
		//card_idとは異なるナニカ。やはりユニークではない。使用しない
		//public int cd_id{get;set;}
		//口上。使用しない
		//public string card_note{get;set;}
		// 経験値％？使用しない
		//public int card_lv_per{get;set;}
		//スキル名。使用しない
		//public string skill_name{get;set;}
		// Lv制限。常に1。使われていない
		//public int req_lv{get;set;}
		// 倉庫フラグ？使用しない
		//public int stock_flg { get; set; }
		// 売却額。使用しない
		//public int sell_cost { get; set; }
		//進化前後のカードグループ。使用しない。
		//public Card[] card_group { get; set; }


		///// <summary>
		///// 物理 = 1,魔法 = 2
		///// </summary>
		//public int card_type { get; set; }
		/// <summary>
		/// LVが最大であるフラグ card_lv >= lvup_max。課金配布などでは上限突破しているケースがあるようだ
		/// </summary>
		public bool max_lv;
		/// <summary>
		/// class。進化段階
		/// </summary>
		public int card_class;
		/// <summary>
		/// レアリティ。Cが1、UCが2、以下R、SR、SSR
		/// </summary>
		public int card_rarity;
		///// <summary>
		///// スキル発動率。1000分率
		///// </summary>
		//public int card_per{get;set;}
		/// <summary>
		/// コスト
		/// </summary>
		public int setcost;
		/// <summary>
		/// 最大LV
		/// </summary>
		public int lvup_max;
		///// <summary>
		///// スキル消費MP。
		///// </summary>
		//public int sp{get;set;}

		/// <summary>
		/// Lv1時点での図鑑値からの乖離
		/// </summary>
		public BParameter AddParam;
		/// <summary>
		/// 図鑑値
		/// </summary>
		public BParameter StParam;
		/// <summary>
		/// 現在値
		/// </summary>
		public BParameter CardParam;
		///// <summary>
		///// 攻撃力(図鑑値)
		///// </summary>
		//public int atk{get;set;}
		///// <summary>
		///// スキル攻撃力(図鑑値)
		///// </summary>
		//public int satk{get;set;}
		///// <summary>
		///// 攻撃力(現在値)
		///// </summary>
		//public int card_atk{get;set;}
		///// <summary>
		///// スキル攻撃力(現在値)
		///// </summary>
		//public int card_satk{get;set;}
		///// <summary>
		///// バランス
		///// </summary>
		//public int balance{get;set;}
		///// <summary>
		///// クリティカル
		///// </summary>
		//public int critical{get;set;}
		///// <summary>
		///// 属性
		///// </summary>
		//public Element element.type { get; set; }
		///// <summary>
		///// 属性値
		///// </summary>
		//public int element.num { get; set; }
		public override string ToString()
		{
			if(card_name == null || card_name.Length == 0)
				return "unknown";

			StringBuilder sb = new StringBuilder();

			sb.Append(card_name);
			if (card_class == 2)
				sb.Append("+");
			if(card_class == 3)
				sb.Append("++");
			//sb.Append(":");
			//sb.Append(card_rarity.ToString());
			//sb.Append(":");
			//sb.Append(StParam.element.ToString());
			sb.Append(":lv = ");
			sb.Append(card_lv.ToString());
			if (Info == CardInfo.Complete)
				sb.Append(":サーバー値");
			else if (Info == CardInfo.Calculated)
				sb.Append(":計算値");
			else if (Info == CardInfo.Virtual)
				sb.Append(":育成情報なし");
			else if (Info == CardInfo.Virtual)
				sb.Append(":csv情報なし");
			else if (Info == CardInfo.None)
				sb.Append(":情報なし");
			return sb.ToString();
		}
		public string NameWithClass
		{
			get
			{
				StringBuilder sb = new StringBuilder();

				sb.Append(card_name);
				if (card_class == 2)
					sb.Append("+");
				if (card_class == 3)
					sb.Append("++");
				return sb.ToString();

			}
		}

		internal BattleData.ExpectedDamage CalcExpected(BParameter defParam)
		{
			var damage = new BattleData.ExpectedDamage();
			double atk, satk, def, bal, cri, dmg, per;
			double factor = CardParam.element.GetElementFactor(defParam.element.type);
			atk = CardParam.atk * factor;
			satk = CardParam.satk * factor;
			bal = CardParam.balance * 0.01;
			cri = CardParam.critical * 0.01;
			per = CardParam.s_per * 0.001;
			if (CardParam.type == 1)
			{
				def = defParam.def;
				if (defParam.ability == BattleAbility.ImmuneToPhysical)
					return damage;
			}
			else
			{
				def = defParam.rst;
				if (defParam.ability == BattleAbility.ImmuneToMagic)
					return damage;
			}
			damage.Min = (int)Math.Max(Math.Min(atk, satk) * (1.0 - bal) - def, 0.0);
			damage.Max = (int)(Math.Max(atk, satk) * (1.0 + bal) + 0.9999);
			//クリティカル発動分は先に加算
			dmg = (atk * (1 - per) + satk * per) * cri;
			//通常攻撃　(1.0 - per)
			if (atk * (1.0 - bal) > def)//常に貫通
			{
				dmg += (atk - def) * (1.0 - per) * (1.0 - cri);
			}
			else if (atk * (1.0 + bal) > def && bal > 0.0)//ときどき貫通
			{
				dmg += ((atk * (1.0 + bal) - def) * (bal - (def - atk) / atk) / 4 / bal) * (1.0 - per) * (1.0 - cri);
			}
			//スキル攻撃　per
			if (satk * (1.0 - bal) > def)//常に貫通
			{
				dmg += (satk - def) * per * (1.0 - cri);
			}
			else if (satk * (1.0 + bal) > def && bal > 0.0)//ときどき貫通
			{
				dmg += ((satk * (1.0 + bal) - def) * (bal - (def - satk) / satk) / 4 / bal) * per * (1.0 - cri);
			}
			damage.Expected = (int)dmg;
			return damage;
		}
	}
}
