﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NetMonitor.LoW.StaticData;
using NetMonitor.AmfFormat;

namespace NetMonitor.LoW
{
	class Chara
	{
		
		//setcard
		public Card[] setcard = new Card[3];
		//equip
		public Equipment[] equip = new Equipment[3];
		public int lv;
		public string chara_id;
		public string chara_name;
		//avatar;
		//public Dictionary<string, string> guild_id;
		//public DateTime lastUpdate;
		//public DateTime lastChanged;
		public BParameter Param;
		
		/*自分用*/
		//public DateTime lastSetcardUpdate;
		public bool myself;
		public ActionParam energy;
		public ActionParam force;
		public int setcard_charisma;
		public int exp_now;
		public int exp_next;
		public int battle_rank;
		public int battle_winnum;

		public bool lboss;
		public bool pstock;
		public bool ParamIsDoubt;
		
		
		/*戦友用*/
		//public bool isFriend;
		//public DateTime lastFriendTime;
		//public DateTime FriendTime;
		public void CalcParam()
		{
			int[] elementPower = new int[5];
			ParamIsDoubt = false;
			Param = BParameter.Lv1Chara;
			Param.sp += (lv - 1) * 10;
			for (int i = 0; i < equip.Length; i++)
			{
				if (equip[i] == null)
					continue;
				Param = Param + equip[i].Param;
				if (equip[i].Param.element.type != Element.None)
					elementPower[(int)equip[i].Param.element.type] += equip[i].Param.element.num;
				if(equip[i].Doubt)
					this.ParamIsDoubt = true;
			}
			Param.element.type = Element.None;
			Param.element.num = 0;
			for (int i = 1; i < elementPower.Length; i++)
			{
				if (elementPower[i] > Param.element.num)
				{
					Param.element.type = (Element)i;
					Param.element.num = elementPower[i];
				}
			}
			if (Param.atk >= Param.mag)
				Param.type = 1;
			else
				Param.type = 2;
		}

		public bool UpdateSetcard(Card[] newCards)
		{
			if(newCards == null || newCards.Length != setcard.Length)
				return false;
			if(!Card.Consistent(setcard, newCards))
			{
				setcard = newCards;
				return true;
			}
			for(int i = 0; i<setcard.Length;i++)
			{
				if(setcard[i] != null && newCards[i] != null)
				{
					if(setcard[i].Info == CardInfo.Complete || newCards[i].Info == CardInfo.Virtual)
						return false;
					if(setcard[i].Info == CardInfo.Virtual || newCards[i].Info == CardInfo.Complete)
					{
						setcard = newCards;
						return true;
					}
					break;
				}
			}
			return false;
		}
		
		public bool UpdateData(AmfObjectData obj, DateTime updateTime)
		{
			bool update = false;
			int i = 0;
			foreach (AmfObjectMember mem in obj.Members)
			{
				switch (mem.Key)
				{
					case "chara_id":
						if(chara_id == null || chara_id != mem.Value.GetStrValue())
						{
						update = true;
						chara_id = mem.Value.GetStrValue();
						}
						break;
					case "chara_name":
						if(chara_name == null || chara_name != mem.Value.GetStrValue())
						{
							update = true;
							chara_name = mem.Value.GetStrValue();
						}
						break;
					case "lv":
						i =  mem.Value.GetIntValue();
						if(lv !=i)
						{
							update = true;
							lv = i;
						}
						break;
					case "setcard":
						{
							Card[] newCard = Card.SetcardFromAmfArray((AmfArrayData)mem.Value);
							if(!Card.Consistent(setcard, newCard))
							{
								update = true;
							}
							UpdateSetcard(newCard);
						}
						break;
					case "equip":
						{
							Equipment[] newEquip = Equipment.EquipFromAmfObject((AmfObjectData)mem.Value);
							if (!Equipment.Consistent(equip, newEquip))
							{
								update = true;
								equip = newEquip;
							}
						}
						break;
					//自分用データ
					case "action":
					{
						AmfObjectData actionObj = (AmfObjectData)mem.Value;
						AmfObjectData ene = (AmfObjectData)actionObj.GetMember("energy");
						energy = ActionParam.FromAmfObject(ene, updateTime);
						force = ActionParam.FromAmfObject((AmfObjectData)actionObj.GetMember("force"), updateTime);
						break;
					}
					case "exp":
					{
						AmfObjectData expObj = (AmfObjectData)mem.Value;
						exp_now = expObj.GetMember("now").GetIntValue();
						exp_next = expObj.GetMember("next").GetIntValue();
						break;
					}
					case "setcard_charisma": setcard_charisma = mem.Value.GetIntValue(); break;
					case "parameter":
						Param = BParameter.FromAmfObject((AmfObjectData) mem.Value);
						if(Param.atk >= Param.mag)
							Param.type = 1;
						else
							Param.type = 2;
						ParamIsDoubt = false;
						break;
					case "battle":
						{
							AmfObjectData btlObj = (AmfObjectData)mem.Value;
							battle_rank = btlObj.GetMember("rank").GetIntValue();
							battle_winnum = btlObj.GetMember("winnum").GetIntValue();
						}
						break;
					case "lboss": lboss = mem.Value.GetBooleanValue(); break;
					case "pstock":
						if(mem.Value is AmfBooleanData)
						{
							pstock = mem.Value.GetBooleanValue(); 
						}break;
					//case "bbs":別処理
					//case "quest":別処理
				}
			}
			return update;
		}



		internal double CalcMp()
		{
			int mp = this.Param.sp;
			int needMp = 0;
			foreach (Card card in setcard)
				if(card != null)
					needMp += card.CardParam.sp * 2;
			if (mp >= needMp)
				return double.NegativeInfinity;
			long mpShort = 0;
			int[] index = new int[3];
			int[] per = new int[3];
			for (int i = 0; i < 3*3*3; i++)
			{
				index[0] = i%3;
				index[1] = i/3%3;
				index[2] = i/9;
				needMp = 0;
				for(int j = 0;j<3;j++)
				{
					int sper = 1000;
					
					if (setcard[j] != null)
					{
						needMp += setcard[j].CardParam.sp * index[j];
						sper = setcard[j].CardParam.s_per;
					}
					if(index[j] == 0)
						per[j] = (1000-sper)*(1000-sper);
					else if (index[j] == 1)
						per[j] = sper*(1000-sper) * 2;
					else
						per[j] = sper*sper;
				}
				if(needMp > mp)
				mpShort += ((long)per[0]) * per[1] * per[2];
			}
			return ((double)mpShort) / 1000000 / 1000000 / 1000000;
		}

		internal string MyData()
		{
			int qbatk = 0;
			StringBuilder sb = new StringBuilder();
			if (this.chara_name == null || this.chara_name.Length == 0)
			{
				sb.Append("◆自己情報がありません");sb.Append(System.Environment.NewLine);
				sb.Append("街に戻る、装備欄を開くなどで情報を更新して下さい");
				return sb.ToString();
			}
			sb.Append(this.chara_name); sb.Append(System.Environment.NewLine);
			sb.Append(string.Format("energy = {0,3}/{1,3} | force = {2,3}/{3,3}", energy.now, energy.max, force.now, force.max)); sb.Append(System.Environment.NewLine);

			sb.Append(string.Format("atk = {0,5}  | mag = {1,5}", Param.atk, Param.mag)); sb.Append(System.Environment.NewLine);
			sb.Append(string.Format("def = {0,5}  | rst = {1,5}", Param.def, Param.rst)); sb.Append(System.Environment.NewLine);
			sb.Append(string.Format("cri = {0,5}  | bal = {1,5}", Param.critical, Param.balance)); sb.Append(System.Environment.NewLine);
			sb.Append(string.Format("MP  = {0,5} ", Param.sp));
			double mpshort = CalcMp();
			if (mpshort >= 0.0)
				sb.Append(string.Format("(MP不足率 {0,4:0.0}%)", mpshort * 100));
			else
				sb.Append("(十分)");
			sb.Append(System.Environment.NewLine);
			qbatk += Math.Max(Param.atk, Param.mag) * 4;
				
			for (int i = 0; i < equip.Length; i++)
			{
				sb.Append("Equip[" + i.ToString() + "] : ");
				if (equip[i] != null)
					sb.Append(equip[i].NameWithPlus);
				else
					sb.Append("null");
				sb.Append(System.Environment.NewLine);
			}
			cardInfoComplete = true;
			for (int i = 0; i < setcard.Length; i++)
			{
				sb.Append("Card [" + i.ToString() + "] : ");
				if (setcard[i] != null)
				{
					sb.Append(setcard[i].ToString());
					qbatk += setcard[i].CardParam.atk;
					qbatk += setcard[i].CardParam.satk;
					if (setcard[i].Info != CardInfo.Complete && setcard[i].Info != CardInfo.Calculated)
						cardInfoComplete = false;
				}
				else
					sb.Append("null");
				sb.Append(System.Environment.NewLine);
			}
			sb.Append(string.Format("対クエストボス火力:{0,6}",qbatk));sb.Append(System.Environment.NewLine);
			if (!cardInfoComplete)
			{
				sb.Append("◆カード情報が不完全です");sb.Append(System.Environment.NewLine);
				sb.Append("カードデッキ欄を開き情報を更新して下さい");
			}
			return sb.ToString();
		}
		public bool cardInfoComplete;
		
		
		internal BattleData.ExpectedDamage CalcExpected(BParameter defParam)
		{
			var damage = new BattleData.ExpectedDamage();
			double atk, def, bal, cri, dmg;
			dmg = 0.0;
				BParameter atkparam = this.Param;
				double factor = atkparam.element.GetElementFactor(defParam.element.type);
					bal = atkparam.balance * 0.01;
					cri = atkparam.critical * 0.01;
				if (atkparam.type == 1)
				{
					atk = atkparam.atk * factor;
					def = defParam.def;
					if (defParam.ability == BattleAbility.ImmuneToPhysical)
						return damage;
				}
				else
				{
					atk = atkparam.mag * factor;
					def = defParam.rst;
					if (defParam.ability == BattleAbility.ImmuneToMagic)
						return damage;
				}
				//最小値
				damage.Min = (int)Math.Max(atk * (1.0 - bal) - def, 0.0);
				//最大値 charaならcri率は1以上あるはず
				damage.Max = (int)Math.Max(atk * (1.0 + bal) + 0.9999, damage.Min);
				//期待値
				dmg = atk * cri;
				if (damage.Min > 0)//常に貫通
				{
					dmg += (atk - def) * (1.0 - cri);
				}
				else if (atk * (1.0 + bal) > def && bal > 0.0)//ときどき貫通
				{
					dmg += ( (atk * (1.0 + bal) - def) * (bal - (def - atk) / atk) / 4 / bal) * (1.0 - cri);
				}
				//else  dmg += 0;無理
			damage.Expected = (int)dmg;
			return damage;
			
		}
	}
}