﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using MinorShift._Library;
using System.IO;
using PacketDotNet;
using SharpPcap;

namespace NetMonitor
{
	static class Program
	{
		/// <summary>
		/// アプリケーションのメイン エントリ ポイントです。
		/// </summary>
		[STAThread]
		static void Main()
		{
#if DEBUG
			ExeDir = Sys.ExeDir;
			ExeDir = Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(Path.GetDirectoryName(Sys.ExeDir)))) + "\\";
#else
			ExeDir = Sys.ExeDir;
			if (Sys.PrevInstance())
			{
				MessageBox.Show("二重に起動できません", "既に起動しています");
				return;
			}

#endif
			MinorShift._Library.LangManager.setEncode(932);
			DataDir = ExeDir + "LoWData\\";
			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault(false);
			Application.Run(new MainWindow());
		}
		public static string ExeDir { get; private set; }
		public static string DataDir { get; private set; }
		public static DateTime StartTime { get; private set; }
		#region debug
		static string getOutputpath(string ext, DateTime time)
		{
			string dir = ExeDir + "debug\\";
			if (!Directory.Exists(dir))
			{
				Directory.CreateDirectory(dir);
			}
			string filename;
			int index = 0;
			string timename = time.ToString("yyyyMMddHHmmssffff");
			while (true)
			{
				filename = dir + timename + "_" + index.ToString() + ext;
				if (!File.Exists(filename))
					break;
				index++;
			}
			return filename;
		}

		public static void OutputDebugFile(byte[] payload,string ext, DateTime time)
		{
			try
			{
				File.WriteAllBytes(getOutputpath(ext, time), payload);
			}
			catch
			{
			}
		}
		public static void OutputDebugFile(AmfFormat.AmfObjectData objData, string ext, DateTime time)
		{
			FileStream fs = null;
			StreamWriter writer = null;
			try
			{
				fs = new FileStream(getOutputpath(ext, time), FileMode.Create);
				writer = new StreamWriter(fs, System.Text.Encoding.UTF8);
				objData.Write(writer, 0, 999);
			}
			catch
			{
			}
			finally
			{
				if (writer != null)
					writer.Close();
				else if (fs != null)
					fs.Close();
			}
		}


		public static volatile bool FlagOutputAmf;
		public static volatile bool FlagOutputGz;
		public static volatile bool FlagOutputTxt;
		#endregion

	}
}
