#
#   def_class.py
#
#   2003.9.26
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import types

class VPrint:
    import Lpy.def_parm
    ON     = Lpy.def_parm.ON
    OFF    = Lpy.def_parm.OFF
    Never  = Lpy.def_parm.Never
    ON_OFF = Lpy.def_parm.ON_OFF
    intType  = 'intType'
    charType = 'charType'

    Yes = 'yes'
    No  = 'no'
    Yes_No = (No,Yes)

    def __init__(self):
        self.support = self.ON
        self.value = None
        self.error = None
        self.auto_value = self.OFF  # if NO_support,then value is OFF
        self.save_static = self.OFF # save value_name

    def get_error(self):
        return self.error
    def set_Error(self,func,value,msg = None):
        print "Set Error:%s (%s:%s:%s)" % (func,self.__class__.__name__,value,msg)

    def get_value(self):
        return self.value
    def get_title(self):
        return self.title

    def get_support(self):
        return self.support
    def set_support(self,value):
        if not value in (self.ON,self.OFF,self.Never):
            self.support = self.Never
            #self.set_Error("set_support",value,"ON,OFF,Never")
            return None
        self.support = value
        if value != self.ON and self.auto_value == self.ON:
            if isinstance(self.value_list, (types.ListType,types.TupleType)):
                self.value = self.value_list[0]

    def get_vlist(self):
        return self.value_list
    def set_vlist(self,vlist,value):
        self.value_list = vlist
        self.set_value(value)

    def tuple_index(self,value):
        count = 0
        for key in self.value_list:
            if key == value:
                return count
            count += 1
        else:
            return 0

    def set_value(self,value):
        #print "set_value:(%s:%s)" % (self.__class__.__name__,value)
        if isinstance(self.value_list,(types.ListType,types.TupleType)):
            if isinstance(value,types.IntType):
                if value >= 0 and value < len(self.value_list):
                    self.value = value
                    return None
                else:
                    self.set_Error("set_value",value,"range over")
                    return None

            if self.save_static == self.ON:
                self.value = value
            else:
                if self.support != self.ON or value is None:
                    return 0
                else:
                    self.value = self.tuple_index(value)
        else:
            self.value = value
        return None

    ## int ==> string.value
    def set_selected(self,value):
        if not isinstance(value,types.IntType):
            self.set_Error("set_selected",value)
            return None
        if value < len(self.value_list):
            self.value = self.value_list[value]
        else:
            self.set_Error("set_selected",value,"range over")

    def get_selected(self,data =None):
        if isinstance(self.value,types.IntType):
            return self.value
        elif self.support != self.ON or self.value is None:
            return 0
        return self.tuple_index(self.value)

    ## save,load
    def set_load_value(self,values):
        if values == None:
            self.support = self.Never
            return None

        self.set_support(values[0])
        if len(values) >= 2:
            self.set_value(values[1])

    def get_save_value(self):
        if self.support != self.ON:
            return self.support,None

        if isinstance(self.value,types.StringType):
            val = -1
            if self.save_static == self.OFF: # not maker,model
                if isinstance(self.value_list,(types.ListType,types.TupleType)):
                    val = self.get_selected()
            if val == -1:
                val = self.value
        else:
            val = self.value
        return self.support,val

    def get_a2ps(self):
        return None

