#
#       f_encoding.py
#
#       2004.3.22
#       2004.6.26
#       2004.12.1
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################

JapanCode = 'japanese'

L_encode_tbl = {       # a2ps , python codecs
        'iso8859-1' : ('iso1','latin-1'), 
        'iso8859-2' : ('iso2','iso8859-2'),
        'iso8859-3' : ('iso3','iso8859-3'),
        'iso8859-4' : ('iso4','iso8859-4'),
        'iso8859-5' : ('iso5','iso8859-5'),
        'iso8859-7' : ('iso7','iso8859-7'),
        'iso8859-9' : ('iso9','iso8859-9'),
        'iso8859-10': ('iso10','iso8859-10'),
        'iso8859-13': ('iso13','iso8859-13'),
        'iso8859-15': ('iso15','iso8859-15'),
        'koi8-r'    : ('koi8','koi8-r'),
        'cp1250'   : ('ms-cp1250','cp1250'),
        'cp437'    : ('ibm-cp437','cp437'),
        'cp850'    : ('ibm-cp850','cp850'),
        'macintosh': ('mac','macroman'),
        'ascii'    : ('ascii','ascii'),
        JapanCode : ('euc-jp','euc-jp'),
        #'Korean'   : ('euc-kr','euc-kr'),
        #'eucCN'   : ('euc-cn','euc-cn'),
        #'eucTW'   : ('euc-tw','euc-tw'),
        #'hp-roman' : ('hp','hp-roman8'),
        }

import locale
import codecs
import Lpy.utils.file_utils

L_lang,L_encode = locale.getdefaultlocale()

def get_lang():
    if L_lang == None:
        return None

    if len(L_lang) >= 2:
        if L_lang[:2] == 'ja':
            return JapanCode
        #elif L_lang[:2] == "ko":
        #    return 'Korean'
        # elif L_lang[:5] == "zh_CN":
        # elif L_lang[:5] == "zh_TW":
    return None

def get_encode():
    lang = get_lang()
    if lang and L_encode_tbl.has_key(lang):
        return L_encode_tbl[lang][1]
  
    if L_encode == None:
        return 'iso8859-1'

    encode = L_encode.lower().replace('_','-')

    if encode.startswith('iso'):
        if encode[3] == '-' and encode[4] == '8':
            encode = 'iso' + encode[4:]
    # modified 2004.12.1
    if not L_encode_tbl.has_key(encode):
        encode = 'iso8859-1'
        #print "lang :" ,L_lang,L_encode,encode

    return encode
 
def codecs_convert(filename, outfile, out_code, in_code):
    try:
        fp = open(filename,'r')
    except :
        return 2
    try:
        f_obj = codecs.EncodedFile(fp, out_code, in_code)
    except :
        return None

    ret = 0
    try:
        data = f_obj.read()
    except :
        ret = 1
 
    fp.close()  

    if ret:
       return None
    try:
        fp2 = open(outfile,'w')
    except:
        ret = 2

    if ret == 0:
        try:
            fp2.write(data)
        except:
            ret = 2
        fp2.close()

    if ret == 2:
        Lpy.utils.file_utils.remove_file(outfile)
        return 2
    return 1

def file_encoding(out_encoding, filename):
        outfile = Lpy.utils.file_utils.make_tmpfile(filename)
 
        # japanese encoding
        if out_encoding == L_encode_tbl[JapanCode][1]:
            from  Lpy.lpy_programs import get_prg
            nkf = get_prg('nkf')
            if nkf:
                msg = Lpy.utils.file_utils.sys_command("%s -e %s > %s" % (nkf,filename,outfile))
                if msg:
                    Lpy.utils.file_utils.remove_file(outfile)
                    return None
            else:
                return filename
        else:
            ret = codecs_convert(filename,outfile,out_encoding,'utf-8')
            if ret == None:
                return filename
            elif ret == 2:
                return None

        if Lpy.utils.file_utils.check_file(outfile) in Lpy.utils.file_utils.Error_lists:
            Lpy.utils.file_utils.remove_file(outfile)
            return None
        return outfile



