#
#   menu_main.py
#
#   2003.9.30
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
################################
import gtk
import os,types

import Lpy.lpy_version
import Lpy.lpy_about
import Lpy.def_parm

import gui_set
import page_main
import page_setup
import page_queue
import page_paper
import page_tray
import page_advance
import dialog_menu
#import page_color

class NameSpace:
    pass

class Memu_Main:
    title = (_(" Setup"),_(" Queue"),_(" Main "),_(" a2ps "),
            _(" Tray "),_("Advanced"),_(" Color"),_("What is lpy ?"))
    subtitle = (_("Select a parameter file"),_("Save a parameter file"))

    err_msg = (_("Page Range setting error."),
               _("A output file is not selected."),
               _("Please select a file."))

    Page = NameSpace()
    ## menu class
    Page.setup = page_setup.PageSetup()
    Page.queue = page_queue.PageQueue()
    Page.main  = page_main.PageMain()
    Page.paper = page_paper.PagePaper()
    Page.tray  = page_tray.PageTray()
    Page.advanced = page_advance.PageAdvance()
    Page.color = None # page_color.PageColor()

    ## menu content
    Page.a2ps_page = None
    Page.tray_page = None
    Page.advanced_page = None
    Page.color_page = None

    ##### GTK Menu Size #####
    Hsize  = 460
    Vsize  = 414
    Border = 6
    Table_num = 7

    def __init__(self,dum1,dum2):
        pass
    ### Main
    def main(self):
        self.set_Pdict()
        self.main_menu()
        gtk.main()

    def set_Pdict(self):
        self.ON  = self.P.ON
        self.OFF = self.P.OFF
        self.ON_OFF = self.P.ON_OFF

        ### get parm ##
        self.G_value = 1
        self.G_vlist = 2
        self.G_support = 3
        self.G_title   = 4
        self.G_selected = 5

        self.GUI = gui_set.Gui_Set(self.get_menu_parm,self.set_parm_callback)
        self.GUI.__dict__['S'] = self
        self.re_set()

    def set_dicts(self,obj,dicts):
        for key in dicts:
            obj.__dict__[key] = dicts[key]

    def re_set(self):
        dicts = {'S': self, 'P': self.P}
        self.set_dicts(self.Page.setup,dicts)

        dicts = {'S': self, 'P': self.P,'PJL': self.PJL,'GUI': self.GUI}
        self.set_dicts(self.Page.queue,dicts)
        self.set_dicts(self.Page.main,dicts)
        self.set_dicts(self.Page.paper,dicts)
        self.set_dicts(self.Page.tray,dicts)
        self.set_dicts(self.Page.advanced,dicts)
        if self.Page.color:
            self.set_dicts(self.Page.color,dicts)
    ### Gui_set: parm
    def get_menu_parm(self,keyname,flag):
        if keyname in self.P.clist:
            base = self.P.get_func(keyname)
        elif keyname in self.PJL.clist:
            base = self.PJL.get_func(keyname)
        else:
            return None

        if  base is None:
            return self.Never
        if flag == self.G_value:
            return base.get_value()
        elif flag == self.G_vlist:
            return base.get_vlist()
        elif flag == self.G_support:
            return base.get_support()
        elif flag == self.G_title:
            return base.get_title()
        elif flag == self.G_selected:
            return base.get_selected()
        else:
            print "menu_main:get_menu_parm:(%s) flag(%s) is not defined." % (keyname,flag)
            return None

    def set_mainTitle(self):
        self.window.set_title("%s(%s) (%s)" %
            (Lpy.lpy_version.Command_name.capitalize(),Lpy.lpy_version.Version,self.get_printermaker()))

    def main_menu(self):
        self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
        self.set_mainTitle()
        self.window.connect("delete_event", gtk.main_quit)
        self.window.set_border_width(self.Border)
        table = gtk.Table(3,self.Table_num,gtk.FALSE)
        self.window.add(table)

        self.notebook = gtk.Notebook()
        self.notebook.set_tab_pos(gtk.POS_TOP)

        table.attach(self.notebook, 0,self.Table_num,0,1)

    # Notebook
        self.notebook.append_page(self.Page.setup.page(),gtk.Label(self.title[0]))
        self.notebook.append_page(self.Page.queue.page(),gtk.Label(self.title[1]))
        self.notebook.append_page(self.Page.main.page(),gtk.Label(self.title[2]))
        self.notebook.connect("switch-page",self.Page.queue.page_change_queue)

        self.print_tray_menu()
        self.notebook.set_current_page(2)
        self.notebook.show()

    # Action Buttons
        button = gtk.Button('',gtk.STOCK_QUIT) # Quit
        button.connect("clicked", gtk.main_quit)
        table.attach(button, 0,1,1,2)
        button.show()

        button = gtk.Button('', gtk.STOCK_HELP) # About
        button.connect("clicked", self.show_about)
        table.attach(button, 1,2,1,2)
        button.show()

        button = gtk.Button('',gtk.STOCK_PRINT) # Print Start
        button.connect("clicked", self.print_start)
        table.attach(button, 2,3,1,2)
        button.show()

        button = gtk.Button("",gtk.STOCK_OPEN)  # "Load a named parameter file"
        button.connect("clicked", self.open_parm_button)
        table.attach(button, 3,4,1,2)
        button.show()

        button = gtk.Button('',gtk.STOCK_SAVE) #STOCK_SAVE_AS) "Save a named parameter file"
        button.connect("clicked", self.save_parm_button)
        table.attach(button, 4,5,1,2)
        button.show()
        table.show()
        self.window.show()

    def print_tray_menu(self):
        if self.Page.a2ps_page is None:
            self.Page.a2ps_page = self.Page.paper.page()
            self.notebook.append_page(self.Page.a2ps_page,gtk.Label(self.title[3]))

        if self.PJL.get_func(self.PJL.P_pjl).get_support() == self.ON:
            self.Page.tray_page = self.Page.tray.page()
            self.Page.advanced_page = self.Page.advanced.page()
            self.notebook.append_page(self.Page.tray_page,gtk.Label(self.title[4]))
            self.notebook.append_page(self.Page.advanced_page,gtk.Label(self.title[5]))
        # color
        if self.Page.color: # P.T_colortype
            if self.Page.color.support_colorpage() == self.ON:
                self.Page.color_page = self.Page.color.page()
                self.notebook.append_page(self.Page.color_page,gtk.Label(self.title[6]))

    def menu_clear(self):
        if self.Page.a2ps_page != None:
            self.notebook.remove_page(self.notebook.page_num(self.Page.a2ps_page))
            self.Page.a2ps_page = None

        if self.Page.tray_page:
            self.notebook.remove_page(self.notebook.page_num(self.Page.tray_page))
            self.Page.tray_page = None
        if self.Page.advanced_page:
            self.notebook.remove_page(self.notebook.page_num(self.Page.advanced_page))
            self.Page.advanced_page = None

        if self.Page.color and Page.color_page:
            self.notebook.remove_page(self.notebook.page_num(self.Page.color_page))
            self.Page.color_page = None

    def get_printermaker(self):
        return ("%s:%s %s Printer" % (self.P.printer,self.PJL.get_func(self.PJL.P_maker).get_value(),
               self.PJL.get_func(self.PJL.P_lang).get_value()))

    def menu_change(self):
        self.menu_clear()
        self.re_set()
        self.Page.main.redraw()

        self.print_tray_menu()
        self.Page.setup.clear_setting(None)
        if self.notebook.get_current_page() != 0:
            self.notebook.set_current_page(2)

        self.notebook.queue_draw_area(0,0,-1,-1)

 ### parm set
    def set_parm_callback(self,keyname,count):
  
        #print "set:%s=%s" % (keyname,count)
        #return None

        end_input = 0

        if isinstance(count,types.StringTypes):
            if count.endswith(os.linesep):
                count = count.rstrip()
                end_input = 1

        if keyname in self.P.clist:
            self.P.get_func(keyname).set_value(count)
        elif keyname in self.PJL.clist:
            self.PJL.get_func(keyname).set_value(count)
        else:
            print "menu_main.py set_parm_callback: Error (%s:%s)" % (keyname,count)
            return None

        ## add setting
        if keyname == self.P.T_header:
            self.Page.paper.header_menu()
        elif keyname == self.P.T_pageall:
            if self.Page.main.pageRangeBox:
                if self.P.get_func(self.P.T_pageall).get_value() == 0:
                    self.Page.main.pageRangeBox.hide()
                else:
                    self.Page.main.pageRangeBox.show()

        elif keyname == self.P.T_output:
            self.Page.main.outfile_menu()

        elif keyname == self.P.T_outfile:
            if end_input or count.endswith('.ps'): 
                self.Page.main.callback_outfile(count)

        elif keyname == self.P.T_printer: # "printer"
            self.change_printer(count)

        elif keyname == self.P.T_nup:
            if self.P.get_func(self.P.T_nup).get_selected() >= 1:
                # Landscape
                self.P.get_func(self.P.T_portrait).set_value(1)
                self.Page.main.S_orientation.set_history(1)
            self.Page.main.redraw()

        elif keyname == self.PJL.P_duplex:
            if self.PJL.get_func(self.PJL.P_duplex).get_support() == self.OFF:
                self.Page.main.S_duplex.set_history(0)
                return None
            LongMargin = 20
            if self.PJL.get_func(self.PJL.P_duplex).get_selected() >= 1:
                self.set_parm_callback(self.P.T_marginleft,self.Page.main.longmargin.get_value_as_int())
                if  self.P.get_func(self.P.T_marginleft).get_value() == 0:
                    self.set_parm_callback(self.P.T_marginleft,LongMargin)
                    self.Page.main.longmargin.set_text(str(LongMargin))

    ### Action ##
    def change_printer(self,data):
        printer = self.P.get_func(self.P.T_printer).get_printer(data)
        self.P.set_pjl_parm(printer)
        self.P.load_a2ps(printer)
        self.menu_change()

    ## print start ##
    def print_start(self,button):
        if self.P.get_func(self.P.T_pagerange).check_range() == self.OFF:
            self.P.error_menu(self.err_msg[0],self.P.get_func(self.P.T_pagerange).get_value())
            return None

        if self.P.get_func(self.P.T_outprinter).get_value():
            ret = self.P.output_data() # printers.py
        else:
            self.P.error_menu(self.err_msg[1],self.err_msg[2])
            return None

    def open_parm_button(self,button): ## suffix list
        filename = self.P.check_suffix(self.P.get_filename(self.P.printer))
        pattern = '*' + self.P.get_suffix()

        dialog_menu.fileDialog(None,self.P.load_a2ps_file,filename,self.subtitle[0],pattern)

    def save_parm_button(self,button):
        if self.notebook.get_current_page() == 0:
            self.Page.setup.default_save(None)
        filename = self.P.check_suffix(self.P.get_filename(self.P.printer))
        dialog_menu.fileDialog(None,self.P.save_a2ps_file,filename,self.subtitle[1])
        
    def show_about(self, button):
        dialog_menu.message_dialog(self.title[7],Lpy.lpy_about.get_data())



