#
#       page_main.py
#
#       2003.5.13
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################
import gtk
import os

import Lpy.snmp.snmp_get
import Lpy.paper_size
import dialog_menu

class PageMain:
    #title = " Main "
    sub_title = (_("Printer"),_("Printing filename"),_('Page Selection'),
                 _('Printout File Selection'),_("Files"),_("Status"),_('Printer Information'),)
    units_title = (_('CustomPaper Setting'),_('Unit'),_('Width'),_('Height'))

    def __init__(self):
        self.Option_box = None
        self.Out_box = None
        self.pageRangeBox = None

    def page(self):
        base_vbox = gtk.VBox(gtk.FALSE, 0)
        base_vbox.set_border_width(self.S.Border)
        base_vbox.set_size_request(self.S.Hsize, self.S.Vsize)
        base_vbox.show()

  ## Printer
        Pframe = gtk.Frame(self.sub_title[0])
        base_vbox.pack_start(Pframe, gtk.FALSE, gtk.FALSE, 0)
        Pframe.show()

        Dev_box = gtk.HBox(gtk.FALSE, 0)
        Dev_box.show()
        Pframe.add(Dev_box)

        ## Printer
        Abox = gtk.VBox(gtk.FALSE, 0)
        Abox.show()
        Dev_box.pack_start(Abox, gtk.TRUE, gtk.FALSE, 0)
        self.S_maker = gtk.Label(self.S.get_printermaker())
        self.S_maker.show()
        Abox.pack_start(self.S_maker, gtk.FALSE, gtk.FALSE, 0)

        ppbox = gtk.HBox(gtk.FALSE, 0)
        ppbox.show()
        Abox.pack_start(ppbox,gtk.FALSE, gtk.FALSE, 0)

        pbutton,self.S_printer = self.GUI.table_set(self.P.T_printer)
        ppbox.pack_start(pbutton,gtk.FALSE, gtk.FALSE, 0)

        ## status
        self.status_button = gtk.Button(self.sub_title[5])
        self.status_button.connect_object("clicked", self.button_status,None)
        ppbox.pack_start(self.status_button,gtk.FALSE,gtk.FALSE, 0)
        if self.PJL.get_func(self.PJL.P_SNMP).get_support() == self.S.ON:
            self.status_button.show()
        else:
            self.status_button.hide()

        ## Color Printer
        Bbox = gtk.VBox(gtk.FALSE, 0)
        Bbox.show()
        Dev_box.pack_start(Bbox, gtk.TRUE, gtk.FALSE, 0)
        color_title = gtk.Label(self.P.get_func(self.P.T_colortype).get_title())
        color_title.show()
        Bbox.pack_start(color_title, gtk.FALSE, gtk.FALSE, 0)
        self.color_box = self.GUI.make_radiobutton(self.GUI.Horizontal,self.P.T_colortype)
        Bbox.pack_start(self.color_box,gtk.FALSE,gtk.FALSE, 0)

## Frame-2
        Aframe = gtk.Frame("")
        base_vbox.pack_start(Aframe, gtk.FALSE,gtk.FALSE ,0)
        Dev_box = gtk.HBox( gtk.FALSE, 0)
        Dev_box.show()
        Aframe.add(Dev_box)

    ## Abox
        Abox = gtk.VBox(gtk.FALSE, 0)
        Abox.show()
        Dev_box.pack_start(Abox, gtk.TRUE, gtk.FALSE, 0)
        A_group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
        A_table = self.GUI.create_table(3)
        Abox.pack_start(A_table, gtk.FALSE,gtk.FALSE, 0)

        # Copies
        self.copies = self.GUI.make_spin(self.P.T_copies)
        self.GUI.group_table(A_table, 0,A_group,self.P.T_copies,self.copies)
        self.longmargin = self.GUI.make_spin( self.P.T_marginleft)
        self.GUI.group_table(A_table, 1,A_group,self.P.T_marginleft,self.longmargin)
        self.fontsize = self.GUI.make_spin(self.P.T_fontsize ,self.GUI.FLoat)
        self.GUI.group_table(A_table, 2,A_group, self.P.T_fontsize, self.fontsize)
        A_table.show()

        ## Page Range
        pabox = gtk.VBox(gtk.FALSE, 0)
        Abox.pack_start(pabox, gtk.FALSE, gtk.FALSE, 0)
        label = gtk.Label(self.P.get_func(self.P.T_pageall).get_title())
        label.show()
        self.page_box = self.GUI.make_radiobutton(self.GUI.Vertical,self.P.T_pageall)

        range_box = gtk.HBox(gtk.FALSE, 0)
        range_box.pack_start(label,gtk.TRUE,gtk.FALSE,0)
        range_box.pack_start(self.page_box, gtk.TRUE, gtk.FALSE, 0)
        range_box.show()
        pabox.pack_start(range_box,gtk.TRUE,gtk.FALSE,0)
        pabox.show()

        self.pageRangeBox,ent = self.GUI.input_hbox(self.P.T_pagerange,1,None,self.callback_range)
        pabox.pack_start(self.pageRangeBox, gtk.FALSE, gtk.FALSE, 0)
        if self.P.get_func(self.P.T_pageall).get_value() == 0: # 0 ==> all print
            self.pageRangeBox.hide()

    ## Bbox
        Bbox = gtk.VBox(gtk.FALSE, 0)
        Bbox.show()
        Dev_box.pack_start(Bbox, gtk.TRUE, gtk.FALSE, 0)
        B_group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
        B_table = self.GUI.create_table(4)
        Bbox.pack_start(B_table,gtk.FALSE, gtk.FALSE, 0)
        self.S_orientation = self.GUI.make_table(B_table,0,B_group,self.P.T_portrait)
        self.S_duplex  = self.GUI.make_table(B_table,1,B_group,self.PJL.P_duplex)
        self.nup       = self.GUI.make_table(B_table,2,B_group,self.P.T_nup)
        self.papersize = self.GUI.make_table(B_table,3,B_group,self.P.T_paper,self.set_userPaper) # paper size
        B_table.show()
        Aframe.show()

  ## File Selection
        Fframe = gtk.Frame(self.sub_title[1])
        base_vbox.pack_start(Fframe, gtk.FALSE, gtk.FALSE, 0)
        self.MFbox = gtk.VBox(gtk.FALSE, 0)
        self.MFbox.show()
        Fframe.add(self.MFbox)

        Fbox = gtk.HBox(gtk.FALSE, 0)
        Fbox.show()
        self.MFbox.pack_start(Fbox, gtk.TRUE, gtk.FALSE,0)
        # entry
        OPbox ,self.entry = self.GUI.input_hbox(self.P.T_outprinter,0)
        Fbox.pack_start(OPbox, gtk.TRUE, gtk.TRUE, 0)
        # File Select
        Fbutton = dialog_menu.selectFile2(self.fDialoue,self.P.T_outprinter)
        Fbox.pack_start(Fbutton,gtk.FALSE, gtk.FALSE, 0)

    ## multi-files
        self.MSbox = gtk.HBox(gtk.FALSE, 0)
        self.MFbox.pack_start(self.MSbox, gtk.TRUE, gtk.FALSE,0)
        ## file align
        self.fbutton,self.filealign = self.GUI.table_set(self.P.T_filealign)
        self.MSbox.pack_start(self.fbutton, gtk.TRUE, gtk.FALSE,0)
        ## error_stop
        self.errorstop = self.GUI.make_chkbutton(self.P.T_errorstop)
        self.MSbox.pack_start(self.errorstop,gtk.TRUE,gtk.FALSE,0)
        ## selected files list
        selected_button = gtk.Button(self.sub_title[4]) # '' ,gtk.STOCK_DIALOG_INFO) #
        selected_button.connect("clicked",self.selected_list)
        self.MSbox.pack_start(selected_button, gtk.TRUE, gtk.FALSE,0)
        selected_button.show()
        self.select_multifile()
        Fframe.show()

    ## Output Printer or File
        out_frame = gtk.Frame('') #self.P.get_func(self.P.T_output).get_title())
        base_vbox.pack_start(out_frame, gtk.FALSE, gtk.FALSE, 0)
        out_frame.show()
        Tbox = gtk.VBox(gtk.FALSE, 0)
        Tbox.show()
        out_frame.add(Tbox)

        ## Abox
        Pbox = gtk.HBox(gtk.FALSE, 0)
        Pbox.show()
        Tbox.pack_start(Pbox, gtk.FALSE,gtk.TRUE, 0)
        outbox,self.toutput = self.GUI.table_set(self.P.T_output)
        outbox.set_border_width(5)
        Pbox.pack_start(outbox,gtk.FALSE, gtk.FALSE,0)

        ## Bbox
        self.PPbox = gtk.VBox(gtk.FALSE, 0)
        self.PPbox.show()
        Tbox.pack_start(self.PPbox,gtk.FALSE, gtk.FALSE, 0)

        ## output file
        self.Out_box = self.outfile_select()
        self.PPbox.pack_start(self.Out_box, gtk.FALSE, gtk.FALSE, 0)
        ## Printer extra option
        self.Option_box = self.option_select()
        self.PPbox.pack_start(self.Option_box, gtk.FALSE, gtk.FALSE, 0)
        self.outfile_menu()
        return base_vbox

    def redraw(self):
        self.S.set_mainTitle()
        self.S_maker.set_label(self.S.get_printermaker())
 
    ## 2004.11.17 modified
        val = self.P.get_func(self.P.T_printer).get_selected()
        self.S_printer.set_history(val)

        if self.PJL.get_func(self.PJL.P_SNMP).get_support() == self.S.ON:
            self.status_button.show()
        else:
            self.status_button.hide()

        colors = self.color_box.get_children()
        if self.P.get_func(self.P.T_colortype).get_value() == 1:
            colors[1].set_active(gtk.TRUE)
        else:
            colors[0].set_active(gtk.TRUE)

        self.copies.set_value(self.P.get_func(self.P.T_copies).get_value())
        self.longmargin.set_value(self.P.get_func(self.P.T_marginleft).get_value())
        self.fontsize.set_value(self.P.get_func(self.P.T_fontsize).get_value())
        pagerange = self.page_box.get_children()

        if self.P.get_func(self.P.T_pageall).get_value() == 0:
            pagerange[0].set_active(gtk.TRUE)
            self.pageRangeBox.hide()
        else:
            pagerange[1].set_active(gtk.TRUE)
            self.pageRangeBox.show()

        self.S_orientation.set_history(self.P.get_func(self.P.T_portrait).get_selected())

        if self.PJL.get_func(self.PJL.P_duplex).get_support() == self.S.OFF:
            self.S_duplex.set_history(0)
        else:
            self.S_duplex.set_history(self.PJL.get_func(self.PJL.P_duplex).get_selected())
 
        self.nup.set_history(self.P.get_func(self.P.T_nup).get_selected())
        self.papersize.set_history(self.P.get_func(self.P.T_paper).get_selected())
        ##self.S.Page.tray.redraw_paperSize()

        self.toutput.set_history(self.P.get_func(self.P.T_output).get_selected())
        self.select_multifile()
        self.outfile_menu()

    def callback_range(self,widget,event,entry):
        if event.type == gtk.gdk.KEY_RELEASE:
            keyname = entry.get_property('name')
            if keyname == self.P.T_pagerange:
                tmp = entry.get_text()
                if tmp == '' or tmp[-1] in '0123456789-,':
                    self.P.get_func(keyname).set_value(tmp)
                else:
                    entry.set_text(self.P.get_func(keyname).get_value())
                    entry.set_position(len(entry.get_text()))

## SNMP printer status
    def button_status(self,data):
        if self.PJL.get_func(self.PJL.P_SNMP).get_support() == self.S.OFF:
            Lpy.snmp.snmp_get.print_snmp_error(4)
            return None

        host,community,port = self.PJL.get_func(self.PJL.P_SNMP).get_port()
        GetSNMP = Lpy.snmp.snmp_get.Get_SNMP(host,community,port)
        ret = GetSNMP.check_snmp_ports()
        if ret is None:
            return None

        ret = GetSNMP.get_snmp_printer()
        if ret is None:
            return None

        data = []
        data2 = GetSNMP.SNMP_Data.get_status_data()
        if data2:
            data.append( data2)

        data2 = GetSNMP.SNMP_Data.get_alert_data(2)
        if data2:
            data.extend( data2)

        data2 = GetSNMP.SNMP_Data.get_toner_remain()
        if data2:
            data.extend( data2)

        dialog_menu.message_lists(self.sub_title[6],data,None,450,350)

## Custom Paper Size
    def set_userPaper(self,item,keyname,data):
        if data == Lpy.paper_size.UserSize:
            units,width,height = self.P.get_func(self.P.T_paper).get_user_paperSize()
            dat = [[self.units_title[1],list(Lpy.paper_size.unitsList),units],
                   [self.units_title[2],width],[self.units_title[3],height]]
            ret = dialog_menu.input_dialog(self.units_title[0],dat,200,100)
            if ret:
                self.P.get_func(self.P.T_paper).set_user_paperSize(ret[0],ret[1],ret[2])
                self.S.Page.tray.redraw_paperSize()
        else:
            self.P.get_func(self.P.T_paper).set_value(data)
            self.S.Page.tray.redraw_paperSize(data)

## File slect dialogue
    def fDialoue(self, widget,keyname):
        if keyname == self.P.T_outprinter:
            filename = self.P.get_func(self.P.T_outprinter).get_value()
            dialog_menu.fileDialog_multi(None,self.callback_outprinter,filename,self.sub_title[3])

        elif keyname == self.P.T_outfile:
            filename = self.P.get_func(self.P.T_outfile).get_value()
            dialog_menu.fileDialog(None,self.callback_outfile,filename,"")

    def callback_outprinter(self,filenames):
        self.P.get_func(self.P.T_outprinter).set_value(filenames)
        filename = self.P.get_func(self.P.T_outprinter).get_value()
        if filename:
            self.entry.set_text(filename)
            self.entry.set_position(len(filename))
        else:
            self.entry.set_text('')
            self.entry.set_position(0)
        self.S.Page.paper.set_title_name(os.path.basename(filename))
        self.redraw()

    def callback_outfile(self,file):
        name = self.P.get_func(self.P.T_outfile).set_output_name(file)
        self.outfile.set_text(name)
        self.outfile.set_position(len(name))

## Extra printing Option
    def option_select(self):
        Option_box = gtk.HBox(gtk.FALSE,0)
        Option_box.show()
        label = gtk.Label(self.P.get_func(self.P.T_option).get_title())
        Option_box.pack_start(label,gtk.FALSE, gtk.FALSE, 0)
        label.show()
        OPbox ,self.ex_option = self.GUI.input_hbox(self.P.T_option,0)
        OPbox.set_size_request(self.S.Hsize - 120,-1)
        Option_box.pack_start(OPbox,gtk.FALSE, gtk.FALSE, 0)
        return Option_box

 ## OutFile Set
    def outfile_select(self):
        #self.P.get_func(self.P.T_outfile).set_output_name()
        Tbox = gtk.HBox(gtk.FALSE, 0)
        Tbox.show()

        Fbutton = dialog_menu.selectFile2(self.fDialoue,self.P.T_outfile)
        Tbox.pack_start(Fbutton,gtk.FALSE, gtk.FALSE, 0)

        ## OutFile Filename input # label_text = None,callback
        OPbox ,self.outfile = self.GUI.input_hbox(self.P.T_outfile,0)
        OPbox.set_size_request(self.S.Hsize - 120,-1)
        Tbox.pack_start(OPbox,gtk.FALSE,gtk.FALSE,0) # gtk.TRUE
        return Tbox

    def outfile_menu(self):
        if self.P.get_func(self.P.T_output).get_value() == 1: # output file
            self.Option_box.hide()
            self.Out_box.show()
            self.PPbox.reorder_child(self.Out_box,1)
        else:
            self.Out_box.hide()
            self.Option_box.show()
            self.PPbox.reorder_child(self.Option_box,1)

 ## multifiles selected
    def select_multifile(self):
        files = self.P.get_func(self.P.T_outprinter).get_filenames()
        if files:
            nup = self.P.get_func(self.P.T_nup).get_value()
            if nup >=1:
                self.fbutton.show()
            else:
                self.fbutton.hide()

            if self.P.get_func(self.P.T_errorstop).get_value() == 1:
                self.errorstop.set_active(gtk.TRUE)
            else:
                self.errorstop.set_active(gtk.FALSE)
            self.filealign.set_history(self.P.get_func(self.P.T_filealign).get_selected())
            self.MSbox.show()
        else:
            self.MSbox.hide()

    def selected_list(self,button):
        files = self.P.get_func(self.P.T_outprinter).get_filenames()
        data = ''
        count = 0
        for filename in files:
            count += 1
            data += "%3d: %s%s" % (count,filename,os.linesep)
        dialog_menu.message_dialog(self.sub_title[4],data,None,450,140)
