#
#       set_media.py
#
#       2003.6.17
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################
import gtk

class MediaTypes:
    import Lpy.pjl.pjl_title 
    #title = " MediaType"
    sub_title = (Lpy.pjl.pjl_title.u_interleaveMedia,)
    table_num = 2

    def __init__(self):
        self.resolv_list = None
        self.media_list  = None
        self.cover_list  = None
        self.insert_list = None

    def page(self):
        base_vbox = gtk.VBox(gtk.FALSE, 0)
        base_vbox.set_border_width(self.PP.Border)
        base_vbox.show()

        Noteframe = gtk.Frame()
        base_vbox.pack_start(Noteframe, gtk.FALSE, gtk.FALSE, 0)
        table = gtk.Table(4,self.table_num,gtk.FALSE)
        Noteframe.add(table)
        Noteframe.show()
        table.show()
        self.notebook = gtk.Notebook()
        self.notebook.set_tab_pos(gtk.POS_TOP)
        table.attach(self.notebook, 0,self.table_num,0,1)

        ## Resolution
        if self.PJL.get_func(self.PJL.P_resolution).get_support() != self.S.Never:
            self.resolv_list = self.PJL.get_func(self.PJL.P_resolution).get_tmplist()
            if self.resolv_list:
                self.select_list(self.PJL.P_resolution,self.resolv_list,4)

        ## MediaType
        if self.PJL.get_func(self.PJL.P_mediatype).get_support() != self.S.Never: # == self.S.ON:
            self.media_list = self.PJL.get_func(self.PJL.P_mediatype).get_tmplist()
            if self.media_list:
                self.select_list(self.PJL.P_mediatype,self.media_list,3)

        if self.PJL.get_func(self.PJL.P_coverMedia).get_support() != self.S.Never:
            self.cover_list = self.PJL.get_func(self.PJL.P_coverMedia).get_tmplist()
            if self.cover_list:
                self.select_list(self.PJL.P_coverMedia,self.cover_list,3)

        if self.PJL.get_func(self.PJL.P_insertMedia).get_support() != self.S.Never:
            self.insert_list = self.PJL.get_func(self.PJL.P_insertMedia).get_tmplist()
            if self.insert_list:
                self.select_list(self.PJL.P_insertMedia,self.insert_list,3,self.sub_title[0])

        self.notebook.set_current_page(1)
        self.notebook.show()
        return base_vbox

    def select_list(self,keyname,mlist,col,title = None):
        Dev_box = gtk.VBox(gtk.FALSE, 0)
        Dev_box.show()

        hbox = gtk.HBox(gtk.FALSE, 0)
        hbox.show()
        chk = self.GUI.make_chkbutton(keyname,title)
        hbox.pack_start(chk,gtk.FALSE,gtk.FALSE,20)
        Dev_box.pack_start(hbox, gtk.TRUE,gtk.FALSE,0)
        ## separetor
        separator = gtk.HSeparator()
        Dev_box.pack_start(separator, gtk.FALSE, gtk.TRUE, 0)
        separator.show()

        namelist = self.PJL.get_func(keyname).get_select_list()
        Dev_box.pack_start(self.GUI.chkbutton_dict(namelist,mlist,col),gtk.TRUE,gtk.FALSE,0)
        if title:
            self.notebook.append_page(Dev_box,gtk.Label(title))
        else:
            self.notebook.append_page(Dev_box,gtk.Label(self.PJL.get_func(keyname).get_title()))

    def set_parmlists(self):
        if self.resolv_list != None:
            self.PJL.get_func(self.PJL.P_resolution).set_tmplist(self.resolv_list)

        if self.media_list != None:
            self.PJL.get_func(self.PJL.P_mediatype).set_tmplist(self.media_list)

        if self.cover_list != None:
            self.PJL.get_func(self.PJL.P_coverMedia).set_tmplist(self.cover_list)

        if self.insert_list != None:
            self.PJL.get_func(self.PJL.P_insertMedia).set_tmplist(self.insert_list)



