#
#       set_snmp.py
#
#       2003.7.22
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################################
import gtk
import os

import Lpy.utils.get_env
import Lpy.snmp.snmp_get

import gui_set
import set_snmp_data

class MakerSNMP(set_snmp_data.Set_SNMP_Data):
    #title = " SNMP"
    import Lpy.pjl.pjl_title 
    snmp_name = (Lpy.pjl.pjl_title.u_hostname,
                 Lpy.pjl.pjl_title.u_communityName,
                 Lpy.pjl.pjl_title.u_snmp_port)

    hostname_err  = Lpy.pjl.pjl_title.u_hostname_err
    community_err = Lpy.pjl.pjl_title.u_community_err

    def __init__(self):
        self.SNMP = None

    def page(self):
        self.SNMP = self.PJL.get_func(self.PJL.P_SNMP)
        base_vbox = gtk.VBox(gtk.FALSE, 0)
        base_vbox.set_border_width(self.PP.Border)
        base_vbox.show()

    ## SNMP
        Sframe = gtk.Frame(self.sub_title[0])
        base_vbox.pack_start(Sframe, gtk.FALSE, gtk.FALSE,0)
        Dev_box = gtk.HBox( gtk.FALSE,0)
        Dev_box.show()
        Sframe.add(Dev_box)
        Sframe.show()

        ADev_box = gtk.VBox(gtk.FALSE,0)
        ADev_box.show()
        Dev_box.pack_start(ADev_box, gtk.TRUE,gtk.FALSE,0)

        self.host,self.community,self.port = self.SNMP.get_port()

        # support
        self.A_snmp = self.GUI.make_chkbutton(self.PJL.P_SNMP)
        ADev_box.pack_start(self.A_snmp, gtk.FALSE,gtk.FALSE, 0)

        self.host_entry = gui_set.input_box(self.snmp_name[0],self.get_entry_data,self.host)
        self.comm_entry = gui_set.input_box(self.snmp_name[1],self.get_entry_data,self.community)
        # port
        self.snmpPort = self.snmp_port(self.port)

        A_group = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
        A_table = gui_set.create_table(3)
        gui_set.group_menu(A_table,A_group,0,gui_set.set_label(self.snmp_name[0]),self.host_entry)
        gui_set.group_menu(A_table,A_group,1,gui_set.set_label(self.snmp_name[1]),self.comm_entry)
        gui_set.group_menu(A_table,A_group,2,gui_set.set_label(self.snmp_name[2]),self.snmpPort)

        ADev_box.pack_start(A_table, gtk.FALSE,gtk.FALSE, 0)
        A_table.show()

        snmp_button = gtk.Button(self.sub_title[1])
        snmp_button.connect("clicked", self.snmp_check)
        ADev_box.pack_start(snmp_button,gtk.FALSE,gtk.FALSE,8)
        snmp_button.show()

    ## IPP
        """
        BDev_box = gtk.VBox(gtk.FALSE, 0)
        BDev_box.show()
        Dev_box.pack_start(BDev_box, gtk.TRUE,gtk.FALSE,0)
        BDev_box.pack_start(self.GUI.make_chkbutton('IPP'),gtk.FALSE,gtk.FALSE,0)
        """

        return base_vbox

    def change_tmp_value(self):
        self.SNMP = self.PJL.get_func(self.PJL.P_SNMP)
        if self.SNMP.get_tmp() == self.P.ON:
            self.A_snmp.set_active(gtk.TRUE)
        else:
            self.A_snmp.set_active(gtk.FALSE)

        self.host,self.community,self.port = self.SNMP.get_port()
        if self.host:
            self.host_entry.set_text(self.host)
        else:
            self.host_entry.set_text('')

        if self.community:
            self.comm_entry.set_text(self.community)
        else:
            self.comm_entry.set_text('')

        if self.port:
            self.snmpPort.set_value(self.port)

    def set_tmp_value(self):
        self.SNMP.set_tmp_value()
        if self.SNMP.get_tmp() == self.P.ON:
            self.SNMP.set_host(self.host)
            self.SNMP.set_community(self.community)
            self.SNMP.set_port(self.port)
        else:
            self.SNMP.set_host('')
            self.SNMP.set_community('')

    ### hostname
    def get_entry_data(self, widget,event,entry):
        if event.type == gtk.gdk.KEY_RELEASE:
            if entry.get_property('name') == self.snmp_name[0]: # hostname
                data = entry.get_text()
                if len(data) < 2:
                    self.host = ''
                    return None
                dat = Lpy.utils.get_env.check_hostname(data)
                if len(dat) >= 2:
                    self.host = dat
                else:
                    self.host = ''
                    entry.set_text('')
                    Lpy.snmp.snmp_get.print_snmp_error(2,self.hostname_err)

            elif entry.get_property('name') == self.snmp_name[1]: # community
                data = entry.get_text()
                data = data.strip()
                if len(data) < 2:
                    self.community = ''
                    return None
                dat = Lpy.utils.get_env.check_name(data,0)
                if dat:
                    self.community = ''
                    entry.set_text('')
                    Lpy.snmp.snmp_get.print_snmp_error(3,self.community_err)
                else:
                    self.community = data

    def callback_port(self,widget, spin):
        port = spin.get_value_as_int()
        if (port >= 161 and port <= 162) or (port >1024 and port <= 65535):
            self.port = port
        else:
            widget.set_value(self.port)

    def snmp_port(self,port):
        max = 65535.0 # MAX
        interv = 10.0
        min = 161.0
        adj = gtk.Adjustment(port,min,max,1.0,interv ,0.0)
        copies = gtk.SpinButton(adj,0,0)
        copies.set_numeric(gtk.TRUE)
        adj.connect("value_changed",self.callback_port,copies)
        copies.show()
        return copies

