#
#   lpy_argset.py
#
#   2004.1.26
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import sys

import Lpy.lpy_version
import Lpy.def_spooler

def usage():
    print "Usage:%s [options] [spooler parameters] [filenames]" % Lpy.lpy_version.Command_name
    print "   options"
    print "     --help"
    print "     --version"
    print "     --menu :Display menu mode"
    print "     --line :Command line mode"
    print 
    print "   spooler parameters"
    print "     lpr or lp parameters"
    print 
    print "   example)"
    print "     %s --li(ne) filename # command line mode" % Lpy.lpy_version.Command_name
    print "     %s --me(nu) filename # menu mode" % Lpy.lpy_version.Command_name
    print 

def print_version():
    print "%s is %s" % (Lpy.lpy_version.Command_name,Lpy.lpy_version.Description)
    print "Version  : %s" % Lpy.lpy_version.Version
    print "Copyright: %s" % Lpy.lpy_version.Copyright
    print "License  : %s" % Lpy.lpy_version.License
    print "URL      : %s" % Lpy.lpy_version.URL

###################################
menu_parm = ['menu',"Menu"]
line_parm = ["line","Line"]
help_parm = ["help","Help"]
vers_parm = ["version","Version"]
longparm = menu_parm + line_parm + help_parm + vers_parm

lpr_parm = "1:2:3:4:#:ABC:D:F:GJ:K:NP:QR:T:U:VX:YZ:bcdfghi:klm:npqrstvw:o:LE"
lp_parm  = "ckmprswd:BD:f:GH:n:o:P:q:S:t:T:X:Yy:h:i:p:E"


class Lpy_ArgSet:
## BSD spooler (lpr) #####################
    def set_lpr_args(self,key,dat):
        if key == '-#' or key == '-K':
            self.get_func(self.T_copies).set_value(int(dat))
        elif key == '-r':
            self.get_func(self.T_outprinter).set_remove()
        elif key == '-m': # end mail
            if dat:
                import Lpy.utils.get_env
                data = Lpy.utils.get_env.check_mail_address(dat)
                if data <= 2:
                    self.args_error("bad mail_address. (-m %s)" % dat)
                else:
                    self.tmp_options += "%s %s " % (key,data)
        elif key == '-Y': # send port
            self.tmp_options += "%s %s " % (key,dat)
        elif key == '-l':  # raw filetype
            import Lpy.fconvert.file_type
            self.get_func(self.T_outprinter).set_ftype(Lpy.fconvert.file_type.F_binary)
        elif key == '-s':  # use symlink
            self.tmp_options += "-s "
        #elif key == '-i': # indent
        #elif key == '-h': # no_burst
        elif key == '-T': # title,filename
            self.get_func(self.T_titletext).set_value(dat)
        elif key == '-J':  # jobname
            self.get_func(self.T_outprinter).set_ptitle(dat)
        elif key == '-C': # hostname
            self.tmp_options += "%s %s " % (key,dat)
            self.PJL.get_func(self.PJL.P_SNMP).set_host(dat)
        elif key == '-U':  # User
            self.get_func(self.T_useridtext).set_value(dat)
        elif key == '-A': ## auth LPR-ng
            self.tmp_options += "-A "
        elif key == '-Q': # holding
            self.tmp_options += "-Q "

## BSD (CUPS)
    def set_lpr_cups(self,key,dat):
        if key == '-#' :
            self.get_func(self.T_copies).set_value(int(dat))
        elif key == '-r':
            self.get_func(self.T_outprinter).set_remove()
        elif key == '-p': # pretty
            self.get_func(self.T_header).set_value(1)
            self.get_func(self.T_border).set_value(1)
        elif key == '-l':  # raw filetype
            import Lpy.fconvert.file_type
            self.get_func(self.T_outprinter).set_ftype(Lpy.fconvert.file_type.F_binary)
        #elif key == '-i' # indent
        elif key == '-T': # title,filename
            self.get_func(self.T_titletext).set_value(dat)
        elif key == '-J':  # 'J' : Job name
            self.get_func(self.T_outprinter).set_ptitle(dat)
        elif key == '-C': # hostname
            self.tmp_options += "%s %s " % (key,dat)
            self.PJL.get_func(self.PJL.P_SNMP).set_host(dat)
        elif key == '-E': # CUPS only
            self.tmp_options += "-E "
        elif key == '-q': # holding
            self.tmp_options += "-q "
        #elif key == '-o': # option,
        #   self.cups_options(dat)

####################################
## SYSTEM V spooler (lp)
    def set_lp_args(self,key,dat):
        if key == '-n':
            self.get_func(self.T_copies).set_value(int(dat))
        elif key == '-P':
            if dat:
                self.get_func(self.T_pagerange).set_value(dat)
        elif key == '-m' or key == '-w': # end mail ;  dat == mailaddress
            if dat:
                import Lpy.utils.get_env
                data = Lpy.utils.get_env.check_mail_address(dat)
                if data <= 2:
                    self.args_error("bad mail_address. (%s %s)" % (key,dat))
                else:
                    self.tmp_options += "%s %s " % (key,data)
        elif key == "-q": # priority,
            self.tmp_options += "%s %s " % (key,dat)
        elif key == '-h': #server,
            self.tmp_options += "%s %s " % (key,dat)
            self.PJL.get_func(self.PJL.P_SNMP).set_host(dat)
        elif key == '-Y': #_port,
            self.get_func(self.T_copies).set_value(int(dat))
        elif key == '-t': # job title
            self.get_func(self.T_outprinter).set_ptitle(dat)
        elif key == "-s": #silent mode
            self.tmp_options += "-s "
        elif key == '-A': ## auth LPR-ng
            self.tmp_options += "-A "
        elif key == '-H': ## "hold"
            if dat == "hold": ## Solaris
                self.tmp_options += "-H %s " % dat
        # option
        elif key == '-o':
            if dat == "nofilebreak" or dat == "nobanner":
                self.tmp_options += "-o %s " % dat

## SYTEM V (CUPS)
    def set_lp_cups(self,key,dat):
        if key == '-n':
            self.get_func(self.T_copies).set_value(int(dat))
        elif key == '-P':
            if dat:
                self.get_func(self.T_pagerange).set_value(dat)
        elif key == "-q": # L_priority,
            self.tmp_options += "%s %s " % (key,dat)
        elif key == '-h': # L_server,
            self.tmp_options += "%s %s " % (key,dat)
            self.PJL.get_func(self.PJL.P_SNMP).set_host(dat)
        elif key == '-t': # job title
            self.get_func(self.T_outprinter).set_ptitle(dat)
        elif key == "-s": #silent mode
            self.tmp_options += "-s "
        ## encryption
        elif key == '-E':
            self.tmp_options += "-E "
        elif key == '-H': ## "hold"
            if dat == "hold": ## Solaris
                self.tmp_options += "-H %s " % dat
        # option
        elif key == '-o': # option,
            if dat == "nofilebreak" or dat == "nobanner":
                self.tmp_options += "-o %s " % dat
            #self.cups_options(dat)
##
    def args_error(self,msg):
        import os
        print os.linesep,os.linesep
        print msg
        print os.linesep,os.linesep

        self.write_logs(msg)
        usage()
        sys.exit(1)

    def set_args(self,argvs):
        import getopt
        spooler = Lpy.def_spooler.spooler

        if spooler == Lpy.def_spooler.L_lpr:
            shortparm = lpr_parm
        else:
            shortparm = lp_parm

        try:
            opts, args = getopt.getopt(argvs,shortparm,longparm)
        except:
            self.args_error(_("%s has a bad argument. (%s)") % (Lpy.lpy_version.Command_name,argvs))

        self.get_func(self.T_outprinter).initialize()
        self.tmp_options = ''
        if opts:
            self.menutype = self.get_menutype(opts)
            self.set_option_data(spooler,opts)
        else:
            self.printer_ready(None)
        if args:
            self._set_arg(args)
        if len(self.tmp_options) >= 1:
            self.get_func(self.T_option).set_value(self.tmp_options)

    def _set_arg(self,arg):
        import Lpy.utils.file_utils
        for dat in arg:
            if dat == '-': # stdin
                tmpfile = Lpy.utils.file_utils.make_tmpfile('_stdin')
                ret = Lpy.utils.file_utils.write_tmpfile(tmpfile,sys.stdin.read(),"w")
                if ret is None:
                    self.args_error(_("I can't write a tmpfile for stdin data."))
                else:
                    self.get_func(self.T_outprinter).value_append(tmpfile,1)

            else:
                if Lpy.utils.file_utils.check_file(dat) in Lpy.utils.file_utils.Error_lists:
                    self.tmp_options += dat
                else:
                    self.get_func(self.T_outprinter).value_append(dat)

    def get_menutype(self,opts):
        menu = self.Display_menu
        for op,arg in opts:
            if len(op) >= 4 and op[:2] == '--':
                ll = op[2:]
                if ll in menu_parm:  # Menu mode
                    menu = self.Display_menu
                elif ll in line_parm:     # command Line mode
                    menu = self.Commandline
                elif ll in vers_parm: # version
                    print_version()
                    sys.exit(0)
                elif ll in help_parm: # help
                    usage()
                    sys.exit(1)
        return menu

    def printer_ready(self,printer):
        if printer:
            self.set_pjl_parm(printer)
            ret = self.load_a2ps(printer,self.lastprinter)
        else:
            ret = self.load_a2ps(None,self.lastprinter)
            if ret != self.ON:
                printer = self.PR.get_value()
                self.set_pjl_parm(printer)

        if ret != self.ON:
            ret = self.load_a2ps(self.printer)

        import Lpy.def_parm
        if ret != self.ON or self.printer == Lpy.def_parm.Dummy:
                self.menutype = self.Display_menu

    def set_option_data(self,spooler,opts):
        printer = None
        if spooler == Lpy.def_spooler.L_lpr:
            for op,arg in opts:
                if op == '-P':
                    printer = arg
                elif op == '-D':
                    self.Debug = int(arg)
        else:
            for op,arg in opts:
                if op == '-d':
                    printer = arg
                elif op == '-D':
                    self.Debug = int(arg)
        self.printer_ready(printer)

        if spooler == Lpy.def_spooler.L_lpr:
            for op,arg in opts:
                if arg == '' or arg == '--':
                    arg = None
                if op == '-P' or op == '-D':
                    continue
                else:
                    if Lpy.def_spooler.spool_daemon == Lpy.def_spooler.S_cups: # CUPS
                        self.set_lpr_cups(op,arg)
                    else:
                        self.set_lpr_args(op,arg)
        else:
            for op,arg in opts:
                if arg == '' or arg == '--':
                    arg = None
                if op == '-d' or op == '-D':
                     continue
                else:
                    if Lpy.def_spooler.spool_daemon == Lpy.def_spooler.S_cups: # CUPS
                        self.set_lp_cups(op,arg)
                    else:
                        self.set_lp_args(op,arg)
