#
#   def_mediatype.py
#
#   2003.10.24
#   2004.5.2
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
##############################
import pjl_title

class MediaTypes:
    typeMedia  = 'media'
    typeInsert = 'ohp_insert'
    typeCover  = 'Coverpaper'
    ##
    M_default = "Default"
    M_auto  = "Auto"
    M_Paper = "Paper"
    M_Color  = "Color"
    M_Bond   = "Bond"
 
    M_LetterHead = "LetterHead"
    M_Recycled   = "Recycled"
    M_PrePrinted = "PrePrinted"
    M_PrePunched = "PrePunched"
    M_Vellum  = "Vellum"
    M_Special = "Special"
    M_Glossy  = "Glossy"
    M_HeavyGlossy = "HeavyGlossy"

    M_Light  = "Light"
    M_Heavy  = "Heavy"
    M_Rough  = "Rough"
    M_ToughPaper = "ToughPaper"

    M_CardStock    = "CardStock"
    M_Transparency = "Transparency"
    M_Envelope   = "Envelope"
    M_JPpostCard = "JPpostCard"
    M_Labels     = "Labels"
    M_Film       = "Film"
    M_UserType1  = "UserType1"
    M_UserType2  = "UserType2"
    M_UserType3  = "UserType3"
    M_UserType4  = "UserType4"
    M_UserType5  = "UserType5"

    MediaLists = (M_default,M_auto,M_Paper,M_Color,M_Bond,M_LetterHead,
        M_Recycled,M_PrePrinted,M_PrePunched,M_Vellum,
        M_Special,M_Glossy,M_HeavyGlossy,M_Light,M_Heavy,
        M_Rough,M_ToughPaper,M_CardStock,
        M_Transparency,M_JPpostCard,M_Envelope,M_Labels,M_Film,
        M_UserType1,M_UserType2,M_UserType3,M_UserType4,M_UserType5
        )

    not_booklet = (M_Envelope,M_JPpostCard,M_Labels,M_Transparency,
            M_CardStock,M_Film)
 
    def hp_media(self,mediaType):
        if mediaType == self.typeMedia:
            self.select_dict = {
            self.M_default: [self.ON,pjl_title.u_default,"DEFAULTMEDIATYPE"],
            self.M_auto   : [self.ON,pjl_title.u_auto,"ANY"],
            self.M_Paper  : [self.ON,pjl_title.u_plainPaper,"PLAIN"], # PAPER
            self.M_Color  : [self.ON,pjl_title.u_colorPaper,'COLOR'],
            self.M_Bond   : [self.ON,pjl_title.u_bondPaper,'BOND'], 
 
            self.M_LetterHead : [self.ON,pjl_title.u_LetterHead,'LETTERHEAD'],
            self.M_Recycled   : [self.ON,pjl_title.u_Recycled,'RECYCLED'],
            self.M_PrePrinted : [self.ON,pjl_title.u_PrePrinted,'PREPRINTED'],
            self.M_PrePunched : [self.ON,pjl_title.u_PrePunched,'PREPUNCHED'],
            self.M_Vellum :     [self.ON,pjl_title.u_Vellum,'VELLUM'],
            self.M_Glossy :     [self.ON,pjl_title.u_GlossyPaper,'GLOSSY'],
            self.M_HeavyGlossy: [self.ON,pjl_title.u_HeavyGlossy,"HEAVYGLOSSY"],

            self.M_Light     : [self.ON,pjl_title.u_LightPaper,"LIGHT"],
            self.M_Heavy     : [self.ON,pjl_title.u_HeavyPaper,"HEAVY"],
            self.M_Rough     : [self.ON,pjl_title.u_RoughPaper,"ROUGH"],
            self.M_ToughPaper: [self.ON,pjl_title.u_ToughPaper,"TOUGHPAPER"],
 
            self.M_CardStock   : [self.ON,pjl_title.u_CardStock,"CARDSTOCK"],
            self.M_Transparency: [self.ON,pjl_title.u_Transparency,'TRANSPARENCY'],
            self.M_Envelope    : [self.ON,pjl_title.u_Envelope,'ENVELOPE'],
            self.M_Labels      : [self.ON,pjl_title.u_Labels,'LABELS'],
 
            self.M_UserType1  : [self.ON,pjl_title.u_user1,"USERTYPE1"],
            self.M_UserType2  : [self.ON,pjl_title.u_user2,"USERTYPE2"],
            self.M_UserType3  : [self.ON,pjl_title.u_user3,"USERTYPE3"],
           # self.M_UserType4  : [self.ON,pjl_title.u_user4,"USERTYPE4"],
           # self.M_UserType5  : [self.ON,pjl_title.u_user5,"USERTYPE5"],
            }
        else:
            self.select_dict = None

    def xerox_media(self,mediaType):
        if mediaType == self.typeMedia:
            self.select_dict = {
            self.M_default: [self.ON,pjl_title.u_default,"DEFAULTMEDIATYPE"],
            self.M_Paper  : [self.ON,pjl_title.u_plainPaper,"PLAIN"], 
            #self.M_Color  : [self.ON,pjl_title.u_colorPaper,'COLOR'],
            #self.M_Bond   : [self.ON,pjl_title.u_bondPaper,'BOND'], 
 
            self.M_Recycled   : [self.ON,pjl_title.u_Recycled,'RECYCLED'],
            self.M_PrePrinted : [self.ON,pjl_title.u_PrePrinted,'PREPRINTED'],
            self.M_PrePunched : [self.ON,pjl_title.u_PrePunched,'PREPUNCHED'],
            self.M_Envelope    : [self.ON,pjl_title.u_Envelope,'ENVELOPE'],
            self.M_Labels      : [self.ON,pjl_title.u_Labels,'LABELS'],
            }
        else:
            self.select_dict = {
            self.M_default: [self.ON,pjl_title.u_default,"DEFAULTMEDIATYPE"],
            self.M_Paper  : [self.ON,pjl_title.u_plainPaper,"PLAIN"], 
            self.M_Recycled   : [self.ON,pjl_title.u_Recycled,'RECYCLED'],
            self.M_PrePrinted : [self.ON,pjl_title.u_PrePrinted,'PREPRINTED'],
            self.M_PrePunched : [self.ON,pjl_title.u_PrePunched,'PREPUNCHED'],
            }

    def media_init(self,mediaType,vendor = None):
        if mediaType == self.typeMedia:

            self.select_dict = {
            self.M_Paper  : [self.ON,pjl_title.u_plainPaper,"PLAIN"], 
            self.M_Color  : [self.ON,pjl_title.u_colorPaper,'COLOR'],
            self.M_Bond   : [self.ON,pjl_title.u_bondPaper,'BOND'], 
            self.M_Recycled   : [self.ON,pjl_title.u_Recycled,'RECYCLED'],
            self.M_PrePrinted : [self.ON,pjl_title.u_PrePrinted,'PREPRINTED'],
            self.M_PrePunched : [self.ON,pjl_title.u_PrePunched,'PREPUNCHED'],
            self.M_Envelope   : [self.ON,pjl_title.u_Envelope,'ENVELOPE'],
            self.M_Labels     : [self.ON,pjl_title.u_Labels,'LABELS'],
            }

        else:
            self.select_dict = {
            self.M_Paper  : [self.ON,pjl_title.u_plainPaper,"PLAIN"], 
            self.M_Color  : [self.ON,pjl_title.u_colorPaper,'COLOR'],
            self.M_Bond   : [self.ON,pjl_title.u_bondPaper,'BOND'], 
            self.M_Recycled   : [self.ON,pjl_title.u_Recycled,'RECYCLED'],
            self.M_PrePrinted : [self.ON,pjl_title.u_PrePrinted,'PREPRINTED'],
            self.M_PrePunched : [self.ON,pjl_title.u_PrePunched,'PREPUNCHED'],
            }

    ## select_lists
    def set_selectDict(self,lists = None):
        if self.select_dict == None:
            print "Error:set_selectDict:select_dict is not defined."
            return None

        self.select_lists = []
        self.value_list = []
        self.media_dict = {}

        for key in self.MediaLists:
            if not self.select_dict.has_key(key):
                continue
            if lists:
                if self.select_dict[key][0] != self.Never:
                    self.select_dict[key][0] = self.OFF
                for name in lists:
                    if name == key:
                        self.select_dict[key][0] = self.ON
                        self.select_lists.append(self.select_dict[key][1])
                        self.media_dict[self.select_dict[key][1]] = self.select_dict[key][0]
                        break
                else:
                    continue
            else:
                self.select_lists.append(self.select_dict[key][1])
                self.media_dict[self.select_dict[key][1]] = self.select_dict[key][0]

            if self.select_dict[key][0] != self.ON:
                continue
            t_len = len(self.select_dict[key])
            if t_len == 3:
                self.value_list.append(self.select_dict[key][1])
            else:
                print "Error:(%s) select_dict IMedia_Dict." % key

    def get_mkey(self,media = None):
        if self.value == None:
            self.value = 0
        if media is None:
            media = self.value_list[self.value]
        for key in self.select_dict.keys():
            if media == self.select_dict[key][1]:
                return key
        return None

    def is_not_Booklet(self):
        media = self.get_mkey()
        if media in self.not_booklet:
            return self.OFF
        else:
            return self.ON

    def is_Transparency(self):
        if self.value and self.select_dict.has_key(self.M_Transparency):
            if self.value_list[self.value] == self.select_dict[self.M_Transparency][1]:
                return self.ON
            return self.OFF
        else:
            return None
    def get_pjlparm(self):
        if self.support != self.ON:
            return None
        media = self.get_pjl_media()
        if self.pjl_cmd and media:
            return "%s=%s" % (self.pjl_cmd,media)
        else:
            return None

    def get_pjl_media(self):
        key = self.get_mkey()
        if key:
            return self.select_dict[key][2]
        return None

    ## Save,Load
    def set_load_value(self,values):
        if values and len(values) >= 2:
            self.set_selectDict(values[1])
            self.set_value(values[0])
        else:
            self.support = self.OFF

    def get_save_value(self):
        if self.support != self.ON:
            return None
 
        mlist = []
        for name in self.value_list:
            key = self.get_mkey(name)
            if key:
                mlist.append(key)
        return self.get_selected(),mlist

