#
#   def_pjl.py
#
#   2003.9.26
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import types

import Lpy.def_class

class Vparm(Lpy.def_class.VPrint):
    T_Support = 1
    T_List  = 3 # Smooth,OutTray : select_dict

    def __init__(self):
        Lpy.def_class.VPrint.__init__(self)
        self.support = self.OFF
        self.pjl_cmd   = None
        self.pjl_lists = None
        self.cmd_list  = None
        self.pjl_options = None
        self.select_lists = None
        self.select_dict  = None
        self.value_list = None
        self.max_val  = 1
        self.save_list = self.OFF # value_list save
        self.unique   = self.ON # Vendor PJL command
        self.tmp      = self.Never
        self.tmpValue = None

    ## PJL set unique ##
    def check_unique(self):
        return self.unique

    def check_max(self,data):
        if self.max_val > 1:
            vv = int(data)
            if vv > 0 and vv <= self.max_val:
                return self.ON
            else:
                return self.OFF
        return self.ON

 ## PJL command
    def set_pjl_cmd(self,cmd):
        self.pjl_cmd = cmd
    def set_pjl_cmdlist(self,clist):
        self.pjl_lists = clist
    def get_pjl_cmd(self):
        return self.pjl_cmd
    def get_pjl_cmdlist(self):
        return self.pjl_lists

    def get_pjlparm(self):
        if self.support != self.ON:
            return None
        if self.pjl_cmd is None or self.pjl_lists is None:
            return None

        num = self.get_selected()

        if self.pjl_cmd in self.pjl_lists:
            return self.pjl_lists[num]

        if num >= 0 and num < len(self.pjl_lists):
           return "%s=%s" % (self.pjl_cmd, self.pjl_lists[num])
        else:
           return None

    def get_pjlparm2(self):
        return None

 ## val set ##
    def get_maxval(self):
        return self.max_val
    def set_maxval(self,value):
        self.max_val = value
    def get_select_list(self):
        if self.select_lists:
            return self.select_lists
        return None

 ## tmp value ##
    def set_tmp_data(self):
        self.tmp = self.support
        self.tmpValue = self.value

    def set_tmp_value(self):
        if self.support != self.Never:
            self.support = self.tmp
            self.value = self.tmpValue

    def set_tmp(self,tmp): # support
        if self.support != self.Never:
            self.tmp = tmp
    def set_tmpValue(self,tmp):
        self.tmpValue = tmp

    def get_tmp(self):
        if self.support == self.Never:
            return self.Never
        return self.tmp
    def get_tmpValue(self):
        if self.support == self.Never:
            return self.Never
        return self.tmpValue

    def get_tmp_select(self):
        if isinstance(self.tmpValue,types.IntType):
            return self.tmpValue
        return self.tuple_index(self.tmpValue)

    def get_tmplist(self):
        if self.support == self.Never or self.select_lists == None:
            #print "get_tmplist:Error",self.__class__.__name__
            return None

        tmplist = {}
        for key in self.select_lists:
            if not self.media_dict.has_key(key):
                continue
            if self.media_dict[key] == self.ON:
                tmplist[key] = self.ON
            else:
                tmplist[key] = self.OFF
        return tmplist

    def set_tmplist(self,tmplist):
        if self.support != self.ON:
            return None

        keys = tmplist.keys()
        self.value_list = []
        for key in self.select_lists:
            if not tmplist.has_key(key):
                continue
            if tmplist[key] == self.ON:
                self.media_dict[key] = self.ON
                self.value_list.append(key)
            else:
                self.media_dict[key] = self.OFF

        if len(self.value_list) == 0:
            self.value_list.append(self.select_lists[0])
            self.media_dict[self.value_list[0]] = self.ON

        if not self.value in self.value_list:
            self.value = 0

    def set_list_dict(self,value,vlist):
        if self.select_dict.has_key(value):
            self.select_dict[value][1] = vlist
        else:
            self.set_Error("set_list_dict",value,"parm error (%d)" % value)

    def set_vlist(self,vlist,value):
        if self.support == self.Never:
            return None

        self.value_list = vlist
        if value >= 0:
            self.set_value(value)

    ## save,load
    def set_load_value(self,values):
        if values is None:
            self.support = self.Never
            return None

        self.set_support(values[0])
        num = len(values)
        if num >= 3 and self.save_list == self.ON:
            self.set_vlist(values[2],values[1])
        elif num == 2:
            #print "values[1]",values[1],self.__class__.__name__
            self.set_value(values[1])

    def get_save_value(self):
        if self.support != self.ON:
            return None

        if isinstance(self.value,types.StringType):
            val = -1
            if self.save_static == self.OFF: # not maker,model
                if isinstance(self.value_list,(types.ListType,types.TupleType)):
                    val = self.get_selected()
            if val == -1:
                val = self.value
        else:
            val = self.value

        if self.save_list == self.ON:
            return self.support,val,self.value_list
        else:
            return self.support,val


