#
#   pjl_printer.py
#
#   2003.9.25
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import def_pjl
import pjl_title

class PrinterInfo(def_pjl.Vparm):
    title = pjl_title.u_pname
    def __init__(self):
        def_pjl.Vparm.__init__(self)

        self.support = self.ON
        self.unique = self.ON
        self.value  = None
        self.Memory = None
        self.HD     = None

    def get_memory(self):
        return self.Memory
    def get_hd(self):
        return self.HD
    def set_memory(self,val):
        self.Memory = val
    def set_hd(self,val):
        self.HD = val
    def get_save_value(self):
        return (self.value,self.Memory,self.HD)
    def set_load_value(self,values):
        self.value = values[0]
        vv = len(values)
        if vv >= 2:
            self.Memory = values[1]
        if vv >= 3:
            self.HD = values[2]

class PrinterMaker(def_pjl.Vparm):
    title = pjl_title.u_maker
    def __init__(self,maker):
        def_pjl.Vparm.__init__(self)
        self.support = self.ON
        self.unique = self.ON
        self.save_static = self.ON
        self.value = maker

class PrinterType(def_pjl.Vparm):
    title  = pjl_title.u_printertype
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.unique = self.ON
        self.save_static = self.ON
        self.support = self.ON
        self.value   = None

    def check_model(self,ptype,model):
        self.value_list = self.get_namelists(self.model_lists)
        if ptype:
            self.value = self.get_keyname(ptype)

        if self.value == None:
            self.value = self.value_list[0]

    def get_save_value(self):
        if self.value_list:
            return self.support,self.get_keyname(self.value_list[self.get_selected()])
        else:
            return self.support,None

    def set_load_value(self,values):
        if values is None:
            return None
        self.set_support(values[0])
        num = len(values)
        if num <= 1:
            self.value = self.value_list[0]
            return None
        vv = self.get_typename(values[1])
        if vv in self.value_list:
            self.value = vv
        else:
            self.value = self.value_list[0]

class PrinterModel(def_pjl.Vparm):
    title = pjl_title.u_model
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.ON
        self.unique = self.ON
        self.save_static = self.ON

    def check_model(self,ptype,model):
        self.value_list = self.get_printer_model(self.get_keyname(ptype))

        #print "PrinterModel",ptype,model , self.value_list
        if model and model in self.value_list:
            self.value = model
            self.tmpValue = self.value
        if not self.value in self.value_list:
            self.value = self.value_list[0]

class PrinterLang(def_pjl.Vparm):
    title = pjl_title.u_lang 
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.ON
        self.unique = self.ON
        self.save_static = self.ON
        self.save_list = self.ON

    def check_model(self,ptype,model):
        self.value_list = self.get_langList(self.get_keyname(ptype),model)

        if not self.value in self.value_list:
            self.value = self.value_list[0]
        self.tmpValue = self.value

class GhostScript(def_pjl.Vparm):
    from  Lpy.lpy_programs import get_prg
    gs = get_prg('gs')
    title = pjl_title.u_gs_filter

    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.unique = self.ON
        self.support = self.OFF
        self.extra_args = None
        self.value   = 'ljet4'
        if self.gs :
            self.gs_base = "%s -q -dBATCH -dQUIET -dSAFER -dNOPAUSE " % self.gs

    def get_device_list(self,printer,lang,color,model):
        if self.gs is None:
            return None

        value_list = self.get_langList(self.get_keyname(printer),model,1)
        if self.tmpValue is None or not self.tmpValue in value_list:
            self.tmpValue = value_list[0]
        return value_list

    def check_model(self,ptype,model):
        pass

    def get_basefilter(self,papersize,hh):
        if self.gs is None:
            return None

        if hh is None:
            return "%s -sPAPERSIZE=%s -sOutputFile=-" % (self.gs_base,papersize)
        else:
            return "%s -dDEVICEWIDTHPOINTS=%s -dDEVICEHEIGHTPOINTS=%s -sOutputFile=-" % (self.gs_base,papersize,hh)

    def get_filter(self,papersize,hh):
        if self.support == self.ON and self.gs and self.value:
            filter = self.get_basefilter(papersize,hh)
            filter += " -sDEVICE=%s" % (self.value)
            if self.extra_args:
                filter += " %s" % self.extra_args
            return filter
        return None

class PrinterPJL(def_pjl.Vparm):
    title = pjl_title.u_pjl 
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.ON
        self.unique = self.ON
        self.save_static = self.ON
        self.value_list = None

    def check_model(self,ptype,model):
        ptype = self.get_keyname(ptype)
        if ptype == self.InkJet:
            self.support = self.OFF
            self.tmp = self.OFF
        else:
            self.support = self.OFF
            self.tmp = self.OFF
        self.value_list = self.get_langList(ptype,model,0)

    def check_personality(self,lang):
        if self.support == self.ON and self.value_list:
            if lang in self.value_list:
                return self.ON
        return self.OFF

class SNMP(def_pjl.Vparm):
    title = pjl_title.u_snmp
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.unique = self.ON
        self.value_list = '32-0'
        self.host = ""
        self.community = "public"
        self.port = 161
        self.vendorID = 0
        self.oid_support = self.OFF # enterprise MIB

    def set_host(self,host):
        self.host = host
    def set_community(self,community):
        self.community = community
    def set_port(self,port):
        self.port = port
    def set_id(self,id):
        self.vendorID = id
    def get_port(self):
        return (self.host,self.community,self.port)
    def get_id(self):
        return self.vendorID
    def get_oid_support(self):
        return self.oid_support

    def get_save_value(self):
        return (self.support,self.host,self.community,self.port,self.oid_support)
    def set_load_value(self,values):
        self.support = values[0]
        vv = len(values)
        if vv >= 2:
            self.host = values[1]
        if vv >= 3:
            self.community = values[2]
        if vv >= 4:
            self.port = values[3]
        if vv >= 5:
            self.oid_support = values[4]


class IPP(def_pjl.Vparm):
    title = pjl_title.u_ipp
    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.OFF
        self.unique  = self.ON
        self.value = 631

class Duplex(def_pjl.Vparm):
    title  = pjl_title.u_duplex
    title2 = pjl_title.u_duplexUnit

    def __init__(self):
        def_pjl.Vparm.__init__(self)
        self.support = self.ON
        self.pjl_lists = self.ON_OFF
        self.pjl_cmd = 'DUPLEX'
        self.value_list = (pjl_title.u_none,pjl_title.u_duplex) # ,'Tumble')

        self.set_value(0)
        self.auto_value = self.ON

    def get_title2(self):
        return self.title2

