"""
    lpy SNMP OID module
    2003.8.18
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
"""
import  rfc1213
import  hostMIB
import  printerMIB
import  jobmon
import  tc_printer

OID_rfc1213 = "rfc1213"
OID_host    = "host"
OID_printer = "printer"
OID_jobmon  = "jobmon"

def get_key_oid(name,flag = None):
    if flag == OID_rfc1213:
        return rfc1213.rfc1213.get(name,None)
    elif flag == OID_host:
        return hostMIB.hosts.get(name,None)
    elif flag == OID_printer:
        return printerMIB.PrinterMIB.get(name,None)
    elif flag == OID_jobmon:
        return jobmon.jobmon.get(name,None)
    else:
        if hostMIB.hosts.has_key(name):
            return hostMIB.hosts[name]
        if printerMIB.PrinterMIB.has_key(name):
            return printerMIB.PrinterMIB[name]
        if rfc1213.rfc1213.has_key(name):
            return rfc1213.rfc1213[name]
        if jobmon.jobmon.has_key(name):
            return jobmon.jobmon[name]
    return None

def get_tc_dict(name):
    return tc_printer.TC_index.get(name,None)

def get_tc(key,name):
    keyname = get_tc_dict(name)
    if keyname:
        return keyname.get(str(key),key)
    return key
