#
#       snmp_data.py
#
#       2003.9.9
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################
import os

import Lpy.pjl.pjl_title

import snmp_printer
import snmp_option
import print_mib

######
class SNMP_data(snmp_printer.SNMP_Printer,snmp_option.SNMP_Option):
    hrStorageFixedDisk  = '.1.3.6.1.2.1.25.3.1.4'
    hrDevicePrinter     = '.1.3.6.1.2.1.25.3.1.5'
    hrDeviceDiskStorage = '.1.3.6.1.2.1.25.3.1.6'

    SNMP_err = (Lpy.pjl.pjl_title.u_snmp_err0,
                Lpy.pjl.pjl_title.u_snmp_err1,
                Lpy.pjl.pjl_title.u_snmp_err2,
                Lpy.pjl.pjl_title.u_snmp_err3,
                Lpy.pjl.pjl_title.u_snmp_err4)

    def __init__(self,host,community,port):
        snmp_printer.SNMP_Printer.__init__(self,host,community,port)

        self.system_mib  = None
        self.if_mib      = None
        self.host_mib    = None
        self.printer_mib = None
        self.device_data = None
        self.p_index     = None
        self.options     = None
        self.productname = None

    def get_device_index(self,data,Index,start = 1):
        for num in range(start,len(data) + 1):
            ii = "%02d" % num
            if data.has_key(ii):
                dat = data[ii]
                #print ii,dat["2"]
                if dat["2"][1] == Index:
                   return num
        return None

    ## get general MIB data ##
    def get_mib_data(self,name):
        mib = self.get_snmp_data(name)
        return mib

    def get_enterpriseCode(self):
        key = self.get_string_index(self.p_index)
        if key is None:
            return None
        if self.device_data and self.device_data.has_key(key):
            data = self.device_data[key]["4"][1].split('.')
            return data[7]
        return None

    ## System Mib
    def get_system_mib(self):
        sys_mib = self.get_snmp_data('system')
        if sys_mib == None:
            #print "system MIB is None."
            return None
        if sys_mib:
            self.system_mib = self.check_snmp_system(sys_mib)
        return 1

    ## Host MIB
    def get_host_mib(self):
        Debug = 0
        if Debug :
            print "get_host_mib ::start"
        host_mib = self.get_snmp_data('host')
        if host_mib == None:
            err = self.SNMP_err[0] + os.linesep + self.SNMP_err[4] + os.linesep
            return None,err
        if Debug :
            print "get_host_mib:get_snmp_data :host:end"

        device_data = self.get_host_device(host_mib)
        if device_data == None:
            err = self.SNMP_err[2] + os.linesep
            return None,err
        if Debug :
            print "get_host_mib:get_host_device ::end"

        pIndex = self.get_device_index(device_data,self.hrDevicePrinter)
        if pIndex == None:
            err = self.SNMP_err[3] + os.linesep
            return None,err
        if Debug :
            print "get_host_mib:get_device_index ::end"

        self.host_mib    = host_mib
        self.device_data = device_data
        self.p_index     = str(pIndex)
        return pIndex,None

    ## Printer MIB
    def get_printer_mib(self):
        Debug = 0
        if Debug :
            print "get_printer_mib ::start"

        printer_mib = self.get_snmp_data('printmib')
        if printer_mib == None:
            err = self.SNMP_err[1] + os.linesep
            return None,err
        if Debug :
            print "get_printer_mib:get_snmp_data :printer_mib:end"
            print_mib.print_mib_debug(printer_mib)

        self.printer_mib = printer_mib
        return self.p_index,None

## Status Dialog data ###
    def get_string_index(self,name):
        if name == 0:
            return None
        if len(name) == 1:
            key = "0" + name
        else:
            key = name
        return key

    def check_printer_error(self):
        printer_status = self.get_printer_status(self.host_mib,self.p_index)
        if printer_status and printer_status["3"][1] != '0x0':
            return 1
        return None

    def get_status_data(self):
        data = []
        
        ## Vendor Status ##
        key = self.get_string_index(self.p_index)
        if self.device_data and self.device_data.has_key(key):
            dat = self.device_data[key]
            self.productname = dat["3"][1]
            data.append( print_mib.set_text_text(Lpy.pjl.pjl_title.u_product,dat["3"][1]))
            data.append( print_mib.set_text_text(Lpy.pjl.pjl_title.u_deviceStatus,dat["5"][1]))
            data.append( print_mib.set_text_text(Lpy.pjl.pjl_title.u_errorCount,dat["6"][1]))
     
        ## Printer Status ##
        printer_status = self.get_printer_status(self.host_mib,self.p_index)
        if printer_status:
            data.append( print_mib.set_text_text(Lpy.pjl.pjl_title.u_printer_status,printer_status["1"][1]))
            data.append( print_mib.set_text_text(Lpy.pjl.pjl_title.u_detectError,printer_status["2"][1]))
        return (Lpy.pjl.pjl_title.u_device_info, data)

    ## Alert ##
    def get_alert_data(self,flag = 1):
        if self.printer_mib == None:
            return None
        alert_dic = self.get_printer_Alert(self.printer_mib,self.p_index,flag)
        if alert_dic:
            #print "alert_dic",alert_dic  

            keys = alert_dic.keys()
            keys.sort()
            if flag == 1:
                return (Lpy.pjl.pjl_title.u_alert, print_mib.get_dict2_text(alert_dic))
            else:
                tmp = print_mib.get_dict2_text(alert_dic,2)
                data = []
                count = 1
                for key in tmp:
                    key.insert(0,"%s-%d = " % (Lpy.pjl.pjl_title.u_alert, count))
                    data.append((Lpy.pjl.pjl_title.u_alert,key))
                    count += 1
                return data
        return None

    def get_toner_remain(self):
        if self.options == None:
            self.get_printer_all_mib(self.printer_mib,self.p_index)
            self.get_snmp_options()

        data = self.get_print_supplies()
        if data:
            s_data = []
            data.insert(0, Lpy.pjl.pjl_title.u_suplly_remains + " = " )
            s_data.append((Lpy.pjl.pjl_title.u_suplly_remains,data))
            return s_data

        return None

    ## Disk
    def set_disk_mib(self):
            diskData = {}
            num = 1
            while num < len(self.device_data):
                diskIndex = self.get_device_index(self.device_data,self.hrDeviceDiskStorage,num)
                if diskIndex:
                    diskData[diskIndex] = self.get_host_disk(self.host_mib,str(diskIndex))
                    num = 1 + diskIndex
                else:
                    break
            return diskData
## Dialog data ###
    def get_dialog_data(self):
        data = []
        ## System
        #if self.system_mib:
        #    data.extend( print_mib.get_dict_text(self.system_mib,"System"))
        self.get_printer_all_mib(self.printer_mib,self.p_index)
        ## Status
        data2 = self.get_status_data()
        if data2:
            data.append( data2)
        data2 = self.get_alert_data(1)
        if data2:
            data.append( data2)
        ## Options
        self.get_snmp_options()
        if self.options:
            data2 = self.get_print_options()
            if data2:
                data.append((Lpy.pjl.pjl_title.u_option,data2))
            data2 = self.get_print_supplies()
            if data2:
                data.append((Lpy.pjl.pjl_title.u_suplly_remains,data2))
        ## storage
        storage_data = self.get_host_storage(self.host_mib,self.hrStorageFixedDisk)
        if storage_data:
            data.append( ( Lpy.pjl.pjl_title.u_memory, print_mib.get_dict2_text(storage_data)))
            diskData = self.set_disk_mib()
            if diskData:
                data.append( (Lpy.pjl.pjl_title.u_harddisk, print_mib.get_dict2_text(diskData)))
        ## Default
        data2 = self.get_mib_func(self.S_general)
        if data2:
            data.append( (Lpy.pjl.pjl_title.u_default, print_mib.get_dict_text(data2)))
        keys = self.snmp_func.keys()
        keys.sort()
        for tbl in keys:
            if tbl == self.S_general or tbl == self.S_Alert:
                continue
            dat = self.get_mib_func(tbl)
            if dat:
                data.append( (self.snmp_func[tbl][self.P_name],print_mib.get_dict2_text(dat)))
        return data
