#
#       snmp.snmp_get.py
#
#       2003.7.22
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################################
import os
import signal

import Lpy.message_win
import Lpy.pjl.pjl_title
import snmp_data

def print_snmp_error(flag,msg = None):
    import types
    import Lpy.lpy_main

    snmp_err = (Lpy.pjl.pjl_title.u_snmp_error0,
            Lpy.pjl.pjl_title.u_snmp_error1,
            Lpy.pjl.pjl_title.u_snmp_error2,
            Lpy.pjl.pjl_title.u_snmp_error3,
            Lpy.pjl.pjl_title.u_snmp_error4,
            Lpy.pjl.pjl_title.u_snmp_error5,
            Lpy.pjl.pjl_title.u_snmp_error6,
            Lpy.pjl.pjl_title.u_snmp_error7,
            Lpy.pjl.pjl_title.u_snmp_error8,
            Lpy.pjl.pjl_title.u_snmp_error9)     

    if isinstance(flag,types.IntType) and flag < len(snmp_err):
        if msg:
            msg_data = snmp_err[flag]
        else:
            msg_data = snmp_err[0]
            msg = snmp_err[flag]
    else:
        msg_data = flag
    
    Lpy.lpy_main.Printer.error_menu(msg_data,msg)

class Get_SNMP:
    enterprise_Head = '.1.3.6.1.4.1.'
    wait_title = (Lpy.pjl.pjl_title.u_snmp_wait0,
            Lpy.pjl.pjl_title.u_snmp_wait1,
            Lpy.pjl.pjl_title.u_snmp_wait2,
            Lpy.pjl.pjl_title.u_snmp_wait3)

    def __init__(self,host,community,port):
        self.version = 1
        self.timeout = 3.0
        self.retries = 4

        self.host = host
        self.community = community
        self.port = port

        self.SNMP_Data = None
        self.enterprise_data = None

    ## wait msg
    def start_wait_window(self,flag):
        if flag >= 1 and flag <= 2:
            msg = self.wait_title[flag]
        else:
            msg = None
        return Lpy.message_win.nowait_process(Lpy.message_win.wait_main,self.wait_title[0],msg,self.wait_title[3])

    def close_wait_window(self,pid,flag = 0):
        self.SNMP_Data.socket.close()
        if pid:
            os.kill(pid,signal.SIGKILL)

        if flag >= 1:
            err = "%s %s %s%s" % (self.host,self.community,self.port,os.linesep)
            print_snmp_error(flag,err)

    def check_snmp_ports(self):
        if self.host == '':
            print_snmp_error(2)
            return None
        if self.community == '':
            print_snmp_error(3)
            return None

        if (self.port >= 161 and self.port <= 162) or (self.port > 1024 and self.port < 65536):
            pass
        else:
            self.port = 161
        return 1

    def set_snmp_timeout(self,version,timeout,retries):
        if version == 0:
            version = self.version
        if timeout == 0:
            timeout = self.timeout
        if retries == 0:
            retries = self.retries
        return version,timeout,retries

    def get_snmp_printer(self,version = 0,timeout = 0,retries = 0):
        version,timeout,retries = self.set_snmp_timeout(version,timeout,retries)
        self.SNMP_Data = snmp_data.SNMP_data(self.host,self.community,self.port)
        err = self.SNMP_Data.socket_open(version,timeout,retries)
        if err:
            print_snmp_error(1,err)
            return None

        pid = self.start_wait_window(1)
        mib = self.SNMP_Data.get_system_mib()
        if mib == None:
            self.close_wait_window(pid,1)
            return None

        status,error = self.SNMP_Data.get_host_mib()
        if status == None:
            self.close_wait_window(pid,8)
            return None

        status,error = self.SNMP_Data.get_printer_mib()
        if status == None:
            self.close_wait_window(pid,6)
            return None
        self.close_wait_window(pid)
        return 1

    ## Enterprise Mib
    def get_enterprise_mib(self,vendorID = 0,version = 0,timeout = 0,retries = 0):
        version,timeout,retries = self.set_snmp_timeout(version,timeout,retries)

        if int(vendorID) >= 1:
            vendor = vendorID
        else:
            print_snmp_error(9)
            return  None

        if self.SNMP_Data is None:
            self.SNMP_Data = snmp.snmp_data.SNMP_data(self.host,self.community,self.port)

        err = self.SNMP_Data.socket_open(version,timeout,retries)
        if err:
            print_snmp_error(1,err)
            return None

        pid = self.start_wait_window(2)
        mib = self.SNMP_Data.check_enterprises_mib(self.enterprise_Head + vendor)
        if mib is None:
            self.close_wait_window(pid,7)
            return None

        self.close_wait_window(pid)
        data = {}
        for key in mib.keys():  # cut header
            data[key[len(self.enterprise_Head):]] = mib[key]
        return data

    ## Printer status
    def get_mibData(self,name,version = 0,timeout = 0,retries = 0):
        version,timeout,retries = self.set_snmp_timeout(version,timeout,retries)

        if self.SNMP_Data is None:
            self.SNMP_Data = snmp.snmp_data.SNMP_data(self.host,self.community,self.port)

        err = self.SNMP_Data.socket_open(version,timeout,retries)
        if err:
            print_snmp_error(1,err)
            return None

        mib = self.SNMP_Data.get_mib_data(name)
        self.SNMP_Data.socket.close()
        return mib


