#
#       Lpy.snmp.snmp_option.py
#
#       2004.7.9
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
############################
import os

import Lpy.def_parm
import Lpy.printer_model
import Lpy.pjl.pjl_title
import print_mib
import oid

def get_init_options():
    return  {
        Lpy.printer_model.o_printer: [None,None],
        Lpy.printer_model.o_color  : [None,None],
        Lpy.printer_model.o_supply : [None,None],
        Lpy.printer_model.o_lang   : [None,None],
        Lpy.printer_model.o_duplex : [None,None],
        Lpy.printer_model.o_intray : [None,None],
        Lpy.printer_model.o_outtray: [None,None],
        Lpy.printer_model.o_first2last: [None,None],
        Lpy.printer_model.o_faceup   : [None,None],
        Lpy.printer_model.o_mailbin  : [None,None],
        Lpy.printer_model.o_finisher : [None,None],
        #Lpy.printer_model.o_media    : [None,None],
        #Lpy.printer_model.o_papersize : [None,None],
    }

def set_option_data(data):
        val = ''
        for ii in data:
            if val:
                val += ","
            val += str(ii)
        return val

class SNMP_Option:
    ON  = Lpy.def_parm.ON
    OFF = Lpy.def_parm.OFF

    ## Options ##
    def get_options_data(self):
        if self.options:
            return self.options
        return None

    def get_printer_options(self,keyname,num,num2= None):
        data = self.get_mib_func(keyname)
        if data is None:
            return None
        keys = data.keys()
        keys.sort()
        val = []
        for key in keys:
            if data[key].has_key(num):
                if data[key][num][1]:
                    val.append(data[key][num][1])
                else:
                    if num2 and data[key].has_key(num2):
                        val.append(data[key][num2][1])
        return val

    def get_snmp_options(self):
        self.options = get_init_options()

        dat = self.get_printer_options(self.S_Marker,"02")
        if dat:
            self.options[Lpy.printer_model.o_printer][0] = dat[0]

        self.get_supply_info()

        self.options[Lpy.printer_model.o_lang][0]   = self.get_printer_options(self.S_Interpreter,"02")
        self.options[Lpy.printer_model.o_duplex][0] = self.get_printer_options(self.S_MediaPath,"09")
        self.options[Lpy.printer_model.o_intray][0] = self.get_printer_options(self.S_inputTray,"02")

        self.options[Lpy.printer_model.o_outtray][0]  = self.get_printer_options(self.S_outputTray,'02')
        self.options[Lpy.printer_model.o_first2last][0] = self.get_printer_options(self.S_outputTray,"19")
        self.options[Lpy.printer_model.o_faceup][0]     = self.get_printer_options(self.S_outputTray,"20")
        mailbin = self.get_printer_options(self.S_outputTray,"22")
        for key in mailbin:
            if key == self.ON:
                self.options[Lpy.printer_model.o_mailbin][0] = self.ON
                self.options[Lpy.printer_model.o_mailbin][1] = self.ON
                break

        ## if Finisher Mib Support.
        finisher = self.get_printer_options(self.S_findevice,"02")
        if finisher:
            self.options[Lpy.printer_model.o_finisher][0] = finisher # "puncher",
            self.options[Lpy.printer_model.o_finisher][1] = self.ON
 
    def get_supply_info(self):
        data = self.get_mib_func(self.S_MarkerColorant)
        if not data :
            return None
        keys = data.keys()
        keys.sort()
        if len(keys) >= 2:
            self.options[Lpy.printer_model.o_color][0] = _("Color")
            self.options[Lpy.printer_model.o_color][1] = self.ON
        else:
            self.options[Lpy.printer_model.o_color][0] = _("BW")
            self.options[Lpy.printer_model.o_color][1] = self.OFF

        supply = self.get_mib_func(self.S_MarkerSupplies)
        if supply is None:
            return None

        used = self.get_mib_func(self.S_Marker)
        if used is None:
            return None

        num = "4"
        val = {}
        for key in keys:
            if data[key][num][1]:
                if supply[key].has_key('9') and used[key].has_key('04'):
                    lifeCount = "%s %s" % ( used[key]['04'][1], used[key]['03'][1])
                    remains = "%2.2f %%" % (float(supply[key]["9"][1])/float(supply[key]["8"][1]) * 100)
                    val[key] = (data[key][num][1],remains,lifeCount)

        if len(val) >= 1:
            self.options[Lpy.printer_model.o_supply][0] = val

    def set_printertype(self,data,dicts,color):
        if data in (dicts["3"], dicts["4"],dicts["5"]):
            if color and color == "color":
                return Lpy.printer_model.Model_lang.CLaser
            else:
                return Lpy.printer_model.Model_lang.Laser
        elif data in (dicts["12"] ,dicts["13"], dicts["14"]):
            return Lpy.vendors.Printer_model.Model_lang.InkJet
        # InkJet
        elif data in (dicts["16"],dicts["17"],dicts["18"],dicts["19"]):
            return Lpy.printer_model.Model_lang.Thermal
        elif data in (dicts["6"],dicts["7"],dicts["8"],dicts["9"]):
            return Lpy.printer_model.Model_lang.DotMatrix
        else:
            print "printer type is (%s)" % data
            return None

    def get_print_options(self):
        pdata = []
        options = self.options

        if options[Lpy.printer_model.o_printer][0]:
            pdata.append(print_mib.set_text_text(Lpy.pjl.pjl_title.u_printertype,options[Lpy.printer_model.o_printer][0]))
            dicts = oid.get_tc_dict("MarkerMarkTech")
            options[Lpy.printer_model.o_printer][1] = self.set_printertype(options[Lpy.printer_model.o_printer][0],dicts,options[Lpy.printer_model.o_color][0])

        if options[Lpy.printer_model.o_color][0]:
            pdata.append( print_mib.set_text_text(Lpy.pjl.pjl_title.u_colorPrinter,options[Lpy.printer_model.o_color][0]))

        if options[Lpy.printer_model.o_lang][0]:
            data = set_option_data(options[Lpy.printer_model.o_lang][0])
            pdata.append( print_mib.set_text_text(Lpy.pjl.pjl_title.u_lang,data))

            dicts = oid.get_tc_dict("LangFamily")
            if dicts["3"] in options[Lpy.printer_model.o_lang][0]:
                options[Lpy.printer_model.o_lang][1] = self.ON
            else:
                options[Lpy.printer_model.o_lang][1] = self.OFF

        if options[Lpy.printer_model.o_duplex][0]:
            dicts = oid.get_tc_dict("MediaPathType")
            duplex = self.OFF
            if dicts:
                if dicts["3"] in options[Lpy.printer_model.o_duplex][0]:
                    duplex = self.ON
                elif dicts["4"] in options[Lpy.printer_model.o_duplex][0]:
                    duplex = self.ON
            pdata.append( print_mib.set_text_text(Lpy.pjl.pjl_title.u_duplex,duplex))
            options[Lpy.printer_model.o_duplex][1] = duplex

        if options[Lpy.printer_model.o_intray][0]:
            data = set_option_data(options[Lpy.printer_model.o_intray][0])
            pdata.append( print_mib.set_text_text(Lpy.pjl.pjl_title.u_intray,data))
            trayDict = oid.get_tc_dict("InputType")
            inTray = mpTray = Manual = Roll = FanFold = 0
            for key in options[Lpy.printer_model.o_intray][0]:
                if key == trayDict["3"]: # "sheetFeedAutoRemovableTray",
                    inTray += 1
                elif key == trayDict["4"]: # "sheetFeedAutoNonRemovableTray",
                    mpTray = 1 # MPTRAY
                elif key == trayDict["5"]:
                    Manual = 1
                elif key == trayDict["6"]:
                    Roll += 1
                elif key == trayDict["7"]:
                    FanFold = 1
            options[Lpy.printer_model.o_intray][1] = (inTray,mpTray,Manual,Roll,FanFold)

        if options[Lpy.printer_model.o_outtray][0]:
            data = set_option_data(options[Lpy.printer_model.o_outtray][0])
            pdata.append( print_mib.set_text_text(Lpy.pjl.pjl_title.u_outtray,data))
            outDict = oid.get_tc_dict("OutputType")
            outTray = Tray = Roll = FanFold = 0
            for key in options[Lpy.printer_model.o_outtray][0]:
                if key == outDict["3"]:   #"removableBin",
                    outTray += 1
                elif key == outDict["4"]: #"unRemovableBin",
                    Tray += 1
                elif key == outDict["5"]: # 6 == mailbox
                    Roll += 1
                elif key == outDict["7"]:
                    FanFold = self.ON
            options[Lpy.printer_model.o_outtray][1] = (outTray,Tray,Roll,FanFold)

        if options[Lpy.printer_model.o_first2last][0]:
            data = set_option_data(options[Lpy.printer_model.o_first2last][0])
            pdata.append( print_mib.set_text_text(Lpy.pjl.pjl_title.u_first,data))
            firstToLast = lastToFirst = self.OFF
            dicts = oid.get_tc_dict("StackingOrder")
            if dicts["3"] in options[Lpy.printer_model.o_first2last][0]:
                firstToLast = self.ON
            if dicts["4"] in options[Lpy.printer_model.o_first2last][0]:
                lastToFirst = self.ON
            options[Lpy.printer_model.o_first2last][1] = (firstToLast,lastToFirst)

        if options[Lpy.printer_model.o_faceup][0]:
            data = set_option_data(options[Lpy.printer_model.o_faceup][0])
            pdata.append( print_mib.set_text_text(Lpy.pjl.pjl_title.u_faceup,data))
            faceUp = faceDown = self.OFF
            dicts = oid.get_tc_dict("PageDeliveryOrientation")
            if dicts["3"] in options[Lpy.printer_model.o_faceup][0]:
                faceUp = self.ON
            if dicts["4"] in options[Lpy.printer_model.o_faceup][0]:
                faceDown = self.ON
            options[Lpy.printer_model.o_faceup][1] = (faceUp,faceDown)

        if options[Lpy.printer_model.o_mailbin][0]:
            pdata.append( print_mib.set_text_text(Lpy.pjl.pjl_title.u_mailbin,options[Lpy.printer_model.o_mailbin][0]))

        if options[Lpy.printer_model.o_finisher][0]:
            pdata.append( print_mib.set_text_text(Lpy.pjl.pjl_title.u_finisher,options[Lpy.printer_model.o_finisher][0]))

        if pdata:
            return pdata
        return None

    def get_print_supplies(self):
        if self.options[Lpy.printer_model.o_supply][0]:
            supply = self.options[Lpy.printer_model.o_supply][0]
            keys = supply.keys()
            keys.sort()
            sdata = []
            for key in keys:
                for name,sname in Lpy.printer_model.supply_colors:
                    if supply[key][0] == name:
                        s_name = sname
                        break
                else:
                    s_name = supply[key][0]

                dstart = 15 - print_mib.get_keylen(s_name)  # # " %s" %  supply[key][2])
                sdata.append( "   %s%s = %s" % (s_name,' '* dstart,supply[key][1]))   
            if sdata:
                return sdata
 
        return None
