#
#   utils.file_utils.py
#
#   2003.9.25
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import os
import time,types
import random
import shutil
import codecs

Error_cant_read = "Cannot_read"
Error_no_exist  = "No_exist"
Error_lists = (Error_no_exist,Error_cant_read)

OK = 1
Error_mkdir = -1
Error_chmod = -2
Error_open  = -1
Error_read  = -2
Error_write = -3
Error_file  = -4
Error_datatype = -11

## tmp dir
tmpdir = os.getenv('TMPDIR')
if not tmpdir:
    tmpdir = '/var/tmp'
    if not os.path.isdir(tmpdir):
        os.mkdir(tmpdir,0777)

## Random
g_random = random.Random()
g_random.seed()

## time
def get_localtime():
        ## mmddhhmm
        return time.strftime("%m:%d:%H_%M :",time.localtime())

## Random number ##
def get_random_number(start,end):
        #g_random = random.Random()
        #g_random.seed()
        return  g_random.randint(start,end)

## error
error_msg = None

def get_error_msg():
    return error_msg

## system command
def sys_command(cmds):
        if not cmds:
            return "Error:command:cmds is None"
        if os.system("(%s) < /dev/null >> /dev/null 2>&1" % cmds):
            return "Error:command:(%s)" % cmds
        return None

## popen commnad
def get_command_data(cmds):
    global error_msg
    error_msg = None
    try:
        #data = os.popen(cmds).readlines()
        fp = os.popen(cmds)
        data = fp.readlines()
        fp.close()
    except:
        data = None
        error_msg = "Error:(%s)" % cmds
    return data

## remove
def remove_file(filename):
    if not filename:
        return None
    names = filename.strip().split()
    for vv in names:
        if os.path.isfile(vv):
            try:
                os.remove(vv)
            except os.error, msg:
                print "Can't remove %s:%s" % (vv,str(msg))
## copy file
def copy_file(src,trg):
    if not src and not trg:
        return None
    trg.strip()
    try:
        shutil.copyfile(src.strip(),trg)
    except:
        trg = None
    return trg

## rename file
def rename_file(src,trg):
    if not src and not trg:
        return None
    trg = copy_file(src,trg)
    if trg:
        remove_file(src)
    return trg

## file ##
def check_file(filename):
    if not filename:
        return Error_no_exist
    if os.path.isabs(filename):
        name = filename
    else:
        name = os.path.abspath(filename)
    if os.path.isfile(name):
        if os.access(name,os.R_OK):
            return name
        else:
            return Error_cant_read
    else:
        return Error_no_exist

def check_filename(filename):
    if not filename:
        return None
    if os.path.isabs(filename):
        name = filename
    else:
        name = os.path.abspath(filename)
    if os.path.isfile(name) and os.access(name,os.R_OK):
        return name
    return None

def get_seq_filename(name):
        bname,suf = os.path.splitext(name)

        ret = bname.rfind('.')
        if ret >= 1:
            bname = bname[:ret]
            try:
                num = int(bname[ret+1:]) + 1
            except:
                num = 1
        else:
            num = 1

        while 1:
            filename = bname + '.' + str(num) + suf
            if check_filename(filename) == None:
                break
            num += 1

        return filename

def set_ps_filename(name,suffix = '.ps'):
        if not name.endswith(suffix):
            name += suffix
        if not os.path.isabs(name):
            name = os.getcwd() + os.sep + name

        ret = check_file(name)
        if ret == Error_no_exist:
            return name
        return get_seq_filename(name)


## check program ##
def find_command(cmd_name):
    if not cmd_name:
        return None
    global error_msg
    error_msg = None
    if os.path.isabs(cmd_name):
        if not os.path.isfile(cmd_name):
            return None
        if not os.access(cmd_name,os.X_OK):
            error_msg = ("%s is not executable.")  % cmd_name
            return None
        return cmd_name
    else:
        try:
            files = os.popen('which %s 2>&1' % cmd_name).readlines()
        except:
            files = None
        if not files:
            error_msg = "Cann't found (%s)."  % cmd_name
            return None

        prgfile = files[0].strip()
        if not os.access(prgfile,os.X_OK):
            error_msg = ("%s is not executable.")  % cmd_name
            return None
        return prgfile

## Dir ##
def check_dir(dirname):
    global error_msg
    error_msg = None

    if not os.path.isdir(dirname):
        try:
            os.mkdir(dirname,0744)
        except:
            error_msg = "I can't mkdir (%s)" % dirname
            return Error_mkdir

    if not os.access(dirname,os.W_OK):
        try:
            os.chmod(dirname,0744)
        except:
            error_msg = "I can't chmod(0744) (%s)" % dirname
            return Error_chmod
    return OK

def makedir(pathname):
    if os.path.isdir(pathname):
        return
    dirname = os.path.dirname(pathname)
    if dirname: 
        makedir(dirname)
    os.mkdir(pathname, 0777)

def make_tmpfile(file = 'tmp'):
        #import tempfile
        #return tempfile.mktemp()

        if file.startswith(os.sep):
            file = os.path.basename(file)
        num = g_random.randint(1000,9999)
        filename = tmpdir + os.sep + file + '_' + str(num)

        if not os.path.isfile(filename):
           return filename
        else:
            return make_tmpfile(file)

## read data
def get_filedata(name,bufsize = None):
        global error_msg
        error_msg = None

        filename = check_filename(name)
        if filename is None:
            error_msg = "(%s) can't be found." % name
            return None

        try:
            fp = open(filename,"r") #
        except:
            fp = None

        if fp is None:
            error_msg = "I can't open a file(%s)" % filename
            return None

        if bufsize:
            try:
                lines = fp.read(bufsize)
            except:
                lines = None
        else:
            try:
                lines = fp.readlines()
            except:
                lines = None
        fp.close()
        if lines is None:
            error_msg = "I can't read a file(%s)" % filename
            return None
        return lines

## write data
def rewrite_file(filename,backup,lines):
        if not lines:
            return None
        global error_msg
        error_msg = None

        if backup is None:
            backup = '.bak'
        # backup
        try:
            os.rename(filename,filename + backup)
        except:
            error_msg = "I can't backup a file(%s)" % filename
            return None

        # rewrite
        try:
            fp = open(filename,"w")
        except:
            fp = None
        if fp is None:
            os.rename(filename + backup,filename)
            error_msg = "replace Error:I can't open a write-file.(%s)" % filename
            return None
        try:
            fp.writelines(lines)
        except:
            error_msg = "replace Error:I can't write a data.(%s)" % filename
        fp.close()

        if error_msg:
            remove_file(filename)
            os.rename(filename + backup,filename)
            return None
        return OK

def write_tmpfile(tmpfile,data,flag,encoding = None):
        if not data:
            return None

        if not flag in ("w","a"):
            print "write_tmpfile:flag errror(%s:%s)" % (tmpfile,flag)
            return None
        global error_msg
        error_msg = None

        if encoding:
            try:
                fp = codecs.open(tmpfile,flag,encoding,'replace')
            except:
                try:
                    fp = open(tmpfile,flag)
                except:
                    error_msg = "I can't open a file(%s:%s)" % (tmpfile,flag)
                    return None
        else:
            try:
                fp = open(tmpfile,flag)
            except:
                error_msg = "I can't open a file(%s:%s)" % (tmpfile,flag)
                return None

        if isinstance(data,types.ListType):
            try:
                fp.writelines(data)
            except:
                error_msg = "replace Error:I can't write a data.(%s)" % filename
        else:
            try:
                fp.write(data)
            except:
                error_msg = "I can't write data in a file(%s)" % tmpfile
        fp.close()
        if error_msg:
            if flag == 'w':
                remove_file(tmpfile)
            return None
        return OK

def write_logs(logfile,msg1,encoding = None):
        if not msg1:
            return None
        msg = get_localtime() + msg1
        if not msg1.endswith(os.linesep):
           msg += os.linesep

        if write_tmpfile(logfile,msg,"a",encoding) is None:
            print msg1
            print "A log isn't be written in the logfile (%s)." % logfile
            print get_error_msg()
            return None

## marshal ##
import marshal
def save_parm_marshal(filename,data):
        global error_msg
        error_msg = None

        try:
            fp = open(filename,"w") #
        except:
            error_msg = "I can't open a file(%s)" % tmpfile
            return Error_open
        try:
            marshal.dump(data,fp)
            ret = OK
        except:
            error_msg =  "I can't write a marshal file (%s) by marshal." % filename
            ret = Error_write
        fp.close()
        if error_msg:
            remove_file(filename)
        return ret

## Load
def load_parm_marshal(filename):
        global error_msg
        error_msg = None

        try:
            fp = open(filename,"r") 
        except:
            error_msg = "I can't open a file (%s)." % filename
            return None
        try:
            parm = marshal.load(fp)
        except:
            error_msg =  "I can't read a marshal file (%s) by marshal." % filename
        fp.close()
        if error_msg:
            return None
        return parm

## log file
def log_rotate(logdir,logfile, logCount = 6):
        cwd = os.getcwd()
        os.chdir(logdir)
        logBase = logfile + '_'
        for num in range(logCount,0,-1):
            logs = logBase + str(num) + '.gz'
            if not os.path.isfile(logs):
                continue
            if num == logCount:
                remove_file(logs)
            else:
                old_log = logBase + str(num + 1) + '.gz'
                rename_file(logs,old_log)
  
        # archive
        ret = sys_command("gzip " + logfile)
        if ret == None:
            rename_file(logfile + '.gz' ,logBase + '1.gz')
        else:
            print ret
        os.chdir(cwd)

