#
#   utils.get_env.py
#
#       2003.9.27
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import os,sys
import string

## python version
def get_pythonVersion():
    big,small = sys.version[:3].split('.') # 2.2,2.3
    return int(big)*10 + int(small)        # 22 ,23

## OS
os_systemV = ('sunos','aix','hp','irix')
os_BSD   = ('linux','freebsd','netbsd')
os_misc  = ('win','mac','cygwin','beos','darwin','atheos','osf1')

def get_os_type():
        for os in (os_BSD + os_systemV + os_misc):
            if sys.platform.startswith(os):
                platform = os
                break
        else:
            platform = sys.platform
        return platform

def get_process(name,platform = None):
        if platform is None:
           platform = get_os_type()

        grepdata = "grep %s" % name
        if platform in os_systemV:
            cmds = "ps -e | %s" % grepdata
        else:
            cmds = "ps ax | %s" % grepdata

        #data = utils.file_utils.get_command_data(cmds)
        data = os.popen(cmds).readlines()
        if data:
            for line in data:
                if line.find(grepdata) >= 0:
                    continue
                if line.find(name) >= 0:
                    return line.strip()
        return None

def check_process(name,data):
    line = get_process(name)
    if line is None:
        return 0
    if line.find(data) >= 1:
       # print "process:",line
        return int(line.split()[0])
    return 0

##
def get_home():
        if os.environ.has_key("HOME"):
            return os.environ["HOME"]
        else:
            print "Warning::You have not environ HOME."
            return os.getcwd()

def get_logname():
        if os.environ.has_key("LOGNAME"):
            return  os.environ["LOGNAME"]
        return None

## IP Address
def check_strings(data):
    if not data:
        return '0'
    dat = data.strip()
    if len(dat.split()) >= 2:
        return '1'
    return dat

def check_ipaddress(data):
    ip = check_strings(data)
    if len(ip) <= 1:
        return ip

    try:
        dat = map(string.atoi,ip.split('.'))
    except:
        return '2'

    ss = len(dat)
    if ss != 4 and ss != 6:
        return '3'
    data = ''
    for key in dat:
        if key < 0 or key > 255:
            return '4'
        data += "%d." % key
    return data[:-1]

## name
nameChars = string.letters + string.digits + '-'
mailChars = '_' + '.' + '+'

def check_name(dat,flag = 0):
    if not dat:
        return '7'
    if flag == 1: # hostname
        if dat[0] in string.digits:
            return '8'
        if dat[0] == '-':
            return '8'
        for key in dat:
            if not key in nameChars:
                return '9'
    elif flag == 0: # mail name
        for key in dat:
            if not key in nameChars and not key in mailChars:
                return '9'
    return None

def check_address(data):
    dat = check_strings(data)
    if len(dat) <= 1:
        return dat

    try:
        names = dat.split('.')
    except:
        return '2'

    data = ''
    for key in names:
        ret = check_name(key,1)
        if ret:
            return ret
        data += "%s." % key
    return data[:-1]

def check_hostname(data):
    dat = check_strings(data)
    if len(dat) <= 1:
        return dat

    if dat[0] in string.digits:
        names = check_ipaddress(dat)
    else:
        names = check_address(dat)
    return names

def check_mail_address(data):
    dat = check_strings(data)
    if len(dat) <= 1:
        return dat

    try:
        person,hostbase = string.split(dat,'@',1)
    except:
        return '2'

    names = check_hostname(hostbase)
    if len(names) <= 2:
        return names

    ret = check_name(person,0)
    if ret:
        return ret

    return person + '@' + names
