#
#       canon_models.py
#
#       2004.7.7
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import Lpy.printer_model

class Canon_Model(Lpy.printer_model.Model_lang):
    import Lpy.gs_filter

    l_lips = "LIPS"
    canon_lips  = Lpy.gs_filter.get_filters("lips")
    model_lists = [Lpy.printer_model.Model_lang.Laser,Lpy.printer_model.Model_lang.CLaser] 

    def __init__(self):
        Lpy.printer_model.Model_lang.__init__(self)

    def get_printer_model(self,ptype):
        models = (self.N_enterprise,self.N_personal)

        if ptype == self.Laser:
            return models
        elif ptype == self.CLaser:
            return models
        else:
            print "No supported printer_type(%s)" % ptype
            return None

    def get_langList(self,ptype,model,flag = 0):
        support_pjl = (self.l_lips,self.F_pcl,self.F_ps)

        if ptype == self.Laser: # B/W Laser
            if flag == 0:   # Lang list
                    return support_pjl
            elif flag == 1: # GS filter
                return self.canon_lips + self.pcl4 + self.pcl5

        elif ptype == self.CLaser: # Color Laser
            if flag == 0:
                return support_pjl
            elif flag == 1:
                return self.canon_lips + self.pcl4 + self.pcl5 + self.pcl5c
        else:
            print "No supported printer_type(%s:%s:%s)" % (ptype,model,flag)
            return None
