#
#       hp_models.py
#
#       2004.7.5
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import Lpy.printer_model

class HP_Model(Lpy.printer_model.Model_lang):
    # must be list
    model_lists = [Lpy.printer_model.Model_lang.Laser,Lpy.printer_model.Model_lang.CLaser] 

## addendum ,6/2003
    ## B/W
    LJ1150 = "LJ1150"
    LJ1200 = "LJ1200"
    LJ1300 = "LJ1300"
    LJ2200 = "LJ2200"
    LJ2300 = "LJ2300"
    LJ4100   = "LJ4100"
    LJ4100MF = "LJ4100MFP"
    LJ4200 = "LJ4200"
    LJ4300 = "LJ4300"
    LJ5100 = "LJ5100"
    LJ8150 = "LJ8150"
    LJ9000 = "LJ9000"
    LJ9000MF = "LJ9000MFP"
    LJ3200MF = "LJ3200MFP"
    LJ3300MF = "LJ3300MFP"

    ## Color
    CLJ2500 = "CLJ2500"
    CLJ4550 = "CLJ4550"
    CLJ4600 = "CLJ4600"
    CLJ5500 = "CLJ5500"
    CLJ8550 = "CLJ8550"
    CLJ8550MF = "CLJ8550MFP"

## Editon 12 ,6/2003
    ## B/W
    LJ1100 = "LJ1100"
    LJ2100 = "LJ2100"
    LJ5000 = "LJ5000"
    LJ8000 = "LJ8000"
    LJ8100 = "LJ8100"
    ## Color
    CLJ4500 = "CLJ4500"
    CLJ8500 = "CLJ8500"

## Editon 10 E1097 (1997)
    LJ4    = "LJ4"
    LJ4M   = "LJ4M"
    LJ4P   = "LJ4Plus"
    LJ4MPl = "LJ4MPlus"
    LJ4V   = "LJ4V"
    LJ4MV  = "LJ4MV"
    LJ4S   = "LJ4Si"
    LJ4SM  = "LJ4SiMx"
    LJ4L   = "LJ4L"
    LJ4ML  = "LJ4ML"
    LJ4P   = "LJ4P"
    LJ4MP  = "LJ4MP"
    LJ4PJ  = "LJ4PJ"
    LJ4LJP = "LJ4LJPro"
    LJ4LC  = "LJ4LC"
    LJ4000 = "LJ4000"

    LJ5L  = "LJ5L"
    LJ5P  = "LJ5P"
    LJ5MP = "LJ5MP"
    LJ5S  = "LJ5Si"
    LJ5SM = "LJ5SiMx"
    LJ5SMp= "LJ5SiMop"
    LJ6L  = "LJ6L"
    LJ6P  = "LJ6P"
    LJ6MP = "LJ6MP"

    # Color
    CL5  = "CLJ5"
    CL5M = "CLJ5M"
    DJ1200  = "DJ1200C"
    DJ1600  = "DJ1600C"
    PJXL300 = "XL300"

    """
    DesignJet
     ("230","250C","330","350C","430","450C","455CA","488CA")
     ("700","750C","750C Plus","755CM","1050C","1055CM")
     ("2000CP","2500CP","3000CP","3500CP")
    """

    # BW
    pjl_2003_6_bw = (LJ9000MF,LJ9000,LJ8150,LJ8100,LJ8000,LJ5100,LJ5000,LJ4300,
        LJ4200,LJ4100MF,LJ4100,LJ3300MF,LJ3200MF,
        LJ2300,LJ2200,LJ2100,LJ1300,LJ1200,LJ1150,LJ1100)

    pjl_1997_10_bw = (LJ6MP,LJ6P,LJ6L,LJ5SMp,LJ5SM,LJ5S,LJ5MP,LJ5P,LJ5L,LJ4000,
        LJ4LC,LJ4LJP,LJ4PJ,LJ4MP,LJ4P,LJ4ML,LJ4L,LJ4SM,LJ4S,LJ4MV,LJ4V,
        LJ4MPl,LJ4P,LJ4M,LJ4)
   
    # Color
    pjl_2003_6_color = (CLJ8550MF,CLJ8550,CLJ8500,CLJ5500,CLJ4600,CLJ4550,CLJ4500,CLJ2500)
    pjl_1997_10_color = (PJXL300,DJ1600,DJ1200,CL5M,CL5)

    ## set nameList 
    mono_printers  = pjl_2003_6_bw # + pjl_1997_10_bw
    color_printers = pjl_2003_6_color # + pjl_1997_10_color
  
    def __init__(self):
        Lpy.printer_model.Model_lang.__init__(self)
        self.modelname  = None

    def get_defaultPrinter(self,ptype):
        if ptype == self.CLaser:
            return self.CLJ8550
        elif ptype == self.Laser:
            return self.LJ4300
        else:
            return None
    def get_color_model(self,modelname):
        if modelname in self.mono_printers:
            return None
        else:
            return 1

    def get_model_name(self,modelname):
        if modelname:
            self.modelname = modelname
        return self.modelname

    def get_printer_model(self,ptype):
        if ptype == self.CLaser:
            return self.color_printers
        else:
            return self.mono_printers

    def get_langList(self,ptype,model,flag = 0):
        support_pjl = (self.F_pcl,self.F_ps,self.F_hpgl)

        if ptype == self.Laser: # B/W Laser
            if flag == 0:   # Lang list
               return support_pjl
            elif flag == 1: # GS filter
                return self.pcl3 + self.pcl4 + self.pcl5
        elif ptype == self.CLaser: # Color Laser
            if flag == 0:
               return support_pjl
            elif flag == 1:
                return self.pcl4 + self.pcl5 + self.pcl5c
        else:
            print "No supported printer_type(%s:%s:%s)" % (ptype,model,flag)
            return None
