#
#       okidata.py
#
#       2003.12.18
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import Lpy.pjl.pjl_vendor
import Lpy.vendors.okidata_pjl
import Lpy.pjl.pjl_snmp

private_mib = "Lpy.vendors.okidata_snmp"

class Maker_PJL(Lpy.pjl.pjl_vendor.PJL_Vendor,Lpy.pjl.pjl_snmp.PJL_SNMP):
    #Maker = 'OKI Data'
    pjl_files = "Lpy.vendors.okidata_pjl"
    d_classes = Lpy.pjl.pjl_vendor.get_dummy_class(pjl_files,Lpy.vendors.okidata_pjl.__dict__.keys())

    def __init__(self,maker,printertype,model):
        Lpy.pjl.pjl_vendor.PJL_Vendor.__init__(self,maker,printertype)
        Lpy.pjl.pjl_snmp.PJL_SNMP.__init__(self,private_mib)

        self.init_vendor(maker,printertype,model)
        self.init_support()

    def get_snmpFile(self,productname,model):
        return "okidata"

    def set_privateMib(self,snmp_data,privateMIB,productname):
        Lpy.printer_model

        check_titles = ('cfg2EditSizeSelection','usageStapler','usagePuncher') 
        p_data = self.get_vendor_mib(snmp_data,privateMIB,check_titles)
        if not p_data:
            return None

        keys = p_data.keys()
        keys.sort()
        finisher  = []
        papersize = []

        for key in keys:
            #print "%s (%s) = %s" % (key,p_data[key][0],p_data[key][1])
            if key.startswith('usageStapler'):
                if key.startswith('usageStaplerDescription'):
                    finisher.append(p_data[key][1])
                
            elif key.startswith('usagePuncher'):
                if key.startswith('usagePuncherDescription'):
                    finisher.append(p_data[key][1])

            elif key.startswith('cfg2EditSizeSelection'):
                papersize.append(p_data[key][1])

        dat = {} 
        if len(papersize) >= 1:
            vlist = self.get_func(self.P_mediaSize).get_vlist()
            papers = []
            for key in papersize:
                for pp in vlist:
                    if key == pp:
                        break
                    elif key.upper() == pp.upper():
                        break
                else:
                    if key != 'CASSETTESIZE':
                        papers.append(key)
                        
            if len(papers):
                dat[Lpy.printer_model.o_papersize] = [papers,self.ON]
        
        #if len(finisher) >= 1:
        #    dat[Lpy.printer_model.o_finisher] = [finisher,self.ON]
        
        if not dat:
            return None
        else:
            return dat


