#
#       xerox.py
#
#       2003.11.10
#
#
#   Copyright (C) Hidetoshi Nakano
#
#   Please use this program at your own risk.
#   Without any warranty.
# 
#
#############################################
import Lpy.pjl.pjl_vendor
import Lpy.vendors.xerox_pjl

class Maker_PJL(Lpy.pjl.pjl_vendor.PJL_Vendor):
    # Xerox
    pjl_files = "Lpy.vendors.xerox_pjl"
    d_classes = Lpy.pjl.pjl_vendor.get_dummy_class(pjl_files,Lpy.vendors.xerox_pjl.__dict__.keys())

    ## AccXES Controller
    PJL_Xeroxstart = '@PJL COMMENT XRXbegin'
    PJL_Xeroxend   = '@PJL COMMENT XRXend'

    def __init__(self,maker,printertype = None,model= None):
        Lpy.pjl.pjl_vendor.PJL_Vendor.__init__(self,maker,printertype)

        self.init_vendor(maker,printertype,model)
        self.init_support()

    def pjl_output_value(self,keymame):
        value = self.get_func(keymame).get_pjlparm()
        if value:
            return "%s %s;%s" % (self.PJL_Comment,value,self.PJL_CRLF)
        return None

    def pjl_output_val(self,keymame):
        value = self.get_func(keymame).get_pjlparm()
        if value:
            return "%s %s%s" % (self.PJL_setParam,value,self.PJL_CRLF)
        return None

    def get_pjl_header(self,jobname):
        data = []
        data.append(self.PJL_header)
        ## Xerox PJL Header
        data.append(self.PJL_Xeroxstart + self.PJL_CRLF)

        username = self.get_func(self.P_userName).get_value()
        if username:
            data.append('%s OID_ATT_JOB_OWNER "%s";%s' % (self.PJL_Comment,username,self.PJL_CRLF))
        if jobname:
            data.append('%s OID_ATT_JOB_NAME "%s";%s' % (self.PJL_Comment,jobname,self.PJL_CRLF))

        ## Accounting ##
        if (self.get_func(self.P_accounting).get_support() == self.ON and
            self.get_func(self.P_accounting).get_value() == 1):
            dat = self.accounting_pjl()
            if dat:
                data.append(dat)

        ## Delay Print ##
        if (self.get_func(self.P_delayPrint).get_support() == self.ON and
            self.get_func(self.P_delayPrint).get_value() == 1):
            dat = self.delayprint_pjl()
            if dat:
                data.append(dat)

        return data

    def vendor_unique_pjl(self):
        data = []
        data.append(self.PJL_Xeroxend + self.PJL_CRLF)
        for key in self.uniques:
            value = self.pjl_output_val(key)
            if value:
               data.append(value)
        return data

    def delayprint_pjl(self):
        cmd   = self.get_func(self.P_delayPrint).get_pjl_cmd()
        value = self.get_func(self.P_delayTime).get_value()
        if value == 0:
            return None

        import time

        date = time.gmtime(time.time() + value*60 - time.timezone)
        start_time = time.strftime("%Y%m%d%H%M%S",date) ## yyyymmddhhmmss
        return "%s %s %s;%s" % (self.PJL_Comment,cmd,start_time,self.PJL_CRLF)

    def accounting_pjl(self):
        cmd  = self.get_func(self.P_accounting).get_pjl_cmd()
        username = self.get_func(self.P_userName).get_value()
        account  = self.get_func(self.P_accountName).get_value()
        if cmd is None or username is None or account is None:
            return None

        return '%s %s "%s|042%s";%s' % (self.PJL_Comment,cmd,username,account,self.PJL_CRLF)

    def frontCover_pjl(self):
        data = []
        value = self.pjl_output_value(self.P_coverMedia)
        if value:
            data.append(value)
            # Printing
            value = self.pjl_output_value(self.P_coverPrinting)
            if value:
                data.append(value)
            # Color
            value = self.pjl_output_value(self.P_coverColor)
            if value:
                data.append(value)
        return data

    def insert_Transparency(self):
        value = self.get_func(self.P_insertPaper).get_value()
        data = []
        if value == 1: # ON
            value = self.pjl_output_value(self.P_insertPrinting)
            if value:
                data.append(value)
            value = self.pjl_output_value(self.P_insertMedia)
            if value:
                data.append(value)
        else: # OFF
            value = self.pjl_output_value(self.P_insertPaper)
            if value:
                data.append(value)
        return data
