<?php
/**
 * PS (PostScript) キーワード定義ファイル
 */

$switchHash['.'] = PLUGIN_CODE_SPECIAL_IDENTIFIRE;  //  予約語
$switchHash['$'] = PLUGIN_CODE_SPECIAL_IDENTIFIRE;  //  予約語
$switchHash['"'] = PLUGIN_CODE_CODE_CANCEL;         //  " はリテラルではない (指定を無効化)
$switchHash['('] = PLUGIN_CODE_PAIR_LITERAL;  // ()は文字列リテラル
$literal_delimiter = ')';
// コメント定義
$switchHash['%'] = PLUGIN_CODE_COMMENT;        //  コメントは % から改行まで
$code_comment = Array(
	'%' => Array(
				 Array('/^%/', "\n", 1),
	)
);

// アウトライン用
if($mkoutline){
  $switchHash['{'] = PLUGIN_CODE_BLOCK_START;
  $switchHash['}'] = PLUGIN_CODE_BLOCK_END;
}

$code_css = Array(
  'operator',		// オペレータ関数
  'identifier',	// その他の識別子
  'pragma',		// module, import と pragma
  'system',		// 処理系組み込みの奴 __stdcall とか
  );

$code_keyword = Array(
  'pop'  => 2,
  'exch'  => 2,
  'dup'  => 2,
  'copy'  => 2,
  'index'  => 2,
  'roll'  => 2,
  'clear'  => 2,
  'count'  => 2,
  'mark'  => 2,
  'cleartomark'  => 2,
  'counttomark'  => 2,
  'add'  => 2,
  'div'  => 2,
  'idiv'  => 2,
  'mod'  => 2,
  'mul'  => 2,
  'sub'  => 2,
  'abs'  => 2,
  'neg'  => 2,
  'ceiling'  => 2,
  'floor'  => 2,
  'round'  => 2,
  'truncate'  => 2,
  'sqrt'  => 2,
  'atan'  => 2,
  'cos'  => 2,
  'sin'  => 2,
  'exp'  => 2,
  'ln'  => 2,
  'log'  => 2,
  'rand'  => 2,
  'srand'  => 2,
  'rrand'  => 2,
  'array'  => 2,
  'length'  => 2,
  'get'  => 2,
  'put'  => 2,
  'getinterval'  => 2,
  'putinterval'  => 2,
  'astore'  => 2,
  'aload'  => 2,
  'copy'  => 2,
  'forall'  => 2,
  'dict'  => 2,
  'maxlength'  => 2,
  'begin'  => 2,
  'end'  => 2,
  'def'  => 2,
  'load'  => 2,
  'store'  => 2,
  'known'  => 2,
  'where'  => 2,
  'currentdict'  => 2,
  'countdictstack'  => 2,
  'dictstack'  => 2,
  'cleardictstack'  => 2,
  'internaldict'  => 2,
  '$error'  => 2,
  'systemdict'  => 2,
  'userdict'  => 2,
  'statusdict'  => 2,
  'errordict'  => 2,
  'string'  => 2,
  'anchorsearch'  => 2,
  'search'  => 2,
  'token'  => 2,
  'eq'  => 2,
  'ne'  => 2,
  'ge'  => 2,
  'gt'  => 2,
  'le'  => 2,
  'lt'  => 2,
  'and'  => 2,
  'not'  => 2,
  'or'  => 2,
  'and'  => 2,
  'or'  => 2,
  'not'  => 2,
  'and'  => 2,
  'not'  => 2,
  'or'  => 2,
  'xor'  => 2,
  'bitshift'  => 2,
  'true'  => 2,
  'false'  => 2,
  'arraytype'  => 2,
  'booleantype'  => 2,
  'conditiontype'  => 2,
  'dicttype'  => 2,
  'filetype'  => 2,
  'fonttype'  => 2,
  'gstatetype'  => 2,
  'integertype'  => 2,
  'locktype'  => 2,
  'marktype'  => 2,
  'nametype'  => 2,
  'nulltype'  => 2,
  'operatortype'  => 2,
  'packedarraytype'  => 2,
  'realtype'  => 2,
  'savetype'  => 2,
  'stringtype'  => 2,
  'if'  => 2,
  'ifelse'  => 2,
  'for'  => 2,
  'repeat'  => 2,
  'loop'  => 2,
  'exec'  => 2,
  'exit'  => 2,
  'stop'  => 2,
  'stopped'  => 2,
  'countexecstack'  => 2,
  'execstack'  => 2,
  'quit'  => 2,
  'start'  => 2,
  'type'  => 2,
  'cvlit'  => 2,
  'cvx'  => 2,
  'xcheck'  => 2,
  'executeonly'  => 2,
  'noaccess'  => 2,
  'readonly'  => 2,
  'rcheck'  => 2,
  'wcheck'  => 2,
  'cvi'  => 2,
  'cvn'  => 2,
  'cvr'  => 2,
  'cvrs'  => 2,
  'cvs'  => 2,
  'file'  => 2,
  'closefile'  => 2,
  'read'  => 2,
  'write'  => 2,
  'readhexstring'  => 2,
  'writehexstring'  => 2,
  'readstring'  => 2,
  'writestring'  => 2,
  'bytesavailable'  => 2,
  'flush'  => 2,
  'flushfile'  => 2,
  'resetfile'  => 2,
  'status'  => 2,
  'run'  => 2,
  'currentfile'  => 2,
  'print'  => 2,
  'stack'  => 2,
  'pstack'  => 2,
  'readline'  => 2,
  'deletefile'  => 2,
  'setfileposition'  => 2,
  'fileposition'  => 2,
  'renamefile'  => 2,
  'filenameforall'  => 2,
  'save'  => 2,
  'restore'  => 2,
  'bind'  => 2,
  'null'  => 2,
  'usertime'  => 2,
  'executive'  => 2,
  'echo'  => 2,
  'realtime'  => 2,
  'product'  => 2,
  'revision'  => 2,
  'serialnumber'  => 2,
  'version'  => 2,
  'prompt'  => 2,
  'gsave'  => 2,
  'grestore'  => 2,
  'grestoreall'  => 2,
  'initgraphics'  => 2,
  'setlinewidth'  => 2,
  'setlinecap'  => 2,
  'currentgray'  => 2,
  'currentlinejoin'  => 2,
  'setmiterlimit'  => 2,
  'currentmiterlimit'  => 2,
  'setdash'  => 2,
  'currentdash'  => 2,
  'setgray'  => 2,
  'sethsbcolor'  => 2,
  'currenthsbcolor'  => 2,
  'setrgbcolor'  => 2,
  'currentrgbcolor'  => 2,
  'currentlinewidth'  => 2,
  'currentlinecap'  => 2,
  'setlinejoin'  => 2,
  'setcmykcolor'  => 2,
  'currentcmykcolor'  => 2,
  'setscreen'  => 2,
  'currentscreen'  => 2,
  'settransfer'  => 2,
  'currenttransfer'  => 2,
  'setflat'  => 2,
  'currentflat'  => 2,
  'currentblackgeneration'  => 2,
  'setblackgeneration'  => 2,
  'setundercolorremoval'  => 2,
  'setcolorscreen'  => 2,
  'currentcolorscreen'  => 2,
  'setcolortransfer'  => 2,
  'currentcolortransfer'  => 2,
  'currentundercolorremoval'  => 2,
  'matrix'  => 2,
  'initmatrix'  => 2,
  'identmatrix'  => 2,
  'defaultmatrix'  => 2,
  'currentmatrix'  => 2,
  'setmatrix'  => 2,
  'translate'  => 2,
  'concat'  => 2,
  'concatmatrix'  => 2,
  'transform'  => 2,
  'dtransform'  => 2,
  'itransform'  => 2,
  'idtransform'  => 2,
  'invertmatrix'  => 2,
  'scale'  => 2,
  'rotate'  => 2,
  'newpath'  => 2,
  'currentpoint'  => 2,
  'moveto'  => 2,
  'rmoveto'  => 2,
  'lineto'  => 2,
  'rlineto'  => 2,
  'arc'  => 2,
  'arcn'  => 2,
  'arcto'  => 2,
  'curveto'  => 2,
  'closepath'  => 2,
  'flattenpath'  => 2,
  'reversepath'  => 2,
  'strokepath'  => 2,
  'charpath'  => 2,
  'clippath'  => 2,
  'pathbbox'  => 2,
  'initclip'  => 2,
  'clip'  => 2,
  'eoclip'  => 2,
  'rcurveto'  => 2,
  'pathforall'  => 2,
  'erasepage'  => 2,
  'fill'  => 2,
  'eofill'  => 2,
  'stroke'  => 2,
  'image'  => 2,
  'imagemask'  => 2,
  'colorimage'  => 2,
  'showpage'  => 2,
  'copypage'  => 2,
  'nulldevice'  => 2,
  'findfont'  => 2,
  'FontDirectory'  => 2,
  'ISOLatin1Encoding'  => 2,
  'StandardEncoding'  => 2,
  'definefont'  => 2,
  'scalefont'  => 2,
  'makefont'  => 2,
  'setfont'  => 2,
  'currentfont'  => 2,
  'show'  => 2,
  'ashow'  => 2,
  'stringwidth'  => 2,
  'kshow'  => 2,
  'setcachedevice'  => 2,
  'setcharwidth'  => 2,
  'widthshow'  => 2,
  'awidthshow'  => 2,
  'findencoding'  => 2,
  'cshow'  => 2,
  'rootfont'  => 2,
  'setcachedevice2'  => 2,
  'vmstatus'  => 2,
  'cachestatus'  => 2,
  'setcachelimit'  => 2,
  'Gray'  => 2,
  'Red'  => 2,
  'Green'  => 2,
  'Blue'  => 2,
  'All'  => 2,
  'None'  => 2,
  'DeviceGray'  => 2,
  'DeviceRGB'  => 2,
  'ASCIIHexDecode'  => 2,
  'ASCIIHexEncode'  => 2,
  'ASCII85Decode'  => 2,
  'ASCII85Encode'  => 2,
  'LZWDecode'  => 2,
  'RunLengthDecode'  => 2,
  'RunLengthEncode'  => 2,
  'SubFileDecode'  => 2,
  'NullEncode'  => 2,
  'GIFDecode'  => 2,
  'PNGDecode'  => 2,
  'LZWEncode'  => 2,
  'DCTEncode'  => 2,
  'DCTDecode'  => 2,
  'Colors'  => 2,
  'HSamples'  => 2,
  'VSamples'  => 2,
  'QuantTables'  => 2,
  'QFactor'  => 2,
  'HuffTables'  => 2,
  'ColorTransform'  => 2,
  'CCITTFaxEncode'  => 2,
  'CCITTFaxDecode'  => 2,
  'Uncompressed'  => 2,
  'K'  => 2,
  'EndOfLine'  => 2,
  'Columns'  => 2,
  'Rows'  => 2,
  'EndOfBlock'  => 2,
  'Blacks1'  => 2,
  'DamagedRowsBeforeError'  => 2,
  'EncodedByteAlign'  => 2,
  'FormType'  => 2,
  'XUID'  => 2,
  'BBox'  => 2,
  'Matrix'  => 2,
  'PaintProc'  => 2,
  'Implementation'  => 2,
  'handleerror'  => 2,
  'configurationerror'  => 2,
  'dictfull'  => 2,
  'dictstackunderflow'  => 2,
  'dictstackoverflow'  => 2,
  'execstackoverflow'  => 2,
  'interrupt'  => 2,
  'invalidaccess'  => 2,
  'invalidcontext'  => 2,
  'invalidexit'  => 2,
  'invalidfileaccess'  => 2,
  'invalidfont'  => 2,
  'invalidid'  => 2,
  'invalidrestore'  => 2,
  'ioerror'  => 2,
  'limitcheck'  => 2,
  'nocurrentpoint'  => 2,
  'rangecheck'  => 2,
  'stackoverflow'  => 2,
  'stackunderflow'  => 2,
  'syntaxerror'  => 2,
  'timeout'  => 2,
  'typecheck'  => 2,
  'undefined'  => 2,
  'undefinedfilename'  => 2,
  'undefinedresource'  => 2,
  'undefinedresult'  => 2,
  'unmatchedmark'  => 2,
  'unregistered'  => 2,
  'VMerror'  => 2,
  'Symbol'  => 2,
  'Times-Roman'  => 2,
  'Times-Italic'  => 2,
  'Times-Bold'  => 2,
  'Times-BoldItalic'  => 2,
  'Helvetica'  => 2,
  'Helvetica-Oblique'  => 2,
  'Helvetica-Bold'  => 2,
  'Helvetica-BoldOblique'  => 2,
  'Courier'  => 2,
  'Courier-Oblique'  => 2,
  'Courier-Bold'  => 2,
  'Courier-BoldOblique'  => 2,
  'currentcontext'  => 2,
  'fork'  => 2,
  'join'  => 2,
  'detach'  => 2,
  'lock'  => 2,
  'monitor'  => 2,
  'condition'  => 2,
  'wait'  => 2,
  'notify'  => 2,
  'yield'  => 2,
  'viewclip'  => 2,
  'eoviewclip'  => 2,
  'rectviewclip'  => 2,
  'initviewclip'  => 2,
  'viewclippath'  => 2,
  'deviceinfo'  => 2,
  'sethalftonephase'  => 2,
  'currenthalftonephase'  => 2,
  'wtranslation'  => 2,
  'defineusername'  => 2,
  '.notdef'  => 2,
  'space'  => 2,
  'exclam'  => 2,
  'quotedbl'  => 2,
  'numbersign'  => 2,
  'dollar'  => 2,
  'percent'  => 2,
  'ampersand'  => 2,
  'quoteright'  => 2,
  'parenleft'  => 2,
  'parenright'  => 2,
  'asterisk'  => 2,
  'plus'  => 2,
  'comma'  => 2,
  'hyphen'  => 2,
  'period'  => 2,
  'slash'  => 2,
  'zero'  => 2,
  'one'  => 2,
  'two'  => 2,
  'three'  => 2,
  'four'  => 2,
  'five'  => 2,
  'six'  => 2,
  'seven'  => 2,
  'eight'  => 2,
  'nine'  => 2,
  'colon'  => 2,
  'semicolon'  => 2,
  'less'  => 2,
  'equal'  => 2,
  'greater'  => 2,
  'question'  => 2,
  'at'  => 2,
  'bracketleft'  => 2,
  'backslash'  => 2,
  'bracketright'  => 2,
  'asciicircum'  => 2,
  'underscore'  => 2,
  'quoteleft'  => 2,
  'braceleft'  => 2,
  'bar'  => 2,
  'braceright'  => 2,
  'asciitilde'  => 2,
  'exclamdown'  => 2,
  'cent'  => 2,
  'sterling'  => 2,
  'fraction'  => 2,
  'yen'  => 2,
  'florin'  => 2,
  'section'  => 2,
  'currency'  => 2,
  'quotesingle'  => 2,
  'quotedblleft'  => 2,
  'guillemotleft'  => 2,
  'guilsinglleft'  => 2,
  'guilsinglright'  => 2,
  'fi'  => 2,
  'fl'  => 2,
  'endash'  => 2,
  'dagger'  => 2,
  'daggerdbl'  => 2,
  'periodcentered'  => 2,
  'paragraph'  => 2,
  'bullet'  => 2,
  'quotesinglbase'  => 2,
  'quotedblbase'  => 2,
  'quotedblright'  => 2,
  'guillemotright'  => 2,
  'ellipsis'  => 2,
  'perthousand'  => 2,
  'questiondown'  => 2,
  'grave'  => 2,
  'acute'  => 2,
  'circumflex'  => 2,
  'tilde'  => 2,
  'macron'  => 2,
  'breve'  => 2,
  'dotaccent'  => 2,
  'dieresis'  => 2,
  'ring'  => 2,
  'cedilla'  => 2,
  'hungarumlaut'  => 2,
  'ogonek'  => 2,
  'caron'  => 2,
  'emdash'  => 2,
  'AE'  => 2,
  'ordfeminine'  => 2,
  'Lslash'  => 2,
  'Oslash'  => 2,
  'OE'  => 2,
  'ordmasculine'  => 2,
  'ae'  => 2,
  'dotlessi'  => 2,
  'lslash'  => 2,
  'oslash'  => 2,
  'oe'  => 2,
  'germandbls'  => 2,
  'universal'  => 2,
  'existential'  => 2,
  'suchthat'  => 2,
  'asteriskmath'  => 2,
  'minus'  => 2,
  'congruent'  => 2,
  'Alpha'  => 2,
  'Beta'  => 2,
  'Chi'  => 2,
  'Delta'  => 2,
  'Epsilon'  => 2,
  'Phi'  => 2,
  'Gamma'  => 2,
  'Eta'  => 2,
  'Iota'  => 2,
  'theta1'  => 2,
  'Kappa'  => 2,
  'Lambda'  => 2,
  'Mu'  => 2,
  'Nu'  => 2,
  'Omicron'  => 2,
  'Pi'  => 2,
  'Theta'  => 2,
  'Rho'  => 2,
  'Sigma'  => 2,
  'Tau'  => 2,
  'Upsilon'  => 2,
  'sigma1'  => 2,
  'Omega'  => 2,
  'Xi'  => 2,
  'Psi'  => 2,
  'Zeta'  => 2,
  'therefore'  => 2,
  'perpendicular'  => 2,
  'radicalex'  => 2,
  'alpha'  => 2,
  'beta'  => 2,
  'chi'  => 2,
  'delta'  => 2,
  'epsilon'  => 2,
  'phi'  => 2,
  'gamma'  => 2,
  'eta'  => 2,
  'iota'  => 2,
  'phi1'  => 2,
  'kappa'  => 2,
  'lambda'  => 2,
  'mu'  => 2,
  'nu'  => 2,
  'omicron'  => 2,
  'pi'  => 2,
  'theta'  => 2,
  'rho'  => 2,
  'sigma'  => 2,
  'tau'  => 2,
  'upsilon'  => 2,
  'omega1'  => 2,
  'Upsilon1'  => 2,
  'minute'  => 2,
  'lessequal'  => 2,
  'infinity'  => 2,
  'club'  => 2,
  'diamond'  => 2,
  'heart'  => 2,
  'spade'  => 2,
  'arrowboth'  => 2,
  'arrowleft'  => 2,
  'arrowup'  => 2,
  'arrowright'  => 2,
  'arrowdown'  => 2,
  'degree'  => 2,
  'plusminus'  => 2,
  'second'  => 2,
  'greaterequal'  => 2,
  'multiply'  => 2,
  'proportional'  => 2,
  'partialdiff'  => 2,
  'divide'  => 2,
  'notequal'  => 2,
  'equivalence'  => 2,
  'approxequal'  => 2,
  'arrowvertex'  => 2,
  'arrowhorizex'  => 2,
  'aleph'  => 2,
  'Ifraktur'  => 2,
  'Rfraktur'  => 2,
  'weierstrass'  => 2,
  'circlemultiply'  => 2,
  'circleplus'  => 2,
  'emptyset'  => 2,
  'intersection'  => 2,
  'union'  => 2,
  'propersuperset'  => 2,
  'reflexsuperset'  => 2,
  'notsubset'  => 2,
  'propersubset'  => 2,
  'reflexsubset'  => 2,
  'element'  => 2,
  'notelement'  => 2,
  'angle'  => 2,
  'gradient'  => 2,
  'registerserif'  => 2,
  'copyrightserif'  => 2,
  'trademarkserif'  => 2,
  'radical'  => 2,
  'dotmath'  => 2,
  'logicalnot'  => 2,
  'logicaland'  => 2,
  'logicalor'  => 2,
  'arrowdblboth'  => 2,
  'arrowdblleft'  => 2,
  'arrowdblup'  => 2,
  'arrowdblright'  => 2,
  'arrowdbldown'  => 2,
  'omega'  => 2,
  'xi'  => 2,
  'psi'  => 2,
  'zeta'  => 2,
  'similar'  => 2,
  'carriagereturn'  => 2,
  'lozenge'  => 2,
  'angleleft'  => 2,
  'registersans'  => 2,
  'copyrightsans'  => 2,
  'trademarksans'  => 2,
  'summation'  => 2,
  'parenlefttp'  => 2,
  'parenleftex'  => 2,
  'parenleftbt'  => 2,
  'bracketlefttp'  => 2,
  'bracketleftex'  => 2,
  'bracketleftbt'  => 2,
  'bracelefttp'  => 2,
  'braceleftmid'  => 2,
  'braceleftbt'  => 2,
  'braceex'  => 2,
  'euro'  => 2,
  'angleright'  => 2,
  'integral'  => 2,
  'integraltp'  => 2,
  'integralex'  => 2,
  'integralbt'  => 2,
  'parenrighttp'  => 2,
  'parenrightex'  => 2,
  'parenrightbt'  => 2,
  'bracketrighttp'  => 2,
  'bracketrightex'  => 2,
  'bracketrightbt'  => 2,
  'bracerighttp'  => 2,
  'bracerightmid'  => 2,
  'bracerightbt'  => 2,
  'brokenbar'  => 2,
  'copyright'  => 2,
  'registered'  => 2,
  'twosuperior'  => 2,
  'threesuperior'  => 2,
  'onesuperior'  => 2,
  'onequarter'  => 2,
  'onehalf'  => 2,
  'threequarters'  => 2,
  'Agrave'  => 2,
  'Aacute'  => 2,
  'Acircumflex'  => 2,
  'Atilde'  => 2,
  'Adieresis'  => 2,
  'Aring'  => 2,
  'Ccedilla'  => 2,
  'Egrave'  => 2,
  'Eacute'  => 2,
  'Ecircumflex'  => 2,
  'Edieresis'  => 2,
  'Igrave'  => 2,
  'Iacute'  => 2,
  'Icircumflex'  => 2,
  'Idieresis'  => 2,
  'Eth'  => 2,
  'Ntilde'  => 2,
  'Ograve'  => 2,
  'Oacute'  => 2,
  'Ocircumflex'  => 2,
  'Otilde'  => 2,
  'Odieresis'  => 2,
  'Ugrave'  => 2,
  'Uacute'  => 2,
  'Ucircumflex'  => 2,
  'Udieresis'  => 2,
  'Yacute'  => 2,
  'Thorn'  => 2,
  'agrave'  => 2,
  'aacute'  => 2,
  'acircumflex'  => 2,
  'atilde'  => 2,
  'adieresis'  => 2,
  'aring'  => 2,
  'ccedilla'  => 2,
  'egrave'  => 2,
  'eacute'  => 2,
  'ecircumflex'  => 2,
  'edieresis'  => 2,
  'igrave'  => 2,
  'iacute'  => 2,
  'icircumflex'  => 2,
  'idieresis'  => 2,
  'eth'  => 2,
  'ntilde'  => 2,
  'ograve'  => 2,
  'oacute'  => 2,
  'ocircumflex'  => 2,
  'otilde'  => 2,
  'odieresis'  => 2,
  'ugrave'  => 2,
  'uacute'  => 2,
  'ucircumflex'  => 2,
  'udieresis'  => 2,
  'yacute'  => 2,
  'thorn'  => 2,
  'ydieresis'  => 2,
  'zcaron'  => 2,
  'exclamsmall'  => 2,
  'Hungarumlautsmall'  => 2,
  'dollaroldstyle'  => 2,
  'dollarsuperior'  => 2,
  'ampersandsmall'  => 2,
  'Acutesmall'  => 2,
  'parenleftsuperior'  => 2,
  'parenrightsuperior'  => 2,
  'twodotenleader'  => 2,
  'onedotenleader'  => 2,
  'zerooldstyle'  => 2,
  'oneoldstyle'  => 2,
  'twooldstyle'  => 2,
  'threeoldstyle'  => 2,
  'fouroldstyle'  => 2,
  'fiveoldstyle'  => 2,
  'sixoldstyle'  => 2,
  'sevenoldstyle'  => 2,
  'eightoldstyle'  => 2,
  'nineoldstyle'  => 2,
  'commasuperior'  => 2,
  'threequartersemdash'  => 2,
  'periodsuperior'  => 2,
  'questionsmall'  => 2,
  'asuperior'  => 2,
  'bsuperior'  => 2,
  'centsuperior'  => 2,
  'dsuperior'  => 2,
  'esuperior'  => 2,
  'isuperior'  => 2,
  'lsuperior'  => 2,
  'msuperior'  => 2,
  'nsuperior'  => 2,
  'osuperior'  => 2,
  'rsuperior'  => 2,
  'ssuperior'  => 2,
  'tsuperior'  => 2,
  'ff'  => 2,
  'ffi'  => 2,
  'ffl'  => 2,
  'parenleftinferior'  => 2,
  'parenrightinferior'  => 2,
  'Circumflexsmall'  => 2,
  'hyphensuperior'  => 2,
  'Gravesmall'  => 2,
  'Asmall'  => 2,
  'Bsmall'  => 2,
  'Csmall'  => 2,
  'Dsmall'  => 2,
  'Esmall'  => 2,
  'Fsmall'  => 2,
  'Gsmall'  => 2,
  'Hsmall'  => 2,
  'Ismall'  => 2,
  'Jsmall'  => 2,
  'Ksmall'  => 2,
  'Lsmall'  => 2,
  'Msmall'  => 2,
  'Nsmall'  => 2,
  'Osmall'  => 2,
  'Psmall'  => 2,
  'Qsmall'  => 2,
  'Rsmall'  => 2,
  'Ssmall'  => 2,
  'Tsmall'  => 2,
  'Usmall'  => 2,
  'Vsmall'  => 2,
  'Wsmall'  => 2,
  'Xsmall'  => 2,
  'Ysmall'  => 2,
  'Zsmall'  => 2,
  'colonmonetary'  => 2,
  'onefitted'  => 2,
  'rupiah'  => 2,
  'Tildesmall'  => 2,
  'exclamdownsmall'  => 2,
  'centoldstyle'  => 2,
  'Lslashsmall'  => 2,
  'Scaronsmall'  => 2,
  'Zcaronsmall'  => 2,
  'Dieresissmall'  => 2,
  'Brevesmall'  => 2,
  'Caronsmall'  => 2,
  'Dotaccentsmall'  => 2,
  'Macronsmall'  => 2,
  'figuredash'  => 2,
  'hypheninferior'  => 2,
  'Ogoneksmall'  => 2,
  'Ringsmall'  => 2,
  'Cedillasmall'  => 2,
  'questiondownsmall'  => 2,
  'oneeighth'  => 2,
  'threeeighths'  => 2,
  'fiveeighths'  => 2,
  'seveneighths'  => 2,
  'onethird'  => 2,
  'twothirds'  => 2,
  'zerosuperior'  => 2,
  'foursuperior'  => 2,
  'fivesuperior'  => 2,
  'sixsuperior'  => 2,
  'sevensuperior'  => 2,
  'eightsuperior'  => 2,
  'ninesuperior'  => 2,
  'zeroinferior'  => 2,
  'oneinferior'  => 2,
  'twoinferior'  => 2,
  'threeinferior'  => 2,
  'fourinferior'  => 2,
  'fiveinferior'  => 2,
  'sixinferior'  => 2,
  'seveninferior'  => 2,
  'eightinferior'  => 2,
  'nineinferior'  => 2,
  'centinferior'  => 2,
  'dollarinferior'  => 2,
  'periodinferior'  => 2,
  'commainferior'  => 2,
  'Agravesmall'  => 2,
  'Aacutesmall'  => 2,
  'Acircumflexsmall'  => 2,
  'Atildesmall'  => 2,
  'Adieresissmall'  => 2,
  'Aringsmall'  => 2,
  'AEsmall'  => 2,
  'Ccedillasmall'  => 2,
  'Egravesmall'  => 2,
  'Eacutesmall'  => 2,
  'Ecircumflexsmall'  => 2,
  'Edieresissmall'  => 2,
  'Igravesmall'  => 2,
  'Iacutesmall'  => 2,
  'Icircumflexsmall'  => 2,
  'Idieresissmall'  => 2,
  'Ethsmall'  => 2,
  'Ntildesmall'  => 2,
  'Ogravesmall'  => 2,
  'Oacutesmall'  => 2,
  'Ocircumflexsmall'  => 2,
  'Otildesmall'  => 2,
  'Odieresissmall'  => 2,
  'OEsmall'  => 2,
  'Oslashsmall'  => 2,
  'Ugravesmall'  => 2,
  'Uacutesmall'  => 2,
  'Ucircumflexsmall'  => 2,
  'Udieresissmall'  => 2,
  'Yacutesmall'  => 2,
  'Thornsmall'  => 2,
  'Ydieresissmall'  => 2,
  'Black'  => 2,
  'Bold'  => 2,
  'Book'  => 2,
  'Light'  => 2,
  'Medium'  => 2,
  'Regular'  => 2,
  'Roman'  => 2,
  'Semibold'  => 2,
  'trademark'  => 2,
  'Scaron'  => 2,
  'Ydieresis'  => 2,
  'Zcaron'  => 2,
  'scaron'  => 2,
  'softhyphen'  => 2,
  'overscore'  => 2,
  'graybox'  => 2,
  'Sacute'  => 2,
  'Tcaron'  => 2,
  'Zacute'  => 2,
  'sacute'  => 2,
  'tcaron'  => 2,
  'zacute'  => 2,
  'Aogonek'  => 2,
  'Scedilla'  => 2,
  'Zdotaccent'  => 2,
  'aogonek'  => 2,
  'scedilla'  => 2,
  'Lcaron'  => 2,
  'lcaron'  => 2,
  'zdotaccent'  => 2,
  'Racute'  => 2,
  'Abreve'  => 2,
  'Lacute'  => 2,
  'Cacute'  => 2,
  'Ccaron'  => 2,
  'Eogonek'  => 2,
  'Ecaron'  => 2,
  'Dcaron'  => 2,
  'Dcroat'  => 2,
  'Nacute'  => 2,
  'Ncaron'  => 2,
  'Ohungarumlaut'  => 2,
  'Rcaron'  => 2,
  'Uring'  => 2,
  'Uhungarumlaut'  => 2,
  'Tcommaaccent'  => 2,
  'racute'  => 2,
  'abreve'  => 2,
  'lacute'  => 2,
  'cacute'  => 2,
  'ccaron'  => 2,
  'eogonek'  => 2,
  'ecaron'  => 2,
  'dcaron'  => 2,
  'dcroat'  => 2,
  'nacute'  => 2,
  'ncaron'  => 2,
  'ohungarumlaut'  => 2,
  'rcaron'  => 2,
  'uring'  => 2,
  'uhungarumlaut'  => 2,
  'tcommaaccent'  => 2,
  'Gbreve'  => 2,
  'Idotaccent'  => 2,
  'gbreve'  => 2,
  'blank'  => 2,
  'apple'  => 2,
  'undef'  => 2,
  'globaldict'  => 2,
  'shareddict'  => 2,
  'setpagedevice'  => 2,
  'currentpagedevice'  => 2,
  'rectclip'  => 2,
  'setbbox'  => 2,
  'uappend'  => 2,
  'ucache'  => 2,
  'upath'  => 2,
  'ustrokepath'  => 2,
  'arct'  => 2,
  'rectfill'  => 2,
  'rectstroke'  => 2,
  'ufill'  => 2,
  'ueofill'  => 2,
  'ustroke'  => 2,
  'currentpacking'  => 2,
  'setpacking'  => 2,
  'packedarray'  => 2,
  'languagelevel'  => 2,
  'infill'  => 2,
  'ineofill'  => 2,
  'instroke'  => 2,
  'inufill'  => 2,
  'inueofill'  => 2,
  'inustroke'  => 2,
  'gstate'  => 2,
  'setgstate'  => 2,
  'currentgstate'  => 2,
  'setcolor'  => 2,
  'setcolorspace'  => 2,
  'currentcolorspace'  => 2,
  'setstrokeadjust'  => 2,
  'currentstrokeadjust'  => 2,
  'currentcolor'  => 2,
  'sethalftone'  => 2,
  'currenthalftone'  => 2,
  'setoverprint'  => 2,
  'currentoverprint'  => 2,
  'setcolorrendering'  => 2,
  'currentcolorrendering'  => 2,
  'GlobalFontDirectory'  => 2,
  'SharedFontDirectory'  => 2,
  'glyphshow'  => 2,
  'selectfont'  => 2,
  'addglyph'  => 2,
  'undefinefont'  => 2,
  'xshow'  => 2,
  'xyshow'  => 2,
  'yshow'  => 2,
  'makepattern'  => 2,
  'setpattern'  => 2,
  'execform'  => 2,
  'defineresource'  => 2,
  'undefineresource'  => 2,
  'findresource'  => 2,
  'resourcestatus'  => 2,
  'resourceforall'  => 2,
  'filter'  => 2,
  'printobject'  => 2,
  'writeobject'  => 2,
  'setobjectformat'  => 2,
  'currentobjectformat'  => 2,
  'currentshared'  => 2,
  'setshared'  => 2,
  'defineuserobject'  => 2,
  'execuserobject'  => 2,
  'undefineuserobject'  => 2,
  'gcheck'  => 2,
  'scheck'  => 2,
  'startjob'  => 2,
  'currentglobal'  => 2,
  'setglobal'  => 2,
  'UserObjects'  => 2,
  'setucacheparams'  => 2,
  'setvmthreshold'  => 2,
  'ucachestatus'  => 2,
  'setsystemparams'  => 2,
  'setuserparams'  => 2,
  'currentuserparams'  => 2,
  'setcacheparams'  => 2,
  'currentcacheparams'  => 2,
  'currentdevparams'  => 2,
  'setdevparams'  => 2,
  'vmreclaim'  => 2,
  'currentsystemparams'  => 2,
  'DeviceCMYK'  => 2,
  'Pattern'  => 2,
  'Indexed'  => 2,
  'Separation'  => 2,
  'Cyan'  => 2,
  'Magenta'  => 2,
  'Yellow'  => 2,
  'Black'  => 2,
  'CIEBasedA'  => 2,
  'CIEBasedABC'  => 2,
  'CIEBasedDEF'  => 2,
  'CIEBasedDEFG'  => 2,
  'newerror'  => 2,
  'errorname'  => 2,
  'command'  => 2,
  'errorinfo'  => 2,
  'ostack'  => 2,
  'estack'  => 2,
  'dstack'  => 2,
  'recordstacks'  => 2,
  'binary'  => 2,
  'DefineResource'  => 2,
  'UndefineResource'  => 2,
  'FindResource'  => 2,
  'ResourceStatus'  => 2,
  'ResourceForAll'  => 2,
  'Category'  => 2,
  'InstanceType'  => 2,
  'ResourceFileName'  => 2,
  'Font'  => 2,
  'Encoding'  => 2,
  'Form'  => 2,
  'Pattern'  => 2,
  'ProcSet'  => 2,
  'ColorSpace'  => 2,
  'Halftone'  => 2,
  'ColorRendering'  => 2,
  'Filter'  => 2,
  'ColorSpaceFamily'  => 2,
  'Emulator'  => 2,
  'IODevice'  => 2,
  'ColorRenderingType'  => 2,
  'FMapType'  => 2,
  'FontType'  => 2,
  'FormType'  => 2,
  'HalftoneType'  => 2,
  'ImageType'  => 2,
  'PatternType'  => 2,
  'Category'  => 2,
  'Generic'  => 2,
  'PageSize'  => 2,
  'MediaColor'  => 2,
  'MediaWeight'  => 2,
  'MediaType'  => 2,
  'InputAttributes'  => 2,
  'ManualFeed'  => 2,
  'OutputType'  => 2,
  'OutputAttributes'  => 2,
  'NumCopies'  => 2,
  'Collate'  => 2,
  'Duplex'  => 2,
  'Tumble'  => 2,
  'Separations'  => 2,
  'HWResolution'  => 2,
  'Margins'  => 2,
  'NegativePrint'  => 2,
  'MirrorPrint'  => 2,
  'CutMedia'  => 2,
  'AdvanceMedia'  => 2,
  'AdvanceDistance'  => 2,
  'ImagingBBox'  => 2,
  'Policies'  => 2,
  'Install'  => 2,
  'BeginPage'  => 2,
  'EndPage'  => 2,
  'PolicyNotFound'  => 2,
  'PolicyReport'  => 2,
  'ManualSize'  => 2,
  'OutputFaceUp'  => 2,
  'Jog'  => 2,
  'Bind'  => 2,
  'BindDetails'  => 2,
  'Booklet'  => 2,
  'BookletDetails'  => 2,
  'CollateDetails'  => 2,
  'DeviceRenderingInfo'  => 2,
  'ExitJamRecovery'  => 2,
  'Fold'  => 2,
  'FoldDetails'  => 2,
  'Laminate'  => 2,
  'ManualFeedTimeout'  => 2,
  'Orientation'  => 2,
  'OutputPage'  => 2,
  'PostRenderingEnhance'  => 2,
  'PostRenderingEnhanceDetails'  => 2,
  'PreRenderingEnhance'  => 2,
  'PreRenderingEnhanceDetails'  => 2,
  'Signature'  => 2,
  'SlipSheet'  => 2,
  'Staple'  => 2,
  'StapleDetails'  => 2,
  'Trim'  => 2,
  'ProofSet'  => 2,
  'REValue'  => 2,
  'PrintQuality'  => 2,
  'ValuesPerColorComponent'  => 2,
  'AntiAlias'  => 2,
  'Selector'  => 2,
  'LanguageFamily'  => 2,
  'LanguageVersion'  => 2,
  'HalftoneType'  => 2,
  'HalftoneName'  => 2,
  'AccurateScreens'  => 2,
  'ActualAngle'  => 2,
  'Xsquare'  => 2,
  'Ysquare'  => 2,
  'AccurateFrequency'  => 2,
  'Frequency'  => 2,
  'SpotFunction'  => 2,
  'Angle'  => 2,
  'Width'  => 2,
  'Height'  => 2,
  'Thresholds'  => 2,
  'RedFrequency'  => 2,
  'RedSpotFunction'  => 2,
  'RedAngle'  => 2,
  'RedWidth'  => 2,
  'RedHeight'  => 2,
  'GreenFrequency'  => 2,
  'GreenSpotFunction'  => 2,
  'GreenAngle'  => 2,
  'GreenWidth'  => 2,
  'GreenHeight'  => 2,
  'BlueFrequency'  => 2,
  'BlueSpotFunction'  => 2,
  'BlueAngle'  => 2,
  'BlueWidth'  => 2,
  'BlueHeight'  => 2,
  'GrayFrequency'  => 2,
  'GrayAngle'  => 2,
  'GraySpotFunction'  => 2,
  'GrayWidth'  => 2,
  'GrayHeight'  => 2,
  'GrayThresholds'  => 2,
  'BlueThresholds'  => 2,
  'GreenThresholds'  => 2,
  'RedThresholds'  => 2,
  'TransferFunction'  => 2,
  'RangeA'  => 2,
  'DecodeA'  => 2,
  'MatrixA'  => 2,
  'RangeABC'  => 2,
  'DecodeABC'  => 2,
  'MatrixABC'  => 2,
  'BlackPoint'  => 2,
  'RangeLMN'  => 2,
  'DecodeLMN'  => 2,
  'MatrixLMN'  => 2,
  'WhitePoint'  => 2,
  'RangeDEF'  => 2,
  'DecodeDEF'  => 2,
  'RangeHIJ'  => 2,
  'RangeDEFG'  => 2,
  'DecodeDEFG'  => 2,
  'RangeHIJK'  => 2,
  'Table'  => 2,
  'ColorRenderingType'  => 2,
  'EncodeLMB'  => 2,
  'EncodeABC'  => 2,
  'RangePQR'  => 2,
  'MatrixPQR'  => 2,
  'AbsoluteColorimetric'  => 2,
  'RelativeColorimetric'  => 2,
  'Saturation'  => 2,
  'Perceptual'  => 2,
  'TransformPQR'  => 2,
  'RenderTable'  => 2,
  'PatternType'  => 2,
  'PaintType'  => 2,
  'TilingType'  => 2,
  'XStep'  => 2,
  'YStep'  => 2,
  'ImageType'  => 2,
  'ImageMatrix'  => 2,
  'MultipleDataSources'  => 2,
  'DataSource'  => 2,
  'BitsPerComponent'  => 2,
  'Decode'  => 2,
  'Interpolate'  => 2,
  'FontType'  => 2,
  'FontMatrix'  => 2,
  'FontName'  => 2,
  'FontInfo'  => 2,
  'LanguageLevel'  => 2,
  'WMode'  => 2,
  'Encoding'  => 2,
  'UniqueID'  => 2,
  'StrokeWidth'  => 2,
  'Metrics'  => 2,
  'Metrics2'  => 2,
  'CDevProc'  => 2,
  'CharStrings'  => 2,
  'Private'  => 2,
  'FullName'  => 2,
  'Notice'  => 2,
  'version'  => 2,
  'ItalicAngle'  => 2,
  'isFixedPitch'  => 2,
  'UnderlinePosition'  => 2,
  'FMapType'  => 2,
  'Encoding'  => 2,
  'FDepVector'  => 2,
  'PrefEnc'  => 2,
  'EscChar'  => 2,
  'ShiftOut'  => 2,
  'ShiftIn'  => 2,
  'WeightVector'  => 2,
  'Blend'  => 2,
  '$Blend'  => 2,
  'CIDFontType'  => 2,
  'sfnts'  => 2,
  'CIDSystemInfo'  => 2,
  'CodeMap'  => 2,
  'CMap'  => 2,
  'CIDFontName'  => 2,
  'CIDSystemInfo'  => 2,
  'UIDBase'  => 2,
  'CIDDevProc'  => 2,
  'CIDCount'  => 2,
  'CIDMapOffset'  => 2,
  'FDArray'  => 2,
  'FDBytes'  => 2,
  'GDBytes'  => 2,
  'GlyphData'  => 2,
  'GlyphDictionary'  => 2,
  'SDBytes'  => 2,
  'SubrMapOffset'  => 2,
  'SubrCount'  => 2,
  'BuildGlyph'  => 2,
  'CIDMap'  => 2,
  'FID'  => 2,
  'MIDVector'  => 2,
  'Ordering'  => 2,
  'Registry'  => 2,
  'Supplement'  => 2,
  'CMapName'  => 2,
  'CMapVersion'  => 2,
  'UIDOffset'  => 2,
  'SubsVector'  => 2,
  'UnderlineThickness'  => 2,
  'FamilyName'  => 2,
  'FontBBox'  => 2,
  'CurMID'  => 2,
  'Weight'  => 2,
  'MaxFontItem'  => 2,
  'MinFontCompress'  => 2,
  'MaxUPathItem'  => 2,
  'MaxFormItem'  => 2,
  'MaxPatternItem'  => 2,
  'MaxScreenItem'  => 2,
  'MaxOpStack'  => 2,
  'MaxDictStack'  => 2,
  'MaxExecStack'  => 2,
  'MaxLocalVM'  => 2,
  'VMReclaim'  => 2,
  'VMThreshold'  => 2,
  'SystemParamsPassword'  => 2,
  'StartJobPassword'  => 2,
  'BuildTime'  => 2,
  'ByteOrder'  => 2,
  'RealFormat'  => 2,
  'MaxFontCache'  => 2,
  'CurFontCache'  => 2,
  'MaxOutlineCache'  => 2,
  'CurOutlineCache'  => 2,
  'MaxUPathCache'  => 2,
  'CurUPathCache'  => 2,
  'MaxFormCache'  => 2,
  'CurFormCache'  => 2,
  'MaxPatternCache'  => 2,
  'CurPatternCache'  => 2,
  'MaxScreenStorage'  => 2,
  'CurScreenStorage'  => 2,
  'MaxDisplayList'  => 2,
  'CurDisplayList'  => 2,
  'Predictor'  => 2,
  'letter'  => 2,
  'lettersmall'  => 2,
  'legal'  => 2,
  'ledger'  => 2,
  '11x17'  => 2,
  'a4'  => 2,
  'a3'  => 2,
  'a4small'  => 2,
  'b5'  => 2,
  'note'  => 2,
  'lettertray'  => 2,
  'legaltray'  => 2,
  'ledgertray'  => 2,
  'a3tray'  => 2,
  'a4tray'  => 2,
  'b5tray'  => 2,
  '11x17tray'  => 2,
  'sccbatch'  => 2,
  'sccinteractive'  => 2,
  'setsccbatch'  => 2,
  'setsccinteractive'  => 2,
  'duplexmode'  => 2,
  'firstside'  => 2,
  'newsheet'  => 2,
  'setduplexmode'  => 2,
  'settumble'  => 2,
  'tumble'  => 2,
  'devdismount'  => 2,
  'devformat'  => 2,
  'devmount'  => 2,
  'devstatus'  => 2,
  'devforall'  => 2,
  'accuratescreens'  => 2,
  'checkscreen'  => 2,
  'pagemargin'  => 2,
  'pageparams'  => 2,
  'setaccuratescreens'  => 2,
  'setpage'  => 2,
  'setpagemargin'  => 2,
  'setpageparams'  => 2,
  'appletalktype'  => 2,
  'buildtime'  => 2,
  'byteorder'  => 2,
  'checkpassword'  => 2,
  'defaulttimeouts'  => 2,
  'diskonline'  => 2,
  'diskstatus'  => 2,
  'manualfeed'  => 2,
  'manualfeedtimeout'  => 2,
  'margins'  => 2,
  'mirrorprint'  => 2,
  'pagecount'  => 2,
  'pagestackorder'  => 2,
  'printername'  => 2,
  'processcolors'  => 2,
  'sethardwareiomode'  => 2,
  'setjobtimeout'  => 2,
  'setpagestockorder'  => 2,
  'setprintername'  => 2,
  'setresolution'  => 2,
  'doprinterrors'  => 2,
  'dostartpage'  => 2,
  'hardwareiomode'  => 2,
  'initializedisk'  => 2,
  'jobname'  => 2,
  'jobtimeout'  => 2,
  'ramsize'  => 2,
  'realformat'  => 2,
  'resolution'  => 2,
  'setdefaulttimeouts'  => 2,
  'setdoprinterrors'  => 2,
  'setdostartpage'  => 2,
  'setdosysstart'  => 2,
  'setuserdiskpercent'  => 2,
  'softwareiomode'  => 2,
  'userdiskpercent'  => 2,
  'waittimeout'  => 2,
  'setsoftwareiomode'  => 2,
  'dosysstart'  => 2,
  'emulate'  => 2,
  'setmargins'  => 2,
  'setmirrorprint'  => 2,
  'setsmoothness'  => 2,
  'currentsmoothness'  => 2,
  'shfill'  => 2,
  'clipsave'  => 2,
  'cliprestore'  => 2,
  'setpage'  => 2,
  'setpageparams'  => 2,
  'findcolorrendering'  => 2,
  'composefont'  => 2,
  'DeviceN'  => 2,
  'TrappingDetailsType'  => 2,
  'DeferredMediaSelection'  => 2,
  'ImageShift'  => 2,
  'InsertSheet'  => 2,
  'LeadingEdge'  => 2,
  'MaxSeparations'  => 2,
  'MediaClass'  => 2,
  'MediaPosition'  => 2,
  'OutputDevice'  => 2,
  'PageDeviceName'  => 2,
  'PageOffset'  => 2,
  'ProcessColorModel'  => 2,
  'RollFedMedia'  => 2,
  'SeparationColorNames'  => 2,
  'SeparationOrder'  => 2,
  'Trapping'  => 2,
  'TrappingDetails'  => 2,
  'TraySwitch'  => 2,
  'UseCIEColor'  => 2,
  'ColorantDetails'  => 2,
  'ColorantName'  => 2,
  'ColorantType'  => 2,
  'NeutralDensity'  => 2,
  'TrappingOrder'  => 2,
  'ColorantSetName'  => 2,
  'BlackColorLimit'  => 2,
  'BlackDensityLimit'  => 2,
  'BlackWidth'  => 2,
  'ColorantZoneDetails'  => 2,
  'SlidingTrapLimit'  => 2,
  'StepLimit'  => 2,
  'TrapColorScaling'  => 2,
  'TrapSetName'  => 2,
  'TrapWidth'  => 2,
  'ImageResolution'  => 2,
  'ImageToObjectTrapping'  => 2,
  'ImageTrapPlacement'  => 2,
  'StepLimit'  => 2,
  'TrapColorScaling'  => 2,
  'Enabled'  => 2,
  'ImageInternalTrapping'  => 2,
  'ReusableStreamDecode'  => 2,
  'CloseSource'  => 2,
  'CloseTarget'  => 2,
  'UnitSize'  => 2,
  'LowBitFirst'  => 2,
  'FlateEncode'  => 2,
  'FlateDecode'  => 2,
  'DecodeParams'  => 2,
  'Intent'  => 2,
  'AsyncRead'  => 2,
  'Height2'  => 2,
  'Width2'  => 2,
  'FunctionType'  => 2,
  'Domain'  => 2,
  'Range'  => 2,
  'Order'  => 2,
  'BitsPerSample'  => 2,
  'Encode'  => 2,
  'Size'  => 2,
  'C0'  => 2,
  'C1'  => 2,
  'N'  => 2,
  'Functions'  => 2,
  'Bounds'  => 2,
  'InterleaveType'  => 2,
  'MaskDict'  => 2,
  'DataDict'  => 2,
  'MaskColor'  => 2,
  'Shading'  => 2,
  'ShadingType'  => 2,
  'Background'  => 2,
  'ColorSpace'  => 2,
  'Coords'  => 2,
  'Extend'  => 2,
  'Function'  => 2,
  'VerticesPerRow'  => 2,
  'BitsPerCoordinate'  => 2,
  'BitsPerFlag'  => 2,
  'XOrigin'  => 2,
  'YOrigin'  => 2,
  'UnpaintedPath'  => 2,
  'PixelCopy'  => 2,
  'GetHalftoneName'  => 2,
  'GetPageDeviceName'  => 2,
  'GetSubstituteCRD'  => 2,
  'beginbfchar'  => 2,
  'beginbfrange'  => 2,
  'begincidchar'  => 2,
  'begincidrange'  => 2,
  'begincmap'  => 2,
  'begincodespacerange'  => 2,
  'beginnotdefchar'  => 2,
  'beginnotdefrange'  => 2,
  'beginrearrangedfont'  => 2,
  'beginusematrix'  => 2,
  'endbfchar'  => 2,
  'endbfrange'  => 2,
  'endcidchar'  => 2,
  'endcidrange'  => 2,
  'endcmap'  => 2,
  'endcodespacerange'  => 2,
  'endnotdefchar'  => 2,
  'endnotdefrange'  => 2,
  'endrearrangedfont'  => 2,
  'endusematrix'  => 2,
  'StartData'  => 2,
  'usefont'  => 2,
  'usecmp'  => 2,
  'settrapparams'  => 2,
  'currenttrapparams'  => 2,
  'settrapzone'  => 2,
  'removeall'  => 2,
  'removeglyphs'  => 2,
  'AlbertusMT'  => 2,
  'AlbertusMT-Italic'  => 2,
  'AlbertusMT-Light'  => 2,
  'Apple-Chancery'  => 2,
  'Apple-ChanceryCE'  => 2,
  'AntiqueOlive-Roman'  => 2,
  'AntiqueOlive-Italic'  => 2,
  'AntiqueOlive-Bold'  => 2,
  'AntiqueOlive-Compact'  => 2,
  'AntiqueOliveCE-Roman'  => 2,
  'AntiqueOliveCE-Italic'  => 2,
  'AntiqueOliveCE-Bold'  => 2,
  'AntiqueOliveCE-Compact'  => 2,
  'ArialMT'  => 2,
  'Arial-ItalicMT'  => 2,
  'Arial-LightMT'  => 2,
  'Arial-BoldMT'  => 2,
  'Arial-BoldItalicMT'  => 2,
  'ArialCE'  => 2,
  'ArialCE-Italic'  => 2,
  'ArialCE-Light'  => 2,
  'ArialCE-Bold'  => 2,
  'ArialCE-BoldItalic'  => 2,
  'AvantGarde-Book'  => 2,
  'AvantGarde-BookOblique'  => 2,
  'AvantGarde-Demi'  => 2,
  'AvantGarde-DemiOblique'  => 2,
  'AvantGardeCE-Book'  => 2,
  'AvantGardeCE-BookOblique'  => 2,
  'AvantGardeCE-Demi'  => 2,
  'AvantGardeCE-DemiOblique'  => 2,
  'Bodoni'  => 2,
  'Bodoni-Italic'  => 2,
  'Bodoni-Bold'  => 2,
  'Bodoni-BoldItalic'  => 2,
  'Bodoni-Poster'  => 2,
  'Bodoni-PosterCompressed'  => 2,
  'BodoniCE'  => 2,
  'BodoniCE-Italic'  => 2,
  'BodoniCE-Bold'  => 2,
  'BodoniCE-BoldItalic'  => 2,
  'BodoniCE-Poster'  => 2,
  'BodoniCE-PosterCompressed'  => 2,
  'Bookman-Light'  => 2,
  'Bookman-LightItalic'  => 2,
  'Bookman-Demi'  => 2,
  'Bookman-DemiItalic'  => 2,
  'BookmanCE-Light'  => 2,
  'BookmanCE-LightItalic'  => 2,
  'BookmanCE-Demi'  => 2,
  'BookmanCE-DemiItalic'  => 2,
  'Carta'  => 2,
  'Chicago'  => 2,
  'ChicagoCE'  => 2,
  'Clarendon'  => 2,
  'Clarendon-Light'  => 2,
  'Clarendon-Bold'  => 2,
  'ClarendonCE'  => 2,
  'ClarendonCE-Light'  => 2,
  'ClarendonCE-Bold'  => 2,
  'CooperBlack'  => 2,
  'CooperBlack-Italic'  => 2,
  'Copperplate-ThirtyTwoBC'  => 2,
  'CopperPlate-ThirtyThreeBC'  => 2,
  'Coronet-Regular'  => 2,
  'CoronetCE-Regular'  => 2,
  'CourierCE'  => 2,
  'CourierCE-Oblique'  => 2,
  'CourierCE-Bold'  => 2,
  'CourierCE-BoldOblique'  => 2,
  'Eurostile'  => 2,
  'Eurostile-Bold'  => 2,
  'Eurostile-ExtendedTwo'  => 2,
  'Eurostile-BoldExtendedTwo'  => 2,
  'Eurostile'  => 2,
  'EurostileCE-Bold'  => 2,
  'EurostileCE-ExtendedTwo'  => 2,
  'EurostileCE-BoldExtendedTwo'  => 2,
  'Geneva'  => 2,
  'GenevaCE'  => 2,
  'GillSans'  => 2,
  'GillSans-Italic'  => 2,
  'GillSans-Bold'  => 2,
  'GillSans-BoldItalic'  => 2,
  'GillSans-BoldCondensed'  => 2,
  'GillSans-Light'  => 2,
  'GillSans-LightItalic'  => 2,
  'GillSans-ExtraBold'  => 2,
  'GillSansCE-Roman'  => 2,
  'GillSansCE-Italic'  => 2,
  'GillSansCE-Bold'  => 2,
  'GillSansCE-BoldItalic'  => 2,
  'GillSansCE-BoldCondensed'  => 2,
  'GillSansCE-Light'  => 2,
  'GillSansCE-LightItalic'  => 2,
  'GillSansCE-ExtraBold'  => 2,
  'Goudy'  => 2,
  'Goudy-Italic'  => 2,
  'Goudy-Bold'  => 2,
  'Goudy-BoldItalic'  => 2,
  'Goudy-ExtraBould'  => 2,
  'HelveticaCE'  => 2,
  'HelveticaCE-Oblique'  => 2,
  'HelveticaCE-Bold'  => 2,
  'HelveticaCE-BoldOblique'  => 2,
  'Helvetica-Condensed'  => 2,
  'Helvetica-Condensed-Oblique'  => 2,
  'Helvetica-Condensed-Bold'  => 2,
  'Helvetica-Condensed-BoldObl'  => 2,
  'HelveticaCE-Condensed'  => 2,
  'HelveticaCE-Condensed-Oblique'  => 2,
  'HelveticaCE-Condensed-Bold'  => 2,
  'HelveticaCE-Condensed-BoldObl'  => 2,
  'Helvetica-Narrow'  => 2,
  'Helvetica-Narrow-Oblique'  => 2,
  'Helvetica-Narrow-Bold'  => 2,
  'Helvetica-Narrow-BoldOblique'  => 2,
  'HelveticaCE-Narrow'  => 2,
  'HelveticaCE-Narrow-Oblique'  => 2,
  'HelveticaCE-Narrow-Bold'  => 2,
  'HelveticaCE-Narrow-BoldOblique'  => 2,
  'HoeflerText-Regular'  => 2,
  'HoeflerText-Italic'  => 2,
  'HoeflerText-Black'  => 2,
  'HoeflerText-BlackItalic'  => 2,
  'HoeflerText-Ornaments'  => 2,
  'HoeflerTextCE-Regular'  => 2,
  'HoeflerTextCE-Italic'  => 2,
  'HoeflerTextCE-Black'  => 2,
  'HoeflerTextCE-BlackItalic'  => 2,
  'JoannaMT'  => 2,
  'JoannaMT-Italic'  => 2,
  'JoannaMT-Bold'  => 2,
  'JoannaMT-BoldItalic'  => 2,
  'JoannaMTCE'  => 2,
  'JoannaMTCE-Italic'  => 2,
  'JoannaMTCE-Bold'  => 2,
  'JoannaMTCE-BoldItalic'  => 2,
  'LetterGothic'  => 2,
  'LetterGothic-Slanted'  => 2,
  'LetterGothic-Bold'  => 2,
  'LetterGothic-BoldSlanted'  => 2,
  'LetterGothicCE'  => 2,
  'LetterGothicCE-Slanted'  => 2,
  'LetterGothicCE-Bold'  => 2,
  'LetterGothicCE-BoldSlanted'  => 2,
  'LubalinGraph-Book'  => 2,
  'LubalinGraph-BookOblique'  => 2,
  'LubalinGraph-Demi'  => 2,
  'LubalinGraph-DemiOblique'  => 2,
  'LubalinGraphCE-Book'  => 2,
  'LubalinGraphCE-BookOblique'  => 2,
  'LubalinGraphCE-Demi'  => 2,
  'LubalinGraphCE-DemiOblique'  => 2,
  'Marigold'  => 2,
  'Monaco'  => 2,
  'MonacoCE'  => 2,
  'MonaLisa-Recut'  => 2,
  'Oxford'  => 2,
  'Symbol'  => 2,
  'Tekton'  => 2,
  'NewCennturySchlbk-Roman'  => 2,
  'NewCenturySchlbk-Italic'  => 2,
  'NewCenturySchlbk-Bold'  => 2,
  'NewCenturySchlbk-BoldItalic'  => 2,
  'NewCenturySchlbkCE-Roman'  => 2,
  'NewCenturySchlbkCE-Italic'  => 2,
  'NewCenturySchlbkCE-Bold'  => 2,
  'NewCenturySchlbkCE-BoldItalic'  => 2,
  'NewYork'  => 2,
  'NewYorkCE'  => 2,
  'Optima'  => 2,
  'Optima-Italic'  => 2,
  'Optima-Bold'  => 2,
  'Optima-BoldItalic'  => 2,
  'OptimaCE'  => 2,
  'OptimaCE-Italic'  => 2,
  'OptimaCE-Bold'  => 2,
  'OptimaCE-BoldItalic'  => 2,
  'Palatino-Roman'  => 2,
  'Palatino-Italic'  => 2,
  'Palatino-Bold'  => 2,
  'Palatino-BoldItalic'  => 2,
  'PalatinoCE-Roman'  => 2,
  'PalatinoCE-Italic'  => 2,
  'PalatinoCE-Bold'  => 2,
  'PalatinoCE-BoldItalic'  => 2,
  'StempelGaramond-Roman'  => 2,
  'StempelGaramond-Italic'  => 2,
  'StempelGaramond-Bold'  => 2,
  'StempelGaramond-BoldItalic'  => 2,
  'StempelGaramondCE-Roman'  => 2,
  'StempelGaramondCE-Italic'  => 2,
  'StempelGaramondCE-Bold'  => 2,
  'StempelGaramondCE-BoldItalic'  => 2,
  'TimesCE-Roman'  => 2,
  'TimesCE-Italic'  => 2,
  'TimesCE-Bold'  => 2,
  'TimesCE-BoldItalic'  => 2,
  'TimesNewRomanPSMT'  => 2,
  'TimesNewRomanPS-ItalicMT'  => 2,
  'TimesNewRomanPS-BoldMT'  => 2,
  'TimesNewRomanPS-BoldItalicMT'  => 2,
  'TimesNewRomanCE'  => 2,
  'TimesNewRomanCE-Italic'  => 2,
  'TimesNewRomanCE-Bold'  => 2,
  'TimesNewRomanCE-BoldItalic'  => 2,
  'Univers'  => 2,
  'Univers-Oblique'  => 2,
  'Univers-Bold'  => 2,
  'Univers-BoldOblique'  => 2,
  'UniversCE-Medium'  => 2,
  'UniversCE-Oblique'  => 2,
  'UniversCE-Bold'  => 2,
  'UniversCE-BoldOblique'  => 2,
  'Univers-Light'  => 2,
  'Univers-LightOblique'  => 2,
  'UniversCE-Light'  => 2,
  'UniversCE-LightOblique'  => 2,
  'Univers-Condensed'  => 2,
  'Univers-CondensedOblique'  => 2,
  'Univers-CondensedBold'  => 2,
  'Univers-CondensedBoldOblique'  => 2,
  'UniversCE-Condensed'  => 2,
  'UniversCE-CondensedOblique'  => 2,
  'UniversCE-CondensedBold'  => 2,
  'UniversCE-CondensedBoldOblique'  => 2,
  'Univers-Extended'  => 2,
  'Univers-ExtendedObl'  => 2,
  'Univers-BoldExt'  => 2,
  'Univers-BoldExtObl'  => 2,
  'UniversCE-Extended'  => 2,
  'UniversCE-ExtendedObl'  => 2,
  'UniversCE-BoldExt'  => 2,
  'UniversCE-BoldExtObl'  => 2,
  'Wingdings-Regular'  => 2,
  'ZapfChancery-MediumItalic'  => 2,
  'ZapfChanceryCE-MediumItalic'  => 2,
  'ZapfDingBats'  => 2,
  '.setaccuratecurves'  => 2,
  '.currentaccuratecurves'  => 2,
  '.setclipoutside'  => 2,
  '.setdashadapt'  => 2,
  '.currentdashadapt'  => 2,
  '.setdefaultmatrix'  => 2,
  '.setdotlength'  => 2,
  '.currentdotlength'  => 2,
  '.setfilladjust2'  => 2,
  '.currentfilladjust2'  => 2,
  '.currentclipoutside'  => 2,
  '.setcurvejoin'  => 2,
  '.currentcurvejoin'  => 2,
  '.setblendmode'  => 2,
  '.currentblendmode'  => 2,
  '.setopacityalpha'  => 2,
  '.currentopacityalpha'  => 2,
  '.setshapealpha'  => 2,
  '.currentshapealpha'  => 2,
  '.setlimitclamp'  => 2,
  '.currentlimitclamp'  => 2,
  '.setoverprintmode'  => 2,
  '.currentoverprintmode'  => 2,
  '.dashpath'  => 2,
  '.rectappend'  => 2,
  '.setrasterop'  => 2,
  '.currentrasterop'  => 2,
  '.setsourcetransparent'  => 2,
  '.settexturetransparent'  => 2,
  '.currenttexturetransparent'  => 2,
  '.currentsourcetransparent'  => 2,
  '.charboxpath'  => 2,
  '.type1execchar'  => 2,
  'arccos'  => 2,
  'arcsin'  => 2,
  '.dicttomark'  => 2,
  '.forceput'  => 2,
  '.forceundef'  => 2,
  '.knownget'  => 2,
  '.setmaxlength'  => 2,
  '.type1encrypt'  => 2,
  '.type1decrypt'  => 2,
  '.bytestring'  => 2,
  '.namestring'  => 2,
  '.stringmatch'  => 2,
  'max'  => 2,
  'min'  => 2,
  'findlibfile'  => 2,
  'unread'  => 2,
  'writeppmfile'  => 2,
  '.filename'  => 2,
  '.fileposition'  => 2,
  '.peekstring'  => 2,
  '.unread'  => 2,
  '.forgetsave'  => 2,
  'copydevice'  => 2,
  '.getdevice'  => 2,
  'makeimagedevice'  => 2,
  'makewordimagedevice'  => 2,
  'copyscanlines'  => 2,
  'setdevice'  => 2,
  'currentdevice'  => 2,
  'getdeviceprops'  => 2,
  'putdeviceprops'  => 2,
  'flushpage'  => 2,
  'finddevice'  => 2,
  'findprotodevice'  => 2,
  '.getbitsrect'  => 2,
  'getenv'  => 2,
  '.makeoperator'  => 2,
  '.setdebug'  => 2,
  '.oserrno'  => 2,
  '.oserror'  => 2,
  '.execn'  => 2,
  '.begintransparencygroup'  => 2,
  '.discardtransparencygroup'  => 2,
  '.endtransparencygroup'  => 2,
  '.begintransparencymask'  => 2,
  '.discardtransparencymask'  => 2,
  '.endtransparencymask'  => 2,
  '.inittransparencymask'  => 2,
  '.settextknockout'  => 2,
  '.currenttextknockout'  => 2,
  'BCPEncode'  => 2,
  'BCPDecode'  => 2,
  'eexecEncode'  => 2,
  'eexecDecode'  => 2,
  'PCXDecode'  => 2,
  'PixelDifferenceEncode'  => 2,
  'PixelDifferenceDecode'  => 2,
  'PNGPredictorDecode'  => 2,
  'TBCPEncode'  => 2,
  'TBCPDecode'  => 2,
  'zlibEncode'  => 2,
  'zlibDecode'  => 2,
  'PNGPredictorEncode'  => 2,
  'PFBDecode'  => 2,
  'MD5Encode'  => 2,
  'InitialCodeLength'  => 2,
  'FirstBitLowOrder'  => 2,
  'BlockData'  => 2,
  'DecodedByteAlign'  => 2,
  'BitsPerPixel'  => 2,
  '.HWMargins'  => 2,
  'HWSize'  => 2,
  'Name'  => 2,
  'GrayValues'  => 2,
  'ColorValues'  => 2,
  'TextAlphaBits'  => 2,
  'GraphicsAlphaBits'  => 2,
  'BufferSpace'  => 2,
  'OpenOutputFile'  => 2,
  'PageCount'  => 2,
  'BandHeight'  => 2,
  'BandWidth'  => 2,
  'BandBufferSpace'  => 2,
  'ViewerPreProcess'  => 2,
  'GreenValues'  => 2,
  'BlueValues'  => 2,
  'OutputFile'  => 2,
  'MaxBitmap'  => 2,
  'RedValues'  => 2,

  );
?>